/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9StackWalkState;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackWalkerUtils {
    public static final Logger logger = Logger.getLogger("j9ddr.stackwalker");
    private static int messageLevel = 0;
    private static PrintStream messageStream = null;
    public static final int INITIAL_O_SLOTS_CORRUPTION_THRESHOLD = 5;
    private static int oslotsCorruptionThreshold = 5;
    public static final boolean DEBUG_STACKMAP = false;
    public static final boolean DEBUG_LOCALMAP = false;
    static final int[] jitArgumentRegisterNumbers;

    public static void swPrintf(WalkState walkState, int level, String message2, Object ... args) {
        Level utilLoggingLevel;
        if (messageLevel >= level && messageStream != null) {
            String output = MessageFormat.format("<" + Long.toHexString(walkState.threadAddress) + "> " + message2, args);
            messageStream.println(output);
        }
        Level level2 = level == 1 ? Level.FINE : (utilLoggingLevel = level == 2 ? Level.FINER : Level.FINEST);
        if (logger.isLoggable(utilLoggingLevel)) {
            logger.logp(utilLoggingLevel, (String)null, (String)null, "<" + Long.toHexString(walkState.threadAddress) + "> " + message2, args);
        }
    }

    public static void swPrintMethod(WalkState walkState) throws CorruptDataException {
        StackWalkerUtils.swPrintMethod(walkState, walkState.method);
    }

    public static void swPrintMethod(WalkState walkState, J9MethodPointer method) throws CorruptDataException {
        if (method.notNull()) {
            J9UTF8Pointer className = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(method).romClass().className();
            J9ROMMethodPointer romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method);
            J9UTF8Pointer name = romMethod.nameAndSignature().name();
            J9UTF8Pointer sig = romMethod.nameAndSignature().signature();
            StackWalkerUtils.swPrintf(walkState, 2, "\tMethod: {0}.{1}{2} !j9method {3}", J9UTF8Helper.stringValue(className), J9UTF8Helper.stringValue(name), J9UTF8Helper.stringValue(sig), method.getHexAddress());
        }
    }

    public static void WALK_METHOD_CLASS(WalkState walkState) throws CorruptDataException {
        if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
            StackWalkerUtils.SWALK_PRINT_CLASS_OF_RUNNING_METHOD(walkState);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = -1;
            StackWalkerUtils.WALK_O_SLOT(walkState, walkState.constantPool.ramClass().classObjectEA());
        }
    }

    public static void WALK_NAMED_INDIRECT_O_SLOT(WalkState walkState, PointerPointer objectSlot, VoidPointer indirectSlot, String tag) throws CorruptDataException {
        UDATA value = UDATAPointer.cast(objectSlot).at(0L);
        if (indirectSlot.notNull()) {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1} -> {2}] = {3}", tag != null ? tag : "O-Slot", indirectSlot.getHexAddress(), objectSlot.getHexAddress(), value.getHexValue());
        } else {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1}] = {2}", tag != null ? tag : "O-Slot", objectSlot.getHexAddress(), value.getHexValue());
        }
        walkState.callBacks.objectSlotWalkFunction(walkState, objectSlot, VoidPointer.cast(objectSlot));
    }

    public static void WALK_NAMED_INDIRECT_I_SLOT(WalkState walkState, PointerPointer intSlot, VoidPointer indirectSlot, String tag) throws CorruptDataException {
        if (indirectSlot.notNull()) {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1} -> {2}] = {3}", tag != null ? tag : "I-Slot", indirectSlot.getHexAddress(), intSlot.getHexAddress(), UDATAPointer.cast(intSlot).at(0L).getHexValue());
        } else {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1}] = {2}", tag != null ? tag : "I-Slot", intSlot.getHexAddress(), UDATAPointer.cast(intSlot).at(0L).getHexValue());
        }
    }

    public static void WALK_INDIRECT_O_SLOT(WalkState walkState, PointerPointer slot, VoidPointer ind) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_O_SLOT(walkState, slot, ind, null);
    }

    public static void WALK_INDIRECT_I_SLOT(WalkState walkState, PointerPointer slot, VoidPointer ind) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_I_SLOT(walkState, slot, ind, null);
    }

    public static void WALK_NAMED_O_SLOT(WalkState walkState, PointerPointer slot, String tag) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_O_SLOT(walkState, slot, VoidPointer.cast(0L), tag);
    }

    public static void WALK_NAMED_I_SLOT(WalkState walkState, PointerPointer slot, String tag) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_I_SLOT(walkState, slot, VoidPointer.cast(0L), tag);
    }

    public static void WALK_O_SLOT(WalkState walkState, PointerPointer slot) throws CorruptDataException {
        StackWalkerUtils.WALK_INDIRECT_O_SLOT(walkState, slot, VoidPointer.cast(0L));
    }

    public static void WALK_I_SLOT(WalkState walkState, PointerPointer slot) throws CorruptDataException {
        StackWalkerUtils.WALK_INDIRECT_I_SLOT(walkState, slot, VoidPointer.cast(0L));
    }

    private static void SWALK_PRINT_CLASS_OF_RUNNING_METHOD(WalkState walkState) {
        StackWalkerUtils.swPrintf(walkState, 4, "\tClass of running method", new Object[0]);
    }

    public static UDATA JIT_RESOLVE_PARM(WalkState walkState, int parmNumber) throws CorruptDataException {
        if (J9BuildFlags.J9VM_ARCH_X86 && !J9BuildFlags.J9VM_ENV_DATA64) {
            return walkState.bp.at(parmNumber);
        }
        return walkState.jitGlobalStorageBase.at(jitArgumentRegisterNumbers[parmNumber - 1]);
    }

    public static void resetOSlotsCorruptionThreshold() {
        oslotsCorruptionThreshold = 5;
    }

    public static boolean oSlotsCorruptionThresholdReached() {
        return oslotsCorruptionThreshold < 0;
    }

    public static void handleOSlotsCorruption(WalkState walkState, String className, String methodName, CorruptDataException ex) {
        if (oslotsCorruptionThreshold > 0) {
            --oslotsCorruptionThreshold;
            EventManager.raiseCorruptDataEvent("CorruptData encountered iterating o-slots. walkThread = " + walkState.getThreadHexAddress(), ex, false);
        }
        if (oslotsCorruptionThreshold == 0) {
            EventManager.raiseCorruptDataEvent("Corruption threshold hit. Will stop walking object slots on this thread. walkThread = " + walkState.getThreadHexAddress(), ex, false);
            walkState.flags &= (J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) ^ 0xFFFFFFFFFFFFFFFFL;
            oslotsCorruptionThreshold = -1;
        }
    }

    public static void enableVerboseLogging(int level) {
        StackWalkerUtils.enableVerboseLogging(level, System.err);
    }

    public static void enableVerboseLogging(int level, PrintStream os) {
        messageLevel = level;
        messageStream = os;
    }

    public static void disableVerboseLogging() {
        messageLevel = 0;
        messageStream = null;
    }

    static {
        if (J9BuildFlags.J9VM_ARCH_X86) {
            jitArgumentRegisterNumbers = J9BuildFlags.J9VM_ENV_DATA64 ? new int[]{0, 5, 3, 2} : new int[0];
        } else if (J9BuildFlags.J9VM_ARCH_ARM) {
            jitArgumentRegisterNumbers = new int[]{0, 1, 2, 3};
        } else if (J9BuildFlags.J9VM_ARCH_AARCH64) {
            jitArgumentRegisterNumbers = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        } else if (J9BuildFlags.J9VM_ARCH_POWER) {
            jitArgumentRegisterNumbers = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
        } else if (J9BuildFlags.J9VM_ARCH_S390) {
            jitArgumentRegisterNumbers = new int[]{1, 2, 3};
        } else if (J9BuildFlags.J9VM_ARCH_RISCV) {
            jitArgumentRegisterNumbers = new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        } else {
            throw new IllegalArgumentException("Unsupported platform");
        }
    }
}

