/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;
import java.math.BigInteger;

public class FindPatternCommand
extends Command {
    private static final int PATTERN_LENGHT = 1024;

    public FindPatternCommand() {
        this.addCommand("findpattern", "<pattern>", "search memory for a specific pattern");
    }

    private void printUsage(PrintStream out) {
        CommandUtils.dbgPrint(out, "Usage: \n");
        CommandUtils.dbgPrint(out, "  !findpattern hexstring,alignment\n");
        CommandUtils.dbgPrint(out, "  !findpattern hexstring,alignment,startPtr\n");
        CommandUtils.dbgPrint(out, "  !findpattern hexstring,alignment,startPtr,bytesToSearch\n");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            byte[] pattern = null;
            BigInteger bytesToSearch = CommandUtils.longToBigInteger(UDATA.MAX.longValue());
            int length = 0;
            if (args.length != 1) {
                this.printUsage(out);
                return;
            }
            String[] realArgs = args[0].split(",");
            if (realArgs.length == 1) {
                CommandUtils.dbgError(out, "Error: must specify alignment\n");
                this.printUsage(out);
                return;
            }
            String hexstring = realArgs[0];
            int patternAlignment = Integer.parseInt(realArgs[1]);
            long startSearchFrom = 0L;
            if (realArgs.length == 3) {
                startSearchFrom = CommandUtils.parsePointer(realArgs[2], J9BuildFlags.env_data64);
                bytesToSearch = bytesToSearch.subtract(CommandUtils.longToBigInteger(startSearchFrom));
            } else if (realArgs.length == 4) {
                startSearchFrom = CommandUtils.parsePointer(realArgs[2], J9BuildFlags.env_data64);
                bytesToSearch = CommandUtils.parseNumber(realArgs[3]);
                if (bytesToSearch.add(CommandUtils.longToBigInteger(startSearchFrom)).toString(16).length() > UDATA.SIZEOF) {
                    out.println("Warning: bytesToSearch value (" + realArgs[3] + ") is larger than the max available memory after the search start address (" + realArgs[2] + ").\n Pattern will be searched in all the remaining memory after the search start address");
                    bytesToSearch = CommandUtils.longToBigInteger(UDATA.MAX.longValue()).subtract(CommandUtils.longToBigInteger(startSearchFrom));
                }
            } else if (realArgs.length > 4) {
                CommandUtils.dbgError(out, "Error: too many arguments\n");
            }
            length = hexstring.length() / 2;
            if (length > 1024) {
                CommandUtils.dbgPrint(out, String.format("Pattern is too long. Truncating to %d bytes\n", 1024));
                length = 1024;
            }
            pattern = new byte[length];
            for (int i = 0; i < length; ++i) {
                int hex1 = this.hexValue(hexstring.charAt(i * 2));
                int hex2 = this.hexValue(hexstring.charAt(i * 2 + 1));
                if (hex1 < 0 || hex2 < 0) {
                    CommandUtils.dbgError(out, "Error: non-hex value found in hex string\n");
                    return;
                }
                pattern[i] = (byte)((hex1 << 4) + hex2);
            }
            if (patternAlignment == 0) {
                patternAlignment = 1;
            }
            CommandUtils.dbgPrint(out, String.format("Searching for %d bytes. Alignment = %d, start = %s, bytesToSearch = %s ...\n", length, patternAlignment, U8Pointer.cast(startSearchFrom).getHexAddress(), bytesToSearch.toString()));
            long result = this.dbgFindPatternInRange(context, pattern, patternAlignment, startSearchFrom, bytesToSearch);
            if (0L != result) {
                CommandUtils.dbgPrint(out, String.format("Result = %s\n", U8Pointer.cast(result).getHexAddress()));
            } else {
                CommandUtils.dbgPrint(out, String.format("Result = No Match Found.\n", new Object[0]));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }
}

