/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MonitorEnterRecordPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class GCVMThreadMonitorRecordSlotIterator
extends GCIterator {
    protected J9MonitorEnterRecordPointer monitorRecord;
    protected J9MonitorEnterRecordPointer jniMonitorRecord;

    protected GCVMThreadMonitorRecordSlotIterator(J9VMThreadPointer vmThread) throws CorruptDataException {
        this.monitorRecord = vmThread.monitorEnterRecords();
        this.jniMonitorRecord = vmThread.jniMonitorEnterRecords();
    }

    public static GCVMThreadMonitorRecordSlotIterator fromJ9VMThread(J9VMThreadPointer vmThread) throws CorruptDataException {
        return new GCVMThreadMonitorRecordSlotIterator(vmThread);
    }

    @Override
    public boolean hasNext() {
        return this.monitorRecord.notNull() || this.jniMonitorRecord.notNull();
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            try {
                J9ObjectPointer next;
                if (this.monitorRecord.notNull()) {
                    next = this.monitorRecord.object();
                    this.monitorRecord = this.monitorRecord.next();
                } else {
                    next = this.jniMonitorRecord.object();
                    this.jniMonitorRecord = this.jniMonitorRecord.next();
                }
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            try {
                VoidPointer next;
                if (this.monitorRecord.notNull()) {
                    next = VoidPointer.cast(this.monitorRecord.objectEA());
                    this.monitorRecord = this.monitorRecord.next();
                } else {
                    next = VoidPointer.cast(this.jniMonitorRecord.objectEA());
                    this.jniMonitorRecord = this.jniMonitorRecord.next();
                }
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

