/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.j9.gc.MMSublistIterator;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_ScavengerRememberedSetPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_SublistPoolPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_SublistPuddlePointer;
import java.util.NoSuchElementException;

public class GCRememberedSetIterator
extends GCIterator {
    int currentNode;
    int nodeCount;
    MM_ScavengerRememberedSetPointer rememberedSet;
    MMSublistIterator sublistIterator;
    MM_SublistPuddlePointer puddle;

    protected GCRememberedSetIterator(MM_ScavengerRememberedSetPointer scvRememberedSet) throws CorruptDataException {
        this.nodeCount = scvRememberedSet._nodeCount().intValue();
        this.currentNode = 1;
        this.rememberedSet = scvRememberedSet;
        this.sublistIterator = new MMSublistIterator(this.rememberedSet._pool().add(this.currentNode));
        this.puddle = null;
    }

    protected GCRememberedSetIterator(MM_SublistPoolPointer sublistPool) throws CorruptDataException {
        this.nodeCount = 1;
        this.currentNode = 1;
        this.rememberedSet = null;
        this.sublistIterator = new MMSublistIterator(sublistPool);
        this.puddle = null;
    }

    @Override
    public boolean hasNext() {
        if (null == this.puddle) {
            try {
                if (!this.sublistIterator.hasNext()) {
                    while (this.currentNode < this.nodeCount) {
                        ++this.currentNode;
                        this.sublistIterator = new MMSublistIterator(this.rememberedSet._pool().add(this.currentNode));
                        if (!this.sublistIterator.hasNext()) continue;
                        this.puddle = this.sublistIterator.next();
                        return true;
                    }
                    return false;
                }
                this.puddle = this.sublistIterator.next();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return false;
            }
        }
        return true;
    }

    @Override
    public MM_SublistPuddlePointer next() {
        if (this.hasNext()) {
            MM_SublistPuddlePointer returnPuddle = this.puddle;
            this.puddle = null;
            return returnPuddle;
        }
        throw new NoSuchElementException("There are no more puddles available through this iterator");
    }

    public static GCRememberedSetIterator from() throws CorruptDataException {
        try {
            MM_ScavengerRememberedSetPointer rsPointer = GCRememberedSetIterator.getExtensions().scvRememberedSet();
            return new GCRememberedSetIterator(rsPointer);
        }
        catch (NoSuchFieldError e) {
            MM_SublistPoolPointer rsPointer = GCRememberedSetIterator.getExtensions().rememberedSet();
            return new GCRememberedSetIterator(rsPointer);
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

