/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.gc.GCHeapMap;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.UDATAPointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.structure.MM_HeapMap;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.util.NoSuchElementException;

public class GCHeapMapWordIterator
extends GCIterator {
    public static UDATA J9MODRON_HEAP_BYTES_PER_UDATA_OF_HEAP_MAP = new UDATA(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * (long)UDATA.SIZEOF * (long)UDATA.SIZEOF * 8L);
    private UDATA _cache;
    private UDATAPointer _heapSlotCurrent;
    private J9ObjectPointer _next = null;

    public GCHeapMapWordIterator(UDATA heapMapWord, VoidPointer heapCardAddress) {
        this._cache = heapMapWord;
        this._heapSlotCurrent = UDATAPointer.cast(heapCardAddress);
        this._next = this.nextObject();
    }

    public GCHeapMapWordIterator(GCHeapMap heapMap, VoidPointer heapCardAddress) throws CorruptDataException {
        UDATA heapOffsetInBytes = UDATA.cast(heapCardAddress).sub(UDATA.cast(heapMap.getHeapBase()));
        U8Pointer heapMapBits = U8Pointer.cast(heapMap.getHeapMapBits());
        UDATAPointer mapPointer = UDATAPointer.cast(heapMapBits.add(heapOffsetInBytes.div(GCHeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_SLOT)));
        this._cache = mapPointer.at(0L);
        this._heapSlotCurrent = UDATAPointer.cast(heapCardAddress);
        this._next = this.nextObject();
    }

    private J9ObjectPointer nextObject() {
        J9ObjectPointer nextObject = null;
        if (!this._cache.eq(0L)) {
            int trailingZeros = this._cache.numberOfTrailingZeros();
            long slotsToSkip = (long)trailingZeros * MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT;
            this._heapSlotCurrent = this._heapSlotCurrent.add(slotsToSkip);
            this._cache = this._cache.rightShift(trailingZeros);
            nextObject = J9ObjectPointer.cast(this._heapSlotCurrent);
            this._heapSlotCurrent = this._heapSlotCurrent.add(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT);
            this._cache = this._cache.rightShift(1);
        }
        return nextObject;
    }

    @Override
    public boolean hasNext() {
        return null != this._next;
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer objectToReturn = this._next;
            this._next = this.nextObject();
            return objectToReturn;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

