/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCCellLinkedFreeHeader;
import com.ibm.j9ddr.vm28.j9.gc.GCIterator;
import com.ibm.j9ddr.vm28.j9.gc.GCMemoryPoolAggregatedCellList;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import java.util.NoSuchElementException;

public class GCFreeListIteratorAggregatedCellList
extends GCIterator {
    protected GCCellLinkedFreeHeader _currentFreeEntry = null;
    protected GCMemoryPoolAggregatedCellList _memoryPool = null;

    public GCFreeListIteratorAggregatedCellList(GCMemoryPoolAggregatedCellList memoryPool) throws CorruptDataException {
        this._memoryPool = memoryPool;
        this._currentFreeEntry = memoryPool.getFirstFreeEntry();
        if (this._currentFreeEntry.getCellLinkedHeader().isNull()) {
            this._currentFreeEntry = null;
        }
    }

    private void advanceFreeListEntry() {
        try {
            this._currentFreeEntry = GCCellLinkedFreeHeader.fromUDATAPointer(this._currentFreeEntry.getNextCell());
            if (this._currentFreeEntry.getCellLinkedHeader().isNull()) {
                this._currentFreeEntry = null;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", e, false);
        }
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCCellLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCCellLinkedFreeHeader next = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        GCFreeListIteratorAggregatedCellList tempIter = null;
        try {
            tempIter = new GCFreeListIteratorAggregatedCellList(this._memoryPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next().toString() + NEW_LINE);
        }
        return builder.toString();
    }
}

