/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm27.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm27.j9.walkers.ROMClassesRangeIterator;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;

public class AllClassesCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String rangeDelim = "..";
    private boolean dumpROMClasses;
    private boolean dumpRAMClasses;
    private U8Pointer rangeStart;
    private U8Pointer rangeEnd;

    public AllClassesCommand() {
        this.addCommand("allclasses", "[help|rom|ram [startAddr..endAddr]]", "Dump a list of loaded ROM/RAM classes. Use 'help' to see more details about the usage.");
    }

    private void init() {
        this.dumpRAMClasses = false;
        this.dumpROMClasses = false;
        this.rangeEnd = null;
        this.rangeStart = null;
    }

    private void printHelp(PrintStream out) {
        CommandUtils.dbgPrint(out, "!allclasses rom [startAddr..endAddr]   -- Dump a list of J9ROMClasses in the given range. If no range is given, all J9ROMClasses are displayed.\n");
        CommandUtils.dbgPrint(out, "                                          Note that 'startAddr' in the range should point to valid J9ROMClass.\n");
        CommandUtils.dbgPrint(out, "!allclasses ram [startAddr..endAddr]   -- Dump a list of J9Classes in the given range. If no range is given, all J9Classes are displayed.\n");
        CommandUtils.dbgPrint(out, "User may specify both 'rom' and 'ram' to dump J9ROMClasses and J9Classes\n");
        CommandUtils.dbgPrint(out, "Note: if no argument is specified, then all J9ROMClasses and J9Classes will be displayed\n");
    }

    private boolean getRange(PrintStream out, String arg) throws DDRInteractiveCommandException {
        String addr = arg.substring(0, arg.indexOf(rangeDelim));
        this.rangeStart = U8Pointer.cast(CommandUtils.parsePointer(addr, J9BuildFlags.env_data64));
        addr = arg.substring(arg.indexOf(rangeDelim) + rangeDelim.length());
        this.rangeEnd = U8Pointer.cast(CommandUtils.parsePointer(addr, J9BuildFlags.env_data64));
        if (this.rangeStart.getAddress() >= this.rangeEnd.getAddress()) {
            out.append("Invalid range specified. Ensure 'startAddr' < 'endAddr'" + nl);
            return false;
        }
        return true;
    }

    private boolean parseROMRAMRange(PrintStream out, String arg) throws DDRInteractiveCommandException {
        if (arg.equals("rom")) {
            if (this.dumpROMClasses) {
                out.append("Argument '" + arg + "' is specified twice" + nl);
                return false;
            }
            this.dumpROMClasses = true;
        } else if (arg.equals("ram")) {
            if (this.dumpRAMClasses) {
                out.append("Argument '" + arg + "' is specified twice" + nl);
                return false;
            }
            this.dumpRAMClasses = true;
        } else {
            if (arg.indexOf(rangeDelim) != -1) {
                return this.getRange(out, arg);
            }
            out.append("Unrecognized argument: " + arg + nl);
            return false;
        }
        return true;
    }

    private boolean parseROMRAM(PrintStream out, String arg) throws DDRInteractiveCommandException {
        if (arg.equals("rom")) {
            if (this.dumpROMClasses) {
                out.append("Argument '" + arg + "' is specified twice" + nl);
                return false;
            }
            this.dumpROMClasses = true;
        } else if (arg.equals("ram")) {
            if (this.dumpRAMClasses) {
                out.append("Argument '" + arg + "' is specified twice" + nl);
                return false;
            }
            this.dumpRAMClasses = true;
        } else {
            out.append("Invalid argument: " + arg + nl);
            return false;
        }
        return true;
    }

    private boolean parseRange(PrintStream out, String arg) throws DDRInteractiveCommandException {
        if (arg.indexOf(rangeDelim) != -1) {
            return this.getRange(out, arg);
        }
        out.append("Invalid argument: " + arg);
        return false;
    }

    private boolean parseArgs(PrintStream out, String[] args) throws DDRInteractiveCommandException {
        if (args.length > 3) {
            out.append("Invalid number of argments" + nl);
            return false;
        }
        switch (args.length) {
            case 1: {
                if (args[0].equals("help")) {
                    this.printHelp(out);
                    return false;
                }
                if (this.parseROMRAM(out, args[0])) break;
                return false;
            }
            case 2: {
                if (!this.parseROMRAM(out, args[0])) {
                    return false;
                }
                if (this.parseROMRAMRange(out, args[1])) break;
                return false;
            }
            case 3: {
                if (!this.parseROMRAM(out, args[0])) {
                    return false;
                }
                if (!this.parseROMRAM(out, args[1])) {
                    return false;
                }
                if (this.parseRange(out, args[2])) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        boolean useRange;
        this.init();
        if (args != null && !this.parseArgs(out, args)) {
            return;
        }
        boolean bl = useRange = this.rangeStart != null && this.rangeEnd != null;
        if (!this.dumpROMClasses && !this.dumpRAMClasses) {
            this.dumpRAMClasses = true;
            this.dumpROMClasses = true;
        }
        try {
            StructurePointer classPointer;
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (this.dumpRAMClasses) {
                out.append("RAM classes (ram size loader rom replacement name)" + nl);
                out.append("Class addr\tsize\t\tClassLoader\tROM class addr\tArray\tClass name" + nl);
                out.append(nl);
                ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
                while (classSegmentIterator.hasNext()) {
                    classPointer = J9ClassPointer.NULL;
                    try {
                        classPointer = (J9ClassPointer)classSegmentIterator.next();
                        if (useRange && (classPointer.getAddress() < this.rangeStart.getAddress() || classPointer.getAddress() >= this.rangeEnd.getAddress())) continue;
                        out.append(classPointer.getHexAddress());
                        out.append('\t');
                        out.append(J9ClassHelper.size((J9ClassPointer)classPointer, vm).getHexValue());
                        out.append('\t');
                        out.append(((J9ClassPointer)classPointer).classLoader().getHexAddress());
                        out.append('\t');
                        out.append(((J9ClassPointer)classPointer).romClass().getHexAddress());
                        out.append('\t');
                        if (J9ClassHelper.isSwappedOut((J9ClassPointer)classPointer)) {
                            out.append(((J9ClassPointer)classPointer).arrayClass().getHexAddress());
                        } else {
                            out.append('0');
                        }
                        out.append('\t');
                        out.append(J9ClassHelper.getJavaName((J9ClassPointer)classPointer));
                        out.append(nl);
                    }
                    catch (CorruptDataException e) {
                        if (useRange && classPointer.getAddress() >= this.rangeStart.getAddress() && classPointer.getAddress() < this.rangeEnd.getAddress()) continue;
                    }
                }
            }
            if (this.dumpROMClasses) {
                ROMClassesIterator iterator = null;
                out.append(nl);
                if (useRange) {
                    iterator = new ROMClassesRangeIterator(out, this.rangeStart, this.rangeEnd);
                    out.append("ROM classes (rom size modifiers name)" + nl);
                    out.append("Class addr\tROM size\tModifiers\tExtra\t\tClass name" + nl);
                } else {
                    iterator = new ROMClassesIterator(out, vm.classMemorySegments());
                    out.append("ROM classes (rom size loader modifiers name)" + nl);
                    out.append("Class addr\tROM size\tClassLoader\tModifiers\tExtra\t\tClass name" + nl);
                }
                out.append(nl);
                while (iterator.hasNext()) {
                    classPointer = iterator.next();
                    out.append(classPointer.getHexAddress());
                    out.append('\t');
                    out.append(((J9ROMClassPointer)classPointer).romSize().getHexValue());
                    if (iterator.getMemorySegmentPointer() != J9MemorySegmentPointer.NULL) {
                        out.append('\t');
                        out.append(iterator.getMemorySegmentPointer().classLoader().getHexAddress());
                    }
                    out.append('\t');
                    out.append(((J9ROMClassPointer)classPointer).modifiers().getHexValue());
                    out.append('\t');
                    out.append(((J9ROMClassPointer)classPointer).extraModifiers().getHexValue());
                    out.append('\t');
                    out.append(J9UTF8Helper.stringValue(((J9ROMClassPointer)classPointer).className()));
                    out.append(nl);
                }
                out.append(nl);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

