/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.events;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm27.events.DefaultEventListener;
import java.util.LinkedList;
import java.util.logging.Logger;

public class EventManager {
    private static Logger log = Logger.getLogger(EventManager.class.getPackage().getName());
    private static LinkedList<IEventListener> listeners = null;
    private static DefaultEventListener defaultListener = null;

    public static void register(IEventListener listener) {
        IEventListener top;
        if (!listeners.isEmpty() && (top = listeners.peek()) == listener) {
            log.warning(String.format("The specified event listener was already registered : %s", listener.getClass().getName()));
            return;
        }
        listeners.addFirst(listener);
    }

    public static void unregister(IEventListener listener) {
        if (listeners.isEmpty()) {
            log.warning("There are no listeners left on the stack, skipping unregistration");
            return;
        }
        IEventListener top = listeners.peek();
        if (top != listener) {
            String msg = String.format("The top listener on the stack does not match : expected [%s] actual [%s]", listener.getClass().getName(), top.getClass().getName());
            log.warning(msg);
            return;
        }
        listeners.removeFirst();
    }

    public static void raiseCorruptDataEvent(String message2, CorruptDataException e, boolean fatal) {
        if (listeners.isEmpty()) {
            defaultListener.corruptData(message2, e, fatal);
        } else {
            IEventListener listener = listeners.peek();
            listener.corruptData(message2, e, fatal);
        }
    }

    static {
        listeners = new LinkedList();
        defaultListener = new DefaultEventListener();
    }
}

