/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMClassSlots
extends Check {
    CheckVMClassSlots() {
    }

    @Override
    public void check() {
        try {
            GCVMClassSlotIterator classSlotIterator = GCVMClassSlotIterator.from();
            while (classSlotIterator.hasNext()) {
                J9ClassPointer theClazz = classSlotIterator.next();
                if (!theClazz.notNull() || this._engine.checkJ9ClassPointer(theClazz) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "VM CLASS SLOTS";
    }

    @Override
    public void print() {
        try {
            GCVMClassSlotIterator classSlotIterator = GCVMClassSlotIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "VMClass Slot");
            while (classSlotIterator.hasNext()) {
                J9ClassPointer theClazz = classSlotIterator.next();
                if (!theClazz.notNull()) continue;
                formatter.entry(theClazz);
            }
            formatter.end("VMClass Slot");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

