/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.gc.GCCellLinkedFreeHeader;
import com.ibm.j9ddr.vm26.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMGCSegregatedAllocationCacheEntryPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.structure.MM_HeapRegionDescriptor$RegionType;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class GCObjectHeapIteratorSegregated_V1
extends GCObjectHeapIterator {
    protected J9ObjectPointer currentObject = null;
    protected U8Pointer scanPtr;
    protected U8Pointer scanPtrTop;
    protected J9ObjectPointer smallPtrTop;
    protected long type;
    protected UDATA cellSize;
    protected U8Pointer[][] allocationCacheRanges;
    protected int currentAllocationCacheRange;
    protected static ArrayList<U8Pointer[]> threadAllocationCacheRanges;
    protected static Comparator<U8Pointer[]> rangeSorter;

    protected GCObjectHeapIteratorSegregated_V1(U8Pointer base, U8Pointer top, long type2, UDATA cellSize, boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        super(includeLiveObjects, includeDeadObjects);
        this.scanPtr = base;
        this.scanPtrTop = top;
        this.type = type2;
        this.cellSize = cellSize;
        this.currentAllocationCacheRange = 0;
        this.calculateActualScanPtrTop();
        ArrayList<U8Pointer[]> allocationCacheRangeList = new ArrayList<U8Pointer[]>(threadAllocationCacheRanges);
        allocationCacheRangeList.add(new U8Pointer[]{this.scanPtrTop, this.scanPtrTop});
        Collections.sort(allocationCacheRangeList, rangeSorter);
        this.allocationCacheRanges = new U8Pointer[allocationCacheRangeList.size()][2];
        allocationCacheRangeList.toArray((T[])this.allocationCacheRanges);
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.currentObject) {
                return true;
            }
            while (this.scanPtr.lt(this.scanPtrTop)) {
                while (this.scanPtr.gt(this.allocationCacheRanges[this.currentAllocationCacheRange][1])) {
                    ++this.currentAllocationCacheRange;
                }
                if (this.scanPtr.gte(this.allocationCacheRanges[this.currentAllocationCacheRange][0])) {
                    this.scanPtr = U8Pointer.cast(this.allocationCacheRanges[this.currentAllocationCacheRange][1]);
                    ++this.currentAllocationCacheRange;
                    continue;
                }
                this.currentObject = J9ObjectPointer.cast(this.scanPtr);
                if (MM_HeapRegionDescriptor$RegionType.SEGREGATED_SMALL == this.type) {
                    GCCellLinkedFreeHeader cellLink = GCCellLinkedFreeHeader.fromJ9Object(this.currentObject);
                    if (!cellLink.isLinked()) {
                        this.scanPtr = this.scanPtr.addOffset(this.cellSize);
                        if (!this.includeLiveObjects) continue;
                        return true;
                    }
                    UDATA sizeInBytes = cellLink.getSizeInBytes();
                    if (sizeInBytes.lt(this.cellSize)) {
                        this.currentObject = null;
                        throw new CorruptDataException("GCCellLinkedFreeHeader at " + this.scanPtr.getHexAddress() + " has an invalid size of " + sizeInBytes.getHexValue());
                    }
                    this.scanPtr = this.scanPtr.addOffset(sizeInBytes);
                    if (!this.includeDeadObjects) continue;
                    return true;
                }
                if (MM_HeapRegionDescriptor$RegionType.SEGREGATED_LARGE == this.type) {
                    this.scanPtr = U8Pointer.cast(this.scanPtrTop);
                    if (!this.includeLiveObjects) continue;
                    return true;
                }
                throw new CorruptDataException("Invalid region type");
            }
            return false;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return false;
        }
    }

    @Override
    public void advance(UDATA size) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer next = this.currentObject;
            this.currentObject = null;
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    private void calculateActualScanPtrTop() {
        if (MM_HeapRegionDescriptor$RegionType.SEGREGATED_SMALL == this.type) {
            UDATA cellCount = UDATA.cast(this.scanPtrTop).sub(UDATA.cast(this.scanPtr)).div(this.cellSize);
            UDATA actualSize = cellCount.mult(this.cellSize);
            this.scanPtrTop = this.scanPtr.add(actualSize);
        }
    }

    @Override
    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            return this.currentObject;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    static {
        rangeSorter = new Comparator<U8Pointer[]>(){

            @Override
            public int compare(U8Pointer[] o1, U8Pointer[] o2) {
                return o1[0].compare(o2[0]);
            }
        };
        try {
            ArrayList<U8Pointer[]> ranges = new ArrayList<U8Pointer[]>();
            GCVMThreadListIterator threadIterator = new GCVMThreadListIterator();
            while (threadIterator.hasNext()) {
                J9VMThreadPointer vmThread = threadIterator.next();
                long smallSizeClassesNumVersion1 = 0L;
                long smallSizeClassesNumVersion2 = 0L;
                try {
                    Class<?> j9vmgcSizeClass = Class.forName(DataType.getStructurePackageName() + ".J9VMGCSizeClasses");
                    Field fieldVersion1 = j9vmgcSizeClass.getDeclaredField("J9VMGC_SIZECLASSES_NUM_SMALL");
                    smallSizeClassesNumVersion1 = fieldVersion1.getLong(null);
                }
                catch (NoSuchFieldException j9vmgcSizeClass) {
                }
                catch (ClassNotFoundException j9vmgcSizeClass) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnsupportedOperationException("This shouldn't happen considering how DDR works");
                }
                try {
                    Class<?> j9ConstsClass = Class.forName(DataType.getStructurePackageName() + ".J9Consts");
                    Field sizeClassNumfield2 = j9ConstsClass.getDeclaredField("J9VMGC_SIZECLASSES_NUM_SMALL");
                    smallSizeClassesNumVersion2 = sizeClassNumfield2.getLong(null);
                }
                catch (NoSuchFieldException j9ConstsClass) {
                }
                catch (ClassNotFoundException j9ConstsClass) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnsupportedOperationException("This shouldn't happen considering how DDR works");
                }
                if (smallSizeClassesNumVersion1 == 0L && smallSizeClassesNumVersion2 == 0L) {
                    throw new UnsupportedOperationException("This cores seems invalid.. J9VMGC_SIZECLASSES_NUM_SMALL must be defined in either J9Consts or J9VMGCSizeClasses");
                }
                if (smallSizeClassesNumVersion1 != 0L && smallSizeClassesNumVersion2 != 0L) {
                    throw new UnsupportedOperationException("This cores seems invalid.. J9VMGC_SIZECLASSES_NUM_SMALL can't be defined in two places");
                }
                long smallSizeClassesNum = smallSizeClassesNumVersion1 != 0L ? smallSizeClassesNumVersion1 : smallSizeClassesNumVersion2;
                int sizeClass = 0;
                while ((long)sizeClass < smallSizeClassesNum + 1L) {
                    U8Pointer heapTop;
                    J9VMGCSegregatedAllocationCacheEntryPointer allocationCache = vmThread.segregatedAllocationCacheEA().add(sizeClass);
                    U8Pointer heapCurrent = U8Pointer.cast(allocationCache.current());
                    if (heapCurrent.lt(heapTop = U8Pointer.cast(allocationCache.top()))) {
                        ranges.add(new U8Pointer[]{heapCurrent, heapTop});
                    }
                    ++sizeClass;
                }
            }
            Collections.sort(ranges, rangeSorter);
            threadAllocationCacheRanges = ranges;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error calculating active allocation cache ranges", e, true);
        }
    }
}

