/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9RAMMethodHandleRefPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9RAMMethodTypeRefPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm26.structure.J9ConstantPool;
import com.ibm.j9ddr.vm26.structure.J9RAMConstantPoolItem;
import java.util.ArrayList;
import java.util.Iterator;

public class GCConstantPoolSlotIterator
extends GCIterator {
    protected Iterator<AbstractPointer> slotIterator;
    protected Iterator<VoidPointer> addressIterator;

    protected GCConstantPoolSlotIterator(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        this.initializeSlots_V1(clazz, returnClassSlots, returnObjectSlots);
    }

    public static GCConstantPoolSlotIterator fromJ9Class(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        return new GCConstantPoolSlotIterator(clazz, returnClassSlots, returnObjectSlots);
    }

    protected void initializeSlots_V1(J9ClassPointer clazz, boolean returnClassSlots, boolean returnObjectSlots) throws CorruptDataException {
        U32Pointer cpDescriptionSlots = clazz.romClass().cpShapeDescription();
        PointerPointer cpEntry = PointerPointer.cast(clazz.ramConstantPool());
        long cpDescription = 0L;
        long cpEntryCount = clazz.romClass().ramConstantPoolCount().longValue();
        long cpDescriptionIndex = 0L;
        ArrayList<StructurePointer> slots = new ArrayList<StructurePointer>();
        ArrayList<VoidPointer> addresses = new ArrayList<VoidPointer>();
        while (cpEntryCount > 0L) {
            StructurePointer ref;
            StructurePointer slot;
            long slotType;
            if (0L == cpDescriptionIndex) {
                cpDescription = cpDescriptionSlots.at(0L).longValue();
                cpDescriptionSlots = cpDescriptionSlots.add(1L);
                cpDescriptionIndex = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            }
            if ((slotType = cpDescription & J9ConstantPool.J9_CP_DESCRIPTION_MASK) == J9ConstantPool.J9CPTYPE_STRING) {
                if (returnObjectSlots && (slot = ((J9RAMStringRefPointer)(ref = J9RAMStringRefPointer.cast(cpEntry))).stringObject()).notNull()) {
                    slots.add(slot);
                    addresses.add(VoidPointer.cast(((J9RAMStringRefPointer)ref).stringObjectEA()));
                }
            } else if (slotType == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                if (returnObjectSlots && (slot = ((J9RAMMethodTypeRefPointer)(ref = J9RAMMethodTypeRefPointer.cast(cpEntry))).type()).notNull()) {
                    slots.add(slot);
                    addresses.add(VoidPointer.cast(((J9RAMMethodTypeRefPointer)ref).typeEA()));
                }
            } else if (slotType == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                if (returnObjectSlots && (slot = ((J9RAMMethodHandleRefPointer)(ref = J9RAMMethodHandleRefPointer.cast(cpEntry))).methodHandle()).notNull()) {
                    slots.add(slot);
                    addresses.add(VoidPointer.cast(((J9RAMMethodHandleRefPointer)ref).methodHandleEA()));
                }
            } else if (slotType == J9ConstantPool.J9CPTYPE_CLASS && returnClassSlots && (slot = ((J9RAMClassRefPointer)(ref = J9RAMClassRefPointer.cast(cpEntry))).value()).notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(((J9RAMClassRefPointer)ref).valueEA()));
            }
            cpEntry = cpEntry.addOffset(J9RAMConstantPoolItem.SIZEOF);
            --cpEntryCount;
            cpDescription >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            --cpDescriptionIndex;
        }
        this.slotIterator = slots.iterator();
        this.addressIterator = addresses.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    @Override
    public AbstractPointer next() {
        this.addressIterator.next();
        return this.slotIterator.next();
    }

    @Override
    public VoidPointer nextAddress() {
        this.slotIterator.next();
        return this.addressIterator.next();
    }
}

