/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm26.j9.gc.GCBase;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.GC_ArrayletObjectModelPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMArrayClassPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm26.structure.GC_ArrayletObjectModel$ArrayLayout;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.structure.J9IndexableObjectContiguous;
import com.ibm.j9ddr.vm26.structure.J9IndexableObjectDiscontiguous;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.NoSuchElementException;

class GCArrayletObjectModel_V2
extends GCArrayObjectModel {
    protected GC_ArrayletObjectModelPointer arrayletObjectModel = GC_ArrayletObjectModelPointer.cast(GCBase.getExtensions().indexableObjectModel());
    protected VoidPointer arrayletRangeBase = this.arrayletObjectModel._arrayletRangeBase();
    protected VoidPointer arrayletRangeTop = this.arrayletObjectModel._arrayletRangeTop();
    protected UDATA largestDesirableArraySpineSize = this.arrayletObjectModel._largestDesirableArraySpineSize();
    protected UDATA arrayletLeafSize;
    protected UDATA arrayletLeafLogSize;
    protected UDATA arrayletLeafSizeMask;

    public GCArrayletObjectModel_V2() throws CorruptDataException {
        J9JavaVMPointer vm = this.arrayletObjectModel._vm();
        this.arrayletLeafSize = vm.arrayletLeafSize();
        this.arrayletLeafLogSize = vm.arrayletLeafLogSize();
        this.arrayletLeafSizeMask = this.arrayletLeafSize.sub(1L);
    }

    protected boolean isInlineContiguousArraylet(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getArrayLayout(array) == GC_ArrayletObjectModel$ArrayLayout.InlineContiguous;
    }

    protected long getArrayLayout(J9IndexableObjectPointer array) throws CorruptDataException {
        if (J9BuildFlags.gc_hybridArraylets && !J9IndexableObjectContiguousPointer.cast(array).size().eq(0L)) {
            return GC_ArrayletObjectModel$ArrayLayout.InlineContiguous;
        }
        if (array.lt(this.arrayletRangeBase) || array.gte(this.arrayletRangeTop)) {
            return GC_ArrayletObjectModel$ArrayLayout.InlineContiguous;
        }
        UDATA dataSizeInBytes = this.getDataSizeInBytes(array);
        long layout = this.getArrayLayout(J9IndexableObjectHelper.clazz(array), dataSizeInBytes);
        return layout;
    }

    protected long getArrayLayout(J9ArrayClassPointer clazz, UDATA dataSizeInBytes) throws CorruptDataException {
        long layout = GC_ArrayletObjectModel$ArrayLayout.Illegal;
        UDATA minimumSpineSize = J9BuildFlags.gc_hybridArraylets ? new UDATA(0L) : new UDATA(ObjectReferencePointer.SIZEOF);
        UDATA minimumSpineSizeAfterGrowing = minimumSpineSize;
        if (GCExtensions.isVLHGC()) {
            minimumSpineSize = minimumSpineSize.add(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES);
        }
        if (this.largestDesirableArraySpineSize.eq(UDATA.MAX) || dataSizeInBytes.lte(this.largestDesirableArraySpineSize.sub(minimumSpineSizeAfterGrowing).sub(J9IndexableObjectContiguous.SIZEOF))) {
            layout = GC_ArrayletObjectModel$ArrayLayout.InlineContiguous;
        } else {
            UDATA adjustedHybridSpineBytes;
            UDATA lastArrayletBytes = dataSizeInBytes.bitAnd(this.arrayletLeafSizeMask);
            UDATA numberArraylets = this.numArraylets(dataSizeInBytes);
            boolean align = this.shouldAlignSpineDataSection(clazz);
            UDATA hybridSpineBytes = this.getSpineSize(GC_ArrayletObjectModel$ArrayLayout.Hybrid, numberArraylets, dataSizeInBytes, align);
            UDATA adjustedHybridSpineBytesAfterMove = adjustedHybridSpineBytes = ObjectModel.adjustSizeInBytes(hybridSpineBytes);
            if (GCExtensions.isVLHGC()) {
                adjustedHybridSpineBytesAfterMove.add(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES);
            }
            layout = lastArrayletBytes.gt(0) && adjustedHybridSpineBytesAfterMove.lte(this.largestDesirableArraySpineSize) ? GC_ArrayletObjectModel$ArrayLayout.Hybrid : GC_ArrayletObjectModel$ArrayLayout.Discontiguous;
        }
        return layout;
    }

    @Override
    public UDATA getHeaderSize(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 size;
        UDATA headerSize = J9BuildFlags.gc_hybridArraylets ? ((size = J9IndexableObjectContiguousPointer.cast(array).size()).eq(0L) ? new UDATA(J9IndexableObjectDiscontiguous.SIZEOF) : new UDATA(J9IndexableObjectContiguous.SIZEOF)) : new UDATA(J9IndexableObjectDiscontiguous.SIZEOF);
        return headerSize;
    }

    protected UDATA getHeaderSize(long layout) {
        UDATA headerSize = J9BuildFlags.gc_hybridArraylets ? (GC_ArrayletObjectModel$ArrayLayout.InlineContiguous != layout ? new UDATA(J9IndexableObjectDiscontiguous.SIZEOF) : new UDATA(J9IndexableObjectContiguous.SIZEOF)) : new UDATA(J9IndexableObjectDiscontiguous.SIZEOF);
        return headerSize;
    }

    protected UDATA getSpineSizeWithoutHeader(long layout, UDATA numberArraylets, UDATA dataSize, boolean alignData) throws CorruptDataException {
        UDATA spinePaddingSize;
        UDATA spineArrayoidSize;
        if (J9BuildFlags.gc_hybridArraylets) {
            spineArrayoidSize = new UDATA(0L);
            spinePaddingSize = new UDATA(0L);
            if (GC_ArrayletObjectModel$ArrayLayout.InlineContiguous != layout) {
                spinePaddingSize = alignData ? new UDATA(ObjectReferencePointer.SIZEOF) : new UDATA(0L);
                spineArrayoidSize = numberArraylets.mult(ObjectReferencePointer.SIZEOF);
            } else if (dataSize.eq(0L)) {
                spinePaddingSize = new UDATA(J9IndexableObjectDiscontiguous.SIZEOF - J9IndexableObjectContiguous.SIZEOF);
            }
        } else {
            spinePaddingSize = alignData ? new UDATA(ObjectReferencePointer.SIZEOF) : new UDATA(0L);
            spineArrayoidSize = numberArraylets.mult(ObjectReferencePointer.SIZEOF);
        }
        UDATA spineDataSize = new UDATA(0L);
        if (GC_ArrayletObjectModel$ArrayLayout.InlineContiguous == layout) {
            spineDataSize = dataSize;
        } else if (GC_ArrayletObjectModel$ArrayLayout.Hybrid == layout) {
            spineDataSize = dataSize.bitAnd(this.arrayletLeafSizeMask);
        }
        return spinePaddingSize.add(spineArrayoidSize).add(spineDataSize);
    }

    protected UDATA getSpineSize(J9IndexableObjectPointer array) throws CorruptDataException {
        long layout = this.getArrayLayout(array);
        boolean alignData = this.shouldAlignSpineDataSection(J9IndexableObjectHelper.clazz(array));
        UDATA dataSize = this.getDataSizeInBytes(array);
        UDATA numberArraylets = this.numArraylets(dataSize);
        return this.getSpineSize(layout, numberArraylets, dataSize, alignData);
    }

    public UDATA getSpineSize(long layout, UDATA numberArraylets, UDATA dataSize, boolean alignData) throws CorruptDataException {
        return this.getSpineSizeWithoutHeader(layout, numberArraylets, dataSize, alignData).add(this.getHeaderSize(layout));
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getSpineSize(array);
    }

    @Override
    public UDATA getHashcodeOffset(J9IndexableObjectPointer array) throws CorruptDataException {
        long layout = this.getArrayLayout(array);
        J9ArrayClassPointer clazz = J9IndexableObjectHelper.clazz(array);
        U32 arrayShape = J9ROMArrayClassPointer.cast(clazz.romClass()).arrayShape();
        UDATA numberOfElements = this.getSizeInElements(array);
        UDATA dataSize = numberOfElements.leftShift(arrayShape.bitAnd(65535).intValue());
        UDATA numberArraylets = this.numArraylets(dataSize);
        boolean alignData = this.shouldAlignSpineDataSection(clazz);
        UDATA spineSize = this.getSpineSize(layout, numberArraylets, dataSize, alignData);
        return U32.roundToSizeofU32(spineSize);
    }

    protected boolean shouldAlignSpineDataSection(J9ArrayClassPointer clazz) throws CorruptDataException {
        UDATA classShape;
        boolean needAlignment = false;
        if (J9BuildFlags.gc_compressedPointers) {
            needAlignment = true;
        } else if (!J9BuildFlags.env_data64 && J9Object.OBJECT_HEADER_SHAPE_DOUBLES == (classShape = ObjectModel.getClassShape(J9ClassPointer.cast(clazz))).longValue()) {
            needAlignment = true;
        }
        return needAlignment;
    }

    protected UDATA numArraylets(UDATA dataSizeInBytes) throws CorruptDataException {
        if (dataSizeInBytes.eq(0L)) {
            return new UDATA(1L);
        }
        return dataSizeInBytes.rightShift(this.arrayletLeafLogSize).add(dataSizeInBytes.bitAnd(this.arrayletLeafSizeMask).add(this.arrayletLeafSizeMask).rightShift(this.arrayletLeafLogSize));
    }

    protected UDATA getDataSizeInBytes(J9IndexableObjectPointer array) throws CorruptDataException {
        J9ArrayClassPointer clazz = J9IndexableObjectHelper.clazz(array);
        U32 arrayShape = J9ROMArrayClassPointer.cast(clazz.romClass()).arrayShape();
        UDATA numberOfElements = this.getSizeInElements(array);
        UDATA size = numberOfElements.leftShift(arrayShape.bitAnd(65535).intValue());
        return UDATA.roundToSizeofUDATA(size);
    }

    protected ObjectReferencePointer getArrayoidPointer(J9IndexableObjectPointer arrayPtr) {
        return ObjectReferencePointer.cast(arrayPtr.addOffset(J9IndexableObjectDiscontiguous.SIZEOF));
    }

    protected VoidPointer getDataPointerForContiguous(J9IndexableObjectPointer arrayPtr) throws CorruptDataException {
        if (J9BuildFlags.gc_hybridArraylets) {
            return VoidPointer.cast(arrayPtr.addOffset(J9IndexableObjectContiguous.SIZEOF));
        }
        ObjectReferencePointer arrayoidPointer = this.getArrayoidPointer(arrayPtr);
        return VoidPointer.cast(arrayoidPointer.at(0L));
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer array, int elementIndex, int elementSize) throws CorruptDataException {
        UDATA arrayletIndex;
        boolean isInlineContiguous = this.isInlineContiguousArraylet(array);
        UDATA byteOffsetIntoData = new UDATA(elementIndex * elementSize);
        if (isInlineContiguous) {
            return VoidPointer.cast(this.getDataPointerForContiguous(array).addOffset(byteOffsetIntoData));
        }
        ObjectReferencePointer arrayoid = this.getArrayoidPointer(array);
        VoidPointer arrayletLeafBaseAddress = VoidPointer.cast(arrayoid.at(arrayletIndex = byteOffsetIntoData.rightShift(this.arrayletLeafLogSize)));
        if (arrayletLeafBaseAddress.isNull()) {
            throw new NoSuchElementException("Arraylet leaf not yet initialized");
        }
        UDATA indexIntoArraylet = byteOffsetIntoData.bitAnd(this.arrayletLeafSizeMask);
        return arrayletLeafBaseAddress.addOffset(indexIntoArraylet);
    }
}

