/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm24.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import java.util.NoSuchElementException;

class GCPointerArrayIterator_V1
extends GCObjectIterator {
    protected ObjectReferencePointer data;
    protected int scanIndex = 0;
    protected int scanLimit;

    protected GCPointerArrayIterator_V1(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        super(object, includeClassSlot);
        this.scanLimit = ObjectModel.getSizeInElements(object).intValue();
        if (J9BuildFlags.gc_arraylets) {
            throw new UnsupportedOperationException("No arraylet support yet");
        }
        this.data = ObjectReferencePointer.cast(object.addOffset(ObjectModel.getHeaderSize(object)));
    }

    @Override
    public boolean hasNext() {
        if (this.includeClassSlot) {
            return true;
        }
        return this.scanIndex < this.scanLimit;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return J9ObjectHelper.clazz(this.object).classObject();
                }
                J9ObjectPointer next = this.data.at(this.scanIndex);
                ++this.scanIndex;
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        try {
            if (this.hasNext()) {
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return VoidPointer.cast(J9ObjectHelper.clazz(this.object).classObjectEA());
                }
                VoidPointer next = VoidPointer.cast(this.data.add(this.scanIndex));
                ++this.scanIndex;
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }
}

