/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexedb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexedb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexedbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexqpcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcbpool32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexqpcbpool64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexqpcbpoolTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.EnsmTemplate;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Logger;

public class Edb {
    private long address;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Properties envVars;
    CeexedbTemplate ceexedbTemplate;
    private CeexqpcbTemplate ceexqpcbTemplate;
    private CeexqpcbpoolTemplate ceexqpcbpoolTemplate;
    private boolean is64bit;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private Dll firstDll = null;

    public Edb(long address, AddressSpace space, boolean is64bit) {
        this.address = address;
        this.space = space;
        this.is64bit = is64bit;
        this.inputStream = space.getImageInputStream();
        this.createTemplates(space);
    }

    void createTemplates(AddressSpace space) {
        if (this.is64bit) {
            this.ceexedbTemplate = new Ceexedb64Template();
            this.ceexqpcbTemplate = new Ceexqpcb64Template();
            this.ceexqpcbpoolTemplate = new Ceexqpcbpool64Template();
        } else {
            this.ceexedbTemplate = new Ceexedb32Template();
            this.ceexqpcbTemplate = new Ceexqpcb32Template();
            this.ceexqpcbpoolTemplate = new Ceexqpcbpool32Template();
        }
    }

    public long address() {
        return this.address;
    }

    public long ceeedbensm() throws IOException {
        return this.ceexedbTemplate.getCeeedbensm(this.inputStream, this.address);
    }

    public long ensm_aheap() throws IOException {
        assert (!this.space.is64bit());
        return this.ceeedbensm() + (long)EnsmTemplate.getEnsm_aheap$offset();
    }

    public long ensm_uheap() throws IOException {
        assert (!this.space.is64bit());
        return this.ceeedbensm() + (long)EnsmTemplate.getEnsm_uheap$offset();
    }

    public long ceeedboptcb() throws IOException {
        return this.ceexedbTemplate.getCeeedboptcb(this.inputStream, this.address);
    }

    public long ceeedb_ceeosigr() throws IOException {
        return this.ceexedbTemplate.getCeeedb_ceeosigr(this.inputStream, this.address);
    }

    public long ceeedb_qpcb() throws IOException {
        return this.ceexedbTemplate.getCeeedb_qpcb(this.inputStream, this.address);
    }

    public long getMallocSize(long ptr) throws IOException, IllegalArgumentException {
        long index2;
        long index1 = this.space.readWord(ptr - (long)(2 * this.space.getWordLength()));
        if (index1 != (index2 = this.space.readWord(ptr - (long)this.space.getWordLength()))) {
            try {
                String hanc = this.space.readEbcdicString(index1, 4);
                if (!hanc.equals("HANC")) {
                    throw new IllegalArgumentException("Did not find HANC eyecatcher at index1 " + Edb.hex(index1) + " given ptr " + Edb.hex(ptr) + " index2 " + Edb.hex(index2));
                }
                if (index2 < 0L) {
                    throw new IllegalArgumentException("Negative size " + index2 + " given ptr " + Edb.hex(ptr));
                }
                return index2;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Got exception while reading hanc pointer " + Edb.hex(index1) + " given ptr " + Edb.hex(ptr));
            }
        }
        if (index1 < 1L || index1 > 12L) {
            throw new IllegalArgumentException("Unexpected index1 " + Edb.hex(index1) + " for ptr " + Edb.hex(ptr));
        }
        long qpcb = this.ceeedb_qpcb();
        assert (this.space.readEbcdicString(qpcb, 4).equals("QPCB"));
        long pool = qpcb + (long)this.ceexqpcbTemplate.getQpcb_pool_data_array$offset();
        long pool_index = this.ceexqpcbpoolTemplate.getQpcb_pool_index(this.inputStream, pool += (index1 - 1L) * (long)this.ceexqpcbpoolTemplate.length());
        if (pool_index != index1) {
            log.fine("bad pool index " + pool_index + " does not match " + index1);
            return 0L;
        }
        long size = this.ceexqpcbpoolTemplate.getQpcb_input_cell_size(this.inputStream, pool);
        assert (size + (long)(2 * this.space.getWordLength()) == this.ceexqpcbpoolTemplate.getQpcb_cell_size(this.inputStream, pool));
        return size;
    }

    public long ceeedbdba() throws IOException {
        return this.ceexedbTemplate.getCeeedbdba(this.inputStream, this.address);
    }

    public static Edb getSampleEdb(AddressSpace space) {
        Caa[] caas = Caa.getCaas(space);
        for (int i = 0; i < caas.length; ++i) {
            Edb edb = caas[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caas[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                return edb;
            }
            catch (IOException e) {
                log.fine("caught exception: " + e);
            }
        }
        log.fine("no sample edb found");
        return null;
    }

    public static Edb[] getEdbs(AddressSpace space) {
        HashSet<Edb> set = new HashSet<Edb>();
        Caa[] caas = Caa.getCaas(space);
        for (int i = 0; i < caas.length; ++i) {
            Edb edb = caas[i].getEdb();
            log.fine("found edb " + edb + " for caa " + caas[i]);
            try {
                if (edb.getFirstDll() == null) continue;
                log.fine("edb has a dll: " + edb.getFirstDll());
                set.add(edb);
                continue;
            }
            catch (IOException e) {
                log.fine("caught exception: " + e);
            }
        }
        log.fine("no sample edb found");
        return set.toArray(new Edb[0]);
    }

    public Dll getFirstDll() throws IOException {
        if (this.firstDll == null) {
            long ceeedb_dlcb_first = this.ceexedbTemplate.getCeeedb_dlcb_first(this.inputStream, this.address);
            log.fine("ceeedb_dlcb_first = " + Edb.hex(ceeedb_dlcb_first));
            if (ceeedb_dlcb_first != 0L) {
                this.firstDll = new Dll(ceeedb_dlcb_first, this.space);
            }
        }
        return this.firstDll;
    }

    public Properties getEnvVars() throws IOException {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.envVars = new Properties();
        long ceeedbenvar = this.ceexedbTemplate.getCeeedbenvar(this.inputStream, this.address);
        long env = 0L;
        while ((env = this.space.readWord(ceeedbenvar, this.is64bit)) != 0L) {
            String name = this.space.readEbcdicCString(env);
            int eq = name.indexOf(61);
            if (eq <= 0) {
                log.fine("bad name: " + name);
            } else {
                String key = name.substring(0, eq);
                String value = name.substring(eq + 1);
                this.envVars.put(key, value);
            }
            ceeedbenvar += (long)(this.is64bit ? 8 : 4);
        }
        return this.envVars;
    }

    public boolean rptstg() throws IOException {
        return (this.space.readUnsignedByte(this.ceeedboptcb() + 204L) & 0x80) != 0;
    }

    public boolean storage() throws IOException {
        return (this.space.readUnsignedByte(this.ceeedboptcb() + 236L) & 0x80) != 0;
    }

    public boolean equals(Object obj) {
        Edb e = (Edb)obj;
        return e.space == this.space && e.address == this.address;
    }

    public int hashCode() {
        return (int)this.address;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    public String toString() {
        return Edb.hex(this.address);
    }
}

