/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.IModuleFile;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class XCOFFReader
implements IModuleFile {
    public static final short F_RELFLG = 1;
    public static final short F_EXEC = 2;
    public static final short F_LNNO = 4;
    public static final short F_AR32W = 512;
    public static final short F_DYNLOAD = 4096;
    public static final short F_SHROBJ = 8192;
    public static final short F_LOADONLY = 16384;
    public static final int STYP_REG = 0;
    public static final int STYP_PAD = 8;
    public static final int STYP_TEXT = 32;
    public static final int STYP_DATA = 64;
    public static final int STYP_BSS = 128;
    public static final int STYP_EXCEPT = 256;
    public static final int STYP_INFO = 512;
    public static final int STYP_TDATA = 1024;
    public static final int STYP_TBSS = 2048;
    public static final int STYP_LOADER = 4096;
    public static final int STYP_DEBUG = 8192;
    public static final int STYP_TYPCHK = 16384;
    public static final int STYP_OVRFLO = 32768;
    private static final short XCOFF_MAGIC_NUMBER_AIX32 = 479;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_PRE43 = 495;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_POST51 = 503;
    private final ImageInputStream _backing;
    private long _startOffset;
    private long _size;
    private boolean _is64Bit;
    private final String _library;
    private long _symbolTableOffset = -1L;
    private long _timeAndDate = 0L;
    private short _flags = 0;

    public XCOFFReader(File library) throws IOException {
        this(library, 0L, (int)library.length());
    }

    public XCOFFReader(File library, long l, long m) throws IOException {
        this._startOffset = l;
        this._size = m;
        this._library = library.getName();
        this._backing = new ClosingFileReader(library, ByteOrder.BIG_ENDIAN);
        this.init();
    }

    public XCOFFReader(String libraryName, ImageInputStream in, long l, long m) throws IOException {
        this._backing = in;
        this._library = libraryName;
        this._startOffset = l;
        this._size = m;
        this.init();
    }

    private void init() throws IOException {
        this.seekFileRelative(0L);
        short magic = this._backing.readShort();
        if (479 != magic && 495 != magic && 503 != magic) {
            throw new IllegalArgumentException();
        }
        this._is64Bit = 495 == magic || 503 == magic;
        this._backing.readShort();
        this._timeAndDate = 1000L * (0xFFFFFFFFL & (long)this._backing.readInt());
        this._symbolTableOffset = this._is64Bit ? this._backing.readLong() : 0xFFFFFFFFL & (long)this._backing.readInt();
        this.seekFileRelative(16L);
        this._backing.readShort();
        this._flags = this._backing.readShort();
    }

    private void seekFileRelative(long offset) throws IOException {
        this._backing.seek(this._startOffset + offset);
    }

    private long _symbolTableOffset() throws IOException {
        return this._symbolTableOffset;
    }

    private int _numberOfSymbols() throws IOException {
        this.seekFileRelative(this._is64Bit ? 20L : 12L);
        return this._backing.readInt();
    }

    private String _stringFromArray(byte[] rawData, int start) {
        int end;
        for (end = start; end < rawData.length && 0 != rawData[end]; ++end) {
        }
        try {
            return new String(rawData, start, end - start, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public long baseFileOffset() {
        return this._startOffset;
    }

    public long logicalSize() {
        return this._size;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.put("Time and Date", new Date(this._timeAndDate).toString());
        String flagRep = (0 != (this._flags & 1) ? "F_RELFLG " : "") + (0 != (this._flags & 2) ? "F_EXEC " : "") + (0 != (this._flags & 4) ? "F_LNNO " : "") + (0 != (this._flags & 0x200) ? "F_AR32W " : "") + (0 != (this._flags & 0x1000) ? "F_DYNLOAD " : "") + (0 != (this._flags & 0x2000) ? "F_SHROBJ " : "") + (0 != (this._flags & 0x4000) ? "F_LOADONLY " : "");
        props.put("Flags", flagRep);
        return props;
    }

    @Override
    public IMemorySource getTextSegment(long virtualAddress, long virtualSize) {
        return new TextSegment(virtualAddress, virtualSize);
    }

    @Override
    public List<? extends ISymbol> getSymbols(long relocationBase) throws IOException {
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        long symbolTableOffset = this._symbolTableOffset();
        int numberOfSymbols = this._numberOfSymbols();
        if (0L != symbolTableOffset) {
            this.seekFileRelative(symbolTableOffset + (long)(18 * numberOfSymbols));
            int stringTableLength = this._backing.readInt();
            if (4 != stringTableLength && 0 != stringTableLength) {
                byte[] rawStringTable = new byte[stringTableLength - 4];
                this._backing.readFully(rawStringTable);
                this.seekFileRelative(symbolTableOffset);
                byte[] symbolTableEntry = new byte[18];
                int skipNext = 0;
                for (int x = 0; x < numberOfSymbols; ++x) {
                    this._backing.readFully(symbolTableEntry);
                    if (skipNext > 0) {
                        --skipNext;
                        continue;
                    }
                    int stringTableOffset = 0;
                    String symbolName = null;
                    if (this._is64Bit) {
                        stringTableOffset = (0xFF & symbolTableEntry[8]) << 24 | (0xFF & symbolTableEntry[9]) << 16 | (0xFF & symbolTableEntry[10]) << 8 | 0xFF & symbolTableEntry[11];
                    } else if (0 == symbolTableEntry[0] && 0 == symbolTableEntry[1] && 0 == symbolTableEntry[2] && 0 == symbolTableEntry[3]) {
                        stringTableOffset = (0xFF & symbolTableEntry[4]) << 24 | (0xFF & symbolTableEntry[5]) << 16 | (0xFF & symbolTableEntry[6]) << 8 | 0xFF & symbolTableEntry[7];
                    } else {
                        symbolName = this._stringFromArray(symbolTableEntry, 0);
                    }
                    if (null == symbolName && 0 == (symbolTableEntry[16] & 0x80) && 0 != stringTableOffset && stringTableOffset < stringTableLength - 4) {
                        symbolName = this._stringFromArray(rawStringTable, stringTableOffset - 4);
                    } else if (0 == (symbolTableEntry[16] & 0x80) && stringTableOffset > stringTableLength - 4) {
                        symbolName = "(string out of table bounds)";
                    }
                    if (null == symbolName) {
                        symbolName = "";
                    }
                    long value = 0L;
                    value = this._is64Bit ? (0xFFL & (long)symbolTableEntry[0]) << 56 | (0xFFL & (long)symbolTableEntry[1]) << 48 | (0xFFL & (long)symbolTableEntry[2]) << 40 | (0xFFL & (long)symbolTableEntry[3]) << 32 | (0xFFL & (long)symbolTableEntry[4]) << 24 | (0xFFL & (long)symbolTableEntry[5]) << 16 | (0xFFL & (long)symbolTableEntry[6]) << 8 | 0xFFL & (long)symbolTableEntry[7] : (long)((0xFF & symbolTableEntry[8]) << 24 | (0xFF & symbolTableEntry[9]) << 16 | (0xFF & symbolTableEntry[10]) << 8 | 0xFF & symbolTableEntry[11]);
                    symbols.add(new Symbol(symbolName, value + relocationBase));
                    skipNext = symbolTableEntry[17];
                }
            }
        }
        return symbols;
    }

    public void close() throws IOException {
        if (this._backing != null) {
            this._backing.close();
        }
    }

    private class TextSegment
    extends ProtectedMemoryRange
    implements IMemorySource {
        public TextSegment(long baseAddress, long size) {
            super(baseAddress, size);
            this.readOnly = true;
            this.executable = true;
            this.shared = false;
        }

        @Override
        public String getName() {
            return ".text";
        }

        @Override
        public int getAddressSpaceId() {
            return 0;
        }

        @Override
        public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            if (address < this.baseAddress) {
                throw new MemoryFault(address, "Address out of range. Segment starts at 0x" + Long.toHexString(this.baseAddress));
            }
            long topAddress = address + (long)length - 1L;
            if (topAddress > this.getTopAddress()) {
                throw new MemoryFault(address, "Address out of range (overflow). Top address is 0x" + Long.toHexString(this.getTopAddress()));
            }
            if (topAddress - this.baseAddress > this.size) {
                throw new MemoryFault(address, "Address out of range (overflow). Top backed address is 0x" + Long.toHexString(this.baseAddress + this.size - 1L));
            }
            long startPoint = address - this.baseAddress;
            try {
                XCOFFReader.this._backing.seek(XCOFFReader.this._startOffset + startPoint);
                XCOFFReader.this._backing.readFully(buffer, offset, length);
            }
            catch (IOException e) {
                throw new MemoryFault(address, "Memory fault caused by IOException reading file " + XCOFFReader.this._library);
            }
            return length;
        }
    }
}

