/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.ZipFileResolver;
import com.ibm.j9ddr.libraries.CoreFileResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class LibraryResolverFactory {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    public static final String LIBRARY_PATH_SYSTEM_PROPERTY = "com.ibm.j9ddr.library.path";
    public static final String PATH_MAPPING_SYSTEM_PROPERTY = "com.ibm.j9ddr.path.mapping";
    private static final String MAPPING_SEPERATOR = "=";
    public static final String RESOLVER_LIST_PROPERTY = "com.ibm.j9ddr.library.resolvers";
    private static final String RESOLVER_DEFAULT_ORDER = LibraryPathResolver.class.getName() + "," + CoreFileResolver.class.getName() + "," + NextToCoreResolver.class.getName() + "," + InPlaceResolver.class.getName() + "," + ZipFileResolver.class.getName();
    private static final List<File> libraryPath;
    private static final Map<String, String> pathMap;
    private static final List<Class<? extends ILibraryResolver>> resolverClasses;

    public static ILibraryResolver getResolverForCoreFile(ImageInputStream stream) {
        LinkedList<ILibraryResolver> resolvers = new LinkedList<ILibraryResolver>();
        for (Class<? extends ILibraryResolver> resolverClass : resolverClasses) {
            try {
                Constructor<? extends ILibraryResolver> constructor = resolverClass.getConstructor(ImageInputStream.class);
                resolvers.add(constructor.newInstance(stream));
            }
            catch (NoSuchMethodException e) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Skipping Library resolver class: {0} as it does not support an ImageInputStream constructor", new Object[]{resolverClass.getName()});
            }
            catch (Exception e) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to create instance of Library resolver class: {0}", new Object[]{resolverClass.getName()});
            }
        }
        return new DelegatingLibraryPathResolver(resolvers);
    }

    public static ILibraryResolver getResolverForCoreFile(File file) {
        LinkedList<ILibraryResolver> resolvers = new LinkedList<ILibraryResolver>();
        for (Class<? extends ILibraryResolver> resolverClass : resolverClasses) {
            try {
                Constructor<? extends ILibraryResolver> constructor = resolverClass.getConstructor(File.class);
                resolvers.add(constructor.newInstance(file));
            }
            catch (NoSuchMethodException e) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Skipping Library resolver class: {0} as it does not support a File constructor", new Object[]{resolverClass.getName()});
            }
            catch (Exception e) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to create instance of Library resolver class: {0}", new Object[]{resolverClass.getName()});
            }
        }
        return new DelegatingLibraryPathResolver(resolvers);
    }

    private static String stripPath(String moduleName) {
        File file = new File(moduleName);
        return file.getName();
    }

    private static String mapPath(String moduleName) {
        if (pathMap.isEmpty()) {
            return moduleName;
        }
        for (Map.Entry<String, String> entry : pathMap.entrySet()) {
            moduleName = moduleName.replace(entry.getKey(), entry.getValue());
        }
        return moduleName;
    }

    static {
        String specifiedPath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.LIBRARY_PATH_SYSTEM_PROPERTY);
            }
        });
        String mappingPath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.PATH_MAPPING_SYSTEM_PROPERTY);
            }
        });
        String resolvers = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LibraryResolverFactory.RESOLVER_LIST_PROPERTY, RESOLVER_DEFAULT_ORDER);
            }
        });
        String pathSeperator = File.pathSeparator;
        LinkedList<File> localPath = new LinkedList<File>();
        if (specifiedPath != null) {
            String[] pathSections;
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library search path set as: {0} by property {1}", new Object[]{specifiedPath, LIBRARY_PATH_SYSTEM_PROPERTY});
            for (String path : pathSections = specifiedPath.split(pathSeperator)) {
                localPath.add(new File(path));
            }
        } else {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "No library search path set. Falling back on defaults");
        }
        HashMap<String, String> mPaths = new HashMap<String, String>();
        if (mappingPath != null) {
            String[] pathSections;
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library path mappings paths set as: {0} by property {1}", new Object[]{specifiedPath, PATH_MAPPING_SYSTEM_PROPERTY});
            for (String replacePath : pathSections = mappingPath.split(pathSeperator)) {
                Object[] target_subst = replacePath.split(MAPPING_SEPERATOR);
                mPaths.put(target_subst[0], target_subst[1]);
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Mapping libraries paths containing {0} to {1}", target_subst);
            }
        } else {
            logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "No library path mappings set. Falling back on defaults");
        }
        LinkedList<Class<ILibraryResolver>> classes = new LinkedList<Class<ILibraryResolver>>();
        logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Library resolver search order: {0}", new Object[]{resolvers});
        for (String resolver : resolvers.split(",")) {
            try {
                classes.add(Class.forName(resolver).asSubclass(ILibraryResolver.class));
            }
            catch (ClassNotFoundException e) {
                logger.logp(Level.FINE, "LibraryResolverFactory", "<clinit>", "Failed to find Library resolver class: {0}", new Object[]{resolver});
            }
        }
        libraryPath = Collections.unmodifiableList(localPath);
        pathMap = Collections.unmodifiableMap(mPaths);
        resolverClasses = Collections.unmodifiableList(classes);
    }

    private static abstract class BaseResolver
    implements ILibraryResolver {
        private BaseResolver() {
        }

        protected static String normalise(String name, String separator) {
            int reader;
            String[] parts = name.split(separator);
            if (1 >= parts.length) {
                return name;
            }
            int marker = reader = parts.length - 1;
            String output = new String();
            while (reader >= 0) {
                if (parts[marker].equals("..")) {
                    --reader;
                } else if (!parts[marker].equals(".")) {
                    output = separator + parts[reader] + output;
                }
                --marker;
                --reader;
            }
            if (output.startsWith(separator)) {
                output = output.substring(separator.length());
            }
            return output;
        }

        @Override
        public LibraryDataSource getLibrary(String fileName) throws FileNotFoundException {
            return this.getLibrary(fileName, false);
        }

        @Override
        public void dispose() {
        }
    }

    private static final class DelegatingLibraryPathResolver
    extends BaseResolver
    implements ILibraryResolver {
        private final List<ILibraryResolver> resolvers;

        public DelegatingLibraryPathResolver(List<ILibraryResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public LibraryDataSource getLibrary(String fileName, boolean silent) throws FileNotFoundException {
            for (ILibraryResolver resolver : this.resolvers) {
                try {
                    return resolver.getLibrary(fileName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            if (!silent) {
                logger.logp(Level.FINER, "LibraryResolverFactory", "getLibrary", "Couldn't find shared library " + fileName + ". Some data may be unavailable.");
            }
            throw new FileNotFoundException();
        }

        @Override
        public void dispose() {
            for (ILibraryResolver resolver : this.resolvers) {
                resolver.dispose();
            }
        }
    }

    private static final class InPlaceResolver
    extends BaseResolver
    implements ILibraryResolver {
        public InPlaceResolver(File coreFile) {
        }

        @Override
        public LibraryDataSource getLibrary(String fileName, boolean silent) throws FileNotFoundException {
            File library = new File(LibraryResolverFactory.mapPath(fileName));
            logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Looking for {0}.", library);
            if (library.isFile()) {
                logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Found {0}.", library);
                return new LibraryDataSource(library);
            }
            logger.logp(Level.FINER, "LibraryResolverFactory$InPlaceResolver", "getLibrary", "Can't find " + fileName + " on disk");
            throw new FileNotFoundException("Can't find " + fileName + " on disk");
        }
    }

    private static final class LibraryPathResolver
    extends BaseResolver
    implements ILibraryResolver {
        public LibraryPathResolver(File coreFile) {
        }

        @Override
        public LibraryDataSource getLibrary(String fileName, boolean resolver) throws FileNotFoundException {
            if (libraryPath.isEmpty()) {
                throw new FileNotFoundException("No library paths set.");
            }
            String strippedModuleName = LibraryResolverFactory.stripPath(fileName);
            logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking for {0} in library path.", strippedModuleName);
            for (File path : libraryPath) {
                if (path.isDirectory()) {
                    logger.logp(Level.FINEST, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking in directory {0}.", path);
                    File withDirectories = new File(path, fileName);
                    File withoutDirectories = new File(path, strippedModuleName);
                    if (withDirectories.isFile()) {
                        logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in directory {1}.", new Object[]{strippedModuleName, path});
                        return new LibraryDataSource(withDirectories);
                    }
                    if (!withoutDirectories.isFile()) continue;
                    logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in directory {1}.", new Object[]{strippedModuleName, path});
                    return new LibraryDataSource(withoutDirectories);
                }
                logger.logp(Level.FINEST, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Looking in file {0}.", path);
                File libraryFile = this.readArchive(path, fileName, strippedModuleName);
                if (libraryFile == null) continue;
                logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "Found {0} in zip file {1}.", new Object[]{strippedModuleName, path});
                return new LibraryDataSource(libraryFile);
            }
            logger.logp(Level.FINER, "LibraryResolverFactory$LibraryPathResolver", "getLibrary", "{0} not found in library path.", strippedModuleName);
            throw new FileNotFoundException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File readArchive(File path, String filePath, String strippedModuleName) {
            try (ZipFile file2 = new ZipFile(path);){
                File file;
                Enumeration<? extends ZipEntry> entries = file2.entries();
                ZipEntry bestMatch = null;
                while (entries.hasMoreElements()) {
                    ZipEntry thisEntry = entries.nextElement();
                    if (thisEntry.getName().equals(filePath)) {
                        bestMatch = thisEntry;
                        break;
                    }
                    if (!LibraryResolverFactory.stripPath(thisEntry.getName()).equals(strippedModuleName)) continue;
                    bestMatch = thisEntry;
                }
                if (bestMatch != null) {
                    file = this.extractEntry(bestMatch, strippedModuleName, file2);
                    return file;
                }
                file = null;
                return file;
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "LibraryResolverFactory$LibraryPathResolver", "readArchive", "Problems reading " + path + " as a zip file", e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private File extractEntry(ZipEntry thisEntry, String moduleName, ZipFile file) throws FileNotFoundException {
            try {
                File libraryFile = File.createTempFile(moduleName, ".j9ddrlib");
                InputStream in = file.getInputStream(thisEntry);
                try {
                    File file2;
                    FileOutputStream out = new FileOutputStream(libraryFile);
                    try {
                        int read;
                        libraryFile.deleteOnExit();
                        byte[] buffer = new byte[4096];
                        while ((read = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, read);
                        }
                        file2 = libraryFile;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return file2;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, "LibraryResolverFactory$LibraryPathResolver", "extractEntry", "IOException trying to extract " + thisEntry.getName() + " from " + file.getName(), e);
                return null;
            }
        }
    }

    private static final class NextToCoreResolver
    extends BaseResolver
    implements ILibraryResolver {
        private final File coreDirectory;

        public NextToCoreResolver(File coreFile) {
            this.coreDirectory = coreFile.getAbsoluteFile().getParentFile();
        }

        private boolean isAbsolutePath(String name) {
            if (null == name || name.length() == 0) {
                return false;
            }
            if (name.length() == 1) {
                return name.charAt(0) == '/';
            }
            return name.charAt(0) == '/' || name.charAt(1) == ':';
        }

        private File findFile(File dir, String[] parts, int matchDepth) {
            File[] files = dir.listFiles();
            File current = null;
            for (int i = 0; files != null && i < files.length && null == current; ++i) {
                File file = files[i];
                if (file.getName().equals(parts[matchDepth])) {
                    if (++matchDepth == parts.length) {
                        return file;
                    }
                    if (!file.isDirectory()) continue;
                    current = this.findFile(file, parts, matchDepth);
                    continue;
                }
                if (!file.isDirectory()) continue;
                current = this.findFile(file, parts, 0);
            }
            return current;
        }

        @Override
        public LibraryDataSource getLibrary(String fileName, boolean silent) throws FileNotFoundException {
            File[] pathsToCheck;
            String[] parts;
            File file;
            String canonicalName;
            String strippedModuleName = LibraryResolverFactory.stripPath(fileName);
            String separator = null;
            if (fileName.indexOf(47) == -1) {
                if (fileName.indexOf(92) != -1) {
                    separator = "\\\\";
                }
            } else {
                separator = "/";
            }
            String string = canonicalName = separator == null ? fileName : NextToCoreResolver.normalise(fileName, separator);
            if (!this.isAbsolutePath(canonicalName) && separator != null && (file = this.findFile(this.coreDirectory, parts = canonicalName.split(separator), 0)) != null) {
                String abspath = file.getAbsolutePath();
                canonicalName = abspath.substring(this.coreDirectory.getAbsolutePath().length() + 1, abspath.length());
            }
            File withoutDirectories = new File(this.coreDirectory, strippedModuleName);
            File withDirectories = new File(this.coreDirectory, canonicalName);
            final String fileNameWithCase = withDirectories.getName();
            for (File checkPath : pathsToCheck = new File[]{withDirectories, withoutDirectories}) {
                File parent = checkPath.getParentFile();
                if (parent == null || !parent.isDirectory()) continue;
                logger.logp(Level.FINER, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Trying {0}.", checkPath);
                String[] names = parent.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equalsIgnoreCase(fileNameWithCase) && new File(dir, name).isFile();
                    }
                });
                if (names == null || names.length == 0) continue;
                String otherName = null;
                for (String name : names) {
                    if (name.equals(fileNameWithCase)) {
                        File match = new File(parent, name);
                        logger.logp(Level.FINER, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Found {0}.", match);
                        return new LibraryDataSource(match);
                    }
                    if (!name.equalsIgnoreCase(fileNameWithCase)) continue;
                    otherName = name;
                }
                if (otherName == null) continue;
                logger.logp(Level.SEVERE, "LibraryResolverFactory$NextToCoreResolver", "getLibrary", "Found {0} but not {1} in {2}. Case sensitive files may been copied to a case insensitive file system causing {1} to be lost or overwritten by {0}.", new String[]{otherName, fileNameWithCase, checkPath.getParent()});
            }
            throw new FileNotFoundException("Can't find " + strippedModuleName + " in directory " + this.coreDirectory.getAbsolutePath());
        }
    }
}

