/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.SymbolUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDRSymbolFinder {
    private static boolean addSymbols = true;
    private static List<String[][]> paths = new LinkedList<String[][]>();
    private static Set<String> ignoredSymbols = new HashSet<String>();

    public static void addSymbols(IProcess process, long j9RasAddress, StructureReader structureReader) {
        Logger logger;
        long vmAddress = 0L;
        try {
            vmAddress = DDRSymbolFinder.followPointerFromStructure("J9RAS", j9RasAddress, "vm", structureReader, process);
        }
        catch (MemoryFault e) {
            logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
        }
        catch (NoSuchFieldException e) {
            logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
        }
        catch (Exception e) {
            logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
        }
        if (vmAddress == 0L) {
            return;
        }
        for (String[][] path : paths) {
            Logger logger2;
            try {
                long currentAddress = vmAddress;
                String currentType = "J9JavaVM";
                for (String[] pathEntry : path) {
                    String structType = pathEntry[0];
                    String fieldName = pathEntry[1];
                    currentAddress = DDRSymbolFinder.followPointerFromStructure(currentType, currentAddress, fieldName, structureReader, process);
                    currentType = structType;
                }
                DDRSymbolFinder.addVoidPointersAsSymbols(currentType, currentAddress, structureReader, process);
            }
            catch (MemoryFault e) {
                logger2 = Logger.getLogger("j9ddr.structure_reader");
                logger2.log(Level.FINE, null, e);
            }
            catch (NoSuchFieldException e) {
                logger2 = Logger.getLogger("j9ddr.structure_reader");
                logger2.log(Level.FINE, null, e);
            }
            catch (CorruptDataException e) {
                logger2 = Logger.getLogger("j9ddr.structure_reader");
                logger2.log(Level.FINE, null, e);
            }
            catch (DataUnavailableException e) {
                logger2 = Logger.getLogger("j9ddr.structure_reader");
                logger2.log(Level.FINE, null, e);
            }
            catch (Exception e) {
                logger2 = Logger.getLogger("j9ddr.structure_reader");
                logger2.log(Level.FINE, null, e);
            }
        }
    }

    private static void addVoidPointersAsSymbols(String structureName, long structureAddress, StructureReader structureReader, IProcess process) throws DataUnavailableException, CorruptDataException {
        if (structureAddress == 0L) {
            return;
        }
        List<String> voidFields = DDRSymbolFinder.getVoidPointerFieldsFromStructure(structureReader, structureName);
        if (voidFields == null) {
            return;
        }
        int paddingSize = process.bytesPerPointer() * 2;
        String formatString = "[!%s 0x%0" + paddingSize + "X->%s]";
        for (String field : voidFields) {
            IModule module;
            long functionAddress;
            if (ignoredSymbols.contains(structureName + "." + field) || (functionAddress = DDRSymbolFinder.followPointerFromStructure(structureName, structureAddress, field, structureReader, process)) == 0L) continue;
            String symName = String.format(formatString, structureName.toLowerCase(), structureAddress, field);
            if (functionAddress == 0L || !addSymbols || (module = DDRSymbolFinder.getModuleForInstructionAddress(process, functionAddress)) == null) continue;
            boolean found = false;
            for (ISymbol iSymbol : module.getSymbols()) {
                if (iSymbol.getAddress() != functionAddress) continue;
                Logger logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINER, "DDRSymbolFinder: Found exact match with " + iSymbol.toString() + " not adding.");
                found = true;
                break;
            }
            if (found) continue;
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINER, "DDRSymbolFinder: Adding new DDR symbol " + symName);
            SymbolUtil.addDDRSymbolToModule(module, "[" + field + "]", symName, functionAddress);
        }
    }

    private static long followPointerFromStructure(String structureName, long structureAddress, String fieldName, StructureReader reader, IProcess process) throws MemoryFault, NullPointerException {
        if (structureAddress == 0L) {
            throw new NullPointerException("Null " + structureName + " found.");
        }
        for (StructureReader.FieldDescriptor f : reader.getFields(structureName)) {
            if (!f.isPresent() || !f.getDeclaredName().equals(fieldName)) continue;
            long offset = f.getOffset();
            long pointerAddress = structureAddress + offset;
            long pointer = process.getPointerAt(pointerAddress);
            return pointer;
        }
        return 0L;
    }

    private static List<String> getVoidPointerFieldsFromStructure(StructureReader reader, String structureName) throws MemoryFault {
        LinkedList<String> functionPointers = new LinkedList<String>();
        for (StructureReader.FieldDescriptor f : reader.getFields(structureName)) {
            if (!f.isPresent()) continue;
            String name = f.getDeclaredName();
            String type2 = f.getDeclaredType();
            if (!"void *".equals(type2)) continue;
            functionPointers.add(name);
        }
        return functionPointers;
    }

    private static IModule getModuleForInstructionAddress(IProcess process, long address) throws CorruptDataException {
        Collection<? extends IModule> modules = process.getModules();
        IModule matchingModule = null;
        block0: for (IModule iModule : modules) {
            for (IMemoryRange iMemoryRange : iModule.getMemoryRanges()) {
                if (!iMemoryRange.contains(address)) continue;
                matchingModule = iModule;
                break block0;
            }
        }
        return matchingModule;
    }

    static {
        paths.add(new String[][]{{"J9PortLibrary", "portLibrary"}});
        ignoredSymbols.add("J9PortLibrary.portVersion");
        ignoredSymbols.add("J9PortLibrary.portGlobals");
        paths.add(new String[][]{{"J9InternalVMFunctions", "internalVMFunctions"}});
        ignoredSymbols.add("J9InternalVMFunctions.reserved0");
        ignoredSymbols.add("J9InternalVMFunctions.reserved1");
        ignoredSymbols.add("J9InternalVMFunctions.reserved2");
        paths.add(new String[][]{{"J9InternalVMLabels", "internalVMLabels"}});
        paths.add(new String[][]{{"J9MemoryManagerFunctions", "memoryManagerFunctions"}});
        paths.add(new String[][]{{"jniNativeInterface", "jniFunctionTable"}});
        ignoredSymbols.add("jniNativeInterface.reserved0");
        ignoredSymbols.add("jniNativeInterface.reserved1");
        ignoredSymbols.add("jniNativeInterface.reserved2");
        ignoredSymbols.add("jniNativeInterface.reserved3");
        paths.add(new String[][]{{"J9ReflectFunctionTable", "reflectFunctions"}});
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtServerInterface", "server"}});
        ignoredSymbols.add("UtServerInterface.header");
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtClientInterface", "client"}});
        ignoredSymbols.add("UtClientInterface.header");
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtModuleInterface", "module"}});
        paths.add(new String[][]{{"J9RASdumpFunctions", "j9rasDumpFunctions"}});
        ignoredSymbols.add("J9RASdumpFunctions.reserved");
    }
}

