/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.vm.VM;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleResolver;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

abstract class PrimitiveHandle
extends MethodHandle {
    long vmSlot;
    int rawModifiers;
    Class<?> defc;
    final Class<?> referenceClass;
    final String name;
    Class<?> specialCaller;

    PrimitiveHandle(MethodType type, Class<?> referenceClass, String name, byte kind, int modifiers, Object thunkArg) {
        super(type, kind, thunkArg);
        this.referenceClass = referenceClass;
        this.defc = referenceClass;
        this.name = name;
        this.rawModifiers = modifiers;
    }

    PrimitiveHandle(MethodType type, Class<?> referenceClass, String name, byte kind, Object thunkArg) {
        this(type, referenceClass, name, kind, 0, thunkArg);
    }

    PrimitiveHandle(PrimitiveHandle original, MethodType newType) {
        super(original, newType);
        this.referenceClass = original.referenceClass;
        this.defc = original.defc;
        this.name = original.name;
        this.rawModifiers = original.rawModifiers;
        this.specialCaller = original.specialCaller;
        this.vmSlot = original.vmSlot;
    }

    @Override
    Class<?> getDefc() {
        return this.defc;
    }

    @Override
    Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    @Override
    Class<?> getSpecialCaller() {
        return this.specialCaller;
    }

    @Override
    String getMethodName() {
        return this.name;
    }

    @Override
    int getModifiers() {
        return this.rawModifiers;
    }

    private native Class<?> lookupMethod(Class<?> var1, String var2, String var3, byte var4, Class<?> var5);

    final native Class<?> lookupField(Class<?> var1, String var2, String var3, boolean var4, Class<?> var5);

    static native boolean setVMSlotAndRawModifiersFromField(PrimitiveHandle var0, Field var1);

    static native boolean setVMSlotAndRawModifiersFromMethod(PrimitiveHandle var0, Class<?> var1, Method var2, byte var3, Class<?> var4);

    static native boolean setVMSlotAndRawModifiersFromConstructor(PrimitiveHandle var0, Constructor var1);

    static native boolean setVMSlotAndRawModifiersFromSpecialHandle(VirtualHandle var0, DirectHandle var1);

    final void initializeClassIfRequired() {
        if (Modifier.isStatic(this.rawModifiers) && MethodHandleResolver.JITHELPERS.getClassInitializeStatus(this.defc) != VM.J9CLASS_INIT_SUCCEEDED) {
            MethodHandleResolver.UNSAFE.ensureClassInitialized(this.defc);
        }
    }

    @Override
    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (!arrayParameter.isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> lastArgType = this.type().lastParameterType();
        if (!lastArgType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, arrayParameter, MethodHandles.Lookup.isVarargs(this.rawModifiers));
    }

    final Class<?> finishMethodInitialization(Class<?> specialToken, MethodType oldType) throws NoSuchMethodException, IllegalAccessException {
        try {
            String signature = oldType.toMethodDescriptorString();
            return this.lookupMethod(this.referenceClass, this.name, signature, this.kind, specialToken);
        }
        catch (NoSuchMethodError e) {
            NoSuchMethodException eWrapper = new NoSuchMethodException();
            eWrapper.initCause(e);
            throw eWrapper;
        }
        catch (IncompatibleClassChangeError e) {
            throw new IllegalAccessException(e.getMessage());
        }
    }
}

