/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.ECParameters;
import com.ibm.crypto.plus.provider.ECPublicKey;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.g;
import com.ibm.crypto.plus.provider.icc.ECKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyRep;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class ECPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.ECPrivateKey,
java.security.interfaces.ECKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -7596809556341742543L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger s;
    private ECParameterSpec params;
    private ECPublicKey publicKey = null;
    private byte[] privateKeyBytesEncoded = null;
    private byte[] publicKeyBytes = null;
    ObjectIdentifier namedCurveOID = null;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private static final byte TAG_PUBLIC_KEY_ATTRS = 1;
    private transient boolean destroyed = false;
    private transient ECKey ecKey = null;
    private static final String MSG_VERSION1;
    private static final String MSG_SEQ;
    private static final String[] z;

    public ECPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        Object object;
        Object object2;
        this.provider = iBMJCEPlusProvider;
        this.s = bigInteger;
        this.params = eCParameterSpec;
        AlgorithmParameters algorithmParameters = ECParameters.a(iBMJCEPlusProvider, eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, algorithmParameters);
        try {
            object2 = new DerOutputStream();
            object2.putInteger(1);
            object = ECParameters.b(bigInteger.toByteArray());
            object2.putOctetString(object);
            object2.putOctetString(this.s.toByteArray());
            DerValue derValue = new DerValue(48, object2.toByteArray());
            this.key = derValue.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
        try {
            this.publicKeyBytes = null;
            object2 = this.a();
            object = ECParameters.a(this.params);
            this.ecKey = ECKey.createPrivateKey(iBMJCEPlusProvider.a(), (byte[])object2, object);
        }
        catch (Exception exception) {
            object = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a((Exception)object, (Throwable)exception);
            throw object;
        }
    }

    public ECPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
        try {
            this.a(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[6] + iOException.getMessage());
        }
        try {
            byte[] byArray2 = this.privateKeyBytesEncoded;
            byte[] byArray3 = ECParameters.a(this.params);
            this.ecKey = ECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2, byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[7]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public ECPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, ECKey eCKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgorithmId(AlgorithmId.EC_oid, eCKey.getParameters());
            this.key = this.b(eCKey.getPrivateKeyBytes());
            this.ecKey = eCKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[8]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    private void a(byte[] byArray) throws IOException {
        block31: {
            Object object;
            ObjectIdentifier objectIdentifier;
            DerValue[] derValueArray;
            block29: {
                block30: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValueArray = derInputStream.getSequence(3);
                    BigInteger bigInteger = derValueArray[0].getInteger();
                    if (bigInteger.compareTo(BigInteger.ZERO) != 0) {
                        throw new IOException(z[21]);
                    }
                    objectIdentifier = null;
                    ObjectIdentifier objectIdentifier2 = null;
                    if (derValueArray.length <= 1) break block29;
                    if (derValueArray[1].getTag() != 48) break block30;
                    object = derValueArray[1].toDerInputStream();
                    objectIdentifier2 = object.getOID();
                    objectIdentifier = object.getOID();
                    break block29;
                }
                throw new IOException(z[19]);
            }
            object = null;
            if (derValueArray.length < 2) {
                this.publicKey = null;
                this.privateKeyBytesEncoded = null;
                this.publicKeyBytes = null;
                return;
            }
            object = derValueArray[2].getDataBytes();
            if (object == null) {
                this.publicKey = null;
                this.privateKeyBytesEncoded = null;
                this.publicKeyBytes = null;
                return;
            }
            this.privateKeyBytesEncoded = (byte[])object;
            DerInputStream derInputStream = new DerInputStream((byte[])object);
            DerValue[] derValueArray2 = derInputStream.getSequence(4);
            if (derValueArray2.length == 2) {
                BigInteger bigInteger = derValueArray2[0].getInteger();
                if (bigInteger.compareTo(BigInteger.ONE) != 0) {
                    throw new IOException(z[20]);
                }
                byte[] byArray2 = null;
                if (derValueArray2.length > 1) {
                    byArray2 = derValueArray2[1].getOctetString();
                }
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(bigInteger);
                derOutputStream.putOctetString(byArray2);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(objectIdentifier);
                derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2.toByteArray());
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream.toByteArray());
                this.privateKeyBytesEncoded = derOutputStream3.toByteArray();
            } else {
                BigInteger bigInteger = derValueArray2[0].getInteger();
                if (bigInteger.compareTo(BigInteger.ONE) != 0) {
                    throw new IOException(z[18]);
                }
                byte[] byArray3 = null;
                if (derValueArray2.length > 1) {
                    byArray3 = derValueArray2[1].getOctetString();
                }
                DerInputStream derInputStream2 = null;
                DerValue derValue = null;
                if (derValueArray2.length > 2) {
                    derInputStream2 = derValueArray2[2].getData();
                    derValue = derInputStream2.getDerValue();
                }
                if (derValueArray2.length <= 3 || !derValueArray2[3].isContextSpecific((byte)1)) break block31;
                try {
                    DerInputStream derInputStream3 = derValueArray2[3].getData();
                    byte[] byArray4 = derInputStream3.getBitString();
                    DerInputStream derInputStream4 = new DerInputStream(byArray4);
                    if (derInputStream4.peekByte() == 48) {
                        DerOutputStream derOutputStream;
                        DerValue[] derValueArray3 = derInputStream4.getSequence(2);
                        byte[] byArray5 = null;
                        if (derValueArray3.length > 1) {
                            byArray5 = derValueArray3[1].getBitString();
                        }
                        DerOutputStream derOutputStream4 = new DerOutputStream();
                        derOutputStream4.putInteger(bigInteger);
                        derOutputStream4.putOctetString(byArray3);
                        DerOutputStream derOutputStream5 = new DerOutputStream();
                        derOutputStream5.putDerValue(derValue);
                        derOutputStream4.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream5.toByteArray());
                        if (byArray5 != null) {
                            derOutputStream = new DerOutputStream();
                            derOutputStream.putBitString(byArray5);
                            derOutputStream4.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
                        }
                        derOutputStream = new DerOutputStream();
                        derOutputStream.write((byte)48, derOutputStream4.toByteArray());
                        this.privateKeyBytesEncoded = derOutputStream.toByteArray();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.publicKeyBytes = (byte[])this.privateKeyBytesEncoded.clone();
    }

    private byte[] b(byte[] byArray) throws IOException {
        Object object;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(4);
        BigInteger bigInteger = derValueArray[0].getInteger();
        byte[] byArray2 = null;
        if (derValueArray.length > 1) {
            byArray2 = derValueArray[1].getOctetString();
            this.s = new BigInteger(1, byArray2);
        } else {
            this.s = null;
        }
        DerInputStream derInputStream2 = null;
        if (derValueArray.length > 2) {
            derInputStream2 = derValueArray[2].getData();
            if (derInputStream2.tag != 0) {
                throw new IOException(z[10]);
            }
            try {
                object = derInputStream2.getOID();
                if (object != null) {
                    return byArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = null;
        DerInputStream derInputStream3 = null;
        if (derValueArray.length > 3) {
            derInputStream3 = derValueArray[3].getData();
            if (derInputStream3.tag != 0) {
                throw new IOException(z[9]);
            }
            object = derInputStream3.getBitString();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(bigInteger);
        derOutputStream.putOctetString(byArray2);
        DerOutputStream derOutputStream3 = null;
        if (object != null) {
            derOutputStream3 = new DerOutputStream();
            derOutputStream3.putBitString((byte[])object);
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray3 = derOutputStream2.toByteArray();
        return byArray3;
    }

    private byte[] a() throws IOException, InvalidParameterSpecException {
        Object object;
        DerValue derValue;
        Object object2;
        Object object3;
        ECParameterSpec eCParameterSpec = this.getParams();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.ONE);
        if (this.key != null) {
            object3 = new DerInputStream(this.key);
            object2 = object3.getDerValue();
            if (object2.getTag() != 48) {
                throw new IOException(z[1]);
            }
            derValue = object2.getData();
            int n2 = derValue.getInteger().intValue();
            if (n2 != 1) {
                throw new IOException(z[2]);
            }
            object = ECParameters.b(derValue.getOctetString());
            derOutputStream.putOctetString(object);
        }
        object3 = ECParameters.a(eCParameterSpec);
        object2 = ECParameters.b(object3);
        derValue = new DerValue(object2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putDerValue(derValue);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream3);
        if (this.publicKeyBytes != null) {
            object = new DerOutputStream();
            object.putBitString(this.publicKeyBytes);
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), (DerOutputStream)object);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    @Override
    public BigInteger getS() {
        this.c();
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        this.c();
        return this.params;
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        byte[] byArray = super.getEncoded();
        return byArray;
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    ECKey b() {
        return this.ecKey;
    }

    protected void parseKeyBits() throws IOException {
        try {
            Object object;
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[16]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            if (n2 != 1) {
                throw new IOException(z[14]);
            }
            byte[] byArray = derInputStream2.getOctetString();
            this.s = new BigInteger(1, byArray);
            while (derInputStream2.available() != 0) {
                object = derInputStream2.getDerValue();
                if (object.isContextSpecific((byte)0)) {
                    continue;
                }
                if (object.isContextSpecific((byte)1)) {
                    continue;
                }
                throw new IOException(z[12] + object);
            }
            object = this.algid.getAlgParameters();
            if (object == null) {
                throw new IOException(z[13]);
            }
            this.params = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new IOException(z[15]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[17]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.ecKey = null;
            this.s = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[11]);
        }
    }

    public boolean equals(Object object) {
        block7: {
            try {
                BigInteger bigInteger = (BigInteger)object.getClass().getDeclaredMethod(z[3], new Class[0]).invoke(object, new Object[0]);
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Key) || !this.s.equals(bigInteger)) break block7;
                if (!g.equals(this.getParams(), (ECParameterSpec)object.getClass().getDeclaredMethod(z[4], new Class[0]).invoke(object, new Object[0]))) break block7;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[5]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[22];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "(~BB\u0017\u0019nSB\n\bdR\u0001\r\tdBB\u0010\u00126B\f\u001a\u0013rB\u0006Y\u001eoS\u0007Y\u001ddU\u0003\u0000\\{R\u0011\r\\tBB\u0018\\eB\u0013\f\u0019xD\u0007";
        int n3 = 21;
        block31: while (true) {
            char[] cArray;
            block35: {
                int n4;
                int n5;
                block34: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block34;
                    n5 = n5;
                    if (n5 <= n4) break block35;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 124;
                            break;
                        }
                        case 1: {
                            n6 = 22;
                            break;
                        }
                        case 2: {
                            n6 = 39;
                            break;
                        }
                        case 3: {
                            n6 = 98;
                            break;
                        }
                        default: {
                            n6 = 121;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 21: {
                    MSG_SEQ = string.intern();
                    string2 = "(~BB\u001c\u0012uH\u0006\u001c\u00186E\u001b\r\u00196F\u0010\u000b\u001do\u0007\u0011\u001c\rcB\f\u001a\u00196J\u0017\n\b6O\u0003\u000f\u00196Q\u0007\u000b\u000f\u007fH\fY\u0012cJ\u0000\u001c\u000e6\u0016";
                    n3 = 22;
                    continue block31;
                }
                case 22: {
                    MSG_VERSION1 = string.intern();
                    string2 = ":wN\u000e\u001c\u00186S\rY\u001fdB\u0003\r\u00196b!Y\fdN\u0014\u0018\bs\u0007\t\u001c\u0005";
                    n3 = -1;
                    continue block31;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "(~BB\u0017\u0019nSB\n\bdR\u0001\r\tdBB\u0010\u00126B\f\u001a\u0013rB\u0006Y\u001eoS\u0007Y\u001ddU\u0003\u0000\\{R\u0011\r\\tBB\u0018\\eB\u0013\f\u0019xD\u0007";
                    n3 = 0;
                    continue block31;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "(~BB\u001c\u0012uH\u0006\u001c\u00186E\u001b\r\u00196F\u0010\u000b\u001do\u0007\u0011\u001c\rcB\f\u001a\u00196J\u0017\n\b6O\u0003\u000f\u00196Q\u0007\u000b\u000f\u007fH\fY\u0012cJ\u0000\u001c\u000e6\u0016";
                    n3 = 1;
                    continue block31;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001bsS1";
                    n3 = 2;
                    continue block31;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001bsS2\u0018\u000ewJ\u0011";
                    n3 = 3;
                    continue block31;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "9Uw\u0010\u0010\nwS\u00072\u0019o\u0007\t\u001c\u0005e\u0007\u0003\u000b\u00196I\r\r\\rN\u0010\u001c\u001fbK\u001bY\u0018sT\u0007\u000b\u0015wK\u000b\u0003\u001dtK\u0007";
                    n3 = 4;
                    continue block31;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001bsS'\u0017\u001fyC\u0007\u001d,dN\u0014\u0018\bsl\u0007\u0000>oS\u0007\n\\";
                    n3 = 5;
                    continue block31;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ":wN\u000e\u001c\u00186S\rY\u001fdB\u0003\r\u00196b!Y\fdN\u0014\u0018\bs\u0007\t\u001c\u0005";
                    n3 = 6;
                    continue block31;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ":wN\u000e\u001c\u00186S\rY\u001fdB\u0003\r\u00196b!Y\fdN\u0014\u0018\bs\u0007\t\u001c\u0005";
                    n3 = 7;
                    continue block31;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "(~BB\u0017\u0019nSB\u001c\u0012uH\u0006\u001c\u00186E\u001b\r\u0019e\u0007\u000f\f\u000fb\u0007\u0000\u001c\\w\u0007\u0001\u0016\u0012bB\u001a\r\\uH\f\n\bdR\u0001\r\u0019r\u0007\u0000\u0010\b6T\u0016\u000b\u0015x@";
                    n3 = 8;
                    continue block31;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\\BO\u0007Y\u0012s_\u0016Y\u0019xD\r\u001d\u0019r\u0007\u0011\r\u000ecD\u0016\f\u000es\u0007\u000f\f\u000fb\u0007\u0000\u001c\\w\u0007\u0001\u0016\u0012bB\u001a\r\\uH\f\n\bdR\u0001\r\u0019r\u0007-08";
                    n3 = 9;
                    continue block31;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "(~N\u0011Y\u0017s^B\u0010\u000f6I\rY\u0010yI\u0005\u001c\u000e6Q\u0003\u0015\u0015r";
                    n3 = 10;
                    continue block31;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = ")xB\u001a\t\u0019uS\u0007\u001d\\`F\u000e\f\u0019,\u0007";
                    n3 = 11;
                    continue block31;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "9U\u0007\u0006\u0016\u0011wN\fY\fwU\u0003\u0014\u0019bB\u0010\n\\{R\u0011\r\\tBB\u001c\u0012uH\u0006\u001c\u00186N\fY\b~BB\u0018\u0010qH\u0010\u0010\b~JB\u0010\u0018sI\u0016\u0010\u001a\u007fB\u0010";
                    n3 = 12;
                    continue block31;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "(~BB\u001c\u0012uH\u0006\u001c\u00186E\u001b\r\u00196F\u0010\u000b\u001do\u0007\u0011\u001c\rcB\f\u001a\u00196J\u0017\n\b6O\u0003\u000f\u00196Q\u0007\u000b\u000f\u007fH\fY\u0012cJ\u0000\u001c\u000e6\u0016";
                    n3 = 13;
                    continue block31;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "5xQ\u0003\u0015\u0015r\u0007':\\fU\u000b\u000f\u001dbBB\u0012\u0019o";
                    n3 = 14;
                    continue block31;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "(~BB\u0017\u0019nSB\n\bdR\u0001\r\tdBB\u0010\u00126B\f\u001a\u0013rB\u0006Y\u001eoS\u0007Y\u001ddU\u0003\u0000\\{R\u0011\r\\tBB\u0018\\eB\u0013\f\u0019xD\u0007";
                    n3 = 15;
                    continue block31;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "5xQ\u0003\u0015\u0015r\u0007':\\fU\u000b\u000f\u001dbBB\u0012\u0019o";
                    n3 = 16;
                    continue block31;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "8sD\r\u001d\u0015x@B\t\ttK\u000b\u001a\\}B\u001bY\u001awN\u000e\u001c\u00188\u00076\u0011\u00196Q\u0007\u000b\u000f\u007fH\fY\u0011cT\u0016Y\u001es\u0007S";
                    n3 = 17;
                    continue block31;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = ")xB\u001a\t\u0019uS\u0007\u001d\\xH\fY\u000fsV\u0017\u001c\u0012uBB\u000e\u0014\u007fK\u0007Y\fwU\u0011\u0010\u0012q\u0007\u0012\u000b\u0015`F\u0016\u001c\\}B\u001bY\u001eoS\u0007\n";
                    n3 = 18;
                    continue block31;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "8sD\r\u001d\u0015x@B\t\ttK\u000b\u001a\\}B\u001bY\u001awN\u000e\u001c\u00188\u00076\u0011\u00196Q\u0007\u000b\u000f\u007fH\fY\u0011cT\u0016Y\u001es\u0007S";
                    n3 = 19;
                    continue block31;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "8sD\r\u001d\u0015x@B\t\ttK\u000b\u001a\\}B\u001bY\u001awN\u000e\u001c\u00188\u00076\u0011\u00196Q\u0007\u000b\u000f\u007fH\fY\u0011cT\u0016Y\u001es\u0007\u0018\u001c\u000ey";
                    n3 = 20;
                    continue block31;
                }
                case 20: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

