/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.security.action.GetPropertyAction;

class ArabicDecoder
extends CharsetDecoder {
    private final String byteToCharTable;
    private final boolean mapArabic;
    private boolean bidiEnv;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private String csName = null;
    private static final String IBMdeshapeString = "\u0635\u0634\u0633\u0636\u0625\u0623\u0622\u0627\ufffe";
    static char[] CUAdeshape;
    char firstPrivate = (char)63732;
    char lastPrivate = (char)63740;
    private static final String deshapeString = "\u064b\u064b\u064c\ufe73\u064d\ufe75\u064e\u064e\u064f\u064f\u0650\u0650\u0651\u0651\u0652\u0652\u0621\u0622\u0622\u0623\u0623\u0624\u0624\u0625\u0625\u0626\u0626\u0626\u0626\u0627\u0627\u0628\u0628\u0628\u0628\u0629\u0629\u062a\u062a\u062a\u062a\u062b\u062b\u062b\u062b\u062c\u062c\u062c\u062c\u062d\u062d\u062d\u062d\u062e\u062e\u062e\u062e\u062f\u062f\u0630\u0630\u0631\u0631\u0632\u0632\u0633\u0633\u0633\u0633\u0634\u0634\u0634\u0634\u0635\u0635\u0635\u0635\u0636\u0636\u0636\u0636\u0637\u0637\u0637\u0637\u0638\u0638\u0638\u0638\u0639\u0639\u0639\u0639\u063a\u063a\u063a\u063a\u0641\u0641\u0641\u0641\u0642\u0642\u0642\u0642\u0643\u0643\u0643\u0643\u0644\u0644\u0644\u0644\u0645\u0645\u0645\u0645\u0646\u0646\u0646\u0646\u0647\u0647\u0647\u0647\u0648\u0648\u0649\u0649\u064a\u064a\u064a\u064a\u0622\u0622\u0623\u0623\u0625\u0625\u0627\u0627";
    protected static final char[] deshape;
    private static final String deshapeStringFB = "\u0671\u0671\u067b\u067b\u067b\u067b\u067e\u067e\u067e\u067e\u0680\u0680\u0680\u0680\u067a\u067a\u067a\u067a\u067f\u067f\u067f\u067f\u0679\u0679\u0679\u0679\u06a4\u06a4\u06a4\u06a4\u06a6\u06a6\u06a6\u06a6\u0684\u0684\u0684\u0684\u0683\u0683\u0683\u0683\u0686\u0686\u0686\u0686\u0687\u0687\u0687\u0687\u068d\u068d\u068c\u068c\u068e\u068e\u0688\u0688\u0698\u0698\u0691\u0691\u06a9\u06a9\u06a9\u06a9\u06af\u06af\u06af\u06af\u06b3\u06b3\u06b3\u06b3\u06b1\u06b1\u06b1\u06b1\u06ba\u06ba\u06bb\u06bb\u06bb\u06bb\u06c0\u06c0\u06c1\u06c1\u06c1\u06c1\u06be\u06be\u06be\u06be\u06d2\u06d2\u06d3\u06d3\ufbb2\ufbb3\ufbb4\ufbb5\ufbb6\ufbb7\ufbb8\ufbb9\ufbba\ufbbb\ufbbc\ufbbd\ufbbe\ufbbf\ufbc0\ufbc1\ufbc2\ufbc3\ufbc4\ufbc5\ufbc6\ufbc7\ufbc8\ufbc9\ufbca\ufbcb\ufbcc\ufbcd\ufbce\ufbcf\ufbd0\ufbd1\ufbd2\u06ad\u06ad\u06ad\u06ad\u06c7\u06c7\u06c6\u06c6\u06c8\u06c8\u0677\u06cb\u06cb\u06c5\u06c5\u06c9\u06c9\u06d0\u06d0\u06d0\u06d0\u0649\u0649";

    ArabicDecoder(Charset charset, String string, byte by) {
        super(charset, 1.0f, by != 0 ? 2.0f : 1.0f);
        this.byteToCharTable = this.handleIBMSwapLF(string);
        this.mapArabic = by == 1;
        this.csName = charset.name();
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected static final boolean isSwapLF() {
        return ExtendedCharsets.isSwapLF();
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        char c = '\u0000';
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; ++n) {
            int n5 = 1;
            char c2 = this.byteToCharTable.charAt(byArray[n] + 128);
            if (c2 >= '\ue000') {
                if (c2 == '\ufffd') {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (this.mapArabic && !this.bidiEnv) {
                    if (c2 >= '\ufe70') {
                        if (c2 <= '\ufef4') {
                            c2 = deshape[c2 - 65136];
                        } else if (c2 <= '\ufefc') {
                            c = deshape[c2 - 65136];
                            c2 = '\u0644';
                            n5 = 2;
                        }
                    } else if (c2 >= '\ufb50' && c2 <= '\ufbe9') {
                        c2 = deshapeStringFB.charAt(c2 - 64336);
                    } else if (c2 >= this.firstPrivate && c2 <= this.lastPrivate) {
                        c2 = CUAdeshape[c2 - this.firstPrivate];
                    }
                    if (c2 == '\ufffe') {
                        n5 = 0;
                    }
                }
            }
            if (n4 - n3 < n5) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (n5 > 0) {
                cArray[n3++] = c2;
            }
            if (n5 <= 1 || n3 >= n4) continue;
            cArray[n3++] = c;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        char c = '\u0000';
        char c2 = '\u0000';
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 1;
                c = this.byteToCharTable.charAt(byteBuffer.get() + 128);
                if (c >= '\ue000') {
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (this.mapArabic && !this.bidiEnv) {
                        if (c >= '\ufe70') {
                            if (c <= '\ufef4') {
                                c = deshape[c - 65136];
                            } else if (c <= '\ufefc') {
                                c2 = deshape[c - 65136];
                                c = '\u0644';
                                n2 = 2;
                            }
                        } else if (c >= '\ufb50' && c <= '\ufbe9') {
                            c = deshapeStringFB.charAt(c - 64336);
                        } else if (c >= this.firstPrivate && c <= this.lastPrivate) {
                            c = CUAdeshape[c - this.firstPrivate];
                        }
                        if (c == '\ufffe') {
                            n2 = 0;
                        }
                    }
                }
                if (charBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                if (n2 > 0) {
                    charBuffer.put(c);
                }
                if (n2 <= 1) continue;
                charBuffer.put(c2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    @Override
    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled) {
            BidiConvert bidiConvert = new BidiConvert();
            this.bidiEnv = bidiConvert.isBidiEnv(this.bidiParms, this.csName);
            if (bidiConvert.isBidiData(cArray, n2, n, this.bidiParms, this.csName)) {
                cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.csName);
                if (bl) {
                    System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
                } else {
                    charBuffer.position(n3);
                    charBuffer.put(cArray);
                }
            }
        }
        return coderResult;
    }

    static {
        CUAdeshape = IBMdeshapeString.toCharArray();
        deshape = deshapeString.toCharArray();
    }
}

