/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.extensions;

import com.ibm.java.diagnostics.common.extensions.parsers.Parser;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.parser.ParserList;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParserRegistry {
    private static Logger LOG = LogFactory.getTrace(ParserRegistry.class);
    private static ParserRegistry registry = null;

    public static ParserRegistry getInstance() {
        if (registry == null) {
            registry = new ParserRegistry();
        }
        return registry;
    }

    public Parser[] instantiateParsers() {
        ArrayList<Parser> arrayList = new ArrayList<Parser>();
        String[] stringArray = ParserList.getParserList();
        for (String string : stringArray) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                arrayList.add((Parser)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                instantiationException.printStackTrace();
            }
        }
        Object[] objectArray = arrayList.toArray(new Parser[arrayList.size()]);
        return objectArray;
    }
}

