/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.cpu.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.healthcenter.JVMData;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.cpu.CpuLabels;
import com.ibm.java.diagnostics.healthcenter.cpu.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.postprocessor.HealthCenterMissingDataPostProcessor;

public class MissingCpuDataPostProcessor
extends HealthCenterMissingDataPostProcessor {
    private static final String DATA_LABEL = JVMLabels.CPU;
    private static final String ZOS = "z/OS";

    @Override
    protected String getDataLabel() {
        return DATA_LABEL;
    }

    @Override
    protected String getMissingDataAdvice(Data data) {
        String string = this.isZOS() ? Messages.getString("CPU.advice.zos") : Messages.getString("CPU.advice");
        return string;
    }

    @Override
    protected String getRecommendationLabel() {
        return CpuLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemCapabilityId() {
        return "cpu_subsystem";
    }

    private boolean isZOS() {
        String string;
        TableData tableData;
        TableDataRow tableDataRow;
        JVMData jVMData;
        EnvironmentData environmentData;
        boolean bl = false;
        Data data = MarshallerImpl.getMarshaller().getData(null);
        if (data != null && data instanceof JVMData && (environmentData = (jVMData = (JVMData)data).getEnvironmentData()) != null && (tableDataRow = (tableData = environmentData.getSystemProperties()).get("os.name")) != null && tableDataRow.getRowData().length == 2 && (string = (String)tableDataRow.getRowData()[1]).contains(ZOS)) {
            bl = true;
        }
        return bl;
    }
}

