/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HTMLFormatter
extends Formatter {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAIL = "</body>" + NEWLINE + "</html>";
    private static final String TRACE = "";
    private static final String H2_CLOSE = "</h2>" + NEWLINE;
    private static final String HTML_HEAD_HEAD_BODY_H2 = "<html>" + NEWLINE + "<head>" + NEWLINE + "</head>\n<body>" + NEWLINE + "<h2>";
    private static final String RED_EM = "<em style=\"color:red\">";
    private static final String GREEN_EM = "<em style=\"color:green\">";
    private static final String EM_CLOSE = "</em>";
    private static final String EM = "<em>";
    private static final String TAB = "\t";
    private static final String FOUND_EXCEPTION = "Found exception: ";
    private static final String LINEBREAK = NEWLINE + "<p/>" + NEWLINE;

    @Override
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = logRecord.getLoggerName();
        if (string.indexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        stringBuffer.append(new Date(logRecord.getMillis()));
        stringBuffer.append(TAB);
        Level level = logRecord.getLevel();
        if (level.intValue() >= Level.WARNING.intValue()) {
            stringBuffer.append(RED_EM);
            stringBuffer.append(level);
            stringBuffer.append(EM_CLOSE);
        } else if (level.intValue() == Level.INFO.intValue()) {
            stringBuffer.append(GREEN_EM);
            stringBuffer.append(level);
            stringBuffer.append(EM_CLOSE);
        } else {
            stringBuffer.append(EM);
            stringBuffer.append(level);
            stringBuffer.append(EM_CLOSE);
        }
        stringBuffer.append(TAB);
        stringBuffer.append(String.format("[%4d] %s %s", logRecord.getThreadID(), string, logRecord.getMessage()));
        stringBuffer.append(LINEBREAK);
        for (Throwable throwable = logRecord.getThrown(); throwable != null; throwable = throwable.getCause()) {
            stringBuffer.append("<b style=\"color:red\">");
            stringBuffer.append(FOUND_EXCEPTION);
            stringBuffer.append("</b>");
            stringBuffer.append(throwable.getMessage());
            stringBuffer.append(LINEBREAK);
            stringBuffer.append(this.getStackTraceAsString(throwable));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getHead(Handler handler) {
        return HTML_HEAD_HEAD_BODY_H2 + TRACE + H2_CLOSE;
    }

    @Override
    public String getTail(Handler handler) {
        return TAIL;
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }
}

