/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.platform.PPPlatformUtils;

public class PlatformUtils {
    public static final int UMASK_NOT_APPLICABLE = 1024;
    private static final String[] EXTENDED_ATTRIBUTES = new String[]{"a", "l", "p", "s"};
    private static final String EXTENDED_ATTRIBUTES_ADD = "+";
    private static final String EXTENDED_ATTRIBUTES_REMOVE = "-";
    private static final Writer NULL_WRITER = new Writer(){

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };

    public static int executeCommand(String[] cmd, String[] env, File workingDir, Writer out, Writer err) throws IOException {
        Process p = Runtime.getRuntime().exec(cmd, env, workingDir);
        Thread outThread = PlatformUtils.copyOutputThread(p.getInputStream(), out);
        Thread errThread = PlatformUtils.copyOutputThread(p.getErrorStream(), err);
        int returnValue = -1;
        try {
            returnValue = p.waitFor();
            outThread.join();
            errThread.join();
        }
        catch (InterruptedException e) {
            SelfExtract.err("ERROR_EXECUTING_COMMAND", new Object[]{cmd.toString(), Integer.toString(returnValue), e.getMessage()});
        }
        return returnValue;
    }

    private static Thread copyOutputThread(final InputStream in, Writer out) {
        final Writer writer = null == out ? NULL_WRITER : out;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                char[] buf = new char[4096];
                BufferedReader bReader = null;
                try {
                    int read;
                    bReader = new BufferedReader(new InputStreamReader(in));
                    while ((read = bReader.read(buf)) != -1) {
                        writer.write(buf, 0, read);
                    }
                }
                catch (IOException ioe) {
                    SelfExtract.err("ERROR_EXECUTING_COMMAND", new Object[]{null, null, ioe.getMessage()});
                }
                finally {
                    if (null != bReader) {
                        try {
                            bReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        thread.start();
        return thread;
    }

    public static ReturnCode setExecutePermissionAccordingToUmask(String[] files) throws IOException {
        if (null == files || files.length == 0) {
            return ReturnCode.OK;
        }
        int umask = PlatformUtils.getUmask();
        if (umask == 1024) {
            return ReturnCode.OK;
        }
        String perm = "";
        if ((umask & 0x40) == 0) {
            perm = "u";
        }
        if ((umask & 8) == 0) {
            perm = perm + "g";
        }
        if ((umask & 1) == 0) {
            perm = perm + "o";
        }
        if (!perm.isEmpty()) {
            perm = perm + "+x";
        }
        return PlatformUtils.chmod(files, perm);
    }

    public static ReturnCode chmod(String[] fileList, String perm) throws IOException {
        return PPPlatformUtils.getPolicy().chmod(fileList, perm);
    }

    public static ReturnCode setExtendedAttributes(Map extattrFilesMap) throws IOException {
        Set files;
        String attrs;
        HashMap<String, Set> extAttrFilesMap = new HashMap<String, Set>();
        if (extattrFilesMap.size() > EXTENDED_ATTRIBUTES.length) {
            for (Map.Entry entry : extattrFilesMap.entrySet()) {
                attrs = (String)entry.getKey();
                files = (Set)entry.getValue();
                for (int i = 0; i < EXTENDED_ATTRIBUTES.length; ++i) {
                    Set attrfiles;
                    String key;
                    if (attrs.contains(EXTENDED_ATTRIBUTES[i])) {
                        key = EXTENDED_ATTRIBUTES_ADD + EXTENDED_ATTRIBUTES[i];
                        attrfiles = extAttrFilesMap.containsKey(key) ? (Set)extAttrFilesMap.get(key) : new HashSet();
                        attrfiles.addAll(files);
                        extAttrFilesMap.put(key, attrfiles);
                        continue;
                    }
                    key = EXTENDED_ATTRIBUTES_REMOVE + EXTENDED_ATTRIBUTES[i];
                    attrfiles = extAttrFilesMap.containsKey(key) ? (Set)extAttrFilesMap.get(key) : new HashSet();
                    attrfiles.addAll(files);
                    extAttrFilesMap.put(key, attrfiles);
                }
            }
        } else {
            for (Map.Entry entry : extattrFilesMap.entrySet()) {
                attrs = (String)entry.getKey();
                files = (Set)entry.getValue();
                StringBuffer antiAttrsBuffer = new StringBuffer();
                for (int i = 0; i < EXTENDED_ATTRIBUTES.length; ++i) {
                    if (attrs.contains(EXTENDED_ATTRIBUTES[i])) continue;
                    antiAttrsBuffer.append(EXTENDED_ATTRIBUTES[i]);
                }
                String antiAttrs = antiAttrsBuffer.toString();
                attrs = !"".equals(antiAttrs) && !"".equals(attrs) ? EXTENDED_ATTRIBUTES_ADD + attrs + " " + EXTENDED_ATTRIBUTES_REMOVE + antiAttrs : ("".equals(antiAttrs) ? EXTENDED_ATTRIBUTES_ADD + attrs : EXTENDED_ATTRIBUTES_REMOVE + antiAttrs);
                extAttrFilesMap.put(attrs, files);
            }
        }
        ReturnCode rc = ReturnCode.OK;
        for (Map.Entry entry : extAttrFilesMap.entrySet()) {
            String attr = (String)entry.getKey();
            Set files2 = (Set)entry.getValue();
            rc = PlatformUtils.extattr(files2.toArray(new String[files2.size()]), attr);
            if (rc.equals(ReturnCode.OK)) continue;
            break;
        }
        return rc;
    }

    public static ReturnCode extattr(String[] fileList, String attr) throws IOException {
        return PPPlatformUtils.getPolicy().extattr(fileList, attr);
    }

    public static int getUmask() throws IOException {
        return PPPlatformUtils.getPolicy().getUmask();
    }

    public static String getASCIISystemCharSet() {
        return PPPlatformUtils.getPolicy().getASCIISystemCharSet();
    }

    public static String getEBCIDICSystemCharSet() {
        return PPPlatformUtils.getPolicy().getEBCIDICSystemCharSet();
    }
}

