/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.CommonData;

public class ExternalDecimal {
    private static byte EXTERNAL_DECIMAL_SPACE_SYMBOL = (byte)64;
    private static int EXTERNAL_DECIMAL_INVALID_DIGIT = 2;
    private static int EXTERNAL_DECIMAL_INVALID_SIGN = 1;

    private ExternalDecimal() {
    }

    public static int checkExternalDecimal(byte[] byteArray, int offset, int precision, int decimalType, int bytesWithSpaces) {
        if (precision < 1) {
            throw new IllegalArgumentException("Precision must be greater than 0.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be non-negative integer.");
        }
        if (decimalType < 1 || decimalType > 4) {
            throw new IllegalArgumentException("Invalid decimalType.");
        }
        int lengthNeeded = offset + CommonData.getExternalByteCounts(precision, decimalType);
        if (lengthNeeded > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. checkExternalDecimal is trying to access byteArray[" + offset + "] to byteArray[" + (lengthNeeded - 1) + "] but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        return ExternalDecimal.checkExternalDecimal_(byteArray, offset, precision, decimalType, bytesWithSpaces);
    }

    private static int checkExternalDecimal_(byte[] byteArray, int offset, int precision, int decimalType, int bytesWithSpaces) {
        int index;
        int signByte;
        if (decimalType == 1 && (precision == bytesWithSpaces || bytesWithSpaces < 0)) {
            return 3;
        }
        int startIndex = offset;
        int endIndex = startIndex + CommonData.getExternalByteCounts(precision, decimalType) - 1;
        boolean isSignEmbedded = false;
        switch (decimalType) {
            case 1: {
                isSignEmbedded = true;
                signByte = byteArray[endIndex];
                --endIndex;
                startIndex += bytesWithSpaces;
                break;
            }
            case 3: {
                signByte = byteArray[endIndex];
                --endIndex;
                break;
            }
            case 2: {
                isSignEmbedded = true;
                signByte = byteArray[startIndex];
                ++startIndex;
                break;
            }
            case 4: {
                signByte = byteArray[startIndex];
                ++startIndex;
                break;
            }
            default: {
                signByte = -97;
            }
        }
        int returnCode = 0;
        if (decimalType == 1 && bytesWithSpaces > 0) {
            for (index = offset; index < startIndex; ++index) {
                if (byteArray[index] == EXTERNAL_DECIMAL_SPACE_SYMBOL || (byteArray[index] & 0xFFFFFFF0 & 0xF0) == 240 && (byteArray[index] & 0xF) <= 9) continue;
                returnCode = EXTERNAL_DECIMAL_INVALID_DIGIT;
            }
        }
        for (index = startIndex; index <= endIndex && returnCode < EXTERNAL_DECIMAL_INVALID_DIGIT; ++index) {
            if (byteArray[index] != EXTERNAL_DECIMAL_SPACE_SYMBOL && (byteArray[index] & 0xFFFFFFF0 & 0xF0) == 240 && (byteArray[index] & 0xF) <= 9) continue;
            returnCode = EXTERNAL_DECIMAL_INVALID_DIGIT;
        }
        if (isSignEmbedded) {
            if ((signByte & 0xF) > 9) {
                returnCode = EXTERNAL_DECIMAL_INVALID_DIGIT;
            }
            if ((signByte & 0xFFFFFFF0 & 0xF0) < 160) {
                returnCode |= EXTERNAL_DECIMAL_INVALID_SIGN;
            }
        } else if (!isSignEmbedded && signByte != 96 && signByte != 78) {
            returnCode |= EXTERNAL_DECIMAL_INVALID_SIGN;
        }
        return returnCode;
    }
}

