/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.ResourceBundleBasedAdapter;

public class DecimalFormat
extends NumberFormat {
    private transient BigInteger bigIntegerMultiplier;
    private transient BigDecimal bigDecimalMultiplier;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private boolean parseBigDecimal = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    private int maximumIntegerDigits = super.getMaximumIntegerDigits();
    private int minimumIntegerDigits = super.getMinimumIntegerDigits();
    private int maximumFractionDigits = super.getMaximumFractionDigits();
    private int minimumFractionDigits = super.getMinimumFractionDigits();
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private transient boolean isFastPath = false;
    private transient boolean fastPathCheckNeeded = true;
    private transient FastPathData fastPathData;
    static final int currentSerialVersion = 4;
    private int serialVersionOnStream = 4;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final String PATTERN_EXPONENT = "E";
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final int MAXIMUM_INTEGER_DIGITS = Integer.MAX_VALUE;
    static final int MAXIMUM_FRACTION_DIGITS = Integer.MAX_VALUE;
    static final long serialVersionUID = 864413376551465018L;

    public DecimalFormat() {
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(NumberFormatProvider.class, locale);
        if (!(localeProviderAdapter instanceof ResourceBundleBasedAdapter)) {
            localeProviderAdapter = LocaleProviderAdapter.getResourceBundleBased();
        }
        String[] stringArray = localeProviderAdapter.getLocaleResources(locale).getNumberPatterns();
        this.symbols = DecimalFormatSymbols.getInstance(locale);
        this.applyPattern(stringArray[0], false);
    }

    public DecimalFormat(String string) {
        this.symbols = DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof AtomicInteger || object instanceof AtomicLong || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            return this.format(((Number)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string;
        boolean bl = false;
        if (fieldPosition == DontCareFieldPosition.INSTANCE) {
            bl = true;
        } else {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
        }
        if (bl && (string = this.fastFormat(d)) != null) {
            stringBuffer.append(string);
            return stringBuffer;
        }
        return this.format(d, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        if (Double.isNaN(d) || Double.isInfinite(d) && this.multiplier == 0) {
            int n = stringBuffer.length();
            stringBuffer.append(this.symbols.getNaN());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n, stringBuffer.length(), stringBuffer);
            return stringBuffer;
        }
        boolean bl = (d < 0.0 || d == 0.0 && Double.doubleToLongBits(d) == Long.MIN_VALUE) ^ this.multiplier < 0;
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (Double.isInfinite(d)) {
            if (bl) {
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int n = stringBuffer.length();
            stringBuffer.append(this.symbols.getInfinity());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n, stringBuffer.length(), stringBuffer);
            if (bl) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return stringBuffer;
        }
        if (bl) {
            d = -d;
        }
        assert (d >= 0.0 && !Double.isInfinite(d));
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n = super.getMaximumIntegerDigits();
            int n2 = super.getMinimumIntegerDigits();
            int n3 = super.getMaximumFractionDigits();
            int n4 = super.getMinimumFractionDigits();
            this.digitList.set(bl, d, this.useExponentialNotation ? n + n3 : n3, !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl, false, n, n2, n3, n4);
        }
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(l, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long l, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        boolean bl3 = false;
        if (l < 0L) {
            if (this.multiplier != 0) {
                bl3 = true;
            }
        } else if (this.multiplier != 1 && this.multiplier != 0) {
            long l2 = Long.MAX_VALUE / (long)this.multiplier;
            if (l2 < 0L) {
                l2 = -l2;
            }
            boolean bl4 = bl3 = l > l2;
        }
        if (bl3) {
            if (bl) {
                l = -l;
            }
            BigInteger bigInteger = BigInteger.valueOf(l);
            return this.format(bigInteger, stringBuffer, fieldDelegate, true);
        }
        if ((l *= (long)this.multiplier) == 0L) {
            bl = false;
        } else if (this.multiplier < 0) {
            l = -l;
            bl = !bl;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n = super.getMaximumIntegerDigits();
            int n2 = super.getMinimumIntegerDigits();
            int n3 = super.getMaximumFractionDigits();
            int n4 = super.getMinimumFractionDigits();
            this.digitList.set(bl, l, this.useExponentialNotation ? n + n3 : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl, true, n, n2, n3, n4);
        }
    }

    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigDecimal, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl;
        if (this.multiplier != 1) {
            bigDecimal = bigDecimal.multiply(this.getBigDecimalMultiplier());
        }
        boolean bl2 = bl = bigDecimal.signum() == -1;
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n = this.getMaximumIntegerDigits();
            int n2 = this.getMinimumIntegerDigits();
            int n3 = this.getMaximumFractionDigits();
            int n4 = this.getMinimumFractionDigits();
            int n5 = n + n3;
            this.digitList.set(bl, bigDecimal, this.useExponentialNotation ? (n5 < 0 ? Integer.MAX_VALUE : n5) : n3, !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl, false, n, n2, n3, n4);
        }
    }

    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigInteger, stringBuffer, fieldPosition.getFieldDelegate(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl) {
        boolean bl2;
        if (this.multiplier != 1) {
            bigInteger = bigInteger.multiply(this.getBigIntegerMultiplier());
        }
        boolean bl3 = bl2 = bigInteger.signum() == -1;
        if (bl2) {
            bigInteger = bigInteger.negate();
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (bl) {
                n5 = super.getMaximumIntegerDigits();
                n4 = super.getMinimumIntegerDigits();
                n3 = super.getMaximumFractionDigits();
                n2 = super.getMinimumFractionDigits();
                n = n5 + n3;
            } else {
                n5 = this.getMaximumIntegerDigits();
                n4 = this.getMinimumIntegerDigits();
                n3 = this.getMaximumFractionDigits();
                n2 = this.getMinimumFractionDigits();
                n = n5 + n3;
                if (n < 0) {
                    n = Integer.MAX_VALUE;
                }
            }
            this.digitList.set(bl2, bigInteger, this.useExponentialNotation ? n : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl2, true, n5, n4, n3, n2);
        }
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Double || object instanceof Float) {
            this.format(((Number)object).doubleValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof AtomicInteger || object instanceof AtomicLong) {
            this.format(((Number)object).longValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof BigDecimal) {
            this.format((BigDecimal)object, stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof BigInteger) {
            this.format((BigInteger)object, stringBuffer, characterIteratorFieldDelegate, false);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private boolean checkAndSetFastPathStatus() {
        boolean bl = this.isFastPath;
        if (this.roundingMode == RoundingMode.HALF_EVEN && this.isGroupingUsed() && this.groupingSize == 3 && this.multiplier == 1 && !this.decimalSeparatorAlwaysShown && !this.useExponentialNotation) {
            boolean bl2 = this.isFastPath = this.minimumIntegerDigits == 1 && this.maximumIntegerDigits >= 10;
            if (this.isFastPath) {
                if (this.isCurrencyFormat) {
                    if (this.minimumFractionDigits != 2 || this.maximumFractionDigits != 2) {
                        this.isFastPath = false;
                    }
                } else if (this.minimumFractionDigits != 0 || this.maximumFractionDigits != 3) {
                    this.isFastPath = false;
                }
            }
        } else {
            this.isFastPath = false;
        }
        this.resetFastPathData(bl);
        this.fastPathCheckNeeded = false;
        return true;
    }

    private void resetFastPathData(boolean bl) {
        if (this.isFastPath) {
            if (this.fastPathData == null) {
                this.fastPathData = new FastPathData();
            }
            this.fastPathData.zeroDelta = this.symbols.getZeroDigit() - 48;
            this.fastPathData.groupingChar = this.symbols.getGroupingSeparator();
            this.fastPathData.fractionalMaxIntBound = this.isCurrencyFormat ? 99 : 999;
            this.fastPathData.fractionalScaleFactor = this.isCurrencyFormat ? 100.0 : 1000.0;
            this.fastPathData.positiveAffixesRequired = this.positivePrefix.length() != 0 || this.positiveSuffix.length() != 0;
            this.fastPathData.negativeAffixesRequired = this.negativePrefix.length() != 0 || this.negativeSuffix.length() != 0;
            int n = 10;
            int n2 = 3;
            int n3 = Math.max(this.positivePrefix.length(), this.negativePrefix.length()) + n + n2 + 1 + this.maximumFractionDigits + Math.max(this.positiveSuffix.length(), this.negativeSuffix.length());
            this.fastPathData.fastPathContainer = new char[n3];
            this.fastPathData.charsPositiveSuffix = this.positiveSuffix.toCharArray();
            this.fastPathData.charsNegativeSuffix = this.negativeSuffix.toCharArray();
            this.fastPathData.charsPositivePrefix = this.positivePrefix.toCharArray();
            this.fastPathData.charsNegativePrefix = this.negativePrefix.toCharArray();
            int n4 = Math.max(this.positivePrefix.length(), this.negativePrefix.length());
            int n5 = n + n2 + n4;
            this.fastPathData.integralLastIndex = n5 - 1;
            this.fastPathData.fractionalFirstIndex = n5 + 1;
            this.fastPathData.fastPathContainer[n5] = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        } else if (bl) {
            this.fastPathData.fastPathContainer = null;
            this.fastPathData.charsPositiveSuffix = null;
            this.fastPathData.charsNegativeSuffix = null;
            this.fastPathData.charsPositivePrefix = null;
            this.fastPathData.charsNegativePrefix = null;
        }
    }

    private boolean exactRoundUp(double d, int n) {
        double d2;
        double d3;
        double d4;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.isCurrencyFormat) {
            d4 = d * 128.0;
            d3 = -(d * 32.0);
            d2 = d * 4.0;
        } else {
            d4 = d * 1024.0;
            d3 = -(d * 16.0);
            d2 = -(d * 8.0);
        }
        assert (-d3 >= Math.abs(d2));
        d5 = d3 + d2;
        d7 = d5 - d3;
        d6 = d2 - d7;
        double d8 = d5;
        double d9 = d6;
        assert (d4 >= Math.abs(d8));
        d5 = d4 + d8;
        d7 = d5 - d4;
        double d10 = d6 = d8 - d7;
        double d11 = d5;
        double d12 = d9 + d10;
        assert (d11 >= Math.abs(d12));
        d5 = d11 + d12;
        d7 = d5 - d11;
        double d13 = d12 - d7;
        if (d13 > 0.0) {
            return true;
        }
        if (d13 < 0.0) {
            return false;
        }
        return (n & 1) != 0;
    }

    private void collectIntegralDigits(int n, char[] cArray, int n2) {
        int n3 = n2;
        while (n > 999) {
            int n4 = n / 1000;
            int n5 = n - (n4 << 10) + (n4 << 4) + (n4 << 3);
            n = n4;
            cArray[n3--] = DigitArrays.DigitOnes1000[n5];
            cArray[n3--] = DigitArrays.DigitTens1000[n5];
            cArray[n3--] = DigitArrays.DigitHundreds1000[n5];
            cArray[n3--] = this.fastPathData.groupingChar;
        }
        cArray[n3] = DigitArrays.DigitOnes1000[n];
        if (n > 9) {
            cArray[--n3] = DigitArrays.DigitTens1000[n];
            if (n > 99) {
                cArray[--n3] = DigitArrays.DigitHundreds1000[n];
            }
        }
        this.fastPathData.firstUsedIndex = n3;
    }

    private void collectFractionalDigits(int n, char[] cArray, int n2) {
        int n3 = n2;
        char c = DigitArrays.DigitOnes1000[n];
        char c2 = DigitArrays.DigitTens1000[n];
        if (this.isCurrencyFormat) {
            cArray[n3++] = c2;
            cArray[n3++] = c;
        } else if (n != 0) {
            cArray[n3++] = DigitArrays.DigitHundreds1000[n];
            if (c != '0') {
                cArray[n3++] = c2;
                cArray[n3++] = c;
            } else if (c2 != '0') {
                cArray[n3++] = c2;
            }
        } else {
            --n3;
        }
        this.fastPathData.lastFreeIndex = n3;
    }

    private void addAffixes(char[] cArray, char[] cArray2, char[] cArray3) {
        int n = cArray2.length;
        int n2 = cArray3.length;
        if (n != 0) {
            this.prependPrefix(cArray2, n, cArray);
        }
        if (n2 != 0) {
            this.appendSuffix(cArray3, n2, cArray);
        }
    }

    private void prependPrefix(char[] cArray, int n, char[] cArray2) {
        this.fastPathData.firstUsedIndex -= n;
        int n2 = this.fastPathData.firstUsedIndex;
        if (n == 1) {
            cArray2[n2] = cArray[0];
        } else if (n <= 4) {
            int n3 = n2;
            int n4 = n3 + n - 1;
            int n5 = n - 1;
            cArray2[n3] = cArray[0];
            cArray2[n4] = cArray[n5];
            if (n > 2) {
                cArray2[++n3] = cArray[1];
            }
            if (n == 4) {
                cArray2[--n4] = cArray[2];
            }
        } else {
            System.arraycopy(cArray, 0, cArray2, n2, n);
        }
    }

    private void appendSuffix(char[] cArray, int n, char[] cArray2) {
        int n2 = this.fastPathData.lastFreeIndex;
        if (n == 1) {
            cArray2[n2] = cArray[0];
        } else if (n <= 4) {
            int n3 = n2;
            int n4 = n3 + n - 1;
            int n5 = n - 1;
            cArray2[n3] = cArray[0];
            cArray2[n4] = cArray[n5];
            if (n > 2) {
                cArray2[++n3] = cArray[1];
            }
            if (n == 4) {
                cArray2[--n4] = cArray[2];
            }
        } else {
            System.arraycopy(cArray, 0, cArray2, n2, n);
        }
        this.fastPathData.lastFreeIndex += n;
    }

    private void localizeDigits(char[] cArray) {
        int n = this.fastPathData.lastFreeIndex - this.fastPathData.fractionalFirstIndex;
        if (n < 0) {
            n = this.groupingSize;
        }
        for (int i = this.fastPathData.lastFreeIndex - 1; i >= this.fastPathData.firstUsedIndex; --i) {
            if (n != 0) {
                int n2 = i;
                cArray[n2] = (char)(cArray[n2] + this.fastPathData.zeroDelta);
                --n;
                continue;
            }
            n = this.groupingSize;
        }
    }

    private void fastDoubleFormat(double d, boolean bl) {
        char[] cArray = this.fastPathData.fastPathContainer;
        int n = (int)d;
        double d2 = d - (double)n;
        double d3 = d2 * this.fastPathData.fractionalScaleFactor;
        int n2 = (int)d3;
        boolean bl2 = false;
        if (d3 >= 0.5 && (bl2 = (d3 -= (double)n2) == 0.5 ? this.exactRoundUp(d2, n2) : true)) {
            if (n2 < this.fastPathData.fractionalMaxIntBound) {
                ++n2;
            } else {
                n2 = 0;
                ++n;
            }
        }
        this.collectFractionalDigits(n2, cArray, this.fastPathData.fractionalFirstIndex);
        this.collectIntegralDigits(n, cArray, this.fastPathData.integralLastIndex);
        if (this.fastPathData.zeroDelta != 0) {
            this.localizeDigits(cArray);
        }
        if (bl) {
            if (this.fastPathData.negativeAffixesRequired) {
                this.addAffixes(cArray, this.fastPathData.charsNegativePrefix, this.fastPathData.charsNegativeSuffix);
            }
        } else if (this.fastPathData.positiveAffixesRequired) {
            this.addAffixes(cArray, this.fastPathData.charsPositivePrefix, this.fastPathData.charsPositiveSuffix);
        }
    }

    @Override
    String fastFormat(double d) {
        boolean bl = false;
        if (this.fastPathCheckNeeded) {
            bl = this.checkAndSetFastPathStatus();
        }
        if (!this.isFastPath) {
            return null;
        }
        if (!Double.isFinite(d)) {
            return null;
        }
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
            d = -d;
        } else if (d == 0.0) {
            bl2 = Math.copySign(1.0, d) == -1.0;
            d = 0.0;
        }
        if (d > 2.147483647E9) {
            return null;
        }
        if (!bl) {
            this.resetFastPathData(this.isFastPath);
        }
        this.fastDoubleFormat(d, bl2);
        return new String(this.fastPathData.fastPathContainer, this.fastPathData.firstUsedIndex, this.fastPathData.lastFreeIndex - this.fastPathData.firstUsedIndex);
    }

    private StringBuffer subformat(StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        char c;
        char c2 = this.symbols.getZeroDigit();
        int n5 = c2 - 48;
        char c3 = this.symbols.getGroupingSeparator();
        char c4 = c = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        if (bl) {
            this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            int n6;
            boolean bl3;
            int n7;
            int n8;
            int n9;
            int n10 = stringBuffer.length();
            int n11 = -1;
            int n12 = -1;
            int n13 = this.digitList.decimalAt;
            int n14 = n;
            int n15 = n2;
            if (n14 > 1 && n14 > n2) {
                n13 = n13 >= 1 ? (n13 - 1) / n14 * n14 : (n13 - n14) / n14 * n14;
                n15 = 1;
            } else {
                n13 -= n15;
            }
            int n16 = n2 + n4;
            if (n16 < 0) {
                n16 = Integer.MAX_VALUE;
            }
            int n17 = n9 = this.digitList.isZero() ? n15 : this.digitList.decimalAt - n13;
            if (n16 < n9) {
                n16 = n9;
            }
            if (n16 > (n8 = this.digitList.count)) {
                n8 = n16;
            }
            boolean bl4 = false;
            for (n7 = 0; n7 < n8; ++n7) {
                if (n7 == n9) {
                    n11 = stringBuffer.length();
                    stringBuffer.append(c);
                    bl4 = true;
                    n12 = stringBuffer.length();
                }
                stringBuffer.append(n7 < this.digitList.count ? (char)(this.digitList.digits[n7] + n5) : c2);
            }
            if (this.decimalSeparatorAlwaysShown && n8 == n9) {
                n11 = stringBuffer.length();
                stringBuffer.append(c);
                bl4 = true;
                n12 = stringBuffer.length();
            }
            if (n11 == -1) {
                n11 = stringBuffer.length();
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n10, n11, stringBuffer);
            if (bl4) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n11, n12, stringBuffer);
            }
            if (n12 == -1) {
                n12 = stringBuffer.length();
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n12, stringBuffer.length(), stringBuffer);
            n7 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponentSeparator());
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, n7, stringBuffer.length(), stringBuffer);
            if (this.digitList.isZero()) {
                n13 = 0;
            }
            boolean bl5 = bl3 = n13 < 0;
            if (bl3) {
                n13 = -n13;
                n7 = stringBuffer.length();
                stringBuffer.append(this.symbols.getMinusSign());
                fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SIGN, NumberFormat.Field.EXPONENT_SIGN, n7, stringBuffer.length(), stringBuffer);
            }
            this.digitList.set(bl3, n13);
            int n18 = stringBuffer.length();
            for (n6 = this.digitList.decimalAt; n6 < this.minExponentDigits; ++n6) {
                stringBuffer.append(c2);
            }
            for (n6 = 0; n6 < this.digitList.decimalAt; ++n6) {
                stringBuffer.append(n6 < this.digitList.count ? (char)(this.digitList.digits[n6] + n5) : c2);
            }
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, n18, stringBuffer.length(), stringBuffer);
        } else {
            int n19;
            int n20;
            int n21 = stringBuffer.length();
            int n22 = n2;
            int n23 = 0;
            if (this.digitList.decimalAt > 0 && n22 < this.digitList.decimalAt) {
                n22 = this.digitList.decimalAt;
            }
            if (n22 > n) {
                n22 = n;
                n23 = this.digitList.decimalAt - n22;
            }
            int n24 = stringBuffer.length();
            for (n20 = n22 - 1; n20 >= 0; --n20) {
                if (n20 < this.digitList.decimalAt && n23 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n23++] + n5));
                } else {
                    stringBuffer.append(c2);
                }
                if (!this.isGroupingUsed() || n20 <= 0 || this.groupingSize == 0 || n20 % this.groupingSize != 0) continue;
                n19 = stringBuffer.length();
                stringBuffer.append(c3);
                fieldDelegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, n19, stringBuffer.length(), stringBuffer);
            }
            int n25 = n20 = n4 > 0 || !bl2 && n23 < this.digitList.count ? 1 : 0;
            if (n20 == 0 && stringBuffer.length() == n24) {
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n21, stringBuffer.length(), stringBuffer);
            n19 = stringBuffer.length();
            if (this.decimalSeparatorAlwaysShown || n20 != 0) {
                stringBuffer.append(c);
            }
            if (n19 != stringBuffer.length()) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n19, stringBuffer.length(), stringBuffer);
            }
            int n26 = stringBuffer.length();
            for (int i = 0; i < n3 && (i < n4 || !bl2 && n23 < this.digitList.count); ++i) {
                if (-1 - i > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c2);
                    continue;
                }
                if (!bl2 && n23 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n23++] + n5));
                    continue;
                }
                stringBuffer.append(c2);
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n26, stringBuffer.length(), stringBuffer);
        }
        if (bl) {
            this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string, Format.FieldDelegate fieldDelegate, FieldPosition[] fieldPositionArray, Format.Field field) {
        int n = stringBuffer.length();
        if (string.length() > 0) {
            stringBuffer.append(string);
            for (FieldPosition fieldPosition : fieldPositionArray) {
                Format.Field field2 = fieldPosition.getFieldAttribute();
                if (field2 == NumberFormat.Field.SIGN) {
                    field2 = field;
                }
                fieldDelegate.formatted(field2, field2, n + fieldPosition.getBeginIndex(), n + fieldPosition.getEndIndex(), stringBuffer);
            }
        }
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.positivePrefix, this.negativePrefix, this.digitList, false, blArray)) {
            return null;
        }
        if (blArray[0]) {
            if (blArray[1] == this.multiplier >= 0) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.multiplier == 0) {
            if (this.digitList.isZero()) {
                return new Double(Double.NaN);
            }
            if (blArray[1]) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.isParseBigDecimal()) {
            BigDecimal bigDecimal = this.digitList.getBigDecimal();
            if (this.multiplier != 1) {
                try {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier());
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier(), this.roundingMode);
                }
            }
            if (!blArray[1]) {
                bigDecimal = bigDecimal.negate();
            }
            return bigDecimal;
        }
        boolean bl = true;
        boolean bl2 = false;
        double d = 0.0;
        long l = 0L;
        if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl = false;
            l = this.digitList.getLong();
            if (l < 0L) {
                bl2 = true;
            }
        } else {
            d = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl) {
                d /= (double)this.multiplier;
            } else if (l % (long)this.multiplier == 0L) {
                l /= (long)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                bl = true;
            }
        }
        if (!blArray[1] && !bl2) {
            d = -d;
            l = -l;
        }
        if (this.multiplier != 1 && bl) {
            l = (long)d;
            bl = (d != (double)l || d == 0.0 && 1.0 / d < 0.0) && !this.isParseIntegerOnly();
        }
        return bl ? (Number)new Double(d) : (Number)new Long(l);
    }

    private BigInteger getBigIntegerMultiplier() {
        if (this.bigIntegerMultiplier == null) {
            this.bigIntegerMultiplier = BigInteger.valueOf(this.multiplier);
        }
        return this.bigIntegerMultiplier;
    }

    private BigDecimal getBigDecimalMultiplier() {
        if (this.bigDecimalMultiplier == null) {
            this.bigDecimalMultiplier = new BigDecimal(this.multiplier);
        }
        return this.bigDecimalMultiplier;
    }

    private final boolean subparse(String string, ParsePosition parsePosition, String string2, String string3, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.index;
        int n2 = parsePosition.index;
        boolean bl2 = string.regionMatches(n, string2, 0, string2.length());
        boolean bl3 = string.regionMatches(n, string3, 0, string3.length());
        if (bl2 && bl3) {
            if (string2.length() > string3.length()) {
                bl3 = false;
            } else if (string2.length() < string3.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += string2.length();
        } else if (bl3) {
            n += string3.length();
        } else {
            parsePosition.errorIndex = n;
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c = this.symbols.getZeroDigit();
            char c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c3 = this.symbols.getGroupingSeparator();
            String string4 = this.symbols.getExponentSeparator();
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                char c4 = string.charAt(n);
                int n6 = c4 - c;
                if (n6 < 0 || n6 > 9) {
                    n6 = Character.digit(c4, 10);
                }
                if (n6 == 0) {
                    n5 = -1;
                    bl6 = true;
                    if (digitList.count == 0) {
                        if (bl4) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n4;
                        digitList.append((char)(n6 + 48));
                    }
                } else if (n6 > 0 && n6 <= 9) {
                    bl6 = true;
                    ++n4;
                    digitList.append((char)(n6 + 48));
                    n5 = -1;
                } else if (!bl && c4 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.decimalAt = n4;
                    bl4 = true;
                } else if (!bl && c4 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n5 = n;
                } else {
                    if (bl || !string.regionMatches(n, string4, 0, string4.length()) || bl5) break;
                    ParsePosition parsePosition2 = new ParsePosition(n + string4.length());
                    boolean[] blArray2 = new boolean[2];
                    DigitList digitList2 = new DigitList();
                    if (!this.subparse(string, parsePosition2, "", Character.toString(this.symbols.getMinusSign()), digitList2, true, blArray2) || !digitList2.fitsIntoLong(blArray2[1], true)) break;
                    n = parsePosition2.index;
                    n3 = (int)digitList2.getLong();
                    if (!blArray2[1]) {
                        n3 = -n3;
                    }
                    bl5 = true;
                    break;
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.decimalAt = n4;
            }
            digitList.decimalAt += n3;
            if (!bl6 && n4 == 0) {
                parsePosition.index = n2;
                parsePosition.errorIndex = n2;
                return false;
            }
        }
        if (!bl) {
            if (bl2) {
                bl2 = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
            }
            if (bl3) {
                bl3 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
            }
            if (bl2 && bl3) {
                if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                    bl3 = false;
                } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                    bl2 = false;
                }
            }
            if (bl2 == bl3) {
                parsePosition.errorIndex = n;
                return false;
            }
            parsePosition.index = n + (bl2 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        } else {
            parsePosition.index = n;
        }
        blArray[1] = bl2;
        if (parsePosition.index == n2) {
            parsePosition.errorIndex = n;
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
            this.fastPathCheckNeeded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
        this.fastPathCheckNeeded = true;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            this.positivePrefixFieldPositions = this.posPrefixPattern != null ? this.expandAffix(this.posPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
        this.fastPathCheckNeeded = true;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            this.negativePrefixFieldPositions = this.negPrefixPattern != null ? this.expandAffix(this.negPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
        this.fastPathCheckNeeded = true;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            this.positiveSuffixFieldPositions = this.posSuffixPattern != null ? this.expandAffix(this.posSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
        this.fastPathCheckNeeded = true;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            this.negativeSuffixFieldPositions = this.negSuffixPattern != null ? this.expandAffix(this.negSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
        this.bigDecimalMultiplier = null;
        this.bigIntegerMultiplier = null;
        this.fastPathCheckNeeded = true;
    }

    @Override
    public void setGroupingUsed(boolean bl) {
        super.setGroupingUsed(bl);
        this.fastPathCheckNeeded = true;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
        this.fastPathCheckNeeded = true;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
        this.fastPathCheckNeeded = true;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean bl) {
        this.parseBigDecimal = bl;
    }

    @Override
    public Object clone() {
        DecimalFormat decimalFormat = (DecimalFormat)super.clone();
        decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
        decimalFormat.digitList = (DigitList)this.digitList.clone();
        decimalFormat.fastPathCheckNeeded = true;
        decimalFormat.isFastPath = false;
        decimalFormat.fastPathData = null;
        return decimalFormat;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.posPrefixPattern == decimalFormat.posPrefixPattern && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (this.posSuffixPattern == decimalFormat.posSuffixPattern && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (this.negPrefixPattern == decimalFormat.negPrefixPattern && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (this.negSuffixPattern == decimalFormat.negSuffixPattern && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.parseBigDecimal == decimalFormat.parseBigDecimal && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.maximumIntegerDigits == decimalFormat.maximumIntegerDigits && this.minimumIntegerDigits == decimalFormat.minimumIntegerDigits && this.maximumFractionDigits == decimalFormat.maximumFractionDigits && this.minimumFractionDigits == decimalFormat.minimumFractionDigits && this.roundingMode == decimalFormat.roundingMode && this.symbols.equals(decimalFormat.symbols);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        block6: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                c = string.charAt(n++);
                switch (c) {
                    case '\u00a4': {
                        if (n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private FieldPosition[] expandAffix(String string) {
        ArrayList<Object> arrayList = null;
        int n = 0;
        int n2 = 0;
        block6: while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) == '\'') {
                Object object;
                int n3 = -1;
                NumberFormat.Field field = null;
                c = string.charAt(n2++);
                switch (c) {
                    case '\u00a4': {
                        if (n2 < string.length() && string.charAt(n2) == '\u00a4') {
                            ++n2;
                            object = this.symbols.getInternationalCurrencySymbol();
                        } else {
                            object = this.symbols.getCurrencySymbol();
                        }
                        if (((String)object).length() <= 0) continue block6;
                        if (arrayList == null) {
                            arrayList = new ArrayList(2);
                        }
                        FieldPosition fieldPosition = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fieldPosition.setBeginIndex(n);
                        fieldPosition.setEndIndex(n + ((String)object).length());
                        arrayList.add(fieldPosition);
                        n += ((String)object).length();
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        n3 = -1;
                        field = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        n3 = -1;
                        field = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                        n3 = -1;
                        field = NumberFormat.Field.SIGN;
                    }
                }
                if (field != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>(2);
                    }
                    object = new FieldPosition(field, n3);
                    ((FieldPosition)object).setBeginIndex(n);
                    ((FieldPosition)object).setEndIndex(n + 1);
                    arrayList.add(object);
                }
            }
            ++n;
        }
        if (arrayList != null) {
            return arrayList.toArray(EmptyFieldPositionArray);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl);
        } else {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(39, n);
                if (n2 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n), bl);
                    break;
                }
                if (n2 > n) {
                    this.appendAffix(stringBuffer, string.substring(n, n2), bl);
                }
                char c = string.charAt(++n2);
                ++n2;
                if (c == '\'') {
                    stringBuffer.append(c);
                } else if (c == '\u00a4' && n2 < string.length() && string.charAt(n2) == '\u00a4') {
                    stringBuffer.append(c);
                } else if (bl) {
                    switch (c) {
                        case '%': {
                            c = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c);
                n = ++n2;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl3 = bl2 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i >= 0; --i) {
            int n;
            int n2;
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl);
            }
            for (n2 = n = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1; n2 > 0; --n2) {
                if (n2 != n && this.isGroupingUsed() && this.groupingSize != 0 && n2 % this.groupingSize == 0) {
                    stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n2 <= this.getMinimumIntegerDigits() ? (bl ? this.symbols.getZeroDigit() : (char)'0') : (bl ? this.symbols.getDigit() : (char)'#'));
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            for (n2 = 0; n2 < this.getMaximumFractionDigits(); ++n2) {
                if (n2 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    continue;
                }
                stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentSeparator() : PATTERN_EXPONENT);
                for (n2 = 0; n2 < this.minExponentDigits; ++n2) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                }
            }
            if (i == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl);
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        int n = 48;
        int n2 = 44;
        int n3 = 46;
        int n4 = 37;
        int n5 = 8240;
        int n6 = 35;
        int n7 = 59;
        String string2 = PATTERN_EXPONENT;
        int n8 = 45;
        if (bl) {
            n = this.symbols.getZeroDigit();
            n2 = this.symbols.getGroupingSeparator();
            n3 = this.symbols.getDecimalSeparator();
            n4 = this.symbols.getPercent();
            n5 = this.symbols.getPerMill();
            n6 = this.symbols.getDigit();
            n7 = this.symbols.getPatternSeparator();
            string2 = this.symbols.getExponentSeparator();
            n8 = this.symbols.getMinusSign();
        }
        boolean bl2 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 1; i >= 0 && n11 < string.length(); --i) {
            int n12;
            int n13;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n14 = -1;
            int n15 = 1;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = -1;
            int n20 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            block5: for (n13 = n11; n13 < string.length(); ++n13) {
                n12 = string.charAt(n13);
                switch (n20) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (n12 == 39) {
                                if (n13 + 1 < string.length() && string.charAt(n13 + 1) == '\'') {
                                    ++n13;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl3 = false;
                                continue block5;
                            }
                        } else {
                            if (n12 == n6 || n12 == n || n12 == n2 || n12 == n3) {
                                n20 = 1;
                                if (i == 1) {
                                    n9 = n13;
                                }
                                --n13;
                                continue block5;
                            }
                            if (n12 == 164) {
                                boolean bl4;
                                boolean bl5 = bl4 = n13 + 1 < string.length() && string.charAt(n13 + 1) == '\u00a4';
                                if (bl4) {
                                    ++n13;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(bl4 ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (n12 == 39) {
                                if (n12 == 39) {
                                    if (n13 + 1 < string.length() && string.charAt(n13 + 1) == '\'') {
                                        ++n13;
                                        stringBuffer3.append("''");
                                        continue block5;
                                    }
                                    bl3 = true;
                                    continue block5;
                                }
                            } else {
                                if (n12 == n7) {
                                    if (n20 == 0 || i == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + (char)n12 + "' in pattern \"" + string + '\"');
                                    }
                                    n11 = n13 + 1;
                                    n13 = string.length();
                                    continue block5;
                                }
                                if (n12 == n4) {
                                    if (n15 != 1) {
                                        throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"');
                                    }
                                    n15 = 100;
                                    stringBuffer3.append("'%");
                                    continue block5;
                                }
                                if (n12 == n5) {
                                    if (n15 != 1) {
                                        throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"');
                                    }
                                    n15 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    continue block5;
                                }
                                if (n12 == n8) {
                                    stringBuffer3.append("'-");
                                    continue block5;
                                }
                            }
                        }
                        stringBuffer3.append((char)n12);
                        continue block5;
                    }
                    case 1: {
                        if (i == 1) {
                            ++n10;
                        } else {
                            if (--n10 != 0) continue block5;
                            n20 = 2;
                            stringBuffer3 = stringBuffer2;
                            continue block5;
                        }
                        if (n12 == n6) {
                            if (n17 > 0) {
                                ++n18;
                            } else {
                                ++n16;
                            }
                            if (n19 < 0 || n14 >= 0) continue block5;
                            n19 = (byte)(n19 + 1);
                            continue block5;
                        }
                        if (n12 == n) {
                            if (n18 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++n17;
                            if (n19 < 0 || n14 >= 0) continue block5;
                            n19 = (byte)(n19 + 1);
                            continue block5;
                        }
                        if (n12 == n2) {
                            n19 = 0;
                            continue block5;
                        }
                        if (n12 == n3) {
                            if (n14 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            n14 = n16 + n17 + n18;
                            continue block5;
                        }
                        if (string.regionMatches(n13, string2, 0, string2.length())) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            n13 += string2.length();
                            while (n13 < string.length() && string.charAt(n13) == n) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++n10;
                                ++n13;
                            }
                            if (n16 + n17 < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"');
                            }
                            n20 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n13;
                            continue block5;
                        }
                        n20 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n13;
                        --n10;
                        continue block5;
                    }
                }
            }
            if (n17 == 0 && n16 > 0 && n14 >= 0) {
                n13 = n14;
                if (n13 == 0) {
                    ++n13;
                }
                n18 = n16 - n13;
                n16 = n13 - 1;
                n17 = 1;
            }
            if (n14 < 0 && n18 > 0 || n14 >= 0 && (n14 < n16 || n14 > n16 + n17) || n19 == 0 || bl3) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (i == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                n13 = n16 + n17 + n18;
                n12 = n14 >= 0 ? n14 : n13;
                this.setMinimumIntegerDigits(n12 - n16);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? n16 + this.getMinimumIntegerDigits() : Integer.MAX_VALUE);
                this.setMaximumFractionDigits(n14 >= 0 ? n13 - n14 : 0);
                this.setMinimumFractionDigits(n14 >= 0 ? n16 + n17 - n14 : 0);
                this.setGroupingUsed(n19 > 0);
                this.groupingSize = (byte)(n19 > 0 ? n19 : 0);
                this.multiplier = n15;
                this.setDecimalSeparatorAlwaysShown(n14 == 0 || n14 == n13);
                continue;
            }
            this.negPrefixPattern = stringBuffer.toString();
            this.negSuffixPattern = stringBuffer2.toString();
            bl2 = true;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(Integer.MAX_VALUE);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
        if (!bl2 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    @Override
    public void setMaximumIntegerDigits(int n) {
        this.maximumIntegerDigits = Math.min(Math.max(0, n), Integer.MAX_VALUE);
        super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
            super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        }
        this.fastPathCheckNeeded = true;
    }

    @Override
    public void setMinimumIntegerDigits(int n) {
        this.minimumIntegerDigits = Math.min(Math.max(0, n), Integer.MAX_VALUE);
        super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
            super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        }
        this.fastPathCheckNeeded = true;
    }

    @Override
    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = Math.min(Math.max(0, n), Integer.MAX_VALUE);
        super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
            super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        }
        this.fastPathCheckNeeded = true;
    }

    @Override
    public void setMinimumFractionDigits(int n) {
        this.minimumFractionDigits = Math.min(Math.max(0, n), Integer.MAX_VALUE);
        super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
            super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        }
        this.fastPathCheckNeeded = true;
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    @Override
    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    @Override
    public void setCurrency(Currency currency) {
        if (currency != this.symbols.getCurrency()) {
            this.symbols.setCurrency(currency);
            if (this.isCurrencyFormat) {
                this.expandAffixes();
            }
        }
        this.fastPathCheckNeeded = true;
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        this.roundingMode = roundingMode;
        this.digitList.setRoundingMode(roundingMode);
        this.fastPathCheckNeeded = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.digitList = new DigitList();
        this.fastPathCheckNeeded = true;
        this.isFastPath = false;
        this.fastPathData = null;
        if (this.serialVersionOnStream < 4) {
            this.setRoundingMode(RoundingMode.HALF_EVEN);
        } else {
            this.setRoundingMode(this.getRoundingMode());
        }
        if (super.getMaximumIntegerDigits() > 309 || super.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.serialVersionOnStream < 3) {
            this.setMaximumIntegerDigits(super.getMaximumIntegerDigits());
            this.setMinimumIntegerDigits(super.getMinimumIntegerDigits());
            this.setMaximumFractionDigits(super.getMaximumFractionDigits());
            this.setMinimumFractionDigits(super.getMinimumFractionDigits());
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 4;
    }

    private static class DigitArrays {
        static final char[] DigitOnes1000 = new char[1000];
        static final char[] DigitTens1000 = new char[1000];
        static final char[] DigitHundreds1000 = new char[1000];

        private DigitArrays() {
        }

        static {
            int n = 0;
            int n2 = 0;
            int n3 = 48;
            int n4 = 48;
            int n5 = 48;
            for (int i = 0; i < 1000; ++i) {
                DigitArrays.DigitOnes1000[i] = n3;
                n3 = n3 == 57 ? 48 : (int)((char)(n3 + 1));
                DigitArrays.DigitTens1000[i] = n4;
                if (i == n + 9) {
                    n += 10;
                    n4 = n4 == 57 ? 48 : (int)((char)(n4 + 1));
                }
                DigitArrays.DigitHundreds1000[i] = n5;
                if (i != n2 + 99) continue;
                n5 = (char)(n5 + 1);
                n2 += 100;
            }
        }
    }

    private static class FastPathData {
        int lastFreeIndex;
        int firstUsedIndex;
        int zeroDelta;
        char groupingChar;
        int integralLastIndex;
        int fractionalFirstIndex;
        double fractionalScaleFactor;
        int fractionalMaxIntBound;
        char[] fastPathContainer;
        char[] charsPositivePrefix;
        char[] charsNegativePrefix;
        char[] charsPositiveSuffix;
        char[] charsNegativeSuffix;
        boolean positiveAffixesRequired = true;
        boolean negativeAffixesRequired = true;

        private FastPathData() {
        }
    }
}

