/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.MemorySafetyService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public class SecurityManager {
    @Deprecated
    protected boolean inCheck;
    private boolean initialized = false;
    private static ThreadGroup rootGroup = SecurityManager.getRootGroup();
    private static boolean packageAccessValid = false;
    private static PackageCollection packageAccess;
    private static final Object packageAccessLock;
    private static boolean packageDefinitionValid;
    private static PackageCollection packageDefinition;
    private static final Object packageDefinitionLock;

    private boolean hasAllPermission() {
        try {
            this.checkPermission(SecurityConstants.ALL_PERMISSION);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    @Deprecated
    public boolean getInCheck() {
        return this.inCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityManager() {
        Class<SecurityManager> clazz = SecurityManager.class;
        synchronized (SecurityManager.class) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected native Class[] getClassContext();

    @Deprecated
    protected ClassLoader currentClassLoader() {
        ClassLoader classLoader = this.currentClassLoader0();
        if (classLoader != null && this.hasAllPermission()) {
            classLoader = null;
        }
        return classLoader;
    }

    private native ClassLoader currentClassLoader0();

    @Deprecated
    protected Class<?> currentLoadedClass() {
        Class<?> clazz = this.currentLoadedClass0();
        if (clazz != null && this.hasAllPermission()) {
            clazz = null;
        }
        return clazz;
    }

    @Deprecated
    protected native int classDepth(String var1);

    @Deprecated
    protected int classLoaderDepth() {
        int n = this.classLoaderDepth0();
        if (n != -1) {
            n = this.hasAllPermission() ? -1 : --n;
        }
        return n;
    }

    private native int classLoaderDepth0();

    @Deprecated
    protected boolean inClass(String string) {
        return this.classDepth(string) >= 0;
    }

    @Deprecated
    protected boolean inClassLoader() {
        return this.currentClassLoader() != null;
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        ((AccessControlContext)object).checkPermission(permission);
    }

    public void checkCreateClassLoader() {
        this.checkPermission(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
    }

    private static ThreadGroup getRootGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public void checkAccess(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread can't be null");
        }
        if (thread.getThreadGroup() == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (threadGroup == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
    }

    public void checkExit(int n) {
        this.checkPermission(new RuntimePermission("exitVM." + n));
    }

    public void checkExec(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            this.checkPermission(new FilePermission(string, "execute"));
        } else {
            this.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public void checkLink(String string) {
        if (string == null) {
            throw new NullPointerException("library can't be null");
        }
        this.checkPermission(new RuntimePermission("loadLibrary." + string));
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String string) {
        this.checkPermission(new FilePermission(string, "read"));
    }

    public void checkRead(String string, Object object) {
        this.checkPermission(new FilePermission(string, "read"), object);
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String string) {
        this.checkPermission(new FilePermission(string, "write"));
    }

    public void checkDelete(String string) {
        this.checkPermission(new FilePermission(string, "delete"));
    }

    public void checkConnect(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(string + ":" + n, "connect"));
        }
    }

    public void checkConnect(String string, int n, Object object) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"), object);
        } else {
            this.checkPermission(new SocketPermission(string + ":" + n, "connect"), object);
        }
    }

    public void checkListen(int n) {
        this.checkPermission(new SocketPermission("localhost:" + n, "listen"));
    }

    public void checkAccept(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string + ":" + n, "accept"));
    }

    public void checkMulticast(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string, "connect,accept"));
    }

    @Deprecated
    public void checkMulticast(InetAddress inetAddress, byte by) {
        String string = inetAddress.getHostAddress();
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string, "connect,accept"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String string) {
        this.checkPermission(new PropertyPermission(string, "read"));
    }

    @Deprecated
    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        Permission permission = SecurityConstants.AWT.TOPLEVEL_WINDOW_PERMISSION;
        if (permission == null) {
            permission = SecurityConstants.ALL_PERMISSION;
        }
        try {
            this.checkPermission(permission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    @Deprecated
    public void checkSystemClipboardAccess() {
        Permission permission = SecurityConstants.AWT.ACCESS_CLIPBOARD_PERMISSION;
        if (permission == null) {
            permission = SecurityConstants.ALL_PERMISSION;
        }
        this.checkPermission(permission);
    }

    @Deprecated
    public void checkAwtEventQueueAccess() {
        Permission permission = SecurityConstants.AWT.CHECK_AWT_EVENTQUEUE_PERMISSION;
        if (permission == null) {
            permission = SecurityConstants.ALL_PERMISSION;
        }
        this.checkPermission(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PackageCollection getPackages(String string) {
        StringTokenizer stringTokenizer;
        int n;
        PackageCollection packageCollection = null;
        if (string != null && !string.equals("") && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            String string2;
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                if (n >= PackageCollection.THRESHOLD) {
                    packageCollection = new PackageCollection(new HashSet<String>(n));
                    string2 = stringTokenizer.nextToken().trim();
                    packageCollection.packagesInSet.add(string2.intern());
                } else {
                    packageCollection = new PackageCollection(new String[n]);
                }
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
            if (packageCollection.isSet) {
                while (stringTokenizer.hasMoreElements()) {
                    string2 = stringTokenizer.nextToken().trim();
                    packageCollection.packagesInSet.add(string2.intern());
                }
            } else {
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    packageCollection.packagesInArray[n2++] = string3.intern();
                }
            }
        }
        if (packageCollection == null) {
            long l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                packageCollection = new PackageCollection(new String[0]);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
        }
        return packageCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageAccess(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        Object object = packageAccessLock;
        synchronized (packageAccessLock) {
            if (!packageAccessValid) {
                String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("package.access");
                    }
                });
                packageAccess = SecurityManager.getPackages(string2);
                packageAccessValid = true;
            }
            PackageCollection packageCollection = packageAccess;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (packageCollection.isSet) {
                object = string;
                int n = string.length();
                while (n != -1) {
                    if (packageCollection.packagesInSet.contains((String)(object = ((String)object).substring(0, n)) + ".")) {
                        this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
                        break;
                    }
                    n = ((String)object).lastIndexOf(46);
                }
            } else {
                object = packageCollection.packagesInArray;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (!string.startsWith(object[i]) && !object[i].equals(string + ".")) continue;
                    this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageDefinition(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        Object object = packageDefinitionLock;
        synchronized (packageDefinitionLock) {
            if (!packageDefinitionValid) {
                String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("package.definition");
                    }
                });
                packageDefinition = SecurityManager.getPackages(string2);
                packageDefinitionValid = true;
            }
            PackageCollection packageCollection = packageDefinition;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (packageCollection.isSet) {
                object = string;
                int n = string.length();
                while (n != -1) {
                    if (packageCollection.packagesInSet.contains((String)(object = ((String)object).substring(0, n)) + ".")) {
                        this.checkPermission(new RuntimePermission("defineClassInPackage." + string));
                        break;
                    }
                    n = ((String)object).lastIndexOf(46);
                }
            } else {
                object = packageCollection.packagesInArray;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (!string.startsWith(object[i]) && !object[i].equals(string + ".")) continue;
                    this.checkPermission(new RuntimePermission("defineClassInPackage." + string));
                    break;
                }
            }
            return;
        }
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    @Deprecated
    @CallerSensitive
    public void checkMemberAccess(Class<?> clazz, int n) {
        Class[] classArray;
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (n != 0 && ((classArray = this.getClassContext()).length < 4 || classArray[3].getClassLoader() != clazz.getClassLoader())) {
            this.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
    }

    public void checkSecurityAccess(String string) {
        this.checkPermission(new SecurityPermission(string));
    }

    private native Class<?> currentLoadedClass0();

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    static {
        packageAccessLock = new InterruptAccessLock();
        packageDefinitionValid = false;
        packageDefinitionLock = new InterruptDefinitionLock();
    }

    private static class InterruptAccessLock {
        private InterruptAccessLock() {
        }
    }

    private static class InterruptDefinitionLock {
        private InterruptDefinitionLock() {
        }
    }

    private static class PackageCollection {
        public static int THRESHOLD = 50;
        boolean isSet;
        String[] packagesInArray;
        Set<String> packagesInSet;

        public PackageCollection(String[] stringArray) {
            this.isSet = false;
            this.packagesInArray = stringArray;
        }

        public PackageCollection(Set<String> set) {
            this.isSet = true;
            this.packagesInSet = set;
        }
    }
}

