/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Locale;
import sun.nio.fs.DefaultFileSystemProvider;
import sun.security.action.GetPropertyAction;

class WinNTFileSystem
extends FileSystem {
    private final char slash;
    private final char altSlash;
    private final char semicolon;
    private static final boolean ENABLE_ADS;
    private static String[] driveDirCache;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache prefixCache = new ExpiringCache();

    public WinNTFileSystem() {
        this.slash = AccessController.doPrivileged(new GetPropertyAction("file.separator")).charAt(0);
        this.semicolon = AccessController.doPrivileged(new GetPropertyAction("path.separator")).charAt(0);
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
    }

    private boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private String slashify(String string) {
        if (string.length() > 0 && string.charAt(0) != this.slash) {
            return this.slash + string;
        }
        return string;
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.semicolon;
    }

    @Override
    public String normalize(String string) {
        int n = string.length();
        char c = this.slash;
        char c2 = this.altSlash;
        char c3 = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c4 = string.charAt(i);
            if (c4 == c2) {
                return this.normalize(string, n, c3 == c ? i - 1 : i);
            }
            if (c4 == c && c3 == c && i > 1) {
                return this.normalize(string, n, i - 1);
            }
            if (c4 == ':' && i > 1) {
                return this.normalize(string, n, 0);
            }
            c3 = c4;
        }
        if (c3 == c) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    private String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        if (n2 < 3) {
            n2 = 0;
        }
        char c = this.slash;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (n2 == 0) {
            n3 = this.normalizePrefix(string, n, stringBuffer);
        } else {
            n3 = n2;
            stringBuffer.append(string.substring(0, n2));
        }
        while (n3 < n) {
            char c2;
            if (this.isSlash(c2 = string.charAt(n3++))) {
                while (n3 < n && this.isSlash(string.charAt(n3))) {
                    ++n3;
                }
                if (n3 == n) {
                    int n4 = stringBuffer.length();
                    if (n4 == 2 && stringBuffer.charAt(1) == ':') {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 != 1 || !this.isSlash(stringBuffer.charAt(0))) break;
                    stringBuffer.append(c);
                    break;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private int normalizePrefix(String string, int n, StringBuffer stringBuffer) {
        char c;
        int n2;
        for (n2 = 0; n2 < n && this.isSlash(string.charAt(n2)); ++n2) {
        }
        if (n - n2 >= 2 && this.isLetter(c = string.charAt(n2)) && string.charAt(n2 + 1) == ':') {
            stringBuffer.append(c);
            stringBuffer.append(':');
            n2 += 2;
        } else {
            n2 = 0;
            if (n >= 2 && this.isSlash(string.charAt(0)) && this.isSlash(string.charAt(1))) {
                n2 = 1;
                stringBuffer.append(this.slash);
            }
        }
        return n2;
    }

    @Override
    public int prefixLength(String string) {
        char c;
        char c2 = this.slash;
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c3 = string.charAt(0);
        char c4 = c = n > 1 ? string.charAt(1) : (char)'\u0000';
        if (c3 == c2) {
            if (c == c2) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c3) && c == ':') {
            if (n > 2 && string.charAt(2) == c2) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isInvalid(File file) {
        if (file.getPath().indexOf(0) >= 0) {
            return true;
        }
        if (ENABLE_ADS) {
            return false;
        }
        String string = file.getPath();
        int n = string.lastIndexOf(":");
        if (n < 0 || n == 1 && this.isLetter(string.charAt(0))) {
            return false;
        }
        Path path = null;
        try {
            path = DefaultFileSystemProvider.theFileSystem().getPath(string, new String[0]);
            return false;
        }
        catch (InvalidPathException invalidPathException) {
            return true;
        }
    }

    @Override
    public String resolve(String string, String string2) {
        int n = string.length();
        if (n == 0) {
            return string2;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return string;
        }
        String string3 = string2;
        int n3 = 0;
        int n4 = n;
        if (n2 > 1 && string3.charAt(0) == this.slash && n2 == (n3 = string3.charAt(1) == this.slash ? 2 : 1)) {
            if (string.charAt(n - 1) == this.slash) {
                return string.substring(0, n - 1);
            }
            return string;
        }
        if (string.charAt(n - 1) == this.slash) {
            --n4;
        }
        int n5 = n4 + n2 - n3;
        char[] cArray = null;
        if (string2.charAt(n3) == this.slash) {
            cArray = new char[n5];
            string.getChars(0, n4, cArray, 0);
            string2.getChars(n3, n2, cArray, n4);
        } else {
            cArray = new char[n5 + 1];
            string.getChars(0, n4, cArray, 0);
            cArray[n4] = this.slash;
            string2.getChars(n3, n2, cArray, n4 + 1);
        }
        return new String(cArray);
    }

    @Override
    public String getDefaultParent() {
        return "" + this.slash;
    }

    @Override
    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.length() > 2 && string2.charAt(2) == ':') {
            if ((string2 = string2.substring(1)).length() > 3 && string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isAbsolute(File file) {
        int n = file.getPrefixLength();
        return n == 2 && file.getPath().charAt(0) == this.slash || n == 3;
    }

    @Override
    public String resolve(File file) {
        String string = file.getPath();
        int n = file.getPrefixLength();
        if (n == 2 && string.charAt(0) == this.slash) {
            return string;
        }
        if (n == 3) {
            return string;
        }
        if (n == 0) {
            return this.getUserPath() + this.slashify(string);
        }
        if (n == 1) {
            String string2 = this.getUserPath();
            String string3 = this.getDrive(string2);
            if (string3 != null) {
                return string3 + string;
            }
            return string2 + string;
        }
        if (n == 2) {
            String string4 = this.getUserPath();
            String string5 = this.getDrive(string4);
            if (string5 != null && string.startsWith(string5)) {
                return string4 + this.slashify(string.substring(2));
            }
            char c = string.charAt(0);
            String string6 = this.getDriveDirectory(c);
            if (string6 != null) {
                String string7 = "" + c + ':' + string6 + this.slashify(string.substring(2));
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(string7);
                    }
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Cannot resolve path " + string);
                }
                return string7;
            }
            return c + ":" + this.slashify(string.substring(2));
        }
        throw new InternalError("Unresolvable path: " + string);
    }

    private String getUserPath() {
        return this.normalize(System.getProperty("user.dir"));
    }

    private String getDrive(String string) {
        int n = this.prefixLength(string);
        return n == 3 ? string.substring(0, 2) : null;
    }

    private static int driveIndex(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        return -1;
    }

    private native String getDriveDirectory(int var1);

    private String getDriveDirectory(char c) {
        int n = WinNTFileSystem.driveIndex(c);
        if (n < 0) {
            return null;
        }
        String string = driveDirCache[n];
        if (string != null) {
            return string;
        }
        WinNTFileSystem.driveDirCache[n] = string = this.getDriveDirectory(n + 1);
        return string;
    }

    @Override
    public String canonicalize(String string) throws IOException {
        int n = string.length();
        if (n == 2 && this.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            char c = string.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return string;
            }
            return "" + (char)(c - 32) + ':';
        }
        if (n == 3 && this.isLetter(string.charAt(0)) && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            char c = string.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return string;
            }
            return "" + (char)(c - 32) + ':' + '\\';
        }
        if (!useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (useCanonPrefixCache && (string3 = WinNTFileSystem.parentOrNull(string)) != null && (string4 = this.prefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = this.canonicalizeWithPrefix(string4, (String)object);
                this.cache.put(string3 + File.separatorChar + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (useCanonPrefixCache && string3 != null && (string4 = WinNTFileSystem.parentOrNull(string2)) != null && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.prefixCache.put(string3, string4);
                }
            }
        }
        return string2;
    }

    private native String canonicalize0(String var1) throws IOException;

    private String canonicalizeWithPrefix(String string, String string2) throws IOException {
        return this.canonicalizeWithPrefix0(string, string + File.separatorChar + string2);
    }

    private native String canonicalizeWithPrefix0(String var1, String var2) throws IOException;

    private static String parentOrNull(String string) {
        int n;
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        char c2 = '/';
        int n2 = 0;
        int n3 = 0;
        for (int i = n = string.length() - 1; i > 0; --i) {
            char c3 = string.charAt(i);
            if (c3 == '.') {
                if (++n2 >= 2) {
                    return null;
                }
                if (n3 != 0) continue;
                return null;
            }
            if (c3 == c) {
                if (n2 == 1 && n3 == 0) {
                    return null;
                }
                if (i == 0 || i >= n - 1 || string.charAt(i - 1) == c || string.charAt(i - 1) == c2) {
                    return null;
                }
                return string.substring(0, i);
            }
            if (c3 == c2) {
                return null;
            }
            if (c3 == '*' || c3 == '?') {
                return null;
            }
            ++n3;
            n2 = 0;
        }
        return null;
    }

    @Override
    public native int getBooleanAttributes(File var1);

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    @Override
    public boolean delete(File file) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    @Override
    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public File[] listRoots() {
        int n = WinNTFileSystem.listRoots0();
        int n2 = 0;
        for (int i = 0; i < 26; ++i) {
            if ((n >> i & 1) == 0) continue;
            if (!this.access((char)(65 + i) + ":" + this.slash)) {
                n &= ~(1 << i);
                continue;
            }
            ++n2;
        }
        File[] fileArray = new File[n2];
        int n3 = 0;
        char c = this.slash;
        for (int i = 0; i < 26; ++i) {
            if ((n >> i & 1) == 0) continue;
            fileArray[n3++] = new File((char)(65 + i) + ":" + c);
        }
        return fileArray;
    }

    private static native int listRoots0();

    private boolean access(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    @Override
    public long getSpace(File file, int n) {
        if (file.exists()) {
            return this.getSpace0(file, n);
        }
        return 0L;
    }

    private native long getSpace0(File var1, int var2);

    @Override
    public int compare(File file, File file2) {
        return file.getPath().compareToIgnoreCase(file2.getPath());
    }

    @Override
    public int hashCode(File file) {
        return file.getPath().toLowerCase(Locale.ENGLISH).hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    private static native void initMvfsChecking();

    static {
        String string = GetPropertyAction.privilegedGetProperty("jdk.io.File.enableADS");
        ENABLE_ADS = string != null ? !string.equalsIgnoreCase(Boolean.FALSE.toString()) : true;
        driveDirCache = new String[26];
        WinNTFileSystem.initIDs();
        string = System.getProperty("com.ibm.rational.mvfs.checking");
        if (null != string && string.equalsIgnoreCase("true")) {
            WinNTFileSystem.initMvfsChecking();
        }
    }
}

