/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.SymbolTable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ParserPool {
    private final BlockingQueue queue;
    private SAXParserFactory factory;
    private int capacity;

    public ParserPool(int capacity) {
        this.capacity = capacity;
        this.queue = new ArrayBlockingQueue(capacity);
        this.factory = new SAXParserFactoryImpl();
        this.factory.setNamespaceAware(true);
        for (int i = 0; i < capacity; ++i) {
            try {
                this.queue.put(this.factory.newSAXParser());
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            catch (SAXException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public SAXParser get() throws ParserConfigurationException, SAXException {
        try {
            return (SAXParser)this.queue.take();
        }
        catch (InterruptedException ex) {
            throw new SAXException(ex);
        }
    }

    public void put(SAXParser parser) {
        this.queue.offer(parser);
    }

    public void returnParser(SAXParser saxParser) {
        saxParser.reset();
        this.resetSaxParser(saxParser);
        this.put(saxParser);
    }

    private void resetSaxParser(SAXParser parser) {
        try {
            SymbolTable table = new SymbolTable();
            parser.setProperty("http://apache.org/xml/properties/internal/symbol-table", table);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }
}

