/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceCommandParser {
    private static final String XTRACE = "-Xtrace:";
    private static final Pattern PATTERN = Pattern.compile(".*-Xtrace:[^ ]*output=([^,]*)");
    private static final Pattern PID_PATTERN = Pattern.compile("(.*)%p(.*)");

    public static File getTraceOutputFile(String[] vmargs, int pid) {
        File file = null;
        for (int x = 0; x < vmargs.length; ++x) {
            if (!vmargs[x].trim().startsWith(XTRACE)) continue;
            file = TraceCommandParser.getTraceOutputFile(vmargs[x], pid);
        }
        return file;
    }

    public static File getTraceOutputFile(String vmarg, int pid) {
        File file;
        block5: {
            file = null;
            Matcher matcher = PATTERN.matcher(vmarg);
            if (!matcher.find()) break block5;
            String fileName = matcher.group(1);
            Matcher pidMatcher = PID_PATTERN.matcher(fileName);
            if (pidMatcher.matches()) {
                String[] pidsToTry;
                for (String pidString : pidsToTry = new String[]{Integer.toHexString(pid), Integer.toString(pid)}) {
                    String filename = pidMatcher.group(1) + pidString + pidMatcher.group(2);
                    if (!TraceCommandParser.checkFileExists(filename)) continue;
                    file = new File(filename);
                }
            } else {
                file = new File(fileName);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    String template = Messages.getString("TraceCommandParser.could.not.open.trace.file");
                    String message = MessageFormat.format(template, fileName);
                    System.err.println(message);
                    e.printStackTrace(System.err);
                }
            }
        }
        return file;
    }

    private static boolean checkFileExists(String filename) {
        File file = new File(filename);
        return file.exists() && !file.isDirectory() && file.canRead();
    }
}

