/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MemCategoryPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9MemCategoryHelper;
import com.ibm.j9ddr.vm29_00.types.U32;
import com.ibm.j9ddr.vm29_00.view.dtfj.DTFJContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DTFJJavaRuntimeMemoryCategory
implements JavaRuntimeMemoryCategory {
    private final J9MemCategoryPointer category;
    private final JavaRuntime runtime;

    public DTFJJavaRuntimeMemoryCategory(JavaRuntime runtime, J9MemCategoryPointer category) {
        this.category = category;
        this.runtime = runtime;
    }

    public Iterator<?> getChildren() throws com.ibm.dtfj.image.CorruptDataException {
        return new ChildIterator(this.category);
    }

    public long getDeepAllocations() throws com.ibm.dtfj.image.CorruptDataException {
        DeepAllocationVisitor v = new DeepAllocationVisitor();
        try {
            J9MemCategoryHelper.visitMemoryCategoryChildren(this.category, v);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return v.deepAllocations;
    }

    public long getDeepBytes() throws com.ibm.dtfj.image.CorruptDataException {
        DeepBytesVisitor v = new DeepBytesVisitor();
        try {
            J9MemCategoryHelper.visitMemoryCategoryChildren(this.category, v);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return v.deepBytes;
    }

    public Iterator<?> getMemorySections(boolean includeFreed) throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        return IteratorHelpers.filterIterator(this.runtime.getMemorySections(includeFreed), new IteratorHelpers.IteratorFilter<Object>(){

            @Override
            public boolean accept(Object obj) {
                if (obj instanceof JavaRuntimeMemorySection) {
                    try {
                        if (DTFJJavaRuntimeMemoryCategory.this.equals(((JavaRuntimeMemorySection)obj).getMemoryCategory())) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.name().getCStringAtOffset(0L);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public long getShallowAllocations() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.liveAllocations().longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public long getShallowBytes() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.liveBytes().longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.runtime == null ? 0 : this.runtime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DTFJJavaRuntimeMemoryCategory)) {
            return false;
        }
        DTFJJavaRuntimeMemoryCategory other = (DTFJJavaRuntimeMemoryCategory)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        return !(this.runtime == null ? other.runtime != null : !this.runtime.equals((Object)other.runtime));
    }

    class ChildIterator
    implements Iterator<Object> {
        private final J9MemCategoryPointer category;
        private Object next = null;
        private int index = 0;

        public ChildIterator(J9MemCategoryPointer c) {
            this.category = c;
        }

        private Object internalNext() {
            int numberOfChildren = 0;
            try {
                numberOfChildren = this.category.numberOfChildren().intValue();
            }
            catch (CorruptDataException e) {
                return null;
            }
            if (this.index >= numberOfChildren) {
                return null;
            }
            try {
                U32 childCode = this.category.children().at(this.index++);
                J9MemCategoryPointer childCategory = J9MemCategoryHelper.getMemoryCategory(childCode);
                if (childCategory.categoryCode().eq(childCode)) {
                    return new DTFJJavaRuntimeMemoryCategory(DTFJJavaRuntimeMemoryCategory.this.runtime, childCategory);
                }
                return J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unknown child category code " + childCode.getHexValue());
            }
            catch (Throwable e) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), e);
                return cd;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.internalNext();
            return this.next != null;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                Object toReturn = this.next;
                this.next = null;
                return toReturn;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DeepAllocationVisitor
    implements J9MemCategoryHelper.IJ9MemCategoryVisitor {
        long deepAllocations = 0L;

        private DeepAllocationVisitor() {
        }

        @Override
        public void visit(J9MemCategoryPointer category) throws CorruptDataException {
            this.deepAllocations += category.liveAllocations().longValue();
        }
    }

    private static class DeepBytesVisitor
    implements J9MemCategoryHelper.IJ9MemCategoryVisitor {
        long deepBytes = 0L;

        private DeepBytesVisitor() {
        }

        @Override
        public void visit(J9MemCategoryPointer category) throws CorruptDataException {
            this.deepBytes += category.liveBytes().longValue();
        }
    }
}

