/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCConstantPoolClassSlotIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCConstantPoolObjectSlotIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DTFJConstantPoolIterator
implements Iterator,
IEventListener {
    private GCConstantPoolObjectSlotIterator poolObjects;
    private GCConstantPoolClassSlotIterator poolClasses;
    private J9DDRCorruptData cdata = null;
    private boolean EOIObjects = true;
    private boolean EOIClasses = true;

    public DTFJConstantPoolIterator(J9ClassPointer ptr) {
        try {
            EventManager.register(this);
            this.poolObjects = GCConstantPoolObjectSlotIterator.fromJ9Class(ptr);
            this.poolClasses = GCConstantPoolClassSlotIterator.fromJ9Class(ptr);
            this.EOIObjects = !this.poolObjects.hasNext();
            this.EOIClasses = !this.poolClasses.hasNext();
        }
        catch (CorruptDataException e) {
            this.corruptData("Unable to instantiate ConstantPool iterator", e, true);
        }
        finally {
            EventManager.unregister(this);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.EOIObjects || !this.EOIClasses || this.cdata != null;
    }

    public Object next() {
        if (this.hasNext()) {
            Object retval = null;
            if (!this.EOIObjects) {
                try {
                    EventManager.register(this);
                    retval = new DTFJJavaObject(this.poolObjects.next());
                    this.EOIObjects = !this.poolObjects.hasNext();
                }
                finally {
                    EventManager.unregister(this);
                }
                return retval;
            }
            if (!this.EOIClasses) {
                try {
                    EventManager.register(this);
                    try {
                        retval = new DTFJJavaObject(this.poolClasses.next().classObject());
                    }
                    catch (CorruptDataException e) {
                        retval = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
                    }
                    this.EOIClasses = !this.poolClasses.hasNext();
                }
                finally {
                    EventManager.unregister(this);
                }
                return retval;
            }
            if (this.cdata != null) {
                retval = this.cdata;
                this.cdata = null;
            }
            return retval;
        }
        throw new NoSuchElementException("There are no more elements in this iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The image is read only and cannot be modified.");
    }

    @Override
    public void corruptData(String message2, CorruptDataException e, boolean fatal) {
        this.EOIObjects = true;
        this.EOIClasses = true;
        this.cdata = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
    }
}

