/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptorSegregated_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorSegregatedPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySubSpacePointer;
import com.ibm.j9ddr.vm29.structure.MM_HeapRegionDescriptor$RegionType;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class GCHeapRegionDescriptor {
    protected MM_HeapRegionDescriptorPointer heapRegionDescriptor;

    protected GCHeapRegionDescriptor(MM_HeapRegionDescriptorPointer hrd) throws CorruptDataException {
        this.heapRegionDescriptor = hrd;
    }

    public static GCHeapRegionDescriptor fromHeapRegionDescriptor(GCHeapRegionDescriptor hrd) throws CorruptDataException {
        return hrd;
    }

    public static GCHeapRegionDescriptor fromHeapRegionDescriptor(MM_HeapRegionDescriptorPointer hrd) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_HEAP_REGION_DESCRIPTOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        if (GCHeapRegionDescriptor.isRegionSegregrated(hrd)) {
            return new GCHeapRegionDescriptorSegregated_V1(MM_HeapRegionDescriptorSegregatedPointer.cast(hrd));
        }
        return new GCHeapRegionDescriptor_V1(hrd);
    }

    public MM_HeapRegionDescriptorPointer getHeapRegionDescriptorPointer() {
        return this.heapRegionDescriptor;
    }

    private static boolean isRegionSegregrated(MM_HeapRegionDescriptorPointer hrd) throws CorruptDataException {
        long regionType = hrd._regionType();
        return J9BuildFlags.J9VM_GC_REALTIME && (MM_HeapRegionDescriptor$RegionType.SEGREGATED_LARGE == regionType || MM_HeapRegionDescriptor$RegionType.SEGREGATED_SMALL == regionType);
    }

    public abstract VoidPointer getLowAddress();

    public abstract VoidPointer getHighAddress();

    public abstract UDATA getSize();

    public abstract UDATA getTypeFlags();

    public abstract long getRegionType();

    public abstract MM_MemorySubSpacePointer getSubSpace();

    public abstract MM_MemoryPoolPointer getMemoryPool();

    public abstract boolean isAddressInRegion(AbstractPointer var1);

    public abstract boolean hasValidMarkMap();

    public abstract boolean containsObjects();

    public abstract GCObjectHeapIterator objectIterator(boolean var1, boolean var2) throws CorruptDataException;

    public abstract boolean isImmortal();

    public abstract boolean isScoped();

    public abstract GCHeapRegionDescriptor getHeadOfSpan();

    public abstract String descriptionString();

    public String toString() {
        String format = J9BuildFlags.J9VM_ENV_DATA64 ? "%s [0x%016X-0x%016X]" : "%s [0x%08X-0x%08X]";
        return String.format(format, this.descriptionString(), this.getLowAddress().getAddress(), this.getHighAddress().getAddress());
    }
}

