/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MemorySegmentIterator
implements Iterator {
    public static final int MEMORY_TYPE_RAM_CLASS = 65536;
    public static final int MEMORY_ALL_TYPES = -1;
    protected J9MemorySegmentPointer segment;
    private J9MemorySegmentPointer segmentPtr;
    protected final int flags;
    protected final boolean useClassloaderSegments;
    private boolean hasNextSegment = false;
    private boolean EOS = false;
    private CorruptDataException cde = null;

    public MemorySegmentIterator(J9MemorySegmentPointer source, int flags, boolean useClassloaderSegments) {
        this.segmentPtr = source;
        this.flags = flags;
        this.useClassloaderSegments = useClassloaderSegments;
        this.EOS = this.segmentPtr.isNull();
    }

    public MemorySegmentIterator(J9MemorySegmentListPointer source, int flags, boolean useClassloaderSegments) {
        this.flags = flags;
        this.useClassloaderSegments = useClassloaderSegments;
        try {
            this.segmentPtr = source.nextSegment();
            this.EOS = this.segmentPtr.isNull();
        }
        catch (CorruptDataException e) {
            this.EOS = true;
            EventManager.raiseCorruptDataEvent("Could not locate the first segment", e, true);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextSegment) {
            return true;
        }
        if (this.EOS) {
            if (this.cde != null) {
                EventManager.raiseCorruptDataEvent("Could not locate the next segment", this.cde, true);
            }
            return false;
        }
        try {
            while (!this.hasNextSegment && !this.EOS) {
                if (this.segmentPtr.type().anyBitsIn(this.flags)) {
                    this.hasNextSegment = true;
                    this.segment = this.segmentPtr;
                }
                this.segmentPtr = this.useClassloaderSegments ? this.segmentPtr.nextSegmentInClassLoader() : this.segmentPtr.nextSegment();
                if (!this.segmentPtr.isNull()) continue;
                this.EOS = true;
            }
            return this.hasNextSegment;
        }
        catch (CorruptDataException e) {
            this.EOS = true;
            if (this.hasNextSegment) {
                this.cde = e;
            } else {
                EventManager.raiseCorruptDataEvent("Could not locate the next segment", e, true);
            }
            return this.hasNextSegment;
        }
    }

    public Object next() {
        if (this.hasNext()) {
            this.hasNextSegment = false;
            return this.segment;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }
}

