/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm28.j9.ArgBits;
import com.ibm.j9ddr.vm28.j9.PCStack;
import com.ibm.j9ddr.vm28.j9.ROMHelp;
import com.ibm.j9ddr.vm28.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm28.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm28.types.I16;
import com.ibm.j9ddr.vm28.types.I32;
import com.ibm.j9ddr.vm28.types.U32;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.localmap");
    public static final int ENCODED_INDEX = 4;
    public static final int ENCODED_MASK = 3;
    public static final int WIDE_INDEX = 8;
    public static final int DOUBLE_ACCESS = 32;
    public static final int SINGLE_ACCESS = 64;
    public static final int OBJECT_ACCESS = 128;
    public static final int WRITE_ACCESS = 16;
    public static final int INT = 0;
    public static final int OBJ = 1;
    public static final int NOT_FOUND = -1;
    public static final int WALKED = 1;
    private static LocalMapImpl impl = null;

    public static void j9localmap_ArgBitsForPC0(J9ROMMethodPointer romMethod, int[] resultsArray) throws CorruptDataException {
        LocalMap.getImpl().j9localmap_ArgBitsForPC0(romMethod, resultsArray);
    }

    public static int j9localmap_LocalBitsForPC(J9ROMMethodPointer romMethod, UDATA pc, int[] resultsArray) throws CorruptDataException {
        return LocalMap.getImpl().j9localmap_LocalBitsForPC(romMethod, pc, resultsArray);
    }

    private static LocalMapImpl getImpl() {
        if (impl == null) {
            impl = LocalMap.getImpl("ALG_LOCAL_MAP_VERSION");
        }
        return impl;
    }

    private static LocalMapImpl getImpl(String algorithmID) {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf(algorithmID);
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new LocalMap_V1();
    }

    private static class BranchState {
        public final int seekLocals;
        public final U32 programCounter;

        public BranchState(U32 programCounter, int seekLocals) {
            this.seekLocals = seekLocals;
            this.programCounter = programCounter;
        }
    }

    private static interface LocalMapImpl {
        public void j9localmap_ArgBitsForPC0(J9ROMMethodPointer var1, int[] var2) throws CorruptDataException;

        public int j9localmap_LocalBitsForPC(J9ROMMethodPointer var1, UDATA var2, int[] var3) throws CorruptDataException;
    }

    private static class LocalMap_V1
    implements LocalMapImpl {
        private boolean unknownsWereUpdated = false;
        private int knownLocals = 0;
        private int knownObjects = 0;

        protected LocalMap_V1() {
        }

        @Override
        public void j9localmap_ArgBitsForPC0(J9ROMMethodPointer romMethod, int[] resultsArray) throws CorruptDataException {
            ArgBits.argBitsFromSignature(J9UTF8Helper.stringValue(ROMHelp.J9ROMMETHOD_SIGNATURE(romMethod)), resultsArray, ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod).add(31).rightShift(5).intValue(), romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic));
        }

        @Override
        public int j9localmap_LocalBitsForPC(J9ROMMethodPointer romMethod, UDATA pc, int[] resultsArray) throws CorruptDataException {
            UDATA mapWords = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod).add(31))).rightShift(5);
            Arrays.fill(resultsArray, 0, mapWords.intValue() - 1, 0);
            UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
            int[] scratchBuffer = new int[length.intValue()];
            this.mapAllLocals(romMethod, scratchBuffer, pc, resultsArray);
            return 0;
        }

        private void mapAllLocals(J9ROMMethodPointer romMethod, int[] unknownsByPC, UDATA startPC, int[] resultsArray) throws CorruptDataException {
            J9ExceptionInfoPointer exceptionData = null;
            J9ExceptionHandlerPointer handler = null;
            UDATA exceptionCount = new UDATA(0L);
            UDATA remainingLocals = new UDATA(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod)));
            int writeIndex = 0;
            int localIndexBase = 0;
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo)) {
                exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
                exceptionCount = new UDATA(exceptionData.catchCount());
            }
            while (remainingLocals.gt(0)) {
                Arrays.fill(unknownsByPC, 0, ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod).intValue() - 1, 0);
                this.knownLocals = 0;
                if (remainingLocals.gt(32)) {
                    remainingLocals = remainingLocals.sub(32L);
                } else {
                    if (remainingLocals.lt(new U32(32L))) {
                        this.knownLocals = -1;
                        this.knownLocals <<= remainingLocals.intValue();
                    }
                    remainingLocals = new UDATA(0L);
                }
                this.knownObjects = 0;
                this.mapLocalSet(romMethod, unknownsByPC, startPC, localIndexBase);
                if (this.knownLocals != -1 && exceptionCount.gt(0)) {
                    boolean keepLooking = true;
                    int unknownLocals = 0;
                    while (keepLooking) {
                        keepLooking = false;
                        handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionData);
                        for (int e = 0; e < exceptionCount.intValue(); ++e) {
                            unknownLocals = 0;
                            U32 j = handler.startPC();
                            while (j.lt(handler.endPC())) {
                                unknownLocals |= unknownsByPC[j.intValue()];
                                j = j.add(1);
                            }
                            int rawUnknowns = unknownLocals;
                            unknownLocals &= ~this.knownLocals;
                            if (logger.isLoggable(Level.FINER)) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append(String.format("handler[%d] unknowns raw=0x%X masked=0x%X [", e, rawUnknowns, unknownLocals));
                                for (int bitIndex = 0; bitIndex < 32; ++bitIndex) {
                                    int bit = 1 << bitIndex;
                                    if ((unknownLocals & bit) == 0) continue;
                                    buffer.append(String.format("%d ", bitIndex + localIndexBase));
                                }
                                buffer.append("]");
                                logger.logp(Level.FINER, "LocalMap", "mapAllLocals", buffer.toString());
                            }
                            if ((~unknownsByPC[handler.handlerPC().intValue()] & unknownLocals) != 0) {
                                int originalKnownLocals = this.knownLocals;
                                int localsBeforeWalk = this.knownLocals = ~unknownLocals;
                                this.unknownsWereUpdated = false;
                                this.mapLocalSet(romMethod, unknownsByPC, new UDATA(handler.handlerPC()), localIndexBase);
                                int exceptionKnownLocals = this.knownLocals;
                                this.knownLocals = originalKnownLocals;
                                keepLooking = keepLooking || exceptionKnownLocals != localsBeforeWalk;
                                keepLooking = keepLooking || this.unknownsWereUpdated;
                                this.knownLocals |= exceptionKnownLocals & ~localsBeforeWalk;
                            }
                            handler = handler.add(1L);
                        }
                    }
                }
                resultsArray[writeIndex] = this.knownObjects;
                ++writeIndex;
                localIndexBase += 32;
            }
        }

        private int mapLocalSet(J9ROMMethodPointer romMethod, int[] unknownsByPC, UDATA startPC, int localIndexBase) throws CorruptDataException {
            int seekLocals = ~this.knownLocals;
            Stack<BranchState> branchStack = new Stack<BranchState>();
            this.unknownsWereUpdated = false;
            U8Pointer bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            U8Pointer bcEnd = bcStart.add(ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod));
            U8Pointer bcIndex = bcStart.add(startPC);
            while (bcIndex.lt(bcEnd)) {
                boolean shouldBeWalked;
                int pc = (int)(bcIndex.getAddress() - bcStart.getAddress());
                boolean bl = shouldBeWalked = (~unknownsByPC[pc] & seekLocals) != 0;
                if (logger.isLoggable(Level.FINER)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(String.format("pc=%d walk=%s seekLocals=0x%X [", pc, shouldBeWalked ? "true" : "false", seekLocals));
                    for (int bitIndex = 0; bitIndex < 32; ++bitIndex) {
                        int bit = 1 << bitIndex;
                        if ((seekLocals & bit) == 0) continue;
                        buffer.append(String.format("%d ", bitIndex));
                    }
                    buffer.append("]");
                    logger.logp(Level.FINER, "LocalMap", "mapLocalSet", buffer.toString());
                }
                if ((~unknownsByPC[pc] & seekLocals) != 0) {
                    this.unknownsWereUpdated = true;
                    int n = pc;
                    unknownsByPC[n] = unknownsByPC[n] | seekLocals;
                    UDATA bc = new UDATA(bcIndex.at(0L));
                    UDATA size = new UDATA(0xFF & PCStack.J9JavaInstructionSizeAndBranchActionTable[bc.intValue()]);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "bcIndex={0}, bc={1}, size={2}", new Object[]{Long.toHexString(bcIndex.getAddress()), bc, size});
                    }
                    switch (size.intValue() >>> 4) {
                        case 0: {
                            UDATA temp1 = new UDATA(PCStack.J9BytecodeSlotUseTable[bc.intValue()]);
                            if (temp1.longValue() != 0L) {
                                U32 index;
                                if (temp1.anyBitsIn(4L)) {
                                    index = new U32(temp1.bitAnd(3));
                                } else {
                                    index = new U32(MapHelpers.PARAM_8(bcIndex, 1));
                                    if (temp1.anyBitsIn(8L)) {
                                        index = new U32(MapHelpers.PARAM_16(bcIndex, 1));
                                    }
                                }
                                index = index.sub(localIndexBase);
                                boolean doubleAccess = true;
                                while (doubleAccess) {
                                    if (index.lt(new UDATA(32L))) {
                                        int setBit = 1 << index.intValue();
                                        if ((seekLocals & setBit) != 0) {
                                            seekLocals &= ~setBit;
                                            logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  stop looking for local={0}", index);
                                            if (!temp1.anyBitsIn(16L)) {
                                                this.knownLocals |= setBit;
                                                logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  add local={0} to known locals.", index);
                                                if (temp1.anyBitsIn(128L)) {
                                                    this.knownObjects |= setBit;
                                                    logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  add local={0} to known objects.", index);
                                                }
                                            }
                                        } else {
                                            logger.logp(Level.FINEST, "LocalMap", "mapLocalSet", "  skipping reference to local={0}", index);
                                        }
                                    }
                                    if (temp1.anyBitsIn(32L)) {
                                        temp1 = temp1.bitAnd(new UDATA(32L).bitNot());
                                        index = index.add(1);
                                        continue;
                                    }
                                    doubleAccess = false;
                                }
                            }
                            bcIndex = bcIndex.add(size);
                            break;
                        }
                        case 1: {
                            I32 offset = new I32(new I16(MapHelpers.PARAM_16(bcIndex, 1)));
                            branchStack.push(new BranchState(new U32(pc).add(offset), seekLocals));
                        }
                        case 6: {
                            bcIndex = bcIndex.add(size.bitAnd(7));
                            break;
                        }
                        case 2: {
                            UDATA target;
                            I32 offset;
                            if (bc.intValue() == 167) {
                                offset = new I32(new I16(MapHelpers.PARAM_16(bcIndex, 1)));
                                target = new UDATA(pc).add(offset);
                            } else {
                                offset = new I32(MapHelpers.PARAM_32(bcIndex, 1));
                                target = new UDATA(pc).add(offset);
                            }
                            bcIndex = bcStart.add(target);
                            break;
                        }
                        case 4: {
                            if (branchStack.empty()) {
                                return 0;
                            }
                            BranchState newBranch = (BranchState)branchStack.pop();
                            pc = newBranch.programCounter.intValue();
                            seekLocals = newBranch.seekLocals;
                            seekLocals &= ~this.knownLocals;
                            bcIndex = bcStart.add(pc);
                            break;
                        }
                        case 5: {
                            U32 npairs;
                            UDATA temp1;
                            bcIndex = bcIndex.add(4 - (pc & 3));
                            I32 offset = new I32(MapHelpers.PARAM_32(bcIndex, 0));
                            bcIndex = bcIndex.add(4L);
                            UDATA target = new UDATA(pc).add(offset);
                            I32 low = new I32(MapHelpers.PARAM_32(bcIndex, 0));
                            bcIndex = bcIndex.add(4L);
                            if (bc.intValue() == 170) {
                                I32 high = new I32(MapHelpers.PARAM_32(bcIndex, 0));
                                bcIndex = bcIndex.add(4L);
                                npairs = new U32(high.sub(low).add(1L));
                                temp1 = new UDATA(0L);
                            } else {
                                npairs = new U32(low);
                                temp1 = new UDATA(4L);
                            }
                            while (npairs.gt(0)) {
                                bcIndex = bcIndex.add(temp1);
                                offset = new I32(MapHelpers.PARAM_32(bcIndex, 0));
                                bcIndex = bcIndex.add(4L);
                                branchStack.add(new BranchState(new U32(pc).add(offset), seekLocals));
                                npairs = npairs.sub(1);
                            }
                            bcIndex = bcStart.add(target);
                        }
                    }
                    continue;
                }
                if (branchStack.empty()) {
                    return 0;
                }
                BranchState newBranch = (BranchState)branchStack.pop();
                pc = newBranch.programCounter.intValue();
                seekLocals = newBranch.seekLocals;
                seekLocals &= ~this.knownLocals;
                bcIndex = bcStart.add(pc);
            }
            return 0;
        }
    }
}

