/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm28.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm28.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm28.j9.gc.GCMemoryPoolIterator;
import com.ibm.j9ddr.vm28.pointer.generated.MM_MemoryPoolPointer;
import java.util.NoSuchElementException;

class GCTarokMemoryPoolIterator
extends GCMemoryPoolIterator {
    protected MM_MemoryPoolPointer _currentMemoryPool = null;
    protected GCHeapRegionIterator _regionIterator = GCHeapRegionIterator.from();
    protected GCHeapRegionDescriptor _region = null;

    public GCTarokMemoryPoolIterator() throws CorruptDataException {
        this.advancePool();
    }

    private void advancePool() {
        this._currentMemoryPool = null;
        this._region = null;
        while (this._regionIterator.hasNext()) {
            this._region = this._regionIterator.next();
            MM_MemoryPoolPointer tempPool = this._region.getMemoryPool();
            if (!tempPool.notNull()) continue;
            this._currentMemoryPool = tempPool;
            break;
        }
    }

    @Override
    public GCMemoryPool next() {
        try {
            if (this.hasNext()) {
                GCMemoryPool next = GCMemoryPool.fromMemoryPoolPointerInRegion(this._region, this._currentMemoryPool);
                this.advancePool();
                return next;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", e, false);
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public boolean hasNext() {
        return null != this._currentMemoryPool;
    }

    @Override
    public String toString() {
        GCTarokMemoryPoolIterator tempIter = null;
        try {
            tempIter = new GCTarokMemoryPoolIterator();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next() + NEW_LINE);
        }
        return builder.toString();
    }
}

