/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.Pool;
import com.ibm.j9ddr.vm27.j9.SlotIterator;
import com.ibm.j9ddr.vm27.j9.SystemMonitor;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.J9ThreadConstants;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SystemMonitorSingleTier_V1
extends SystemMonitor {
    private static final HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> blockedThreads = new HashMap();
    private static final HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> waitingThreads = new HashMap();

    private static void addToMap(HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> map, J9ThreadMonitorPointer monitor, J9ThreadPointer thread) {
        if (!map.containsKey(monitor)) {
            map.put(monitor, new LinkedList());
        }
        map.get(monitor).add(thread);
    }

    protected SystemMonitorSingleTier_V1(J9ThreadMonitorPointer monitor) {
        this.monitor = monitor;
    }

    @Override
    public boolean isContended() throws CorruptDataException {
        return blockedThreads.containsKey(this.monitor);
    }

    private static List<J9ThreadPointer> threadListHelper(HashMap<J9ThreadMonitorPointer, List<J9ThreadPointer>> map, J9ThreadMonitorPointer monitor) throws CorruptDataException {
        if (map.containsKey(monitor)) {
            return map.get(monitor);
        }
        return new LinkedList<J9ThreadPointer>();
    }

    @Override
    public List<J9ThreadPointer> getWaitingThreads() throws CorruptDataException {
        return SystemMonitorSingleTier_V1.threadListHelper(waitingThreads, this.monitor);
    }

    @Override
    public List<J9ThreadPointer> getBlockedThreads() throws CorruptDataException {
        return SystemMonitorSingleTier_V1.threadListHelper(blockedThreads, this.monitor);
    }

    static {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            J9ThreadLibraryPointer lib = mainThread.osThread().library();
            J9PoolPointer pool = lib.thread_pool();
            Pool<J9ThreadPointer> threadPool = Pool.fromJ9Pool(pool, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> poolIterator = threadPool.iterator();
            while (poolIterator.hasNext()) {
                J9ThreadPointer osThreadPtr = (J9ThreadPointer)poolIterator.next();
                J9ThreadMonitorPointer threadMon = osThreadPtr.monitor();
                UDATA flags = osThreadPtr.flags();
                if (!threadMon.notNull()) continue;
                if (flags.allBitsIn(J9ThreadConstants.J9THREAD_FLAG_BLOCKED) || flags.allBitsIn(J9ThreadConstants.J9THREAD_FLAG_BLOCKED_AFTER_WAIT)) {
                    SystemMonitorSingleTier_V1.addToMap(blockedThreads, threadMon, osThreadPtr);
                }
                if (!flags.allBitsIn(J9ThreadConstants.J9THREAD_FLAG_WAITING)) continue;
                SystemMonitorSingleTier_V1.addToMap(waitingThreads, threadMon, osThreadPtr);
            }
        }
        catch (CorruptDataException e) {
            throw new RuntimeException(e);
        }
    }
}

