/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm26.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm26.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm26.view.dtfj.java.j9.HeapObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DTFJJavaHeap
implements JavaHeap {
    private final MM_MemorySpacePointer space;
    private String name;
    private String description;
    private ImagePointer id;
    List<GCHeapRegionDescriptor> regions;
    List<Object> objects = null;
    List<ImageSection> sections = null;

    public DTFJJavaHeap(MM_MemorySpacePointer space, String name, ImagePointer id) throws CorruptDataException {
        this.space = space;
        this.name = name;
        this.id = id;
        this.initRegions();
    }

    private void initRegions() throws CorruptDataException {
        MM_GCExtensionsPointer gcext = GCExtensions.getGCExtensionsPointer();
        MM_HeapRegionManagerPointer hrm = gcext.heapRegionManager();
        this.regions = IteratorHelpers.toList(GCHeapRegionIterator.fromMMHeapRegionManager(hrm, this.space, true, true));
    }

    public String getName() {
        return this.name + "@" + this.id;
    }

    public Iterator getObjects() {
        return new Iterator(){
            Iterator currentRegionIterator = null;
            Iterator<GCHeapRegionDescriptor> regionsIterator;
            {
                this.regionsIterator = DTFJJavaHeap.this.regions.iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                CurrentRegionListener currentRegionlistener = new CurrentRegionListener();
                try {
                    EventManager.register(currentRegionlistener);
                    if (null == this.currentRegionIterator || !this.currentRegionIterator.hasNext()) {
                        while (this.regionsIterator.hasNext()) {
                            try {
                                this.currentRegionIterator = new HeapObjectIterator(DTFJJavaHeap.this, this.regionsIterator.next());
                            }
                            catch (Throwable t) {
                                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                                this.currentRegionIterator = J9DDRDTFJUtils.corruptIterator(cd);
                            }
                            if (!this.currentRegionIterator.hasNext()) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (null != this.currentRegionIterator) {
                        boolean bl = this.currentRegionIterator.hasNext();
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    EventManager.unregister(currentRegionlistener);
                }
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.currentRegionIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }

            class CurrentRegionListener
            implements IEventListener {
                CurrentRegionListener() {
                }

                @Override
                public void corruptData(String message2, CorruptDataException e, boolean fatal) {
                    if (fatal) {
                        currentRegionIterator = J9DDRDTFJUtils.corruptIterator(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
                    }
                }
            }
        };
    }

    public Iterator getSections() {
        try {
            if (null == this.sections) {
                ArrayList<ImageSection> sectionList = new ArrayList<ImageSection>();
                Iterator<GCHeapRegionDescriptor> it = this.regions.iterator();
                while (it.hasNext()) {
                    try {
                        GCHeapRegionDescriptor region = it.next();
                        long base = region.getLowAddress().getAddress();
                        long size = region.getHighAddress().getAddress() - base;
                        String name = String.format("Heap extent at 0x%x (0x%x bytes)", base, size);
                        sectionList.add(new J9DDRImageSection(MM_HeapRegionDescriptorPointer.getProcess(), base, size, name));
                    }
                    catch (Throwable t) {
                        CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                        sectionList.add((ImageSection)cd);
                    }
                }
                this.sections = sectionList;
            }
            return this.sections.iterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTFJJavaHeap)) {
            return false;
        }
        DTFJJavaHeap compareTo = (DTFJJavaHeap)obj;
        return this.space.eq(compareTo.space);
    }

    public int hashCode() {
        return this.space.hashCode();
    }

    public String toString() {
        if (this.description == null) {
            try {
                U8Pointer minBase = U8Pointer.cast(-1L);
                U8Pointer maxTop = U8Pointer.cast(0L);
                String name = this.space._name().getCStringAtOffset(0L);
                for (GCHeapRegionDescriptor region : this.regions) {
                    U8Pointer base = U8Pointer.cast(region.getLowAddress());
                    U8Pointer top = U8Pointer.cast(region.getHighAddress());
                    if (base.lt(minBase)) {
                        minBase = base;
                    }
                    if (!top.gt(maxTop)) continue;
                    maxTop = top;
                }
                this.description = String.format("%s [%s, Span: 0x%08x->0x%08x, Regions: %d]", this.getName(), name, minBase.getAddress(), maxTop.getAddress(), this.regions.size());
            }
            catch (Throwable t) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                this.description = super.toString();
            }
        }
        return this.description;
    }
}

