/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCFinalizableListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCFinalizableListSlotIterator;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizeListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckFinalizableList
extends Check {
    CheckFinalizableList() {
    }

    @Override
    public void check() {
        try {
            GCFinalizableListIterator finalizableListIterator = GCFinalizableListIterator.from();
            while (finalizableListIterator.hasNext()) {
                GC_FinalizeListPointer finalizeList = finalizableListIterator.next();
                GCFinalizableListSlotIterator finalizableListSlotIterator = GCFinalizableListSlotIterator.fromFinalizeList(finalizeList);
                while (finalizableListSlotIterator.hasNext()) {
                    GC_FinalizerJobPointer job = finalizableListSlotIterator.next();
                    if (this._engine.checkSlotFinalizableList(J9ObjectPointer.cast(job._element())) == 0) continue;
                    return;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "FINALIZABLE";
    }

    @Override
    public void print() {
        try {
            ScanFormatter formatter = new ScanFormatter(this, "finalizableList");
            GCFinalizableListIterator finalizableListIterator = GCFinalizableListIterator.from();
            while (finalizableListIterator.hasNext()) {
                GC_FinalizeListPointer finalizeList = finalizableListIterator.next();
                formatter.section("finalizeList", finalizeList);
                GCFinalizableListSlotIterator finalizableListSlotIterator = GCFinalizableListSlotIterator.fromFinalizeList(finalizeList);
                while (finalizableListSlotIterator.hasNext()) {
                    GC_FinalizerJobPointer job = finalizableListSlotIterator.next();
                    formatter.entry(job);
                }
            }
            formatter.end("finalizableList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

