/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.j9.Pool;
import com.ibm.j9ddr.vm24.j9.SlotIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm24.structure.J9PackageIDTableEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class ClassIterator
implements Iterator<J9ClassPointer> {
    protected static final Logger logger = Logger.getLogger("j9ddr.walkers");
    private final Iterator<J9ClassPointer> iterator;
    private J9ClassPointer next = J9ClassPointer.NULL;

    protected ClassIterator(Iterator<J9ClassPointer> iterator) {
        this.iterator = iterator;
        this.setNextItem();
    }

    public static Iterator<J9ClassPointer> fromJ9Classloader(J9ClassLoaderPointer loader) throws CorruptDataException {
        J9HashTablePointer table = loader.classHashTable();
        SlotIterator<J9ClassPointer> iterator = null;
        switch (AlgorithmVersion.getVMMinorVersion()) {
            case 40: {
                logger.fine("Creating version 2.4.0 class walker");
                iterator = Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator();
                break;
            }
            default: {
                iterator = Pool.fromJ9Pool(table.nodePool(), J9ClassPointer.class, false).iterator();
            }
        }
        return new ClassIterator(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.next.notNull();
    }

    private void setNextItem() {
        this.next = J9ClassPointer.NULL;
        if (this.iterator.hasNext()) {
            block0 : switch (AlgorithmVersion.getVMMinorVersion()) {
                case 40: {
                    do {
                        this.next = this.iterator.next();
                        if (this.next.isNull()) break block0;
                        if ((this.next.getAddress() & J9PackageIDTableEntry.J9PACKAGE_ID_TAG) == 0L) continue;
                        this.next = J9ClassPointer.NULL;
                    } while (this.next.isNull() && this.iterator.hasNext());
                    break;
                }
                default: {
                    this.next = this.iterator.next();
                }
            }
        }
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            J9ClassPointer ptr = this.next;
            this.setNextItem();
            return ptr;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

