/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.j9.ObjectMonitor_V1;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import java.util.List;

public abstract class ObjectMonitor {
    public static ObjectMonitor fromJ9Object(J9ObjectPointer object) throws CorruptDataException {
        if (J9BuildFlags.opt_realTimeLockingSupport) {
            throw new UnsupportedOperationException("realtime locking not supported");
        }
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("OBJECT_MONITOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        ObjectMonitor_V1 v1 = new ObjectMonitor_V1(object);
        if (v1.getLockword().isNull()) {
            return null;
        }
        return v1;
    }

    public abstract J9ObjectPointer getObject();

    public abstract J9ObjectMonitorPointer getLockword();

    public abstract J9VMThreadPointer getOwner() throws CorruptDataException;

    public abstract long getCount() throws CorruptDataException;

    public abstract boolean isInflated();

    public abstract boolean isContended() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException;

    public abstract List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException;

    public abstract J9ThreadAbstractMonitorPointer getInflatedMonitor();
}

