/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.libraries.Footer;
import com.ibm.j9ddr.libraries.FooterLibraryEntry;
import com.ibm.j9ddr.libraries.SlidingFileInputStream;
import com.ibm.j9ddr.libraries.SlidingImageInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class CoreFileResolver
implements ILibraryResolver {
    public static final int FOOTER_MAGIC = 514789549;
    public static final byte[] FOOTER_MAGIC_BYTES = new byte[]{30, -81, 16, -83};
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    protected final File coreFile;
    protected ImageInputStream stream;
    protected boolean validFile = false;
    protected Footer footer = null;

    public static void main(String[] args) {
        CoreFileResolver resolver = new CoreFileResolver(args[0]);
    }

    public CoreFileResolver(String coreFilePath) {
        this.coreFile = new File(coreFilePath);
        this.validateCoreFile();
    }

    public CoreFileResolver(File file) {
        this.coreFile = file;
        this.validateCoreFile();
    }

    public CoreFileResolver(ImageInputStream stream) {
        this.coreFile = null;
        this.stream = stream;
        this.validateContents();
    }

    private void validateCoreFile() {
        if (this.coreFile.exists()) {
            try {
                if (this.stream == null) {
                    this.stream = new FileImageInputStream(this.coreFile);
                }
                this.validateContents();
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The core file specified at " + this.coreFile.getAbsolutePath() + " does not exist");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not validate core file " + this.coreFile.getAbsolutePath(), e);
                return;
            }
        } else {
            throw new IllegalArgumentException("The core file specified at " + this.coreFile.getAbsolutePath() + " does not exist");
        }
    }

    private void validateContents() {
        this.validFile = this.isValidFile();
        if (!this.validFile) {
            try {
                if (this.coreFile != null) {
                    this.stream.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close core file", e);
                return;
            }
        }
    }

    public void extractLibrariesToDir(String path) throws IOException {
        File dir = new File(path);
        if (!dir.exists()) {
            throw new IllegalArgumentException("");
        }
        for (FooterLibraryEntry entry : this.footer.getEntries()) {
            File library = new File(dir, entry.getName());
            this.extractLibrary(entry.getPath(), library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractLibrary(String libraryName, File path) throws IOException {
        FooterLibraryEntry entry = this.footer.findEntry(libraryName);
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(path);
            byte[] buffer = new byte[4096];
            in = new SlidingFileInputStream(this.coreFile, entry.getStart(), (long)entry.getSize());
            int bytesRead = in.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public boolean hasLibraries() {
        return this.validFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFooter() throws IOException {
        ByteOrder bo = this.stream.getByteOrder();
        try {
            this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            long streamLength = this.stream.length();
            this.stream.seek(streamLength - 8L);
            int length = this.stream.readInt();
            SlidingFileInputStream in = new SlidingFileInputStream(this.stream, streamLength - (long)length - 8L, (long)length);
            ObjectInputStream objin = new ObjectInputStream(in);
            try {
                this.footer = (Footer)objin.readObject();
                logger.fine(this.footer.toString());
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, "Could find footer class", e);
            }
            objin.close();
        }
        finally {
            this.stream.setByteOrder(bo);
        }
    }

    private boolean isValidFile() {
        try {
            byte[] check = new byte[FOOTER_MAGIC_BYTES.length];
            this.stream.seek(this.stream.length() - (long)check.length);
            this.stream.readFully(check);
            for (int i = 0; i < check.length; ++i) {
                if (check[i] == FOOTER_MAGIC_BYTES[i]) continue;
                return false;
            }
            this.readFooter();
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not check core file library validity", e);
            return false;
        }
    }

    @Override
    public LibraryDataSource getLibrary(String fileName, boolean silent) throws FileNotFoundException {
        LibraryDataSource source;
        if (!this.validFile) {
            throw new FileNotFoundException("Cannot find " + fileName + " as the required libraries are missing from the core file");
        }
        FooterLibraryEntry entry = this.footer.findEntry(fileName);
        if (entry == null) {
            if (!silent) {
                logger.fine(String.format("Cannot find %s", fileName));
            }
            throw new FileNotFoundException("Cannot find " + fileName);
        }
        try {
            SlidingImageInputStream in = new SlidingImageInputStream(this.stream, entry.getStart(), (long)entry.getSize());
            source = new LibraryDataSource(fileName, in);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error setting sliding input window", e);
            source = new LibraryDataSource(fileName);
        }
        return source;
    }

    @Override
    public LibraryDataSource getLibrary(String fileName) throws FileNotFoundException {
        if (!this.validFile) {
            throw new FileNotFoundException("Cannot find " + fileName + " as the required libraries are missing from the core file");
        }
        return this.getLibrary(fileName, true);
    }

    @Override
    public void dispose() {
        try {
            if (this.validFile) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to dispose of underlying file stream", e);
        }
    }
}

