/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import java.math.BigInteger;
import org.apache.xerces.util.DatatypeMessageFormatter;

class DateTimeUtil {
    static final int indexOf(String string, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static final int parseInt(String string, int n, int n2) throws IllegalArgumentException, UnsupportedOperationException {
        int n3 = 10;
        int n4 = 0;
        int n5 = 0;
        int n6 = -2147483647;
        int n7 = n6 / n3;
        int n8 = n;
        do {
            if ((n5 = DateTimeUtil.getDigit(string.charAt(n8))) < 0) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "WrongFormat", new Object[]{string}));
            }
            if (n4 < n7) {
                throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "OverflowProblem", new Object[]{string}));
            }
            if ((n4 *= n3) < n6 + n5) {
                throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "OverflowProblem", new Object[]{string}));
            }
            n4 -= n5;
        } while (++n8 < n2);
        return -n4;
    }

    private static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final int getDigit(char c) {
        return DateTimeUtil.isDigit(c) ? c - 48 : -1;
    }

    static final int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (DateTimeUtil.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    static int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    private static final BigInteger fQuotient(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger2);
    }

    private static final BigInteger mod(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.subtract(bigInteger3.multiply(bigInteger2));
    }

    static final int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    static final int modulo(int n, int n2, int n3) {
        int n4 = n - n2;
        int n5 = n3 - n2;
        return DateTimeUtil.mod(n4, n5, DateTimeUtil.fQuotient(n4, n5)) + n2;
    }

    static final int fQuotient(int n, int n2, int n3) {
        return DateTimeUtil.fQuotient(n - n2, n3 - n2);
    }

    static final BigInteger modulo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        BigInteger bigInteger5 = bigInteger3.subtract(bigInteger2);
        return DateTimeUtil.mod(bigInteger4, bigInteger5, DateTimeUtil.fQuotient(bigInteger4, bigInteger5)).add(bigInteger2);
    }

    static final BigInteger fQuotient(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return DateTimeUtil.fQuotient(bigInteger.subtract(bigInteger2), bigInteger3.subtract(bigInteger2));
    }

    static final String stripTrailingZeros(String string) {
        int n;
        char c;
        int n2;
        for (n2 = n = string.length() - 1; n2 >= 0 && (c = string.charAt(n2)) == '0'; --n2) {
        }
        if (n == n2) {
            return string;
        }
        return string.substring(0, n2 + 1);
    }

    private DateTimeUtil() {
    }
}

