/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ext.DBCSDecoderMapping;
import sun.nio.cs.ext.ExtendedCharsets;

public abstract class DBCS_IBM_EBCDIC_Decoder
extends CharsetDecoder
implements ArrayDecoder {
    private DBCSDecoderMapping decoderMapping;
    protected static final char REPLACE_CHAR = '\ufffd';
    protected String singleByteToChar;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    protected int shift;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final int SO = 14;
    private static final int SI = 15;
    private int currentState;
    private int convertType = 0;
    protected String indexSurrogate = "";
    protected String indexSurrogate2 = "";
    protected int bytePairLead = 0;
    protected int[] pairsArray = null;
    protected String bytePairs = "";
    private boolean fastSBCS = false;
    private char[] singleByte = null;
    private static final char kSentinalValue = '\uffff';
    private int charOff;
    private int byteOff;
    private static final int MALFORMED_CHAR = 65534;
    private static final int INVALID_SHIFT = 65532;
    private static final int END_INPUT = 65535;
    private boolean sentinalsAdded = false;
    private char originalSI = '\u0000';
    private char originalSO = '\u0000';
    protected char[] charMap;
    private int badInputLength;
    public static final float MIX_AVERAGE_CHARS_PER_BYTE = 1.0f;
    public static final float MIX_MAX_CHARS_PER_BYTE = 1.0f;
    public static final float SBCS_AVERAGE_CHARS_PER_BYTE = 1.0f;
    public static final float SBCS_MAX_CHARS_PER_BYTE = 1.0f;
    public static final float DBCS_AVERAGE_CHARS_PER_BYTE = 0.5f;
    public static final float DBCS_MAX_CHARS_PER_BYTE = 1.0f;
    static final float[] AVERAGE_CHARS_PER_BYTES = new float[]{1.0f, 1.0f, 0.5f};
    static final float[] MAX_CHARS_PER_BYTES = new float[]{1.0f, 1.0f, 1.0f};
    protected static final int NEW_LINE_INDEX = 21;
    protected static final char SWAPPED_NEW_LINE_CHAR = '\u0085';

    public int getBytePairLead() {
        return this.bytePairLead;
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset, String string, String string2, String string3, int n, int n2, float f, float f2) {
        super(charset, f, f2);
        this.singleByteToChar = this.handleIBMSwapLF(string3);
        this.index2 = string;
        this.index2a = string2;
        this.shift = n;
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset, short[] sArray, String string, String string2, String string3, int n, int n2, float f, float f2) {
        super(charset, f, f2);
        this.singleByteToChar = this.handleIBMSwapLF(string3);
        this.index1 = sArray;
        this.index2 = string;
        this.index2a = string2;
        this.shift = n;
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
        this.singleByte = this.singleByteToChar.toCharArray();
        this.setSBCS();
        this.fastSBCS = false;
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset, short[] sArray, String string, String string2, String string3, char[] cArray, int n, int n2, float f, float f2) {
        super(charset, f, f2);
        this.singleByteToChar = this.handleIBMSwapLF(string3);
        this.index1 = sArray;
        this.index2 = string;
        this.index2a = string2;
        this.charMap = cArray;
        this.shift = n;
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
        this.singleByte = this.singleByteToChar.toCharArray();
        this.setSBCS();
        this.fastSBCS = false;
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset, String string, String string2, String string3, int n, int n2, int n3) {
        this(charset, string, string2, string3, n, n2, AVERAGE_CHARS_PER_BYTES[n3 > 2 ? 0 : n3], MAX_CHARS_PER_BYTES[n3 > 2 ? 0 : n3]);
        this.setType(n3);
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset, short[] sArray, String string, String string2, String string3, int n, int n2, int n3) {
        this(charset, sArray, string, string2, string3, n, n2, AVERAGE_CHARS_PER_BYTES[n3 > 2 ? 0 : n3], MAX_CHARS_PER_BYTES[n3 > 2 ? 0 : n3]);
        this.setType(n3);
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
        this.charMap = null;
    }

    @Override
    protected void implReset() {
        this.byteOff = 0;
        this.charOff = 0;
        if (this.singleByte == null && this.singleByteToChar.length() == 256) {
            this.singleByte = this.singleByteToChar.toCharArray();
        }
        if (this.convertType == 0) {
            this.setSBCS();
        }
    }

    protected void setType(int n) {
        this.convertType = n;
        this.currentState = n == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        n = n <= n2 ? n : n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            int n5;
            int n6 = n2 - n;
            this.charOff = n3;
            if (this.fastSBCS && n3 + (n2 - n) <= n4) {
                char c;
                for (n5 = 0; n5 < n6 && (c = this.singleByte[byArray[n5 + n] & 0xFF]) != '\uffff'; ++n5) {
                    cArray[n3 + n5] = c;
                }
                this.charOff = n3 + n5;
            }
            this.byteOff = n5 + n;
            if (n5 + n != n2) {
                CoderResult coderResult = this.convertSlow(byArray, n2, cArray, n4);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(this.byteOff);
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
        }
    }

    private CoderResult convertSlow(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 65533;
        int n8 = 65533;
        boolean bl = false;
        if (0 != this.convertType && this.sentinalsAdded) {
            this.sentinalsAdded = false;
            for (n6 = 0; n6 < this.singleByte.length; ++n6) {
                if (this.singleByte[n6] != '\uffff') continue;
                this.singleByte[n6] = 65533;
            }
            this.singleByte[14] = this.originalSO;
            this.singleByte[15] = this.originalSI;
        }
        this.charMap[14] = this.originalSO;
        this.charMap[15] = this.originalSI;
        if (this.convertType != 0) {
            if (this.convertType == 1) {
                return this.convertType1(byArray, n, cArray, n2);
            }
            return this.convertType2(byArray, n, cArray, n2);
        }
        n6 = 0;
        int n9 = 0;
        int n10 = 65533;
        int n11 = this.charOff;
        int n12 = this.byteOff;
        int n13 = n;
        int n14 = n2;
        int n15 = this.currentState;
        char[] cArray2 = this.charMap;
        cArray2[15] = 65532;
        cArray2[14] = 65532;
        int n16 = n14 - n11;
        int n17 = n13 - n12 - 1;
        int n18 = n5 = n16 < n17 ? n12 + n16 : n13 - 1;
        while (n12 < n5) {
            n6 = byArray[n12++] & 0xFF;
            if (n15 == 0) {
                while (n6 != 14) {
                    n10 = cArray2[n6];
                    if (n10 < 65532) {
                        cArray[n11++] = n10;
                    } else {
                        if (n10 == 65533) {
                            return this.throwUnknownCharacterException(n11, n12 - 1, n15, 1);
                        }
                        if (n10 == 65534) {
                            return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                        }
                        if (n10 == 65532) {
                            return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                        }
                    }
                    if (n12 >= n5) break;
                    n6 = byArray[n12++] & 0xFF;
                }
                if (n6 != 14) continue;
                n15 = 1;
                continue;
            }
            while (n6 != 15) {
                if (14 == n6) {
                    return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                }
                n9 = byArray[n12++] & 0xFF;
                if (!(n6 >= 65 && n6 <= 254 && n9 >= 65 && n9 <= 254 || n6 == 64 && n9 == 64)) {
                    return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                }
                n9 = n6 << 8 | n9;
                n10 = cArray2[n9];
                if (n10 < 65532) {
                    if (n10 >= 55296 && n10 <= 56319) {
                        n7 = this.getSurrogatePair(n9);
                        if (n7 == 65533) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                        }
                        if (n11 + 1 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                        }
                        cArray[n11++] = n10;
                        cArray[n11++] = n7;
                    } else {
                        cArray[n11++] = n10;
                    }
                } else {
                    if (n6 == this.bytePairLead && null != this.bytePairs) {
                        for (n4 = 0; n4 < this.bytePairs.length(); ++n4) {
                            if (this.bytePairs.charAt(n4) != n9) continue;
                            n3 = this.pairsArray[n4];
                            if (n11 + 1 >= n14) {
                                return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                            }
                            cArray[n11++] = (char)(n3 >> 16 & 0xFFFF);
                            cArray[n11++] = (char)(n3 & 0xFFFF);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        if (n10 == 65533) {
                            return this.throwUnknownCharacterException(n11, n12 - 2, n15, 2);
                        }
                        if (n10 == 65534) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                        }
                        if (n10 == 65532) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 1);
                        }
                    } else {
                        bl = false;
                    }
                }
                if (n12 >= n5) break;
                n6 = byArray[n12++] & 0xFF;
            }
            if (n6 != 15) continue;
            n15 = 0;
        }
        block5: while (n12 < n13) {
            n6 = byArray[n12++] & 0xFF;
            if (n15 == 0) {
                while (n6 != 14 && n6 != 15) {
                    n10 = cArray2[n6];
                    if (n10 < 65532) {
                        if (n11 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 1, n15);
                        }
                        cArray[n11++] = n10;
                    } else {
                        if (n10 == 65533) {
                            return this.throwUnknownCharacterException(n11, n12 - 1, n15, 1);
                        }
                        if (n10 == 65534) {
                            return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                        }
                        if (n10 == 65532) {
                            return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                        }
                    }
                    if (n12 >= n13) break block5;
                    n6 = byArray[n12++] & 0xFF;
                }
                if (n6 == 14) {
                    n15 = 1;
                    continue;
                }
                return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
            }
            while (n6 != 15) {
                if (n12 >= n13) {
                    if (n6 == 14) {
                        return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                    }
                    --n12;
                    break block5;
                }
                if (14 == n6) {
                    return this.throwMalformedInputException(n11, n12 - 1, n15, 1);
                }
                n9 = byArray[n12++] & 0xFF;
                if (!(n6 >= 65 && n6 <= 254 && n9 >= 65 && n9 <= 254 || n6 == 64 && n9 == 64)) {
                    return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                }
                n9 = n6 << 8 | n9;
                n10 = cArray2[n9];
                if (n10 < 65532) {
                    if (n10 >= 55296 && n10 <= 56319) {
                        n7 = this.getSurrogatePair(n9);
                        if (n7 == 65533) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                        }
                        if (n11 + 1 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                        }
                        cArray[n11++] = n10;
                        cArray[n11++] = n7;
                    } else {
                        if (n11 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                        }
                        cArray[n11++] = n10;
                    }
                } else {
                    if (n6 == this.bytePairLead && null != this.bytePairs) {
                        for (n4 = 0; n4 < this.bytePairs.length(); ++n4) {
                            if (this.bytePairs.charAt(n4) != n9) continue;
                            n3 = this.pairsArray[n4];
                            if (n11 + 1 >= n14) {
                                return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                            }
                            cArray[n11++] = (char)(n3 >> 16 & 0xFFFF);
                            cArray[n11++] = (char)(n3 & 0xFFFF);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        if (n10 == 65533) {
                            return this.throwUnknownCharacterException(n11, n12 - 2, n15, 2);
                        }
                        if (n10 == 65534) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 2);
                        }
                        if (n10 == 65532) {
                            return this.throwMalformedInputException(n11, n12 - 2, n15, 1);
                        }
                    } else {
                        bl = false;
                    }
                }
                if (n12 >= n13) break;
                n6 = byArray[n12++] & 0xFF;
            }
            if (n6 != 15) continue;
            n15 = 0;
        }
        this.charOff = n11;
        this.byteOff = n12;
        this.currentState = n15;
        if (n15 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult convertType1(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4 = 0;
        boolean bl = false;
        int n5 = 65533;
        int n6 = this.charOff;
        int n7 = this.byteOff;
        int n8 = n;
        int n9 = n2;
        int n10 = this.currentState;
        char[] cArray2 = this.charMap;
        int n11 = n9 - n6;
        int n12 = n8 - n7;
        int n13 = n3 = n11 < n12 ? n7 + n11 : n8;
        while (n7 < n3) {
            if ((n5 = cArray2[n4 = byArray[n7++] & 0xFF]) < 65532) {
                cArray[n6++] = n5;
                continue;
            }
            if (n5 == 65533) {
                return this.throwUnknownCharacterException(n6, n7 - 1, n10, 1);
            }
            if (n5 == 65534) {
                return this.throwMalformedInputException(n6, n7 - 1, n10, 1);
            }
            if (n5 != 65532) continue;
            return this.throwMalformedInputException(n6, n7 - 1, n10, 1);
        }
        if (n3 < n8) {
            return this.throwConversionBufferFullException(n6, n7, n10);
        }
        this.charOff = n6;
        this.byteOff = n7;
        return CoderResult.UNDERFLOW;
    }

    private CoderResult convertType2(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 65533;
        int n7 = 65533;
        int n8 = 65533;
        boolean bl = false;
        int n9 = this.charOff;
        int n10 = this.byteOff;
        int n11 = n;
        int n12 = n2;
        int n13 = this.currentState;
        char[] cArray2 = this.charMap;
        int n14 = n12 - n9;
        int n15 = (n11 - n10) / 2;
        int n16 = n3 = n14 < n15 ? n10 + n14 * 2 : n10 + n15 * 2;
        if (0 == n14) {
            return this.throwConversionBufferFullException(n9, n10, n13);
        }
        while (n10 < n3) {
            n4 = byArray[n10++] & 0xFF;
            n5 = byArray[n10++] & 0xFF;
            if (!(n4 >= 65 && n4 <= 254 && n5 >= 65 && n5 <= 254 || n4 == 64 && n5 == 64)) {
                return this.throwMalformedInputException(n9, n10 - 2, n13, 2);
            }
            n5 = n4 << 8 | n5;
            n6 = cArray2[n5];
            if (n6 < 65532) {
                if (n6 >= 55296 && n6 <= 56319) {
                    n7 = this.getSurrogatePair(n5);
                    if (n7 == 65533) {
                        return this.throwMalformedInputException(n9, n10 - 2, n13, 2);
                    }
                    if (n9 + 1 >= n12) {
                        return this.throwConversionBufferFullException(n9, n10 - 2, n13);
                    }
                    cArray[n9++] = n6;
                    cArray[n9++] = n7;
                    continue;
                }
                cArray[n9++] = n6;
                continue;
            }
            if (n4 == this.bytePairLead && null != this.bytePairs) {
                for (int i = 0; i < this.bytePairs.length(); ++i) {
                    if (this.bytePairs.charAt(i) != n5) continue;
                    int n17 = this.pairsArray[i];
                    if (n9 + 1 >= n12) {
                        return this.throwConversionBufferFullException(n9, n10 - 2, n13);
                    }
                    cArray[n9++] = (char)(n17 >> 16 & 0xFFFF);
                    cArray[n9++] = (char)(n17 & 0xFFFF);
                    bl = true;
                }
            }
            if (!bl) {
                if (n6 == 65533) {
                    return this.throwUnknownCharacterException(n9, n10 - 2, n13, 2);
                }
                if (n6 == 65534) {
                    return this.throwMalformedInputException(n9, n10 - 2, n13, 2);
                }
                if (n6 != 65532) continue;
                return this.throwMalformedInputException(n9, n10 - 2, n13, 2);
            }
            bl = false;
        }
        if (n3 < n11 && n10 >= n11) {
            return this.throwConversionBufferFullException(n9, n10, n13);
        }
        this.charOff = n9;
        this.byteOff = n10;
        return CoderResult.UNDERFLOW;
    }

    private CoderResult throwConversionBufferFullException(int n, int n2, int n3) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        return CoderResult.OVERFLOW;
    }

    private CoderResult throwMalformedInputException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        this.badInputLength = n4;
        return CoderResult.malformedForLength(n4);
    }

    private CoderResult throwUnknownCharacterException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    protected void setSBCS() {
        this.currentState = 0;
        boolean bl = this.fastSBCS = this.singleByte != null;
        if (this.singleByte != null && !this.sentinalsAdded) {
            this.sentinalsAdded = true;
            this.originalSO = this.singleByte[14];
            this.originalSI = this.singleByte[15];
            this.singleByte[14] = 65535;
            this.singleByte[15] = 65535;
            for (int i = 0; i < this.singleByte.length; ++i) {
                if (this.singleByte[i] != '\ufffd') continue;
                this.singleByte[i] = 65535;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (this.convertType == 1) {
            return this.decodeBufferLoop_CT1(byteBuffer, charBuffer);
        }
        if (this.convertType == 2) {
            return this.decodeBufferLoop_CT2(byteBuffer, charBuffer);
        }
        int n = byteBuffer.position();
        char c = '\ufffd';
        char c2 = '\ufffd';
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 0;
                int n3 = byteBuffer.get();
                int n4 = 1;
                int n5 = 65533;
                if (n3 < 0) {
                    n3 += 256;
                }
                if (n3 == 14) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                } else if (n3 == 15) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                } else {
                    int n6;
                    if (this.currentState == 0) {
                        n5 = this.singleByteToChar.charAt(n3);
                    } else {
                        if (14 == n3) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n7 = byteBuffer.get();
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        ++n4;
                        if (!(n3 == 64 && n7 == 64 || n3 >= 65 && n3 <= 254 && n7 >= 65 && n7 <= 254)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n2 = n3 * 256 + n7;
                        n6 = (char)this.index1[(n2 & this.mask1) >> this.shift] + (n2 & this.mask2);
                        n5 = this.index2a == null || n6 < 15000 ? this.index2.charAt(n6) : this.index2a.charAt(n6 - 15000);
                        if (n5 >= 55296 && n5 <= 56319) {
                            c = this.getSurrogatePair(n3 * 256 + n7);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(n4);
                                return coderResult;
                            }
                            bl = true;
                        }
                        if (n5 == 0 && n2 != 0) {
                            n5 = 65533;
                        }
                        if (n5 == 65533 && n3 == this.bytePairLead && null != this.bytePairs) {
                            for (int i = 0; i < this.bytePairs.length(); ++i) {
                                if (this.bytePairs.charAt(i) != n3 * 256 + n7) continue;
                                int n8 = this.pairsArray[i];
                                n5 = (char)(n8 >> 16 & 0xFFFF);
                                c2 = (char)(n8 & 0xFFFF);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (n5 == 0 && n2 != 0) {
                        n5 = 65533;
                    }
                    if (n5 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (bl || bl2) {
                        n6 = charBuffer.arrayOffset() + charBuffer.position();
                        if (charBuffer.arrayOffset() + charBuffer.limit() - (n6 + 1) < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                    }
                    charBuffer.put((char)n5);
                    if (bl) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                        bl = false;
                    } else if (bl2) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c2);
                        bl2 = false;
                    }
                }
                n += n4;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop_CT1(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                boolean bl = false;
                int n2 = byteBuffer.get();
                int n3 = 1;
                char c = '\ufffd';
                if (n2 < 0) {
                    n2 += 256;
                }
                if (this.currentState == 0) {
                    if (n2 > 255) {
                        c = '\ufffd';
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                c = this.singleByteToChar.charAt(n2);
                if (c == '\u0000' && bl) {
                    c = '\ufffd';
                }
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(n3);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put(c);
                n += n3;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop_CT2(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        char c = '\ufffd';
        char c2 = '\ufffd';
        boolean bl = false;
        boolean bl2 = false;
        this.currentState = 1;
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 0;
                int n3 = 0;
                int n4 = byteBuffer.get();
                int n5 = 1;
                int n6 = 65533;
                if (n4 < 0) {
                    n4 += 256;
                }
                if (n4 == 14 && this.convertType == 0) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                } else if (n4 == 15 && this.convertType == 0) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                } else {
                    int n7;
                    if (this.currentState == 0) {
                        n6 = this.singleByteToChar.charAt(n4);
                    } else {
                        if (14 == n4) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n2 = byteBuffer.get();
                        if (n2 < 0) {
                            n2 += 256;
                        }
                        ++n5;
                        if (!(n4 == 64 && n2 == 64 || n4 >= 65 && n4 <= 254 && n2 >= 65 && n2 <= 254)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n3 = n4 * 256 + n2;
                        if (null == this.index1) {
                            n6 = this.charMap[n3];
                        } else {
                            n7 = (char)this.index1[(n3 & this.mask1) >> this.shift] + (n3 & this.mask2);
                            n6 = this.index2a == null || n7 < 15000 ? (int)this.index2.charAt(n7) : (int)this.index2a.charAt(n7 - 15000);
                        }
                        if (n6 >= 55296 && n6 <= 56319) {
                            c = this.getSurrogatePair(n4 * 256 + n2);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(n5);
                                return coderResult;
                            }
                            bl = true;
                        }
                        if (n6 == 0 && n3 != 0) {
                            n6 = 65533;
                        }
                        if (n6 == 65533 && n4 == this.bytePairLead && null != this.bytePairs) {
                            for (n7 = 0; n7 < this.bytePairs.length(); ++n7) {
                                if (this.bytePairs.charAt(n7) != n4 * 256 + n2) continue;
                                int n8 = this.pairsArray[n7];
                                n6 = (char)(n8 >> 16 & 0xFFFF);
                                c2 = (char)(n8 & 0xFFFF);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (n6 == 0 && n3 != 0) {
                        n6 = 65533;
                    }
                    if (n6 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (bl || bl2) {
                        n7 = charBuffer.arrayOffset() + charBuffer.position();
                        if (charBuffer.arrayOffset() + charBuffer.limit() - (n7 + 1) < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                    }
                    charBuffer.put((char)n6);
                    if (bl) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                        bl = false;
                    } else if (bl2) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c2);
                        bl2 = false;
                    }
                }
                n += n5;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected char getSurrogatePair(int n) {
        int n2 = (char)this.index1[n >> this.shift] + (n & this.mask2);
        char c = n2 >= 0 ? (this.indexSurrogate2 == null || n2 < 15000 ? this.indexSurrogate.charAt(n2) : this.indexSurrogate2.charAt(n2 - 15000)) : this.indexSurrogate2.charAt((n2 & 0xFFFF) - 15000);
        if (c == '\u0000' && n != 0) {
            return '\ufffd';
        }
        return c;
    }

    public char[] expandCharMap(short[] sArray, String string, String string2, int n, int n2) {
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        char[] cArray = new char[65536];
        for (int n5 = 0; n5 < n4; n5 = (int)((short)(n5 + 1))) {
            int n6 = n5 * n3;
            if (sArray[n5] == n2) continue;
            for (int i = 0; i < n3; ++i) {
                int n7 = (char)sArray[n5] + i;
                cArray[n6++] = n7 < 15000 || string2 == null ? string.charAt(n7) : string2.charAt(n7 - 15000);
            }
        }
        return cArray;
    }

    public static char[] expandCharMap(short[] sArray, String string, String string2, String string3, int n, int n2) {
        int n3;
        int n4;
        int n5 = 1 << n;
        int n6 = 65536 / n5;
        char[] cArray = new char[65536];
        for (n4 = 0; n4 < n6; n4 = (int)((short)(n4 + 1))) {
            int n7 = n4 * n5;
            if (sArray[n4] == n2) continue;
            for (n3 = 0; n3 < n5; ++n3) {
                int n8 = (char)sArray[n4] + n3;
                cArray[n7++] = n8 < 15000 || string2 == null ? string.charAt(n8) : string2.charAt(n8 - 15000);
            }
        }
        for (n4 = 0; n4 < 256; n4 = (int)((short)(n4 + 1))) {
            cArray[n4] = string3.charAt(n4);
        }
        cArray[255] = 159;
        for (n3 = 256; n3 < 65536; ++n3) {
            if (cArray[n3] != '\u0000') continue;
            cArray[n3] = 65533;
        }
        return cArray;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return ExtendedCharsets.isSwapLF();
    }

    @Override
    public int decode(byte[] byArray, int n, int n2, char[] cArray) {
        if (0 == this.convertType && null != this.charMap) {
            return this.decode_CT0(byArray, n, n2, cArray);
        }
        if (1 == this.convertType) {
            return this.decode_CT1(byArray, n, n2, cArray);
        }
        if (2 == this.convertType && null != this.charMap) {
            return this.decode_CT2(byArray, n, n2, cArray);
        }
        this.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            while (true) {
                CoderResult coderResult;
                try {
                    coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    throw new CoderMalfunctionError(bufferUnderflowException);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    throw new CoderMalfunctionError(bufferOverflowException);
                }
                if (coderResult.isOverflow()) {
                    throw new BufferOverflowException();
                }
                if (coderResult.isUnderflow()) {
                    if (byteBuffer.hasRemaining()) {
                        coderResult = CoderResult.malformedForLength(byteBuffer.remaining());
                    }
                    break;
                }
                if (charBuffer.remaining() < 1) {
                    throw new BufferOverflowException();
                }
                charBuffer.put(new char[]{'\ufffd'});
                byteBuffer.position(byteBuffer.position() + coderResult.length());
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new Error(bufferOverflowException);
        }
        return charBuffer.position();
    }

    public int decode_CT0(byte[] byArray, int n, int n2, char[] cArray) {
        int n3;
        int n4 = 0;
        int n5 = n + n2;
        this.currentState = 0;
        char c = this.replacement().charAt(0);
        while (n < n5 && (n3 = this.singleByte[byArray[n] & 0xFF]) != 65535) {
            cArray[n4++] = n3;
            ++n;
        }
        while (n < n5) {
            int n6;
            block20: {
                int n7;
                block19: {
                    if ((n3 = byArray[n++] & 0xFF) == 14) {
                        if (this.currentState != 0) {
                            cArray[n4++] = c;
                            continue;
                        }
                        this.currentState = 1;
                        continue;
                    }
                    if (n3 == 15) {
                        if (this.currentState != 1) {
                            cArray[n4++] = c;
                            continue;
                        }
                        this.currentState = 0;
                        continue;
                    }
                    n6 = 65533;
                    n7 = 0;
                    if (this.currentState != 0) break block19;
                    n6 = this.singleByteToChar.charAt(n3);
                    if (n6 != 65533) break block20;
                    n6 = c;
                    break block20;
                }
                if (n5 == n) {
                    n6 = c;
                } else {
                    int n8;
                    int n9 = byArray[n++] & 0xFF;
                    n7 = n3 * 256 + n9;
                    if (0 == n3) {
                        n6 = c;
                    } else if (n9 < 64 || n9 > 254 || (n6 = this.charMap[n7]) == 65533) {
                        n6 = c;
                    }
                    if (n6 >= 55296 && n6 <= 56319) {
                        n8 = this.getSurrogatePair(n7);
                        if (n8 == 65533) {
                            n6 = 65533;
                        } else {
                            cArray[n4++] = n6;
                            n6 = (char)n8;
                        }
                    } else if (n6 == 0 && n7 != 0) {
                        n6 = 65533;
                    } else if (n6 == 65533 && n3 == this.bytePairLead && null != this.bytePairs) {
                        for (n8 = 0; n8 < this.bytePairs.length(); ++n8) {
                            if (this.bytePairs.charAt(n8) != n7) continue;
                            int n10 = this.pairsArray[n8];
                            cArray[n4++] = (char)(n10 >> 16 & 0xFFFF);
                            n6 = (char)(n10 & 0xFFFF);
                            break;
                        }
                    }
                }
            }
            cArray[n4++] = n6;
        }
        return n4;
    }

    public int decode_CT1(byte[] byArray, int n, int n2, char[] cArray) {
        int n3;
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        char c = this.replacement().charAt(0);
        for (n3 = 0; n3 < n2; ++n3) {
            int n4;
            char c2;
            if ((c2 = this.singleByteToChar.charAt(n4 = byArray[n++] & 0xFF)) == '\u0000' && n4 != 0) {
                c2 = c;
            }
            cArray[n3] = c2;
        }
        return n3;
    }

    public int decode_CT2(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = 0;
        int n4 = n + n2;
        char c = this.replacement().charAt(0);
        while (n < n4) {
            int n5 = byArray[n++] & 0xFF;
            int n6 = 65533;
            if (n4 == n) {
                n6 = c;
            } else {
                int n7;
                int n8 = 0;
                int n9 = byArray[n++] & 0xFF;
                n8 = n5 * 256 + n9;
                if (n5 < 64 || n5 > 254 || (n6 = this.charMap[n8]) == 65533) {
                    n6 = c;
                }
                if (n6 >= 55296 && n6 <= 56319) {
                    n7 = this.getSurrogatePair(n8);
                    if (n7 == 65533) {
                        n6 = 65533;
                    } else {
                        cArray[n3++] = n6;
                        n6 = (char)n7;
                    }
                } else if (n6 == 0 && n8 != 0) {
                    n6 = 65533;
                } else if (n6 == 65533 && n5 == this.bytePairLead && null != this.bytePairs) {
                    for (n7 = 0; n7 < this.bytePairs.length(); ++n7) {
                        if (this.bytePairs.charAt(n7) != n8) continue;
                        int n10 = this.pairsArray[n7];
                        cArray[n3++] = (char)(n10 >> 16 & 0xFFFF);
                        n6 = (char)(n10 & 0xFFFF);
                        break;
                    }
                }
            }
            cArray[n3++] = n6;
        }
        return n3;
    }
}

