/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

public class Scrollbar
extends Component
implements Adjustable,
Accessible {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int maximum;
    int minimum;
    int visibleAmount;
    int orientation;
    int lineIncrement = 1;
    int pageIncrement = 10;
    transient boolean isAdjusting;
    transient AdjustmentListener adjustmentListener;
    private static final String base = "scrollbar";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 8451667562882310543L;
    private int scrollbarSerializedDataVersion = 1;

    private static native void initIDs();

    public Scrollbar() throws HeadlessException {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int n) throws HeadlessException {
        this(n, 0, 10, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar orientation");
            }
        }
        this.setValues(n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Scrollbar> clazz = Scrollbar.class;
        synchronized (Scrollbar.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollbar(this);
            }
            super.addNotify();
        }
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n == this.orientation) {
                return;
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.orientation = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal scrollbar orientation");
                }
            }
            if (this.peer != null) {
                this.removeNotify();
                this.addNotify();
                this.invalidate();
            }
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n == 1 ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int n) {
        this.setValues(n, this.visibleAmount, this.minimum, this.maximum);
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int n) {
        this.setValues(this.value, this.visibleAmount, n, this.maximum);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int n) {
        if (n == Integer.MIN_VALUE) {
            n = -2147483647;
        }
        if (this.minimum >= n) {
            this.minimum = n - 1;
        }
        this.setValues(this.value, this.visibleAmount, this.minimum, n);
    }

    @Override
    public int getVisibleAmount() {
        return this.getVisible();
    }

    @Deprecated
    public int getVisible() {
        return this.visibleAmount;
    }

    @Override
    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    @Override
    public void setUnitIncrement(int n) {
        this.setLineIncrement(n);
    }

    @Deprecated
    public synchronized void setLineIncrement(int n) {
        int n2;
        int n3 = n2 = n < 1 ? 1 : n;
        if (this.lineIncrement == n2) {
            return;
        }
        this.lineIncrement = n2;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setLineIncrement(this.lineIncrement);
        }
    }

    @Override
    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    @Deprecated
    public int getLineIncrement() {
        return this.lineIncrement;
    }

    @Override
    public void setBlockIncrement(int n) {
        this.setPageIncrement(n);
    }

    @Deprecated
    public synchronized void setPageIncrement(int n) {
        int n2;
        int n3 = n2 = n < 1 ? 1 : n;
        if (this.pageIncrement == n2) {
            return;
        }
        this.pageIncrement = n2;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setPageIncrement(this.pageIncrement);
        }
    }

    @Override
    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    @Deprecated
    public int getPageIncrement() {
        return this.pageIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, int n3, int n4) {
        int n5;
        Scrollbar scrollbar = this;
        synchronized (scrollbar) {
            long l;
            if (n3 == Integer.MAX_VALUE) {
                n3 = 0x7FFFFFFE;
            }
            if (n4 <= n3) {
                n4 = n3 + 1;
            }
            if ((l = (long)n4 - (long)n3) > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
                n4 = n3 + (int)l;
            }
            if (n2 > (int)l) {
                n2 = (int)l;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            if (n < n3) {
                n = n3;
            }
            if (n > n4 - n2) {
                n = n4 - n2;
            }
            n5 = this.value;
            this.value = n;
            this.visibleAmount = n2;
            this.minimum = n3;
            this.maximum = n4;
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            if (scrollbarPeer != null) {
                scrollbarPeer.setValues(n, this.visibleAmount, n3, n4);
            }
        }
        if (n5 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n5, n);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueIsAdjusting(boolean bl) {
        boolean bl2;
        Scrollbar scrollbar = this;
        synchronized (scrollbar) {
            bl2 = this.isAdjusting;
            this.isAdjusting = bl;
        }
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public synchronized AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.getListeners(AdjustmentListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        AdjustmentListener adjustmentListener = null;
        if (clazz != AdjustmentListener.class) {
            return super.getListeners(clazz);
        }
        adjustmentListener = this.adjustmentListener;
        return AWTEventMulticaster.getListeners((EventListener)adjustmentListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 601) {
            return (this.eventMask & 0x100L) != 0L || this.adjustmentListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        AdjustmentListener adjustmentListener = this.adjustmentListener;
        if (adjustmentListener != null) {
            adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",val=" + this.value + ",vis=" + this.visibleAmount + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz") + ",isAdjusting=" + this.isAdjusting;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "adjustmentL", this.adjustmentListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("adjustmentL" == string) {
                this.addAdjustmentListener((AdjustmentListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollBar();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Scrollbar.initIDs();
        }
    }

    protected class AccessibleAWTScrollBar
    extends Component.AccessibleAWTComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -344337268523697807L;

        protected AccessibleAWTScrollBar() {
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Scrollbar.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (Scrollbar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return Scrollbar.this.getValue();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                Scrollbar.this.setValue(number.intValue());
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return Scrollbar.this.getMinimum();
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return Scrollbar.this.getMaximum();
        }
    }
}

