/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.TLGlobals;
import com.sun.java.util.jar.pack.UnpackerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import sun.util.logging.PlatformLogger;

class Utils {
    static final String COM_PREFIX = "com.sun.java.util.jar.pack.";
    static final String METAINF = "META-INF";
    static final String DEBUG_VERBOSE = "com.sun.java.util.jar.pack.verbose";
    static final String DEBUG_DISABLE_NATIVE = "com.sun.java.util.jar.pack.disable.native";
    static final String PACK_DEFAULT_TIMEZONE = "com.sun.java.util.jar.pack.default.timezone";
    static final String UNPACK_MODIFICATION_TIME = "com.sun.java.util.jar.pack.unpack.modification.time";
    static final String UNPACK_STRIP_DEBUG = "com.sun.java.util.jar.pack.unpack.strip.debug";
    static final String UNPACK_REMOVE_PACKFILE = "com.sun.java.util.jar.pack.unpack.remove.packfile";
    static final String NOW = "now";
    static final String PACK_KEEP_CLASS_ORDER = "com.sun.java.util.jar.pack.keep.class.order";
    static final String PACK_ZIP_ARCHIVE_MARKER_COMMENT = "PACK200";
    static final String CLASS_FORMAT_ERROR = "com.sun.java.util.jar.pack.class.format.error";
    static final ThreadLocal<TLGlobals> currentInstance = new ThreadLocal();
    private static TimeZone tz;
    private static int workingPackerCount;
    static final boolean nolog;
    static final boolean SORT_MEMBERS_DESCR_MAJOR;
    static final boolean SORT_HANDLES_KIND_MAJOR;
    static final boolean SORT_INDY_BSS_MAJOR;
    static final boolean SORT_BSS_BSM_MAJOR;
    static final Pack200Logger log;

    static TLGlobals getTLGlobals() {
        return currentInstance.get();
    }

    static PropMap currentPropMap() {
        TLGlobals tLGlobals = currentInstance.get();
        if (tLGlobals instanceof PackerImpl) {
            return ((PackerImpl)tLGlobals).props;
        }
        if (tLGlobals instanceof UnpackerImpl) {
            return ((UnpackerImpl)tLGlobals).props;
        }
        return null;
    }

    static synchronized void changeDefaultTimeZoneToUtc() {
        if (workingPackerCount++ == 0) {
            tz = TimeZone.getDefault();
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        }
    }

    static synchronized void restoreDefaultTimeZone() {
        if (--workingPackerCount == 0) {
            if (tz != null) {
                TimeZone.setDefault(tz);
            }
            tz = null;
        }
    }

    static String getVersionString() {
        return "Pack200, Vendor: " + System.getProperty("java.vendor") + ", Version: " + Constants.MAX_PACKAGE_VERSION;
    }

    static void markJarFile(JarOutputStream jarOutputStream) throws IOException {
        jarOutputStream.setComment(PACK_ZIP_ARCHIVE_MARKER_COMMENT);
    }

    static void copyJarFile(JarInputStream jarInputStream, JarOutputStream jarOutputStream) throws IOException {
        JarEntry jarEntry;
        Object object;
        if (jarInputStream.getManifest() != null) {
            object = new ZipEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry((ZipEntry)object);
            jarInputStream.getManifest().write(jarOutputStream);
            jarOutputStream.closeEntry();
        }
        object = new byte[16384];
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            int n;
            jarOutputStream.putNextEntry(jarEntry);
            while (0 < (n = jarInputStream.read((byte[])object))) {
                jarOutputStream.write((byte[])object, 0, n);
            }
        }
        jarInputStream.close();
        Utils.markJarFile(jarOutputStream);
    }

    static void copyJarFile(JarFile jarFile, JarOutputStream jarOutputStream) throws IOException {
        byte[] byArray = new byte[16384];
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            int n;
            JarEntry jarEntry2 = new JarEntry(jarEntry.getName());
            jarOutputStream.putNextEntry(jarEntry2);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            while (0 < (n = inputStream.read(byArray))) {
                jarOutputStream.write(byArray, 0, n);
            }
        }
        jarFile.close();
        Utils.markJarFile(jarOutputStream);
    }

    static void copyJarFile(JarInputStream jarInputStream, OutputStream outputStream) throws IOException {
        outputStream = new BufferedOutputStream(outputStream);
        outputStream = new NonCloser(outputStream);
        try (JarOutputStream jarOutputStream = new JarOutputStream(outputStream);){
            Utils.copyJarFile(jarInputStream, jarOutputStream);
        }
    }

    static void copyJarFile(JarFile jarFile, OutputStream outputStream) throws IOException {
        outputStream = new BufferedOutputStream(outputStream);
        outputStream = new NonCloser(outputStream);
        try (JarOutputStream jarOutputStream = new JarOutputStream(outputStream);){
            Utils.copyJarFile(jarFile, jarOutputStream);
        }
    }

    static String getJarEntryName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(File.separatorChar, '/');
    }

    static String zeString(ZipEntry zipEntry) {
        int n = zipEntry.getCompressedSize() > 0L ? (int)((1.0 - (double)zipEntry.getCompressedSize() / (double)zipEntry.getSize()) * 100.0) : 0;
        return zipEntry.getSize() + "\t" + zipEntry.getMethod() + "\t" + zipEntry.getCompressedSize() + "\t" + n + "%\t" + new Date(zipEntry.getTime()) + "\t" + Long.toHexString(zipEntry.getCrc()) + "\t" + zipEntry.getName();
    }

    static byte[] readMagic(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(4);
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length && 1 == bufferedInputStream.read(byArray, i, 1); ++i) {
        }
        bufferedInputStream.reset();
        return byArray;
    }

    static boolean isJarMagic(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 75 && byArray[2] >= 1 && byArray[2] < 8 && byArray[3] == byArray[2] + 1;
    }

    static boolean isPackMagic(byte[] byArray) {
        return byArray[0] == -54 && byArray[1] == -2 && byArray[2] == -48 && byArray[3] == 13;
    }

    static boolean isGZIPMagic(byte[] byArray) {
        return byArray[0] == 31 && byArray[1] == -117 && byArray[2] == 8;
    }

    private Utils() {
    }

    static {
        workingPackerCount = 0;
        nolog = Boolean.getBoolean("com.sun.java.util.jar.pack.nolog");
        SORT_MEMBERS_DESCR_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.members.descr.major");
        SORT_HANDLES_KIND_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.handles.kind.major");
        SORT_INDY_BSS_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.indy.bss.major");
        SORT_BSS_BSM_MAJOR = Boolean.getBoolean("com.sun.java.util.jar.pack.sort.bss.bsm.major");
        log = new Pack200Logger("java.util.jar.Pack200");
    }

    private static class NonCloser
    extends FilterOutputStream {
        NonCloser(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }

    static class Pack200Logger {
        private final String name;
        private PlatformLogger log;

        Pack200Logger(String string) {
            this.name = string;
        }

        private synchronized PlatformLogger getLogger() {
            if (this.log == null) {
                this.log = PlatformLogger.getLogger(this.name);
            }
            return this.log;
        }

        public void warning(String string, Object object) {
            this.getLogger().warning(string, object);
        }

        public void warning(String string) {
            this.warning(string, null);
        }

        public void info(String string) {
            int n = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (n > 0) {
                if (nolog) {
                    System.out.println(string);
                } else {
                    this.getLogger().info(string);
                }
            }
        }

        public void fine(String string) {
            int n = Utils.currentPropMap().getInteger(Utils.DEBUG_VERBOSE);
            if (n > 0) {
                System.out.println(string);
            }
        }
    }
}

