/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$AlgorithmItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Details$DetailIdentifier;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

class SecretKeyItemImpl
extends AbstractEntry
implements SecretKeyItem {
    public static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final int BITS_PER_BYTE = 8;
    private DisplayItemFactory$AlgorithmItem algorithm;
    private SecretKey key;
    private int keySize;

    public SecretKeyItemImpl(String string, SecretKey secretKey) throws KeyManagerException {
        block2: {
            super(string);
            this.key = secretKey;
            this.keySize = secretKey instanceof GeneralPKCS11Key ? ((GeneralPKCS11Key)secretKey).getValueLen() * 8 : secretKey.getEncoded().length * 8;
            try {
                this.algorithm = DisplayItemFactory.getAlgorithmItem(secretKey, this.keySize);
            }
            catch (KeyManagerException keyManagerException) {
                if (keyManagerException.getReason() != KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM) break block2;
                this.algorithm = DisplayItemFactory.getUnsupportedAlgorithmItem(secretKey);
            }
        }
    }

    public void extract(String string, CertificateWriter$OutputMode certificateWriter$OutputMode) throws KeyManagerException {
        throw new RuntimeException("not implemented yet");
    }

    public String getAlgorithm() {
        return this.algorithm.getOID();
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.SecretKeyEntry(this.key);
    }

    public boolean isValid() {
        return true;
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.Algorithm") + ": " + this.algorithm + "\n" + Messages.getString("Label.KeySize") + ": " + this.keySize + "\n";
    }

    public KeymanTree toTree() {
        return null;
    }

    public String get(Details$DetailIdentifier details$DetailIdentifier) throws KeyManagerException {
        switch (details$DetailIdentifier) {
            case KeyAlgorithm: {
                return this.algorithm.toString();
            }
            case SecretKeySize: {
                return this.keySize + "";
            }
        }
        return super.get(details$DetailIdentifier);
    }

    public byte[] encryptKey(PublicKey publicKey, String string) throws KeyManagerException {
        try {
            Cipher cipher = null;
            cipher = KeymanUtil.isIBMJCE() ? Cipher.getInstance(ENCRYPTION_ALGORITHM, string) : Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(3, publicKey);
            return cipher.wrap(this.key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_ENCRYPTION_ERROR, invalidKeyException, new String[]{this.getLabel()});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_ENCRYPTION_ERROR, noSuchPaddingException, new String[]{this.getLabel()});
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_ENCRYPTION_ERROR, illegalBlockSizeException, new String[]{this.getLabel()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{string});
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PKCS11_ERROR, pKCS11Exception, new String[]{this.getLabel(), pKCS11Exception.getMessage()});
        }
    }

    public static SecretKeyItem decryptKey(PrivateKey privateKey, byte[] byArray, String string, String string2, String string3) throws KeyManagerException {
        try {
            Cipher cipher = null;
            cipher = KeymanUtil.isIBMJCE() ? Cipher.getInstance(ENCRYPTION_ALGORITHM, string3) : Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(4, privateKey);
            Key key = cipher.unwrap(byArray, string, 3);
            return new SecretKeyItemImpl(string2, (SecretKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_DECRYPTION_ERROR, invalidKeyException, new String[]{string2});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_DECRYPTION_ERROR, noSuchPaddingException, new String[]{string2});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{string3});
        }
    }
}

