/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.harmony.math.internal.nls.Messages;

public class BigDecimal
extends Number
implements Serializable,
Comparable<BigDecimal> {
    private static final boolean DFP_HW_AVAILABLE = BigDecimal.DFPGetHWAvailable();
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final ThreadLocal thLocalToString = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new char[22];
        }
    };
    private static final long[] powersOfTenLL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final BigInteger[] powersOfTenBI = new BigInteger[]{BigInteger.valueOf(1L), BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final char[] doubleDigitsTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] doubleDigitsOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static byte[] doubleDFPComboField = BigDecimal.comboinit();
    private static short[] DPD2BCD = BigDecimal.dpd2bcdinit();
    private static final long dfpZERO = 2465720795985346560L;
    private static final BigInteger MAXBYTE = BigInteger.valueOf(127L);
    private static final BigInteger MINBYTE = BigInteger.valueOf(-128L);
    private static final BigInteger MAXSHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MINSHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAXINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MININT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAXLONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MINLONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAXDFP64 = BigInteger.valueOf(9999999999999999L);
    private static final BigInteger MINDFP64 = BigInteger.valueOf(-9999999999999999L);
    public static final BigDecimal ZERO = new BigDecimal(0);
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final BigDecimal TEN = new BigDecimal(10);
    private static final BigDecimal FIVE = new BigDecimal(5);
    private static BigDecimal[] CACHE1;
    private static BigDecimal[] CACHE2;
    private static String zeroDec;
    private static final int hys_threshold = 1000;
    private static boolean hys_type;
    private static int hys_counter;
    private static final int SCALE_DIFFERENCE_THRESHOLD = 1000000;
    private BigInteger bi;
    private transient int flags;
    private transient long laside;
    private transient int cachedScale;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean useSmallerScaleBD;

    private BigDecimal() {
        this.flags = 0;
        this.cachedScale = 0;
        this.bi = null;
        this.laside = 0L;
    }

    public BigDecimal(BigInteger bigInteger) {
        this(bigInteger, 0, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this(bigInteger, n, MathContext.UNLIMITED);
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this(bigInteger, 0, mathContext);
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        this.bigIntegerConstructor(bigInteger, n, mathContext);
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] cArray, int n, int n2) {
        this(cArray, n, n2, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        if (n2 <= 0 || n2 > cArray.length || n < 0 || n > cArray.length - 1) {
            this.bad(cArray);
        }
        if (this.needConversion(cArray, n, n2)) {
            cArray = this.converToASCII(cArray, n, n2);
        }
        this.charParser(cArray, n, n2, mathContext, cArray);
    }

    public BigDecimal(double d) {
        this(d, MathContext.UNLIMITED);
    }

    public BigDecimal(double d, MathContext mathContext) {
        long l = Double.doubleToLongBits(d);
        long l2 = (l & Long.MIN_VALUE) >> 63;
        long l3 = (l & 0x7FF0000000000000L) >> 52;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        int n = 0;
        l2 = l2 == 0L ? 1L : -1L;
        if (l3 == 2047L) {
            throw new NumberFormatException(Messages.getString("math.38"));
        }
        if (l3 == 0L) {
            if (l4 == 0L) {
                if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
                    this.DFPConstructZero();
                    return;
                }
                this.laside = 0L;
                this.flags |= 1;
                this.flags |= 0x10;
                this.flags |= 0x80;
                return;
            }
            n = (int)(l3 - 1075L + 1L);
        } else {
            l4 |= 0x10000000000000L;
            n = (int)(l3 - 1075L);
        }
        while ((l4 & 1L) == 0L) {
            l4 >>= 1;
            ++n;
        }
        BigInteger bigInteger = null;
        long l5 = l2 * l4;
        long l6 = 1L;
        if (n < 0 && n > -27) {
            int n2;
            int n3;
            for (int i = n; i < 0; ++i) {
                l6 *= 5L;
            }
            long l7 = l5;
            if (l7 < 0L) {
                l7 *= -1L;
            }
            if ((n3 = Long.numberOfLeadingZeros(l7) - 1) + (n2 = Long.numberOfLeadingZeros(l6) - 1) >= 63) {
                l5 *= l6;
            } else {
                bigInteger = BigInteger.valueOf(l5).multiply(BigInteger.valueOf(l6));
            }
        } else if (n > 0 && n < 63) {
            int n4;
            int n5;
            l6 <<= n;
            long l8 = l5;
            if (l8 < 0L) {
                l8 *= -1L;
            }
            if ((n5 = Long.numberOfLeadingZeros(l8) - 1) + (n4 = Long.numberOfLeadingZeros(l6) - 1) >= 63) {
                l5 *= l6;
            } else {
                bigInteger = BigInteger.valueOf(l5).multiply(BigInteger.valueOf(l6));
            }
            n = 0;
        } else if (n != 0) {
            bigInteger = BigInteger.valueOf(l5);
            if (n < 0) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(5L).pow(-n));
            } else if (n > 0) {
                bigInteger = bigInteger.shiftLeft(n);
                n = 0;
            }
        }
        if (bigInteger == null) {
            this.longConstructor(l5, -n, mathContext);
        } else {
            this.bigIntegerConstructor(bigInteger, -n, mathContext);
        }
    }

    public BigDecimal(int n) {
        this(n, MathContext.UNLIMITED);
    }

    public BigDecimal(int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP() && this.DFPIntConstructorHelper(n, mathContext)) {
            return;
        }
        this.flags |= 1;
        this.laside = n;
        this.flags |= 0x10;
        this.flags |= BigDecimal.numDigits(n) << 7;
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    public BigDecimal(long l) {
        this(l, MathContext.UNLIMITED);
    }

    public BigDecimal(long l, MathContext mathContext) {
        this.longConstructor(l, 0, mathContext);
    }

    public BigDecimal(String string) {
        this(string, MathContext.UNLIMITED);
    }

    public BigDecimal(String string, MathContext mathContext) {
        char[] cArray = string.toCharArray();
        if (this.needConversion(cArray, 0, cArray.length)) {
            cArray = this.converToASCII(cArray, 0, cArray.length);
        }
        this.charParser(cArray, 0, cArray.length, mathContext, string.toCharArray());
    }

    private final char[] converToASCII(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!Character.isDigit(cArray[i])) continue;
            int n3 = Character.digit(cArray[i], 10);
            cArray[i] = (char)(n3 + 48);
        }
        return cArray;
    }

    private final boolean needConversion(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (Character.codePointAt(cArray, i) <= 255) continue;
            return true;
        }
        return false;
    }

    private final void longConstructor(long l, int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            this.DFPLongConstructorHelper(l, n, mathContext);
        } else if (l != Long.MIN_VALUE) {
            this.laside = l;
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(l) << 7;
            this.flags |= 1;
            this.cachedScale = n;
        } else {
            this.flags |= 2;
            this.bi = BigInteger.valueOf(l);
            this.flags |= 0x10;
            this.flags |= 0x980;
            this.cachedScale = n;
        }
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    private final void DFPPerformHysteresis(int n) {
        int n2;
        if ((hys_counter += n & ~((((n2 = hys_counter + n) ^ n) & (n2 ^ hys_counter)) >>> 31)) < -1000) {
            hys_type = false;
            hys_counter = 0;
        } else if (hys_counter > 1000) {
            hys_type = true;
            hys_counter = 0;
        }
    }

    private final void charParser(char[] cArray, int n, int n2, MathContext mathContext, char[] cArray2) {
        int n3;
        int n4;
        int n5;
        int n6 = n2;
        boolean bl = false;
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        char c = '\u0000';
        int n10 = 0;
        char c2 = '\u0000';
        int n11 = 0;
        long l = 0L;
        long l2 = 0L;
        int n12 = 32;
        int n13 = 0;
        int n14 = n;
        int n15 = n2;
        while (n15 > 0) {
            c = cArray[n14];
            if (c >= '0' && c <= '9') {
                n9 = n14;
                l2 <<= 4;
                l2 |= (long)(c & 0xF);
                ++n7;
            } else if (c == '.') {
                if (n8 >= 0) {
                    this.bad(cArray2);
                }
                n8 = n14 - n;
            } else if (c == '-') {
                if (n15 != n6) {
                    this.bad(cArray2);
                }
                n12 = 96;
                ++n;
                --n2;
            } else if (c == '+') {
                if (n15 != n6) {
                    this.bad(cArray2);
                }
                ++n;
                --n2;
            } else {
                if (c == 'e' || c == 'E') {
                    n5 = 0;
                    n4 = 0;
                    boolean bl2 = false;
                    if (n14 - n > n2 - 2) {
                        this.bad(cArray2);
                    }
                    bl2 = false;
                    if (cArray[n14 + 1] == '-') {
                        bl2 = true;
                        n5 = n14 + 2;
                    } else {
                        n5 = cArray[n14 + 1] == '+' ? n14 + 2 : n14 + 1;
                    }
                    n4 = n2 - (n5 - n);
                    if (n4 == 0) {
                        throw new NumberFormatException(Messages.getString("math.1D"));
                    }
                    n3 = n4;
                    n10 = n5;
                    while (n3 > 0 && (c2 = cArray[n10]) == '0') {
                        --n4;
                        --n3;
                        ++n10;
                    }
                    n5 = n10;
                    if (n4 > 10) {
                        throw new NumberFormatException(Messages.getString("math.1D"));
                    }
                    char[] cArray3 = new char[]{'2', '1', '4', '7', '4', '8', '3', '6', '4', '7'};
                    if (n4 == 10) {
                        boolean bl3 = true;
                        for (int i = 0; i < 10 && cArray[n5 + i] >= cArray3[i]; ++i) {
                            if (cArray[n5 + i] <= cArray3[i]) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3) {
                            throw new NumberFormatException(Messages.getString("math.1D", new String[]{Integer.toString(Integer.MAX_VALUE), Integer.toString(-2147483647)}));
                        }
                    }
                    n3 = n4;
                    while (n3 > 0) {
                        c2 = cArray[n10];
                        if (c2 < '0') {
                            this.bad(cArray2);
                        }
                        if (c2 > '9') {
                            if (!Character.isDigit(c2)) {
                                this.bad(cArray2);
                            }
                            if ((n11 = Character.digit(c2, 10)) < 0) {
                                this.bad(cArray2);
                            }
                        } else {
                            n11 = c2 - 48;
                        }
                        n13 = n13 * 10 + n11;
                        --n3;
                        ++n10;
                    }
                    if (!bl2) break;
                    n13 = -n13;
                    break;
                }
                if (!Character.isDigit(c)) {
                    this.bad(cArray2);
                }
                bl = true;
                n9 = n14;
                ++n7;
            }
            --n15;
            ++n14;
        }
        if (n7 == 0) {
            this.bad(cArray2);
        }
        if (n8 >= 0) {
            l = (long)n13 + (long)n8 - (long)n7;
            if (-l < Integer.MIN_VALUE || -l > Integer.MAX_VALUE) {
                throw new NumberFormatException(Messages.getString("math.1F", Long.toString(-l)));
            }
            n13 = n13 + n8 - n7;
        }
        n15 = n9 - 1;
        for (n14 = n; n14 <= n15; ++n14) {
            c = cArray[n14];
            if (c == '0') {
                ++n;
                --n8;
                --n7;
                continue;
            }
            if (c == '.') {
                ++n;
                --n8;
                continue;
            }
            if (c <= '9' || Character.digit(c, 10) != 0) break;
            ++n;
            --n8;
            --n7;
        }
        n5 = 1;
        int n16 = n4 = n7 < 17 && n13 >= -398 && n13 < 369 ? 1 : 0;
        if (BigDecimal.DFPHWAvailable() && n4 != 0) {
            if (BigDecimal.DFPPerformHysteresis()) {
                this.DFPPerformHysteresis(10);
            }
            if (BigDecimal.DFPUseDFP()) {
                if (this.DFPCharConstructorHelper(l2, n13, n12, n7, mathContext)) {
                    return;
                }
                n5 = 0;
            }
        }
        char[] cArray4 = new char[n7];
        n10 = n;
        if (bl) {
            n14 = 0;
            n3 = n7;
            while (n3 > 0) {
                if (n14 == n8) {
                    ++n10;
                }
                if ((c2 = cArray[n10]) <= '9') {
                    cArray4[n14] = c2;
                } else {
                    n11 = Character.digit(c2, 10);
                    if (n11 < 0) {
                        this.bad(cArray2);
                    }
                    cArray4[n14] = (char)n11;
                }
                ++n10;
                --n3;
                ++n14;
            }
        } else {
            n3 = n7;
            n14 = 0;
            while (n3 > 0) {
                if (n14 == n8) {
                    ++n10;
                }
                cArray4[n14] = cArray[n10];
                ++n10;
                --n3;
                ++n14;
            }
        }
        if (cArray4[0] == '0') {
            n12 = 0;
        }
        this.charConstructor(cArray4, n13, n12, mathContext, n5 != 0);
    }

    private final void charConstructor(char[] cArray, int n, int n2, MathContext mathContext, boolean bl) {
        if (bl && cArray.length < 19) {
            this.flags |= 1;
            this.laside = BigDecimal.toLongForm(cArray);
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            if (n2 == 96) {
                this.laside *= -1L;
            }
            this.cachedScale = -n;
        } else {
            this.flags |= 2;
            this.bi = n2 == 96 ? new BigInteger("-" + new String(cArray)) : new BigInteger(new String(cArray));
            this.cachedScale = -n;
            if (cArray.length <= 0x1FFFFFF) {
                this.flags |= 0x10;
                this.flags |= cArray.length << 7;
            }
        }
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    private void bigIntegerConstructor(BigInteger bigInteger, int n, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            this.DFPBigIntegerConstructorHelper(bigInteger, n, mathContext);
            return;
        }
        if (bigInteger.bitLength() < 63) {
            this.flags |= 1;
            this.laside = bigInteger.longValue();
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.cachedScale = n;
            if (mathContext != MathContext.UNLIMITED) {
                this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            }
        } else {
            this.flags |= 2;
            this.bi = bigInteger;
            this.cachedScale = n;
            if (mathContext != MathContext.UNLIMITED) {
                this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            }
            return;
        }
    }

    private final void bad(char[] cArray) {
        throw new NumberFormatException(Messages.getString("math.03", String.valueOf(cArray)));
    }

    private final void badDivideByZero() {
        throw new ArithmeticException(Messages.getString("math.1C"));
    }

    private final void conversionOverflow(BigDecimal bigDecimal) {
        throw new ArithmeticException(Messages.getString("math.26", bigDecimal));
    }

    private final void nonZeroDecimals(BigDecimal bigDecimal) {
        throw new ArithmeticException(Messages.getString("math.25", bigDecimal));
    }

    private final void scaleOutOfRange(long l) {
        throw new ArithmeticException(Messages.getString("math.1F", Long.toString(l)));
    }

    private static final void scaleOverflow() {
        throw new ArithmeticException(Messages.getString("math.21"));
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && this.DFPAddHelper(bigDecimal2, bigDecimal)) {
            return bigDecimal2;
        }
        bigDecimal3 = this.possibleClone(this);
        bigDecimal4 = this.possibleClone(bigDecimal);
        if ((bigDecimal3.flags & bigDecimal4.flags & 1) == 1) {
            long l;
            int n = bigDecimal3.cachedScale;
            if (bigDecimal3.cachedScale == bigDecimal4.cachedScale && BigDecimal.overflowAdd(bigDecimal3.laside, bigDecimal4.laside, l = bigDecimal3.laside + bigDecimal4.laside) == 0L) {
                bigDecimal2.laside = l;
                bigDecimal2.cachedScale = n;
                bigDecimal2.flags |= 1;
                bigDecimal2.flags &= 0xFFFFFFEF;
                return bigDecimal2;
            }
        }
        return bigDecimal3.longAdd(bigDecimal4, bigDecimal2, MathContext.UNLIMITED, false);
    }

    private BigDecimal possibleClone(BigDecimal bigDecimal) {
        if (BigDecimal.DFPHWAvailable() && (bigDecimal.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(bigDecimal);
            bigDecimal.DFPToBI();
        }
        return bigDecimal;
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && mathContext.getPrecision() == 16 && mathContext.getRoundingMode().ordinal() == 6) {
            this.DFPPerformHysteresis(10);
        }
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | bigDecimal.flags) & 3) == 0 && this.DFPAddHelper(bigDecimal2, bigDecimal, mathContext)) {
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        if ((bigDecimal3.flags & bigDecimal4.flags & 1) == 1) {
            int n = bigDecimal3.cachedScale;
            int n2 = bigDecimal4.cachedScale;
            if (n == n2) {
                long l = bigDecimal3.laside;
                long l2 = bigDecimal4.laside;
                int n3 = 0;
                long l3 = l + l2;
                if (BigDecimal.overflowAdd(l, l2, l3) == 0L) {
                    bigDecimal2.laside = l3;
                    bigDecimal2.cachedScale = n;
                    n3 |= 1;
                } else {
                    BigInteger bigInteger = BigInteger.valueOf(l);
                    BigInteger bigInteger2 = BigInteger.valueOf(l2);
                    bigDecimal2.bi = bigInteger.add(bigInteger2);
                    bigDecimal2.cachedScale = n;
                    n3 |= 2;
                }
                bigDecimal2.flags = n3 &= 0xFFFFFFEF;
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                BigDecimal.postSetScaleProcessing(bigDecimal2);
                return bigDecimal2;
            }
            bigDecimal2 = bigDecimal3.longAdd(bigDecimal4, bigDecimal2, mathContext, false);
        } else {
            bigDecimal2 = bigDecimal3.longAdd(bigDecimal4, bigDecimal2, mathContext, false);
        }
        BigDecimal.postSetScaleProcessing(bigDecimal2);
        return bigDecimal2;
    }

    private final BigDecimal longAdd(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        if (!bl && (bigDecimal.flags & this.flags & 1) == 1 && bigDecimal.cachedScale == this.cachedScale) {
            BigDecimal bigDecimal3 = bigDecimal2;
            BigInteger bigInteger = BigInteger.valueOf(this.laside);
            BigInteger bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
            bigDecimal3.bi = bigInteger.add(bigInteger2);
            bigDecimal3.cachedScale = this.cachedScale;
            bigDecimal3.flags |= 2;
            bigDecimal3.flags &= 0xFFFFFFEF;
            return bigDecimal3;
        }
        BigDecimal bigDecimal4 = bigDecimal;
        BigDecimal bigDecimal5 = this;
        int n = bigDecimal5.cachedScale;
        int n2 = bigDecimal.cachedScale;
        int n3 = 0;
        boolean bl2 = false;
        if ((bigDecimal5.flags & bigDecimal.flags & 1) == 1) {
            boolean bl3;
            boolean bl4;
            long l;
            long l2;
            long l3;
            long l4;
            if (mathContext.getPrecision() != 0) {
                int n4;
                int n5;
                l4 = bigDecimal5.laside;
                l3 = bigDecimal.laside;
                if (n != n2 && l4 != 0L && l3 != 0L) {
                    BigDecimal bigDecimal6;
                    BigDecimal bigDecimal7;
                    if ((long)n - (long)n2 < 0L) {
                        bigDecimal7 = bigDecimal5;
                        bigDecimal6 = bigDecimal;
                    } else {
                        bigDecimal7 = bigDecimal;
                        bigDecimal6 = bigDecimal5;
                    }
                    n5 = 0;
                    n4 = bigDecimal7.flags;
                    n5 = (n4 & 0x10) != 0 ? (n4 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(bigDecimal7.laside);
                    l2 = (long)bigDecimal7.cachedScale - (long)n5 + (long)mathContext.getPrecision();
                    n4 = bigDecimal6.flags;
                    n5 = (n4 & 0x10) != 0 ? (n4 & 0xFFFFFF80) >> 7 : (useSmallerScaleBD ? BigDecimal.numDigits(bigDecimal6.laside) : BigDecimal.numDigits(bigDecimal7.laside));
                    l = (long)bigDecimal6.cachedScale - (long)n5 + 1L;
                    if (l > (long)bigDecimal7.cachedScale + 2L && l > l2 + 2L) {
                        long l5 = bigDecimal6.laside;
                        int n6 = (int)(l5 >> 63) | (int)(-l5 >>> 63);
                        if (bigDecimal6 == bigDecimal) {
                            bigDecimal = new BigDecimal();
                            bigDecimal.laside = n6;
                            bigDecimal.cachedScale = (int)(Math.max((long)bigDecimal7.cachedScale, l2) + 3L);
                            bigDecimal.flags |= 1;
                        } else {
                            bigDecimal5 = new BigDecimal();
                            bigDecimal5.laside = n6;
                            bigDecimal5.cachedScale = (int)(Math.max((long)bigDecimal7.cachedScale, l2) + 3L);
                            bigDecimal5.flags |= 1;
                        }
                    }
                }
                l4 = bigDecimal5.laside;
                l3 = bigDecimal.laside;
                bl4 = l4 == 0L;
                boolean bl5 = bl3 = l3 == 0L;
                if (bl4 && bl3) {
                    if (!bl) {
                        BigDecimal.clone(bigDecimal2, bigDecimal);
                        bigDecimal4 = bigDecimal2;
                    }
                    bigDecimal4.laside = 0L;
                    bigDecimal4.cachedScale = Math.max(bigDecimal5.cachedScale, bigDecimal.cachedScale);
                    bigDecimal4.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    return bigDecimal4;
                }
                if (bl4) {
                    if (!bl) {
                        BigDecimal.clone(bigDecimal2, bigDecimal);
                        bigDecimal4 = bigDecimal2;
                    }
                    bigDecimal4.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    n5 = Math.max(bigDecimal5.cachedScale, bigDecimal.cachedScale);
                    n4 = 0;
                    int n7 = bigDecimal4.flags;
                    n4 = (n7 & 0x10) != 0 ? (n7 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(bigDecimal4.laside);
                    int n8 = mathContext.getPrecision() - n4;
                    l = n5 - bigDecimal4.cachedScale;
                    bigDecimal4 = (long)n8 >= l ? bigDecimal4.setScale(n5, true) : bigDecimal4.setScale(bigDecimal4.scale() + n8, true);
                    return bigDecimal4;
                }
                if (bl3) {
                    BigDecimal.clone(bigDecimal2, bigDecimal5);
                    bigDecimal4 = bigDecimal2;
                    bigDecimal4.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                    n5 = Math.max(bigDecimal5.cachedScale, bigDecimal.cachedScale);
                    n4 = 0;
                    int n9 = bigDecimal4.flags;
                    n4 = (n9 & 0x10) != 0 ? (n9 & 0xFFFFFF80) >> 7 : BigDecimal.numDigits(bigDecimal4.laside);
                    int n10 = mathContext.getPrecision() - n4;
                    l = n5 - bigDecimal4.cachedScale;
                    bigDecimal4 = (long)n10 >= l ? bigDecimal4.setScale(n5, true) : bigDecimal4.setScale(bigDecimal4.scale() + n10, true);
                    return bigDecimal4;
                }
            }
            l4 = bigDecimal5.laside;
            l3 = bigDecimal.laside;
            n = bigDecimal5.cachedScale;
            n2 = bigDecimal.cachedScale;
            bl4 = l4 == 0L;
            boolean bl6 = bl3 = l3 == 0L;
            if (!bl2) {
                if (!bl) {
                    bigDecimal4 = bigDecimal2;
                }
                n3 = bigDecimal4.flags;
                if (n > n2) {
                    long l6 = (long)(-n2) + (long)n;
                    if (l6 > 1000000L && l6 < Integer.MAX_VALUE && !bl3) {
                        return bigDecimal;
                    }
                    l2 = BigDecimal.powerOfTenLL(l6);
                    if (l2 != -1L) {
                        long l7;
                        int n11;
                        int n12;
                        l = l3;
                        if (l < 0L) {
                            l *= -1L;
                        }
                        if ((n12 = Long.numberOfLeadingZeros(l) - 1) + (n11 = Long.numberOfLeadingZeros(l2) - 1) >= 63 && BigDecimal.overflowAdd(l4, l3 *= l2, l7 = l4 + l3) == 0L) {
                            bigDecimal4.laside = l7;
                            bigDecimal4.cachedScale = n;
                            n3 &= 0xFFFFFFFC;
                            n3 |= 1;
                            bl2 = true;
                        }
                    } else {
                        BigInteger bigInteger = BigInteger.valueOf(l4);
                        BigInteger bigInteger3 = BigInteger.valueOf(l3);
                        if (!bl3) {
                            if (l6 > Integer.MAX_VALUE) {
                                BigDecimal.scaleOverflow();
                            }
                            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l6));
                        }
                        bigDecimal4.bi = bigInteger.add(bigInteger3);
                        bigDecimal4.cachedScale = n;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 2;
                        bl2 = true;
                    }
                } else {
                    long l8 = (long)(-n) + (long)n2;
                    if (l8 > 1000000L && l8 < Integer.MAX_VALUE && !bl4) {
                        return bigDecimal5;
                    }
                    l2 = BigDecimal.powerOfTenLL(l8);
                    if (l2 != -1L) {
                        long l9;
                        int n13;
                        int n14;
                        l = l4;
                        if (l < 0L) {
                            l *= -1L;
                        }
                        if ((n14 = Long.numberOfLeadingZeros(l) - 1) + (n13 = Long.numberOfLeadingZeros(l2) - 1) >= 63 && BigDecimal.overflowAdd(l4 *= l2, l3, l9 = l4 + l3) == 0L) {
                            bigDecimal4.laside = l9;
                            bigDecimal4.cachedScale = n2;
                            n3 &= 0xFFFFFFFC;
                            n3 |= 1;
                            bl2 = true;
                        }
                    } else {
                        BigInteger bigInteger = BigInteger.valueOf(l4);
                        BigInteger bigInteger4 = BigInteger.valueOf(l3);
                        if (!bl4) {
                            if (l8 > Integer.MAX_VALUE) {
                                BigDecimal.scaleOverflow();
                            }
                            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l8));
                        }
                        bigDecimal4.bi = bigInteger.add(bigInteger4);
                        bigDecimal4.cachedScale = n2;
                        n3 &= 0xFFFFFFFC;
                        n3 |= 2;
                        bl2 = true;
                    }
                }
            }
            bigDecimal4.flags = n3;
        }
        bigDecimal4.flags &= 0xFFFFFFEF;
        if (bl2) {
            if (mathContext != MathContext.UNLIMITED) {
                bigDecimal4.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            }
            return bigDecimal4;
        }
        return this.slAdd(bigDecimal, bigDecimal2, mathContext, bl);
    }

    private BigDecimal slAdd(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        boolean bl2;
        long l;
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = this;
        boolean bl3 = false;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        int n = bigDecimal4.cachedScale;
        int n2 = bigDecimal.cachedScale;
        int n3 = 0;
        if (mathContext.getPrecision() != 0) {
            long l2;
            if (n != n2 && bigDecimal4.signum() != 0 && bigDecimal.signum() != 0) {
                BigDecimal bigDecimal5;
                BigDecimal bigDecimal6;
                if ((long)n - (long)n2 < 0L) {
                    bigDecimal6 = bigDecimal4;
                    bigDecimal5 = bigDecimal;
                } else {
                    bigDecimal6 = bigDecimal;
                    bigDecimal5 = bigDecimal4;
                }
                l = (long)bigDecimal6.cachedScale - (long)bigDecimal6.precision() + (long)mathContext.getPrecision();
                l2 = (long)bigDecimal5.cachedScale - (long)bigDecimal5.precision() + 1L;
                if (l2 > (long)bigDecimal6.cachedScale + 2L && l2 > l + 2L) {
                    int n4 = bigDecimal5.signum();
                    if (bigDecimal5 == bigDecimal) {
                        bigDecimal = new BigDecimal();
                        bigDecimal.bi = BigInteger.valueOf(n4);
                        bigDecimal.cachedScale = (int)(Math.max((long)bigDecimal6.cachedScale, l) + 3L);
                        bigDecimal.flags |= 2;
                    } else {
                        bigDecimal4 = new BigDecimal();
                        bigDecimal4.bi = BigInteger.valueOf(n4);
                        bigDecimal4.cachedScale = Math.max(bigDecimal6.cachedScale, (int)l) + 3;
                        bigDecimal4.flags |= 2;
                    }
                }
            }
            boolean bl4 = bigDecimal4.signum() == 0;
            boolean bl5 = bl2 = bigDecimal.signum() == 0;
            if (bl4 && bl2) {
                if (!bl) {
                    BigDecimal.clone(bigDecimal2, bigDecimal);
                    bigDecimal3 = bigDecimal2;
                }
                bigDecimal3.laside = 0L;
                bigDecimal3.cachedScale = Math.max(n, n2);
                bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                return bigDecimal3;
            }
            if (bl4) {
                if (!bl) {
                    BigDecimal.clone(bigDecimal2, bigDecimal);
                    bigDecimal3 = bigDecimal2;
                }
                if ((bigDecimal3.flags & 1) == 1) {
                    bigDecimal3.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                } else {
                    if ((bigDecimal3.flags & 3) == 0) {
                        bigDecimal3.DFPToBI();
                    }
                    bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                }
                int n5 = Math.max(n, n2);
                int n6 = mathContext.getPrecision() - bigDecimal3.precision();
                l2 = n5 - bigDecimal3.cachedScale;
                bigDecimal3 = (long)n6 >= l2 ? bigDecimal3.setScale(n5, true) : bigDecimal3.setScale(bigDecimal3.scale() + n6, true);
                return bigDecimal3;
            }
            if (bl2) {
                BigDecimal.clone(bigDecimal2, bigDecimal4);
                bigDecimal3 = bigDecimal2;
                if ((bigDecimal3.flags & 1) == 1) {
                    bigDecimal3.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                } else {
                    if ((bigDecimal3.flags & 3) == 0) {
                        bigDecimal3.DFPToBI();
                    }
                    bigDecimal3.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
                }
                int n7 = Math.max(n, n2);
                int n8 = mathContext.getPrecision() - bigDecimal3.precision();
                l2 = n7 - bigDecimal3.cachedScale;
                bigDecimal3 = (long)n8 >= l2 ? bigDecimal3.setScale(n7, true) : bigDecimal3.setScale(bigDecimal3.scale() + n8, true);
                return bigDecimal3;
            }
        }
        bigInteger = bigDecimal4.bi;
        bigInteger2 = bigDecimal.bi;
        if ((bigDecimal4.flags & 3) != 2) {
            BigDecimal bigDecimal7 = bigDecimal4;
            if ((bigDecimal4.flags & 3) == 0) {
                bigDecimal7 = BigDecimal.clone(bigDecimal4);
                bigDecimal7.DFPToLL();
            }
            bigInteger = BigInteger.valueOf(bigDecimal7.laside);
        }
        if ((bigDecimal.flags & 3) != 2) {
            BigDecimal bigDecimal8 = bigDecimal;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal8 = BigDecimal.clone(bigDecimal);
                bigDecimal8.DFPToLL();
            }
            bigInteger2 = BigInteger.valueOf(bigDecimal8.laside);
        }
        n = bigDecimal4.cachedScale;
        n2 = bigDecimal.cachedScale;
        boolean bl6 = bigInteger.signum() == 0;
        boolean bl7 = bl2 = bigInteger2.signum() == 0;
        if (!bl3) {
            if (!bl) {
                bigDecimal3 = bigDecimal2;
            }
            n3 = bigDecimal3.flags;
            if (n == n2) {
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.cachedScale = bigDecimal4.cachedScale;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            } else if (n > n2) {
                if (!bl2) {
                    l = -((long)n2) + (long)n;
                    if (l > Integer.MAX_VALUE) {
                        BigDecimal.scaleOverflow();
                    }
                    bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(l));
                }
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.cachedScale = n;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            } else {
                if (!bl6) {
                    l = -((long)n) + (long)n2;
                    if (l > Integer.MAX_VALUE) {
                        BigDecimal.scaleOverflow();
                    }
                    bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l));
                }
                bigDecimal3.bi = bigInteger.add(bigInteger2);
                bigDecimal3.cachedScale = n2;
                n3 &= 0xFFFFFFFC;
                n3 |= 2;
            }
            bigDecimal3.flags = n3;
        }
        bigDecimal3.flags &= 0xFFFFFFEF;
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal3.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal3;
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && this.DFPSubtractHelper(bigDecimal2, bigDecimal)) {
            return bigDecimal2;
        }
        bigDecimal3 = this.possibleClone(this);
        bigDecimal4 = this.possibleClone(bigDecimal);
        return bigDecimal3.subtract(bigDecimal4, bigDecimal2, MathContext.UNLIMITED);
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && mathContext.getPrecision() == 16 && mathContext.getRoundingMode().ordinal() == 6) {
            this.DFPPerformHysteresis(10);
        }
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | bigDecimal.flags) & 3) == 0 && this.DFPSubtractHelper(bigDecimal2, bigDecimal, mathContext)) {
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal2 = bigDecimal3.subtract(bigDecimal4, bigDecimal2, mathContext);
        BigDecimal.postSetScaleProcessing(bigDecimal2);
        return bigDecimal2;
    }

    private final BigDecimal subtract(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimal bigDecimal3 = BigDecimal.clone(bigDecimal);
        if ((bigDecimal.flags & 1) == 1) {
            bigDecimal3.laside *= -1L;
        } else {
            if ((bigDecimal3.flags & 3) == 0) {
                bigDecimal3.DFPToBI();
            }
            bigDecimal3.bi = bigDecimal3.bi.negate();
        }
        bigDecimal3.flags &= 0xFFFFFFFB;
        return this.longAdd(bigDecimal3, bigDecimal2, mathContext, true);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            int n;
            int n2;
            BigDecimal bigDecimal2 = new BigDecimal();
            long l = 0L;
            int n3 = this.flags;
            l = (long)this.scale() + (long)bigDecimal.scale();
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                if (this.signum() == 0) {
                    l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                } else {
                    this.scaleOutOfRange(l);
                }
            }
            bigDecimal2.cachedScale = (int)l;
            long l2 = this.laside;
            long l3 = bigDecimal.laside;
            if (l2 < 0L) {
                l2 *= -1L;
            }
            if (l3 < 0L) {
                l3 *= -1L;
            }
            if ((n2 = Long.numberOfLeadingZeros(l2) - 1) + (n = Long.numberOfLeadingZeros(l3) - 1) >= 63) {
                long l4;
                bigDecimal2.laside = l4 = this.laside * bigDecimal.laside;
                n3 &= 0xFFFFFFFC;
                n3 |= 1;
                bigDecimal2.flags = n3 &= 0xFFFFFFEF;
                return bigDecimal2;
            }
        }
        return this.multiply2(bigDecimal);
    }

    private BigDecimal multiply2(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = null;
        BigDecimal bigDecimal4 = null;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | bigDecimal.flags) & 3) == 0 && this.DFPMultiplyHelper(bigDecimal2, bigDecimal)) {
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        } else {
            bigDecimal4 = bigDecimal;
        }
        if (bigDecimal3 != null) {
            bigDecimal3.longMultiply(bigDecimal4, bigDecimal2, MathContext.UNLIMITED, false);
        } else {
            this.longMultiply(bigDecimal4, bigDecimal2, MathContext.UNLIMITED, false);
        }
        return bigDecimal2;
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && mathContext.getPrecision() == 16 && mathContext.getRoundingMode().ordinal() == 6) {
            this.DFPPerformHysteresis(10);
        }
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | bigDecimal.flags) & 3) == 0 && this.DFPMultiplyHelper(bigDecimal2, bigDecimal, mathContext)) {
            return bigDecimal2;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal3.longMultiply(bigDecimal4, bigDecimal2, mathContext, false);
        return bigDecimal2;
    }

    private final void longMultiply(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        long l = 0L;
        boolean bl2 = false;
        int n = bl ? this.flags : bigDecimal2.flags;
        n &= 0xFFFFFFEF;
        l = (long)this.scale() + (long)bigDecimal.scale();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                this.scaleOutOfRange(l);
            }
        }
        if (bl) {
            this.cachedScale = (int)l;
        } else {
            bigDecimal2.cachedScale = (int)l;
        }
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            int n2;
            int n3;
            long l2 = this.laside;
            long l3 = bigDecimal.laside;
            if (l2 < 0L) {
                l2 *= -1L;
            }
            if (l3 < 0L) {
                l3 *= -1L;
            }
            if ((n3 = Long.numberOfLeadingZeros(l2) - 1) + (n2 = Long.numberOfLeadingZeros(l3) - 1) >= 63) {
                long l4 = this.laside * bigDecimal.laside;
                if (bl) {
                    this.laside = l4;
                } else {
                    bigDecimal2.laside = l4;
                }
                n &= 0xFFFFFFFC;
                n |= 1;
                bl2 = true;
            } else {
                BigInteger bigInteger = BigInteger.valueOf(this.laside);
                BigInteger bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
                if (bl) {
                    this.bi = bigInteger2.multiply(bigInteger);
                } else {
                    bigDecimal2.bi = bigInteger2.multiply(bigInteger);
                }
                n &= 0xFFFFFFFC;
                n |= 2;
                bl2 = true;
            }
            if (bl) {
                this.flags = n;
            } else {
                bigDecimal2.flags = n;
            }
        }
        if (bl2) {
            if (mathContext != MathContext.UNLIMITED) {
                if (bl) {
                    this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                } else {
                    bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
            }
        } else if (bl) {
            this.slMultiply(bigDecimal, this, mathContext, bl);
        } else {
            this.slMultiply(bigDecimal, bigDecimal2, mathContext, bl);
        }
        if (bl) {
            BigDecimal.postSetScaleProcessing(this);
        } else {
            BigDecimal.postSetScaleProcessing(bigDecimal2);
        }
    }

    private final void slMultiply(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, boolean bl) {
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = null;
        if (bl) {
            bigDecimal4 = BigDecimal.clone(this);
        }
        BigInteger bigInteger = bl ? bigDecimal4.bi : this.bi;
        BigInteger bigInteger2 = bigDecimal.bi;
        bigInteger = this.bi;
        bigInteger2 = bigDecimal.bi;
        if (bl) {
            if ((bigDecimal4.flags & 3) != 2) {
                if ((bigDecimal4.flags & 3) == 0) {
                    bigDecimal4.DFPToLL();
                }
                bigInteger = BigInteger.valueOf(bigDecimal4.laside);
            }
        } else if ((this.flags & 3) != 2) {
            bigDecimal3 = BigDecimal.clone(this);
            if ((bigDecimal3.flags & 3) == 0) {
                bigDecimal3.DFPToLL();
            }
            bigInteger = BigInteger.valueOf(bigDecimal3.laside);
        }
        if ((bigDecimal.flags & 3) != 2) {
            bigDecimal3 = BigDecimal.clone(bigDecimal);
            if ((bigDecimal3.flags & 3) == 0) {
                bigDecimal3.DFPToLL();
            }
            bigInteger2 = BigInteger.valueOf(bigDecimal3.laside);
        }
        int n = bigDecimal2.flags;
        n &= 0xFFFFFFFC;
        n |= 2;
        bigDecimal2.bi = bigInteger.multiply(bigInteger2);
        bigDecimal2.flags = n &= 0xFFFFFFEF;
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale(), n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return this.divide(bigDecimal, this.scale(), roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return this.divide(bigDecimal, n, roundingMode.ordinal());
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        RoundingMode.valueOf(n2);
        BigDecimal bigDecimal2 = new BigDecimal();
        BigDecimal bigDecimal3 = this;
        BigDecimal bigDecimal4 = bigDecimal;
        if ((this.flags & 3) == 0) {
            bigDecimal3 = BigDecimal.clone(this);
            bigDecimal3.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal);
            bigDecimal4.DFPToBI();
        }
        bigDecimal3.divide(bigDecimal4, bigDecimal2, n, n2);
        return bigDecimal2;
    }

    private final void divide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        BigDecimal bigDecimal3 = null;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            bigDecimal3 = this.longScaledDivide(bigDecimal, bigDecimal2, n, n2);
        }
        if (bigDecimal3 == null) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal4.LLToBI();
            bigDecimal5.LLToBI();
            bigDecimal4.slScaledDivide(bigDecimal5, bigDecimal2, n2, n);
        }
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = new BigDecimal();
        BigDecimal bigDecimal4 = bigDecimal2;
        BigDecimal bigDecimal5 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && ((this.flags | bigDecimal.flags) & 3) == 0 && this.DFPDivideHelper(bigDecimal3, this, bigDecimal)) {
            return bigDecimal3;
        }
        if ((this.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal4.DFPToBI();
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal5.DFPToBI();
        }
        bigDecimal4.divide(bigDecimal5, bigDecimal3, MathContext.UNLIMITED);
        return bigDecimal3;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = new BigDecimal();
        BigDecimal bigDecimal4 = bigDecimal2;
        BigDecimal bigDecimal5 = bigDecimal;
        int n = mathContext.getPrecision();
        if (n == 0) {
            return bigDecimal2.divide(bigDecimal);
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPPerformHysteresis() && mathContext.getPrecision() == 16 && mathContext.getRoundingMode().ordinal() == 6) {
            this.DFPPerformHysteresis(10);
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            BigDecimal.postSetScaleProcessing(bigDecimal4);
            BigDecimal.postSetScaleProcessing(bigDecimal5);
        }
        if (BigDecimal.DFPHWAvailable() && ((bigDecimal4.flags | bigDecimal5.flags) & 3) == 0 && this.DFPDivideHelper(bigDecimal3, bigDecimal4, bigDecimal5, mathContext)) {
            return bigDecimal3;
        }
        if ((bigDecimal4.flags & 3) == 0) {
            bigDecimal4 = BigDecimal.clone(bigDecimal4);
            bigDecimal4.DFPToBI();
        }
        if ((bigDecimal5.flags & 3) == 0) {
            bigDecimal5 = BigDecimal.clone(bigDecimal5);
            bigDecimal5.DFPToBI();
        }
        bigDecimal4.divide(bigDecimal5, bigDecimal3, mathContext);
        BigDecimal.postSetScaleProcessing(bigDecimal3);
        return bigDecimal3;
    }

    private final void divide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimal bigDecimal3 = null;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            bigDecimal3 = this.longPrecisionDivide(bigDecimal, bigDecimal2, mathContext);
        }
        if (bigDecimal3 == null) {
            bigDecimal4 = BigDecimal.clone(this);
            bigDecimal5 = BigDecimal.clone(bigDecimal);
            bigDecimal4.LLToBI();
            bigDecimal5.LLToBI();
            bigDecimal4.slPrecisionDivide(bigDecimal5, bigDecimal2, mathContext);
        }
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.divideToIntegralValue(bigDecimal);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
        BigDecimal bigDecimal4 = this.subtract(bigDecimal3);
        return bigDecimal4;
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this.divideToIntegralValue(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
        BigDecimal bigDecimal4 = this.subtract(bigDecimal3);
        return bigDecimal4;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal, mathContext), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        MathContext mathContext;
        BigDecimal bigDecimal2;
        int n;
        BigDecimal bigDecimal3;
        if (bigDecimal.signum() == 0) {
            this.badDivideByZero();
        }
        int n2 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal bigDecimal4 = this.abs();
        if (bigDecimal4.compareTo(bigDecimal3 = bigDecimal.abs()) < 0) {
            return BigDecimal.valueOf(0L, n2);
        }
        int n3 = this.precision();
        int n4 = bigDecimal.precision();
        long l = (long)Math.min((double)n3 + Math.ceil(10.0 * (double)n4 / 3.0), 2.147483647E9);
        if ((l += Math.min(Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L + l, Integer.MAX_VALUE)) > Integer.MAX_VALUE) {
            BigDecimal.scaleOverflow();
        }
        if ((n = (bigDecimal2 = this.divide(bigDecimal, mathContext = new MathContext((int)l, RoundingMode.DOWN))).scale()) > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        }
        if (n2 > 0) {
            bigDecimal2 = bigDecimal2.setScale(n2);
        } else {
            int n5 = Math.abs(n2 - bigDecimal2.scale());
            if (n5 != 0) {
                if ((bigDecimal2.flags & 3) == 0) {
                    bigDecimal2.DFPToLL();
                }
                if ((bigDecimal2.flags & 1) == 1) {
                    long l2 = bigDecimal2.laside;
                    int n6 = bigDecimal2.cachedScale;
                    while (l2 % 10L == 0L && n5 > 0) {
                        l2 /= 10L;
                        --n6;
                        --n5;
                    }
                    bigDecimal2.laside = l2;
                    bigDecimal2.cachedScale = n6;
                } else {
                    if ((bigDecimal2.flags & 3) == 0) {
                        bigDecimal2.DFPToBI();
                    }
                    BigInteger bigInteger = bigDecimal2.bi;
                    int n7 = bigDecimal2.cachedScale;
                    while (bigInteger.mod(BigInteger.TEN).equals(BigInteger.ZERO) && n5 > 0) {
                        bigInteger = bigInteger.divide(BigInteger.TEN);
                        --n7;
                        --n5;
                    }
                    bigDecimal2.bi = bigInteger;
                    bigDecimal2.cachedScale = n7;
                }
                bigDecimal2.flags &= 0xFFFFFFEF;
            }
        }
        return bigDecimal2;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        BigDecimal bigDecimal2;
        if (mathContext.getPrecision() == 0) {
            return this.divideToIntegralValue(bigDecimal);
        }
        int n2 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal bigDecimal3 = this.abs();
        if (bigDecimal3.compareTo(bigDecimal2 = bigDecimal.abs()) < 0) {
            return BigDecimal.valueOf(0L, n2);
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision(), RoundingMode.DOWN);
        BigDecimal bigDecimal4 = this.divide(bigDecimal, mathContext2);
        int n3 = bigDecimal4.scale();
        if (n3 > 0) {
            bigDecimal4 = bigDecimal4.setScale(0, RoundingMode.DOWN);
        }
        if (n2 > 0 && mathContext.getPrecision() == 0) {
            bigDecimal4 = bigDecimal4.setScale(n2);
        } else if (n2 >= 0) {
            n = mathContext.getPrecision() - bigDecimal4.precision();
            if (n > 0) {
                bigDecimal4 = bigDecimal4.setScale(Math.min(n, n2));
            }
        } else {
            n = Math.abs(n2 - bigDecimal4.scale());
            if (n != 0) {
                if ((bigDecimal4.flags & 3) == 0) {
                    bigDecimal4.DFPToLL();
                }
                if ((bigDecimal4.flags & 1) == 1) {
                    long l = bigDecimal4.laside;
                    int n4 = bigDecimal4.cachedScale;
                    while (l % 10L == 0L && n > 0) {
                        l /= 10L;
                        --n4;
                        --n;
                    }
                    bigDecimal4.laside = l;
                    bigDecimal4.cachedScale = n4;
                } else {
                    if ((bigDecimal4.flags & 3) == 0) {
                        bigDecimal4.DFPToBI();
                    }
                    BigInteger bigInteger = bigDecimal4.bi;
                    int n5 = bigDecimal4.cachedScale;
                    while (bigInteger.mod(BigInteger.TEN).equals(BigInteger.ZERO) && n > 0) {
                        bigInteger = bigInteger.divide(BigInteger.TEN);
                        --n5;
                        --n;
                    }
                    bigDecimal4.bi = bigInteger;
                    bigDecimal4.cachedScale = n5;
                }
                bigDecimal4.flags &= 0xFFFFFFEF;
            }
        }
        BigDecimal bigDecimal5 = this.subtract(bigDecimal.multiply(bigDecimal4));
        if (bigDecimal5.abs().compareTo(bigDecimal2) >= 0) {
            throw new ArithmeticException(Messages.getString("math.34"));
        }
        if (mathContext.getPrecision() > 0 && bigDecimal4.precision() > mathContext.getPrecision()) {
            throw new ArithmeticException(Messages.getString("math.35"));
        }
        return bigDecimal4;
    }

    private final BigDecimal longPrecisionDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        BigDecimal bigDecimal3 = null;
        long l = this.cachedScale;
        long l2 = bigDecimal.cachedScale;
        long l3 = l;
        long l4 = l2;
        int n = this.signum() * bigDecimal.signum();
        long l5 = this.laside;
        long l6 = bigDecimal.laside;
        boolean bl = true;
        if (l5 < 0L) {
            bl = false;
            l5 *= -1L;
        }
        if (l6 < 0L) {
            bl = false;
            l6 *= -1L;
        }
        long l7 = this.precision();
        long l8 = bigDecimal.precision();
        long l9 = 0L;
        long l10 = 0L;
        boolean bl2 = false;
        int n2 = mathContext.getPrecision();
        boolean bl3 = true;
        long l11 = 0L;
        if (bigDecimal.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException(Messages.getString("math.24"));
            }
            this.badDivideByZero();
        }
        if (n2 == 0) {
            l11 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            n2 = (int)Math.min((double)l7 + Math.ceil(10.0 * (double)l8 / 3.0), 2.147483647E9);
            bl2 = true;
        } else {
            l11 = l3 - l4;
        }
        if (this.laside == 0L) {
            BigDecimal.clone(bigDecimal2, this);
            bigDecimal2.cachedScale = (int)Math.max(Math.min(l11, Integer.MAX_VALUE), Integer.MIN_VALUE);
            return bigDecimal2;
        }
        if (l7 > l8) {
            l9 = l7 - l8;
            l10 = BigDecimal.powerOfTenLL(l9);
            if (l10 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l6, l10)) {
                return null;
            }
            l6 *= l10;
            l2 += l9;
        } else if (l7 < l8) {
            l9 = l8 - l7;
            l10 = BigDecimal.powerOfTenLL(l9);
            if (l10 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l5, l10)) {
                return null;
            }
            l5 *= l10;
            l += l9;
        }
        if (l5 > l6) {
            if (BigDecimal.overflowMultiply(l6, 10L)) {
                return null;
            }
            l6 *= 10L;
            ++l2;
        }
        long l12 = 0L;
        long l13 = 0L;
        l10 = BigDecimal.powerOfTenLL(n2);
        if (l10 == -1L) {
            return null;
        }
        if (BigDecimal.overflowMultiply(l5, l10)) {
            if (l7 > 2L && l8 > 2L && n2 < 17 && l7 < 17L && l8 < 17L && bl && !bl2) {
                long l14 = 0L;
                int n3 = n2 / 2;
                int n4 = n2 - n3 * 2;
                if (n4 != 0) {
                    l14 = (l5 *= 10L) / l6;
                    l13 = l5 - l14 * l6;
                    l12 = l12 * 10L + l14;
                    l5 = l13;
                }
                l5 *= 100L;
                for (int i = 0; i < n3; ++i) {
                    l14 = l5 / l6;
                    l13 = l5 - l14 * l6;
                    l12 = l12 * 100L + l14;
                    l5 = l13 * 100L;
                }
                long l15 = BigDecimal.roundPostLLDivision(l12, n, l6, l13, mathContext.getRoundingMode().ordinal());
                int n5 = BigDecimal.numDigits(l12);
                int n6 = BigDecimal.numDigits(l15);
                boolean bl4 = false;
                if (n6 > n5) {
                    return null;
                }
                int n7 = (int)(l - l2 + (long)n2);
                bigDecimal3 = bigDecimal2;
                bigDecimal3.laside = l15;
                bigDecimal3.cachedScale = n7;
                bigDecimal3.flags &= 0xFFFFFFFC;
                bigDecimal3.flags |= 1;
                return bigDecimal3;
            }
            return null;
        }
        if ((l13 = (l5 *= l10) - (l12 = l5 / l6) * l6) != 0L) {
            bl3 = false;
        }
        if (bl2 && l13 != 0L) {
            throw new ArithmeticException(Messages.getString("math.28"));
        }
        if (n2 != 0 && mathContext.getRoundingMode().ordinal() == 7 && l13 != 0L) {
            throw new ArithmeticException(Messages.getString("math.29"));
        }
        long l16 = l12;
        long l17 = l13;
        long l18 = l6;
        if (l16 < 0L) {
            l16 *= -1L;
        }
        if (l17 < 0L) {
            l17 *= -1L;
        }
        if (l6 < 0L) {
            l18 *= -1L;
        }
        int n8 = BigDecimal.numDigits(l16);
        boolean bl5 = false;
        long l19 = BigDecimal.roundPostLLDivision(l16, n, l18, l17, mathContext.getRoundingMode().ordinal());
        long l20 = l - l2 + (long)n2;
        if (l19 != l16 && l19 % 10L == 0L && l16 % 10L != 0L) {
            bl5 = true;
        }
        if (l19 == -1L) {
            return null;
        }
        int n9 = BigDecimal.numDigits(l19);
        if (n8 < n9 && n9 > n2) {
            l19 /= 10L;
            --l20;
        }
        long l21 = l20 - l11;
        if (bl2 && l20 < l11) {
            l21 = l11 - l20;
            l10 = BigDecimal.powerOfTenLL(l21);
            if (l10 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l19, l10)) {
                return null;
            }
            l20 += l21;
            l19 *= l10;
        }
        if (l20 > l11 && !bl5 && bl3) {
            while (l19 % 10L == 0L && l21 > 0L) {
                l19 /= 10L;
                --l20;
                --l21;
            }
            if (l19 == 0L && l21 > 0L) {
                l20 -= l21;
            }
        }
        if (l20 < Integer.MIN_VALUE || l20 > Integer.MAX_VALUE) {
            this.scaleOutOfRange(l20);
        }
        if (n == -1) {
            l19 *= -1L;
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.laside = l19;
        bigDecimal3.cachedScale = (int)l20;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 1;
        bigDecimal3.flags &= 0x7F;
        bigDecimal3.flags |= BigDecimal.numDigits(bigDecimal3.laside) << 7;
        return bigDecimal3;
    }

    private final BigDecimal longScaledDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        long l;
        BigDecimal bigDecimal3 = null;
        if (bigDecimal.laside == 0L) {
            if (this.laside == 0L) {
                throw new ArithmeticException(Messages.getString("math.24"));
            }
            this.badDivideByZero();
        }
        if (this.laside == 0L) {
            bigDecimal3 = bigDecimal2;
            bigDecimal3.laside = 0L;
            bigDecimal3.cachedScale = n;
            bigDecimal3.flags &= 0xFFFFFFFC;
            bigDecimal3.flags |= 1;
            bigDecimal3.flags &= 0x7F;
            bigDecimal3.flags |= 0x80;
        }
        int n3 = this.signum() * bigDecimal.signum();
        long l2 = this.laside;
        long l3 = bigDecimal.laside;
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if (l3 < 0L) {
            l3 *= -1L;
        }
        long l4 = (long)this.cachedScale - (long)bigDecimal.cachedScale;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        long l8 = l3;
        if (l4 < (long)n) {
            l6 = (long)n - l4;
            l5 = BigDecimal.powerOfTenLL(l6);
            if (l5 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l7, l5)) {
                return null;
            }
            l7 *= l5;
        } else if (l4 > (long)n) {
            l6 = l4 - (long)n;
            l5 = BigDecimal.powerOfTenLL(l6);
            if (l5 == -1L) {
                return null;
            }
            if (BigDecimal.overflowMultiply(l8, l5)) {
                return null;
            }
            l8 *= l5;
        }
        long l9 = l7 / l8;
        long l10 = l7 - l9 * l8;
        long l11 = l9;
        long l12 = l10;
        long l13 = l8;
        if (l11 < 0L) {
            l11 *= -1L;
        }
        if (l12 < 0L) {
            l12 *= -1L;
        }
        if (l8 < 0L) {
            l13 *= -1L;
        }
        if ((l = BigDecimal.roundPostLLDivision(l11, n3, l13, l12, n2)) == -1L) {
            return null;
        }
        if (n3 == -1) {
            l *= -1L;
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.laside = l;
        bigDecimal3.cachedScale = n;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 1;
        bigDecimal3.flags &= 0x7F;
        bigDecimal3.flags |= BigDecimal.numDigits(bigDecimal3.laside) << 7;
        return bigDecimal3;
    }

    private final BigDecimal slPrecisionDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        int n;
        int n2;
        BigInteger[] bigIntegerArray;
        BigDecimal bigDecimal3 = null;
        long l = this.cachedScale;
        long l2 = bigDecimal.cachedScale;
        long l3 = l;
        long l4 = l2;
        int n3 = bigDecimal.signum() * this.signum();
        int n4 = this.precision();
        int n5 = bigDecimal.precision();
        long l5 = 0L;
        boolean bl = false;
        int n6 = mathContext.getPrecision();
        boolean bl2 = true;
        long l6 = 0L;
        if (bigDecimal.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException(Messages.getString("math.24"));
            }
            this.badDivideByZero();
        }
        if (n6 == 0) {
            l6 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
            n6 = (int)Math.min((double)n4 + Math.ceil(10.0 * (double)n5 / 3.0), 2.147483647E9);
            bl = true;
        } else {
            l6 = l3 - l4;
        }
        if ((long)this.bi.signum() == 0L) {
            BigDecimal.clone(bigDecimal2, this);
            bigDecimal2.cachedScale = (int)Math.max(Math.min(l6, Integer.MAX_VALUE), Integer.MIN_VALUE);
            return bigDecimal2;
        }
        BigInteger bigInteger = this.bi.abs();
        BigInteger bigInteger2 = bigDecimal.bi.abs();
        if (n4 > n5) {
            l5 = n4 - n5;
            if (l5 >= Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(l5));
            l2 += l5;
        } else if (n4 < n5) {
            l5 = n5 - n4;
            if (l5 >= Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l5));
            l += l5;
        }
        if (bigInteger.compareTo(bigInteger2) > 0) {
            bigInteger2 = bigInteger2.multiply(BigInteger.TEN);
            ++l2;
        }
        if (n6 >= Integer.MAX_VALUE) {
            BigDecimal.scaleOverflow();
        }
        if ((bigIntegerArray = (bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(n6))).divideAndRemainder(bigInteger2))[1].signum() != 0) {
            bl2 = false;
        }
        if (bl && bigIntegerArray[1].signum() != 0) {
            throw new ArithmeticException(Messages.getString("math.28"));
        }
        if (n6 != 0 && mathContext.getRoundingMode().ordinal() == 7 && bigIntegerArray[1].signum() != 0) {
            throw new ArithmeticException(Messages.getString("math.29"));
        }
        boolean bl3 = false;
        BigInteger bigInteger3 = BigDecimal.roundPostSlowDivision(bigIntegerArray[0], n3, bigInteger2, bigIntegerArray[1], mathContext.getRoundingMode().ordinal());
        long l7 = l - l2 + (long)n6;
        if (!bigInteger3.equals(bigIntegerArray[0]) && bigInteger3.mod(BigInteger.TEN).equals(BigInteger.ZERO) && !bigIntegerArray[1].mod(BigInteger.TEN).equals(BigInteger.ZERO)) {
            bl3 = true;
        }
        if ((n6 == 16 && bigInteger3.equals(BigDecimal.powerOfTenBI(17L)) || n6 != 16) && (n2 = BigDecimal.precisionBI(bigIntegerArray[0])) < (n = BigDecimal.precisionBI(bigInteger3)) && n > n6) {
            bigInteger3 = bigInteger3.divide(BigInteger.TEN);
            --l7;
        }
        long l8 = l7 - l6;
        if (bl && l7 < l6) {
            l8 = l6 - l7;
            if (l8 >= Integer.MAX_VALUE || l7 > Integer.MAX_VALUE || l7 < Integer.MIN_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l8));
            l7 += l8;
        }
        if (l7 > l6 && !bl3 && bl2) {
            while (bigInteger3.mod(BigInteger.TEN).equals(BigInteger.ZERO) && l8 > 0L) {
                bigInteger3 = bigInteger3.divide(BigInteger.TEN);
                --l7;
                --l8;
            }
            if (bigInteger3.equals(BigInteger.ZERO) && l8 > 0L) {
                l7 -= l8;
            }
        }
        if (l7 < Integer.MIN_VALUE || l7 > Integer.MAX_VALUE) {
            this.scaleOutOfRange(l7);
        }
        if (n3 == -1) {
            bigInteger3 = bigInteger3.negate();
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.bi = bigInteger3;
        bigDecimal3.cachedScale = (int)l7;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 2;
        bigDecimal3.flags |= 4;
        bigDecimal3.flags &= 0xFFFFFF9F;
        bigDecimal3.flags |= n3 << 5 & 0x60;
        BigDecimal.postSetScaleProcessing(bigDecimal3);
        return bigDecimal3;
    }

    private final void slScaledDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        BigDecimal bigDecimal3 = null;
        if (bigDecimal.bi.signum() == 0) {
            if (this.bi.signum() == 0) {
                throw new ArithmeticException(Messages.getString("math.24"));
            }
            this.badDivideByZero();
        }
        if ((long)this.bi.signum() == 0L) {
            bigDecimal3 = bigDecimal2;
            bigDecimal3.bi = BigInteger.ZERO;
            bigDecimal3.cachedScale = n2;
            bigDecimal3.flags &= 0xFFFFFFFC;
            bigDecimal3.flags |= 2;
            bigDecimal3.flags |= 4;
            bigDecimal3.flags &= 0xFFFFFF9F;
            return;
        }
        int n3 = this.bi.signum() * bigDecimal.bi.signum();
        BigInteger bigInteger = this.bi.abs();
        BigInteger bigInteger2 = bigDecimal.bi.abs();
        long l = (long)this.cachedScale - (long)bigDecimal.cachedScale;
        long l2 = 0L;
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        long l3 = (long)bigDecimal.cachedScale + (long)n2;
        long l4 = (long)this.cachedScale - (long)n2;
        if (l < (long)n2) {
            l2 = (long)n2 - l;
            if (l2 > Integer.MAX_VALUE || l3 > Integer.MAX_VALUE || l4 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            } else if (l3 < Integer.MIN_VALUE) {
                throw new ArithmeticException(Messages.getString("math.22"));
            }
            bigInteger3 = bigInteger3.multiply(BigDecimal.powerOfTenBI(l2));
        } else if (l > (long)n2) {
            l2 = l - (long)n2;
            if (l2 > Integer.MAX_VALUE || l4 > Integer.MAX_VALUE || l3 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            } else if ((long)this.cachedScale - (long)n2 < Integer.MIN_VALUE || l3 < Integer.MIN_VALUE) {
                throw new ArithmeticException(Messages.getString("math.22"));
            }
            bigInteger4 = bigInteger4.multiply(BigDecimal.powerOfTenBI(l2));
        }
        BigInteger[] bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger4);
        BigInteger bigInteger5 = BigDecimal.roundPostSlowDivision(bigIntegerArray[0], n3, bigInteger4, bigIntegerArray[1], n);
        if (n3 == -1) {
            bigInteger5 = bigInteger5.negate();
        }
        bigDecimal3 = bigDecimal2;
        bigDecimal3.bi = bigInteger5;
        bigDecimal3.cachedScale = n2;
        bigDecimal3.flags &= 0xFFFFFFFC;
        bigDecimal3.flags |= 2;
        bigDecimal3.flags |= 4;
        bigDecimal3.flags &= 0xFFFFFF9F;
        bigDecimal3.flags |= n3 << 5 & 0x60;
        BigDecimal.postSetScaleProcessing(bigDecimal3);
    }

    public BigDecimal abs() {
        return this.abs(MathContext.UNLIMITED);
    }

    public BigDecimal abs(MathContext mathContext) {
        if (this.signum() < 0) {
            return this.negate(mathContext);
        }
        return this.plus(mathContext);
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        int n = this.compareTo(bigDecimal);
        if (n > 0) {
            return this.plus();
        }
        if (n == 0) {
            return this;
        }
        return bigDecimal.plus();
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        int n = this.compareTo(bigDecimal);
        if (n < 0) {
            return this.plus();
        }
        if (n == 0) {
            return this;
        }
        return bigDecimal.plus();
    }

    public BigDecimal negate() {
        return this.negate(MathContext.UNLIMITED);
    }

    public BigDecimal negate(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if (BigDecimal.DFPHWAvailable() && (bigDecimal.flags & 3) == 0) {
            this.DFPNegateHelper(bigDecimal);
        } else if ((this.flags & 3) == 2) {
            bigDecimal.bi = this.bi.negate();
        } else {
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal.DFPToLL();
            }
            bigDecimal.laside *= -1L;
            if (bigDecimal.bi != null) {
                bigDecimal.bi = bigDecimal.bi.negate();
            }
        }
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal;
    }

    public BigDecimal plus() {
        return this.plus(MathContext.UNLIMITED);
    }

    public BigDecimal plus(MathContext mathContext) {
        if (mathContext == MathContext.UNLIMITED) {
            return this;
        }
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal;
    }

    public byte byteValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((l = (long)bigDecimal.precision() - (long)bigDecimal.cachedScale) < 0L || l > 3L) {
            this.conversionOverflow(bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1) {
            if (bigDecimal.cachedScale > 0) {
                long l2 = BigDecimal.powerOfTenLL(bigDecimal.cachedScale);
                if (l2 != -1L) {
                    if (bigDecimal.laside % l2 != 0L) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                } else if (bigDecimal.laside != 0L) {
                    this.nonZeroDecimals(bigDecimal);
                }
            }
        } else {
            BigInteger bigInteger2;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.cachedScale > 0 && bigDecimal.bi.remainder(bigInteger2 = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                this.nonZeroDecimals(bigDecimal);
            }
        }
        if ((bigInteger = bigDecimal.toBigInteger()).compareTo(MAXBYTE) > 0 || bigInteger.compareTo(MINBYTE) < 0) {
            this.conversionOverflow(bigDecimal);
        }
        return bigInteger.byteValue();
    }

    public short shortValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((l = (long)bigDecimal.precision() - (long)bigDecimal.cachedScale) < 0L || l > 5L) {
            this.conversionOverflow(bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1) {
            if (bigDecimal.cachedScale > 0) {
                long l2 = BigDecimal.powerOfTenLL(bigDecimal.cachedScale);
                if (l2 != -1L) {
                    if (bigDecimal.laside % l2 != 0L) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                } else if (bigDecimal.laside != 0L) {
                    this.nonZeroDecimals(bigDecimal);
                }
            }
        } else {
            BigInteger bigInteger2;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.cachedScale > 0 && bigDecimal.bi.remainder(bigInteger2 = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                this.nonZeroDecimals(bigDecimal);
            }
        }
        if ((bigInteger = bigDecimal.toBigInteger()).compareTo(MAXSHORT) > 0 || bigInteger.compareTo(MINSHORT) < 0) {
            this.conversionOverflow(bigDecimal);
        }
        return bigInteger.shortValue();
    }

    public int intValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0;
        }
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((l = (long)bigDecimal.precision() - (long)bigDecimal.cachedScale) < 0L || l > 10L) {
            this.conversionOverflow(bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1) {
            if (bigDecimal.cachedScale > 0) {
                long l2 = BigDecimal.powerOfTenLL(bigDecimal.cachedScale);
                if (l2 != -1L) {
                    if (bigDecimal.laside % l2 != 0L) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                } else if (bigDecimal.laside != 0L) {
                    this.nonZeroDecimals(bigDecimal);
                }
            }
        } else {
            BigInteger bigInteger2;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.cachedScale > 0 && bigDecimal.bi.remainder(bigInteger2 = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                this.nonZeroDecimals(bigDecimal);
            }
        }
        if ((bigInteger = bigDecimal.toBigInteger()).compareTo(MAXINT) > 0 || bigInteger.compareTo(MININT) < 0) {
            this.conversionOverflow(bigDecimal);
        }
        return bigInteger.intValue();
    }

    public long longValueExact() {
        BigInteger bigInteger;
        long l;
        if (this.signum() == 0) {
            return 0L;
        }
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((l = (long)bigDecimal.precision() - (long)bigDecimal.cachedScale) < 0L || l > 19L) {
            this.conversionOverflow(bigDecimal);
        }
        if ((bigDecimal.flags & 1) == 1) {
            if (bigDecimal.cachedScale > 0) {
                long l2 = BigDecimal.powerOfTenLL(bigDecimal.cachedScale);
                if (l2 != -1L) {
                    if (bigDecimal.laside % l2 != 0L) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                } else if (bigDecimal.laside != 0L) {
                    this.nonZeroDecimals(bigDecimal);
                }
            }
        } else {
            BigInteger bigInteger2;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.cachedScale > 0 && bigDecimal.bi.remainder(bigInteger2 = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                this.nonZeroDecimals(bigDecimal);
            }
        }
        if ((bigInteger = bigDecimal.toBigInteger()).compareTo(MAXLONG) > 0 || bigInteger.compareTo(MINLONG) < 0) {
            this.conversionOverflow(bigDecimal);
        }
        return bigInteger.longValue();
    }

    public BigInteger toBigIntegerExact() {
        if (this.signum() == 0) {
            return BigInteger.valueOf(0L);
        }
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        if ((bigDecimal.flags & 1) == 1) {
            if (bigDecimal.cachedScale > 0) {
                long l = BigDecimal.powerOfTenLL(bigDecimal.cachedScale);
                if (l != -1L) {
                    if (bigDecimal.laside % l != 0L) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                } else {
                    BigInteger bigInteger;
                    BigInteger bigInteger2 = BigInteger.valueOf(bigDecimal.laside);
                    if (bigInteger2.remainder(bigInteger = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                        this.nonZeroDecimals(bigDecimal);
                    }
                }
            }
        } else {
            BigInteger bigInteger;
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.cachedScale > 0 && bigDecimal.bi.remainder(bigInteger = BigDecimal.powerOfTenBI(bigDecimal.cachedScale)).compareTo(BigInteger.ZERO) != 0) {
                this.nonZeroDecimals(bigDecimal);
            }
        }
        bigDecimal = bigDecimal.setScale(0);
        if ((bigDecimal.flags & 3) == 1) {
            return BigInteger.valueOf(bigDecimal.laside);
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
        }
        return bigDecimal.bi;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public BigInteger toBigInteger() {
        BigDecimal bigDecimal = this.setScale(0, RoundingMode.DOWN);
        if (bigDecimal == this) {
            bigDecimal = BigDecimal.clone(this);
        }
        if (BigDecimal.DFPHWAvailable() && (bigDecimal.flags & 3) == 0) {
            bigDecimal.DFPToLL();
        }
        if ((bigDecimal.flags & 1) == 1) {
            return BigInteger.valueOf(bigDecimal.laside);
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        return bigDecimal.bi;
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            long l = this.laside;
            long l2 = bigDecimal.laside;
            int n = this.cachedScale;
            int n2 = bigDecimal.cachedScale;
            if (n == n2 && l >> 63 == l2 >> 63) {
                long l3 = l - l2;
                return (int)(l3 >> 63) | (int)(-l3 >>> 63);
            }
        }
        return this.compareTo2(bigDecimal);
    }

    private int compareTo2(BigDecimal bigDecimal) {
        int n = 0;
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = bigDecimal;
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            bigDecimal2 = BigDecimal.clone(this);
            bigDecimal3 = BigDecimal.clone(bigDecimal);
            BigDecimal.postSetScaleProcessing(bigDecimal2);
            BigDecimal.postSetScaleProcessing(bigDecimal3);
        }
        if (BigDecimal.DFPHWAvailable() && ((bigDecimal2.flags | bigDecimal3.flags) & 3) == 0) {
            int n2 = BigDecimal.DFPCompareTo(bigDecimal2.laside, bigDecimal3.laside);
            if (n2 != -2) {
                return n2;
            }
            bigDecimal2 = BigDecimal.clone(bigDecimal2);
            bigDecimal2.DFPToLL();
            bigDecimal3 = BigDecimal.clone(bigDecimal3);
            bigDecimal3.DFPToLL();
            n = BigDecimal.longCompareTo(bigDecimal2, bigDecimal3);
            return n;
        }
        if ((bigDecimal2.flags & bigDecimal3.flags & 1) == 1) {
            long l = bigDecimal2.laside;
            long l2 = bigDecimal3.laside;
            int n3 = bigDecimal2.cachedScale;
            int n4 = bigDecimal3.cachedScale;
            if (n3 == n4) {
                if (this.laside > bigDecimal.laside) {
                    return 1;
                }
                if (this.laside < bigDecimal.laside) {
                    return -1;
                }
                return 0;
            }
            int n5 = (int)(l >> 63) | (int)(-l >>> 63);
            int n6 = (int)(l2 >> 63) | (int)(-l2 >>> 63);
            int n7 = n5 - n6;
            if (n7 != 0) {
                n = n7 > 0 ? 1 : -1;
                return n;
            }
            int n8 = bigDecimal2.flags;
            int n9 = bigDecimal3.flags;
            int n10 = -n3;
            int n11 = -n4;
            int n12 = 0;
            if ((n8 & 0x10) != 0) {
                n10 += (n8 & 0xFFFFFF80) >> 7;
            } else {
                n12 = BigDecimal.numDigits(l);
                n10 += n12;
                n8 |= 0x10;
                n8 &= 0x7F;
                bigDecimal2.flags = n8 |= n12 << 7;
            }
            if ((n9 & 0x10) != 0) {
                n11 += (n9 & 0xFFFFFF80) >> 7;
            } else {
                n12 = BigDecimal.numDigits(l2);
                n11 += n12;
                n9 |= 0x10;
                n9 &= 0x7F;
                bigDecimal3.flags = n9 |= n12 << 7;
            }
            if (n10 < n11) {
                n = -n5;
                return n;
            }
            if (n10 > n11) {
                n = n5;
                return n;
            }
            long l3 = 0L;
            BigInteger bigInteger = null;
            BigInteger bigInteger2 = null;
            if (n3 < n4) {
                l3 = (long)n4 - (long)n3;
                long l4 = BigDecimal.powerOfTenLL(l3);
                if (l4 != -1L) {
                    int n13;
                    int n14;
                    long l5 = l;
                    if (l5 < 0L) {
                        l5 *= -1L;
                    }
                    if ((n14 = Long.numberOfLeadingZeros(l5) - 1) + (n13 = Long.numberOfLeadingZeros(l4) - 1) >= 63) {
                        long l6 = (l *= l4) - l2;
                        n = (int)(l6 >> 63) | (int)(-l6 >>> 63);
                        return n;
                    }
                }
                bigInteger = BigInteger.valueOf(l);
                bigInteger2 = BigInteger.valueOf(l2);
                if (l3 > Integer.MAX_VALUE) {
                    BigDecimal.scaleOverflow();
                }
                bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(l3));
                n = bigInteger.compareTo(bigInteger2);
                return n;
            }
            if (n3 > n4) {
                l3 = n3 - n4;
                long l7 = BigDecimal.powerOfTenLL(l3);
                if (l7 != -1L) {
                    int n15;
                    int n16;
                    long l8 = l2;
                    if (l8 < 0L) {
                        l8 *= -1L;
                    }
                    if ((n16 = Long.numberOfLeadingZeros(l8) - 1) + (n15 = Long.numberOfLeadingZeros(l7) - 1) >= 63) {
                        long l9 = l - (l2 *= l7);
                        n = (int)(l9 >> 63) | (int)(-l9 >>> 63);
                        return n;
                    }
                }
                bigInteger = BigInteger.valueOf(l);
                bigInteger2 = BigInteger.valueOf(l2);
                if (l3 > Integer.MAX_VALUE) {
                    BigDecimal.scaleOverflow();
                }
                bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(l3));
                n = bigInteger.compareTo(bigInteger2);
                return n;
            }
            long l10 = l - l2;
            n = (int)(l10 >> 63) | (int)(-l10 >>> 63);
            return n;
        }
        bigDecimal2 = BigDecimal.clone(this);
        bigDecimal3 = BigDecimal.clone(bigDecimal);
        if ((bigDecimal2.flags & 3) == 0) {
            bigDecimal2.DFPToLL();
        }
        if ((bigDecimal3.flags & 3) == 0) {
            bigDecimal3.DFPToLL();
        }
        if ((bigDecimal2.flags & bigDecimal3.flags & 1) == 1) {
            n = BigDecimal.longCompareTo(bigDecimal2, bigDecimal3);
            return n;
        }
        if ((bigDecimal2.flags & 3) == 1) {
            bigDecimal2.LLToBI();
        }
        if ((bigDecimal3.flags & 3) == 1) {
            bigDecimal3.LLToBI();
        }
        n = BigDecimal.slCompareTo(bigDecimal2, bigDecimal3);
        return n;
    }

    private static final int longCompareTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        long l = bigDecimal.laside;
        int n = (int)(l >> 63) | (int)(-l >>> 63);
        long l2 = bigDecimal2.laside;
        int n2 = (int)(l2 >> 63) | (int)(-l2 >>> 63);
        int n3 = n - n2;
        if (n3 != 0) {
            return n3 > 0 ? 1 : -1;
        }
        int n4 = bigDecimal.cachedScale;
        int n5 = bigDecimal2.cachedScale;
        int n6 = bigDecimal.flags;
        int n7 = bigDecimal2.flags;
        int n8 = -n4;
        int n9 = -n5;
        int n10 = 0;
        if ((n6 & 0x10) != 0) {
            n8 += (n6 & 0xFFFFFF80) >> 7;
        } else {
            n10 = BigDecimal.numDigits(l);
            n8 += n10;
            n6 |= 0x10;
            n6 &= 0x7F;
            bigDecimal.flags = n6 |= n10 << 7;
        }
        if ((n7 & 0x10) != 0) {
            n9 += (n7 & 0xFFFFFF80) >> 7;
        } else {
            n10 = BigDecimal.numDigits(l2);
            n9 += n10;
            n7 |= 0x10;
            n7 &= 0x7F;
            bigDecimal2.flags = n7 |= n10 << 7;
        }
        if (n8 < n9) {
            return -n;
        }
        if (n8 > n9) {
            return n;
        }
        int n11 = 0;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (n4 < n5) {
            n11 = n5 - n4;
            long l3 = BigDecimal.powerOfTenLL(n11);
            if (l3 != -1L) {
                int n12;
                int n13;
                long l4 = l;
                if (l4 < 0L) {
                    l4 *= -1L;
                }
                if ((n13 = Long.numberOfLeadingZeros(l4) - 1) + (n12 = Long.numberOfLeadingZeros(l3) - 1) >= 63) {
                    long l5 = (l *= l3) - l2;
                    return (int)(l5 >> 63) | (int)(-l5 >>> 63);
                }
            }
            bigInteger = BigInteger.valueOf(l);
            bigInteger2 = BigInteger.valueOf(l2);
            if (n11 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(n11));
            return bigInteger.compareTo(bigInteger2);
        }
        if (n4 > n5) {
            n11 = n4 - n5;
            long l6 = BigDecimal.powerOfTenLL(n11);
            if (l6 != -1L) {
                int n14;
                int n15;
                long l7 = l2;
                if (l7 < 0L) {
                    l7 *= -1L;
                }
                if ((n15 = Long.numberOfLeadingZeros(l7) - 1) + (n14 = Long.numberOfLeadingZeros(l6) - 1) >= 63) {
                    long l8 = l - (l2 *= l6);
                    return (int)(l8 >> 63) | (int)(-l8 >>> 63);
                }
            }
            bigInteger = BigInteger.valueOf(l);
            bigInteger2 = BigInteger.valueOf(l2);
            if (n11 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(n11));
            return bigInteger.compareTo(bigInteger2);
        }
        long l9 = l - l2;
        return (int)(l9 >> 63) | (int)(-l9 >>> 63);
    }

    private static final int slCompareTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n;
        int n2;
        int n3 = bigDecimal.bi.signum();
        int n4 = n3 - (n2 = bigDecimal2.bi.signum());
        if (n4 != 0) {
            return n4 > 0 ? 1 : -1;
        }
        BigInteger bigInteger = bigDecimal.bi;
        BigInteger bigInteger2 = bigDecimal2.bi;
        int n5 = bigDecimal.cachedScale;
        int n6 = bigDecimal2.cachedScale;
        int n7 = bigDecimal.precision() - n5;
        if (n7 < (n = bigDecimal2.precision() - n6)) {
            return -n3;
        }
        if (n7 > n) {
            return n3;
        }
        int n8 = 0;
        if (n5 < n6) {
            n8 = n6 - n5;
            if (n8 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger = bigInteger.multiply(BigDecimal.powerOfTenBI(n8));
            return bigInteger.compareTo(bigInteger2);
        }
        if (n5 > n6) {
            n8 = n5 - n6;
            if (n8 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigInteger2 = bigInteger2.multiply(BigDecimal.powerOfTenBI(n8));
            return bigInteger.compareTo(bigInteger2);
        }
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return bigInteger3.signum();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (this == bigDecimal) {
            return true;
        }
        if ((this.flags & bigDecimal.flags & 1) == 1) {
            return this.laside == bigDecimal.laside && this.cachedScale == bigDecimal.cachedScale;
        }
        return this.unscaledValue().equals(bigDecimal.unscaledValue()) && this.scale() == bigDecimal.scale();
    }

    public int hashCode() {
        return this.unscaledValue().hashCode() ^ this.scale() << 16;
    }

    private int cachePrecision(BigDecimal bigDecimal, int n) {
        int n2 = BigDecimal.numDigits(bigDecimal.laside);
        n |= 0x10;
        n &= 0x7F;
        bigDecimal.flags = n |= n2 << 7;
        return n2;
    }

    public int precision() {
        int n = this.flags;
        if ((n & 0x10) != 0) {
            return (n & 0xFFFFFF80) >> 7;
        }
        if (BigDecimal.DFPHWAvailable() && (n & 3) == 0) {
            return this.DFPPrecisionHelper();
        }
        if ((this.flags & 3) == 2) {
            int n2 = BigDecimal.precisionBI(this.bi);
            if (n2 <= 0x1FFFFFF) {
                n |= 0x10;
                n &= 0x7F;
                n |= n2 << 7;
            }
            this.flags = n;
            return n2;
        }
        if ((this.flags & 3) == 0) {
            BigDecimal bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
            int n3 = BigDecimal.numDigits(bigDecimal.laside);
            return n3;
        }
        return this.cachePrecision(this, n);
    }

    private static final int precisionBI(BigInteger bigInteger) {
        String string = bigInteger.toString();
        if (bigInteger.signum() == -1) {
            return string.length() - 1;
        }
        return string.length();
    }

    public int scale() {
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if ((this.flags & 8) != 0) {
                return this.cachedScale;
            }
            int n = BigDecimal.DFPExponent(this.laside);
            this.cachedScale = n == 1000 ? -(BigDecimal.extractDFPExponent(this.laside) - 398) : -(n - 398);
            this.flags |= 8;
        }
        return this.cachedScale;
    }

    public int signum() {
        int n = this.flags;
        if (BigDecimal.DFPHWAvailable() && (n & 3) == 0) {
            return this.DFPSignumHelper();
        }
        if ((n & 3) == 1) {
            long l = this.laside;
            return (int)(l >> 63) | (int)(-l >>> 63);
        }
        if ((this.flags & 3) == 0) {
            BigDecimal bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
            return bigDecimal.bi.signum();
        }
        return this.bi.signum();
    }

    public BigDecimal ulp() {
        BigDecimal bigDecimal = new BigDecimal();
        bigDecimal.laside = 1L;
        bigDecimal.flags |= 1;
        bigDecimal.flags &= 0x7F;
        bigDecimal.flags |= 0x10;
        bigDecimal.flags |= 0x80;
        bigDecimal.cachedScale = this.scale();
        return bigDecimal;
    }

    public BigInteger unscaledValue() {
        if (this.bi != null) {
            return this.bi;
        }
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            return this.DFPUnscaledValueHelper();
        }
        if ((this.flags & 3) == 1) {
            this.bi = BigInteger.valueOf(this.laside);
            return this.bi;
        }
        BigDecimal bigDecimal = this;
        if ((this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
        }
        return bigDecimal.bi;
    }

    public BigDecimal pow(int n) {
        if (n < 0) {
            throw new ArithmeticException(Messages.getString("math.31", Integer.toString(n)));
        }
        return this.pow(n, MathContext.UNLIMITED);
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        int n2 = -999999999;
        int n3 = 999999999;
        int n4 = 0;
        BigDecimal bigDecimal = this;
        BigDecimal bigDecimal2 = null;
        int n5 = n;
        boolean bl = false;
        int n6 = 0;
        if (n > n3 || n < n2) {
            throw new ArithmeticException(Messages.getString("math.32", Integer.toString(n)));
        }
        if (mathContext.getPrecision() == 0 && n < 0) {
            throw new ArithmeticException(Messages.getString("math.31", Integer.toString(n)));
        }
        if (mathContext.getPrecision() > 0 && BigDecimal.numDigits(n) > mathContext.getPrecision()) {
            throw new ArithmeticException(Messages.getString("math.33", Integer.toString(n)));
        }
        if (n == 0) {
            return ONE;
        }
        if ((bigDecimal.flags & 2) == 2 || (bigDecimal.flags & 1) == 1) {
            if (bigDecimal.signum() == 0) {
                if (n >= 0) {
                    BigDecimal bigDecimal3 = BigDecimal.clone(this);
                    long l = (long)bigDecimal3.cachedScale * (long)n;
                    bigDecimal3.cachedScale = l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
                    return bigDecimal3;
                }
                this.badDivideByZero();
            }
        } else if (bigDecimal.signum() == 0) {
            if (n >= 0) {
                BigDecimal bigDecimal4 = BigDecimal.clone(this);
                bigDecimal4.DFPToLL();
                long l = (long)bigDecimal4.cachedScale * (long)n;
                bigDecimal4.cachedScale = l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
                return bigDecimal4;
            }
            this.badDivideByZero();
        }
        if (mathContext.getPrecision() > 0) {
            n4 = mathContext.getPrecision() + BigDecimal.numDigits(n) + 1;
        }
        MathContext mathContext2 = new MathContext(n4, mathContext.getRoundingMode());
        bigDecimal2 = new BigDecimal();
        bigDecimal2.bi = BigInteger.ONE;
        bigDecimal2.flags &= 0x7F;
        bigDecimal2.flags |= 0x10;
        bigDecimal2.flags |= 0x80;
        bigDecimal2.flags |= 2;
        BigDecimal bigDecimal5 = BigDecimal.clone(bigDecimal);
        if (BigDecimal.DFPHWAvailable() && (bigDecimal.flags & 3) == 0) {
            bigDecimal5.DFPToBI();
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        bl = false;
        n6 = 1;
        while (true) {
            if ((n5 += n5) < 0) {
                bl = true;
                bigDecimal2.longMultiply(bigDecimal5, null, mathContext2, true);
                if (BigDecimal.DFPHWAvailable() && (bigDecimal5.flags & 3) == 0) {
                    bigDecimal5.DFPToBI();
                }
                if (BigDecimal.DFPHWAvailable() && (bigDecimal2.flags & 3) == 0) {
                    bigDecimal2.DFPToBI();
                }
            }
            if (n6 == 31) break;
            if (bl) {
                bigDecimal2.longMultiply(bigDecimal2, null, mathContext2, true);
                if (BigDecimal.DFPHWAvailable() && (bigDecimal2.flags & 3) == 0) {
                    bigDecimal2.DFPToBI();
                }
            }
            n6 = (short)(n6 + 1);
        }
        if (n < 0) {
            bigDecimal2 = ONE.divide(bigDecimal2, mathContext2);
        }
        if (mathContext != MathContext.UNLIMITED) {
            bigDecimal2.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return bigDecimal2;
    }

    public BigDecimal movePointLeft(int n) {
        long l = 0L;
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if ((this.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        if ((l = (long)bigDecimal.scale() + (long)n) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                this.scaleOutOfRange(l);
            }
        }
        bigDecimal.cachedScale = (int)l;
        if (l < 0L) {
            return bigDecimal.setScale(0, true);
        }
        return bigDecimal;
    }

    public BigDecimal movePointRight(int n) {
        int n2 = 0;
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if ((this.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        long l = (long)bigDecimal.scale() - (long)n;
        n2 = (this.flags & 3) == 1 ? (int)(bigDecimal.laside >> 63) | (int)(-bigDecimal.laside >>> 63) : bigDecimal.bi.signum();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (n2 == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                this.scaleOutOfRange(l);
            }
        }
        bigDecimal.cachedScale = (int)l;
        if (l < 0L) {
            return bigDecimal.setScale(0, true);
        }
        return bigDecimal;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        long l;
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
        }
        if ((l = (long)bigDecimal.cachedScale - (long)n) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            if (this.signum() == 0) {
                l = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            } else {
                this.scaleOutOfRange(l);
            }
        }
        BigDecimal bigDecimal2 = BigDecimal.clone(bigDecimal);
        bigDecimal2.cachedScale = (int)l;
        return bigDecimal2;
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, false);
    }

    private BigDecimal setScale(int n, boolean bl) {
        BigDecimal bigDecimal = this;
        boolean bl2 = false;
        int n2 = this.scale();
        if (n2 == n) {
            return bigDecimal;
        }
        if (!bl) {
            bigDecimal = new BigDecimal();
            bl2 = true;
        }
        boolean bl3 = false;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if (this.DFPSetScaleHelper(bigDecimal, n)) {
                return bigDecimal;
            }
            bl3 = true;
        }
        if (bl3 || (this.flags & 3) == 2) {
            if (!bl2) {
                bigDecimal = new BigDecimal();
            }
            BigDecimal.clone(bigDecimal, this);
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal.DFPToBI();
            }
            if (bigDecimal.bi.signum() == 0) {
                bigDecimal.cachedScale = n;
                bigDecimal.flags &= 0xFFFFFFEF;
                return bigDecimal;
            }
            int n3 = bigDecimal.flags;
            if (n2 < n) {
                long l = (long)n - (long)n2;
                if (l > Integer.MAX_VALUE) {
                    BigDecimal.scaleOverflow();
                }
                bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
                bigDecimal.cachedScale = n;
                bigDecimal.flags = n3 &= 0xFFFFFFEF;
                return bigDecimal;
            }
            long l = (long)n2 - (long)n;
            if (l > (long)bigDecimal.precision()) {
                throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
            }
            l = Math.min((long)this.precision(), l);
            BigInteger[] bigIntegerArray = null;
            if (l > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            if ((bigIntegerArray = bigDecimal.bi.divideAndRemainder(BigDecimal.powerOfTenBI(l)))[1].signum() != 0) {
                throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
            }
            bigDecimal.bi = bigIntegerArray[0];
            bigDecimal.cachedScale = n;
            bigDecimal.flags = n3 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        if (!bl2) {
            bigDecimal = new BigDecimal();
        }
        BigDecimal.clone(bigDecimal, this);
        int n4 = bigDecimal.flags;
        int n5 = (int)(bigDecimal.laside >> 63) | (int)(-bigDecimal.laside >>> 63);
        if (n5 == 0) {
            bigDecimal.flags &= 0xFFFFFFEF;
            bigDecimal.cachedScale = n;
            return bigDecimal;
        }
        if (n2 < n) {
            int n6;
            int n7;
            long l = 0L;
            l = (long)n - (long)n2;
            if (l > 18L) {
                bigDecimal.LLToBI();
                if (l > Integer.MAX_VALUE) {
                    BigDecimal.scaleOverflow();
                }
                bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
                bigDecimal.cachedScale = n;
                n4 = bigDecimal.flags;
                bigDecimal.flags = n4 &= 0xFFFFFFEF;
                return bigDecimal;
            }
            long l2 = powersOfTenLL[(int)l];
            long l3 = bigDecimal.laside;
            if (l3 < 0L) {
                l3 *= -1L;
            }
            if ((n7 = Long.numberOfLeadingZeros(l3) - 1) + (n6 = Long.numberOfLeadingZeros(l2) - 1) >= 63) {
                bigDecimal.laside *= l2;
                bigDecimal.cachedScale = n;
                bigDecimal.flags = n4 &= 0xFFFFFFEF;
                bigDecimal.bi = null;
                return bigDecimal;
            }
            bigDecimal.LLToBI();
            if (l > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l));
            bigDecimal.cachedScale = n;
            n4 = bigDecimal.flags;
            bigDecimal.flags = n4 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        long l = (long)n2 - (long)n;
        int n8 = 0;
        if ((n4 & 0x10) != 0) {
            n8 = (n4 & 0xFFFFFF80) >> 7;
        } else {
            n8 = BigDecimal.numDigits(bigDecimal.laside);
            n4 |= 0x10;
            n4 &= 0x7F;
            bigDecimal.flags = n4 |= n8 << 7;
        }
        if (l > (long)n8) {
            throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
        }
        if (l > 18L) {
            if (bigDecimal.laside != 0L) {
                throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
            }
            bigDecimal.laside = 0L;
            bigDecimal.cachedScale = n;
            bigDecimal.flags = n4 &= 0xFFFFFFEF;
            return bigDecimal;
        }
        long l4 = bigDecimal.laside % powersOfTenLL[(int)l];
        if (l4 != 0L) {
            throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
        }
        bigDecimal.laside /= powersOfTenLL[(int)l];
        bigDecimal.cachedScale = n;
        bigDecimal.flags = n4 &= 0xFFFFFFEF;
        bigDecimal.bi = null;
        return bigDecimal;
    }

    public BigDecimal setScale(int n, RoundingMode roundingMode) {
        return this.setScale(n, roundingMode.ordinal());
    }

    public BigDecimal setScale(int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException(Messages.getString("math.27", Integer.toString(n2)));
        }
        long l = this.scale();
        if (l == (long)n) {
            return this;
        }
        BigDecimal bigDecimal = new BigDecimal();
        if (!BigDecimal.DFPHWAvailable() || (this.flags & 3) != 0) {
            BigDecimal.clone(bigDecimal, this);
            if ((this.flags & 3) != 2) {
                bigDecimal.bi = null;
            }
            if (bigDecimal.signum() == 0) {
                bigDecimal.cachedScale = n;
                bigDecimal.flags &= 0xFFFFFFEF;
                return bigDecimal;
            }
            boolean bl = false;
            if ((this.flags & 3) == 2) {
                bl = true;
            }
            if (l > (long)n) {
                bigDecimal = bigDecimal.divide(ONE, n, n2);
                bigDecimal.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(bigDecimal);
                return bigDecimal;
            }
            if (!bl) {
                long l2 = (long)n - l;
                if (l2 > 18L) {
                    bigDecimal.LLToBI();
                    if (l2 > Integer.MAX_VALUE) {
                        BigDecimal.scaleOverflow();
                    }
                    bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l2));
                    bigDecimal.cachedScale = n;
                } else {
                    int n3;
                    int n4;
                    long l3 = powersOfTenLL[(int)l2];
                    long l4 = bigDecimal.laside;
                    if (l4 < 0L) {
                        l4 *= -1L;
                    }
                    if ((n4 = Long.numberOfLeadingZeros(l4) - 1) + (n3 = Long.numberOfLeadingZeros(l3) - 1) >= 63) {
                        bigDecimal.laside *= l3;
                        bigDecimal.cachedScale = n;
                        bigDecimal.bi = null;
                    } else {
                        bigDecimal.LLToBI();
                        if (l2 > Integer.MAX_VALUE) {
                            BigDecimal.scaleOverflow();
                        }
                        bigDecimal.bi = bigDecimal.bi.multiply(BigDecimal.powerOfTenBI(l2));
                        bigDecimal.cachedScale = n;
                    }
                }
                bigDecimal.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(bigDecimal);
                return bigDecimal;
            }
        }
        return this.setScale2(n, n2, l, bigDecimal);
    }

    private BigDecimal setScale2(int n, int n2, long l, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            if (this.DFPSetScaleHelper(bigDecimal2, l, n, n2)) {
                return bigDecimal2;
            }
            bl3 = true;
        }
        if (bl3 || (this.flags & 3) == 2) {
            BigDecimal.clone(bigDecimal2, this);
            if (bl3 || (bigDecimal2.flags & 3) == 0) {
                bigDecimal2.DFPToBI();
            }
            bigDecimal2.flags &= 0xFFFFFFEF;
            if (bigDecimal2.bi.signum() == 0) {
                bigDecimal2.cachedScale = n;
                bigDecimal2.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(bigDecimal2);
                return bigDecimal2;
            }
            if (!bl3) {
                long l2 = (long)n - l;
                if (l2 > Integer.MAX_VALUE) {
                    BigDecimal.scaleOverflow();
                }
                bigDecimal2.bi = bigDecimal2.bi.multiply(BigDecimal.powerOfTenBI(l2));
                bigDecimal2.cachedScale = n;
                bigDecimal2.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(bigDecimal2);
                return bigDecimal2;
            }
            if (l > (long)n) {
                bigDecimal2 = bigDecimal2.divide(ONE, n, n2);
                bigDecimal2.flags &= 0xFFFFFFEF;
                BigDecimal.postSetScaleProcessing(bigDecimal2);
                return bigDecimal2;
            }
            long l3 = (long)n - l;
            if (l3 > Integer.MAX_VALUE) {
                BigDecimal.scaleOverflow();
            }
            bigDecimal2.bi = bigDecimal2.bi.multiply(BigDecimal.powerOfTenBI(l3));
            bigDecimal2.cachedScale = n;
            bigDecimal2.flags &= 0xFFFFFFEF;
            BigDecimal.postSetScaleProcessing(bigDecimal2);
            return bigDecimal2;
        }
        if ((this.flags & 3) == 1) {
            BigDecimal.clone(bigDecimal2, this);
            int n3 = (int)(bigDecimal2.laside >> 63) | (int)(-bigDecimal2.laside >>> 63);
            if (n3 == 0) {
                bigDecimal2.cachedScale = n;
                bigDecimal2.flags &= 0xFFFFFFEF;
            }
            BigDecimal.postSetScaleProcessing(bigDecimal2);
            return bigDecimal2;
        }
        return bigDecimal2;
    }

    private static final void postSetScaleProcessing(BigDecimal bigDecimal) {
        if ((!BigDecimal.DFPHWAvailable() || BigDecimal.DFPHWAvailable() && !BigDecimal.DFPUseDFP()) && (bigDecimal.flags & 3) == 2 && bigDecimal.bi.bitLength() < 63) {
            bigDecimal.BIToLL();
        }
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if ((bigDecimal.flags & 3) == 2 && bigDecimal.bi.compareTo(MAXDFP64) <= 0 && bigDecimal.bi.compareTo(MINDFP64) >= 0 && bigDecimal.cachedScale > -369 && bigDecimal.cachedScale < 398) {
                long l = bigDecimal.bi.longValue();
                if (bigDecimal.DFPLongExpConstructor(l, -bigDecimal.cachedScale + 398, 0, 0, 0, false)) {
                    bigDecimal.flags &= 0xFFFFFFFC;
                    bigDecimal.flags |= 8;
                    bigDecimal.flags |= 4;
                    bigDecimal.flags &= 0xFFFFFF9F;
                    bigDecimal.flags = bigDecimal.bi.signum() < 0 ? (bigDecimal.flags |= 0x60) : (bigDecimal.bi.signum() > 0 ? (bigDecimal.flags |= 0x20) : (bigDecimal.flags &= 0xFFFFFF9F));
                    bigDecimal.bi = null;
                }
            } else if ((bigDecimal.flags & 3) == 1 && bigDecimal.laside <= 9999999999999999L && bigDecimal.laside >= -9999999999999999L && bigDecimal.cachedScale > -369 && bigDecimal.cachedScale < 398) {
                int n = bigDecimal.signum();
                if (bigDecimal.DFPLongExpConstructor(bigDecimal.laside, -bigDecimal.cachedScale + 398, 0, 0, 0, false)) {
                    bigDecimal.flags &= 0xFFFFFFFC;
                    bigDecimal.flags |= 8;
                    bigDecimal.flags |= 4;
                    bigDecimal.flags &= 0xFFFFFF9F;
                    bigDecimal.flags = n < 0 ? (bigDecimal.flags |= 0x60) : (n > 0 ? (bigDecimal.flags |= 0x20) : (bigDecimal.flags &= 0xFFFFFF9F));
                }
            }
        }
    }

    public BigDecimal stripTrailingZeros() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal2 = BigDecimal.clone(this);
            bigDecimal2.DFPToLL();
            bigDecimal = bigDecimal2;
        } else {
            bigDecimal = BigDecimal.clone(bigDecimal2);
        }
        if (bigDecimal.signum() == 0) {
            return ZERO;
        }
        if ((bigDecimal2.flags & 3) == 1) {
            bigDecimal.flags &= 0xFFFFFFEF;
            int n = 0;
            long l = bigDecimal.laside;
            if (l < 0L) {
                l *= -1L;
            }
            if (l < Integer.MAX_VALUE) {
                int n2 = (int)l;
                byte by = 0;
                while ((by = (byte)(n2 - ((BigDecimal.uDivideByTen(n2) << 1) + (BigDecimal.uDivideByTen(n2) << 3)))) == 0) {
                    n2 = BigDecimal.uDivideByTen(n2);
                    ++n;
                }
                bigDecimal.laside = bigDecimal.laside < 0L ? (long)(-n2) : (long)n2;
            } else {
                byte by = 0;
                while ((by = (byte)(l - ((l / 10L << 1) + (l / 10L << 3)))) == 0) {
                    l /= 10L;
                    ++n;
                }
                bigDecimal.laside = bigDecimal.laside < 0L ? -l : l;
            }
            bigDecimal.cachedScale -= n;
            return bigDecimal;
        }
        if ((bigDecimal.flags & 3) == 0) {
            bigDecimal.DFPToBI();
        }
        bigDecimal.flags &= 0xFFFFFFEF;
        int n = 0;
        BigInteger bigInteger = bigDecimal.bi;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ONE;
        while ((bigInteger2 = (bigInteger3 = bigInteger).remainder(BigInteger.TEN)).signum() == 0) {
            ++n;
            bigInteger = bigInteger.divide(BigInteger.TEN);
        }
        bigDecimal.bi = bigInteger;
        bigDecimal.cachedScale -= n;
        return bigDecimal;
    }

    public String toString() {
        int n;
        long l;
        if ((this.flags & 1) == 1 && BigDecimal.longTest1(l = (long)(-this.cachedScale), n = this.precision())) {
            long l2 = this.laside >> 63 | -this.laside >>> 63;
            int n2 = 1 + n;
            if (BigDecimal.longTest2(l, n)) {
                if (l2 == -1L) {
                    ++n2;
                }
                char[] cArray = n2 <= 22 ? new char[23] : new char[n2];
                this.longString1(n2, (int)l2, cArray);
                return new String(cArray, 0, n2);
            }
            if (l2 == 0L && l == -2L) {
                return zeroDec;
            }
            int n3 = -((int)l) - n;
            return this.longString2(n2 += 1 + n3, n, (int)l2);
        }
        return this.toString2();
    }

    private static boolean longTest1(long l, int n) {
        return l < 0L && l >= (long)(-5 - n);
    }

    private static boolean longTest2(long l, int n) {
        return l > (long)(-n) && l >= -19L;
    }

    private void longString1(int n, int n2, char[] cArray) {
        long l = this.laside;
        long l2 = -this.cachedScale;
        byte by = 0;
        int n3 = 0;
        l = Math.abs(l);
        if (n2 == -1) {
            cArray[n3++] = 45;
        }
        int n4 = n - 1;
        if (l <= Integer.MAX_VALUE) {
            if (l2 == -2L) {
                int n5;
                int n6 = n5 = (int)l;
                by = (byte)(n6 - (n5 /= 100) * 100);
                char c = doubleDigitsOnes[by];
                char c2 = doubleDigitsTens[by];
                cArray[n4--] = c;
                cArray[n4--] = c2;
                cArray[n4--] = 46;
                while (n5 != 0) {
                    n6 = n5;
                    by = (byte)(n6 - (n5 /= 100) * 100);
                    c = doubleDigitsOnes[by];
                    c2 = doubleDigitsTens[by];
                    cArray[n4--] = c;
                    if (n4 >= n3) {
                        cArray[n4--] = c2;
                        continue;
                    }
                    break;
                }
            } else {
                int n7 = (int)((long)n - -l2 - 1L);
                int n8 = (int)l;
                while (n8 != 0) {
                    int n9 = n8;
                    by = (byte)(n9 - (n8 /= 100) * 100);
                    char c = doubleDigitsOnes[by];
                    char c3 = doubleDigitsTens[by];
                    if (n4 == n7) {
                        cArray[n4--] = 46;
                    }
                    cArray[n4--] = c;
                    if (n4 == n7) {
                        cArray[n4--] = 46;
                    }
                    if (n4 >= n3) {
                        cArray[n4--] = c3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            char c;
            char c4;
            int n10 = (int)((long)n - -l2 - 1L);
            while (l > Integer.MAX_VALUE) {
                long l3 = l;
                by = (byte)(l3 - (((l /= 100L) << 6) + (l << 5) + (l << 2)));
                c4 = doubleDigitsOnes[by];
                c = doubleDigitsTens[by];
                if (n4 == n10) {
                    cArray[n4--] = 46;
                }
                cArray[n4--] = c4;
                if (n4 == n10) {
                    cArray[n4--] = 46;
                }
                cArray[n4--] = c;
            }
            int n11 = (int)l;
            while (n11 != 0) {
                int n12 = n11;
                by = (byte)(n12 - (((n11 /= 100) << 6) + (n11 << 5) + (n11 << 2)));
                c4 = doubleDigitsOnes[by];
                c = doubleDigitsTens[by];
                if (n4 == n10) {
                    cArray[n4--] = 46;
                }
                cArray[n4--] = c4;
                if (n4 == n10) {
                    cArray[n4--] = 46;
                }
                if (n4 >= n3) {
                    cArray[n4--] = c;
                    continue;
                }
                break;
            }
        }
    }

    private String longString2(int n, int n2, int n3) {
        char[] cArray;
        block9: {
            long l = this.laside;
            long l2 = -this.cachedScale;
            int n4 = 0;
            long l3 = 0L;
            byte by = 0;
            if (n3 == -1) {
                ++n;
            }
            cArray = new char[n];
            Arrays.fill(cArray, 0, n, '0');
            if (n3 == -1) {
                cArray[n4++] = 45;
            }
            int n5 = ++n4;
            ++n4;
            cArray[n5] = 46;
            n4 = (int)((long)n4 + (-l2 - (long)n2));
            if (n3 == 0) break block9;
            l = Math.abs(l);
            int n6 = n - 1;
            if (l <= Integer.MAX_VALUE) {
                int n7 = (int)l;
                while (n7 != 0) {
                    int n8 = n7;
                    by = (byte)(n8 - (((n7 /= 100) << 6) + (n7 << 5) + (n7 << 2)));
                    char c = doubleDigitsOnes[by];
                    char c2 = doubleDigitsTens[by];
                    cArray[n6--] = c;
                    if (n6 >= n4) {
                        cArray[n6--] = c2;
                        continue;
                    }
                    break;
                }
            } else {
                char c;
                char c3;
                while (l > Integer.MAX_VALUE) {
                    l3 = l;
                    by = (byte)(l3 - (((l /= 100L) << 6) + (l << 5) + (l << 2)));
                    c3 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n6--] = c3;
                    cArray[n6--] = c;
                }
                int n9 = (int)l;
                while (n9 != 0) {
                    int n10 = n9;
                    by = (byte)(n10 - (((n9 /= 100) << 6) + (n9 << 5) + (n9 << 2)));
                    c3 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n6--] = c3;
                    if (n6 >= n4) {
                        cArray[n6--] = c;
                        continue;
                    }
                    break;
                }
            }
        }
        return new String(cArray, 0, n);
    }

    private String toString2() {
        long l;
        long l2 = 0L;
        int n = this.flags;
        int n2 = 0;
        if ((n & 1) == 1) {
            l2 = -this.cachedScale;
            l = this.laside;
            if ((n & 0x10) != 0) {
                n2 = (n & 0xFFFFFF80) >> 7;
            } else {
                n2 = BigDecimal.numDigits(l);
                n |= 0x10;
                n &= 0x7F;
                this.flags = n |= n2 << 7;
            }
            if (l2 < 0L && l2 >= (long)(-5 - n2)) {
                if (l2 > (long)(-n2) && l2 >= -19L) {
                    char c;
                    char c2;
                    int n3 = (int)(l >> 63) | (int)(-l >>> 63);
                    int n4 = 1 + n2;
                    int n5 = 0;
                    l = Math.abs(l);
                    if (n3 == -1) {
                        ++n4;
                    }
                    if (l2 == Integer.MIN_VALUE) {
                        l2 = -l2;
                    }
                    char[] cArray = n4 <= 22 ? (char[])thLocalToString.get() : new char[n4];
                    if (n3 == -1) {
                        cArray[n5++] = 45;
                    }
                    int n6 = (int)((long)n4 - -l2 - 1L);
                    byte by = 0;
                    int n7 = n4 - 1;
                    while (l > Integer.MAX_VALUE) {
                        long l3 = l;
                        by = (byte)(l3 - (((l /= 100L) << 6) + (l << 5) + (l << 2)));
                        c2 = doubleDigitsOnes[by];
                        c = doubleDigitsTens[by];
                        if (n7 == n6) {
                            cArray[n7--] = 46;
                        }
                        cArray[n7--] = c2;
                        if (n7 == n6) {
                            cArray[n7--] = 46;
                        }
                        cArray[n7--] = c;
                    }
                    int n8 = (int)l;
                    while (n8 != 0) {
                        int n9 = n8;
                        by = (byte)(n9 - (((n8 /= 100) << 6) + (n8 << 5) + (n8 << 2)));
                        c2 = doubleDigitsOnes[by];
                        c = doubleDigitsTens[by];
                        if (n7 == n6) {
                            cArray[n7--] = 46;
                        }
                        cArray[n7--] = c2;
                        if (n7 == n6) {
                            cArray[n7--] = 46;
                        }
                        if (n7 < n5) break;
                        cArray[n7--] = c;
                    }
                    return new String(cArray, 0, n4);
                }
                if (l2 != 0L) {
                    // empty if block
                }
            }
        }
        l2 = -((long)this.scale());
        if ((n & 1) == 1) {
            if ((n & 0x10) != 0) {
                n2 = (n & 0xFFFFFF80) >> 7;
            } else {
                n2 = BigDecimal.numDigits(this.laside);
                n |= 0x10;
                n &= 0x7F;
                this.flags = n |= n2 << 7;
            }
        } else {
            n2 = this.precision();
        }
        if (-l2 >= 0L && l2 >= (long)(-5 - n2)) {
            if (-l2 == 0L) {
                if (BigDecimal.DFPHWAvailable() && (n & 3) == 0) {
                    l = BigDecimal.DFPUnscaledValue(this.laside);
                    if (l == Long.MAX_VALUE) {
                        l = BigDecimal.DFPBCDDigits(this.laside);
                        if (l == 10L) {
                            l = BigDecimal.extractDFPDigitsBCD(this.laside);
                        }
                        long l4 = 0L;
                        int n10 = 0;
                        while (l != 0L) {
                            l4 += (l & 0xFL) * BigDecimal.powerOfTenLL(n10++);
                            l >>>= 4;
                        }
                        return Long.toString(l4 * (long)this.signum());
                    }
                    return Long.toString(l);
                }
                if ((n & 1) == 1) {
                    return Long.toString(this.laside);
                }
                BigDecimal bigDecimal = this;
                if ((n & 3) == 0) {
                    bigDecimal = BigDecimal.clone(this);
                    bigDecimal.DFPToBI();
                }
                return bigDecimal.bi.toString();
            }
            int n11 = 0;
            if (BigDecimal.DFPHWAvailable() && (n & 3) == 0) {
                n11 = this.signum();
                if (-l2 < (long)n2) {
                    int n12 = 1 + n2;
                    if (n11 == -1) {
                        ++n12;
                    }
                    return new String(this.prePaddedStringDFP(n11, n2), 0, n12);
                }
                int n13 = 2 - (int)l2;
                if (n11 == -1) {
                    ++n13;
                }
                return new String(this.prePaddedStringDFP(n11, n2), 0, n13);
            }
            if ((n & 1) == 1) {
                n11 = (int)(this.laside >> 63) | (int)(-this.laside >>> 63);
                int n14 = 2 - (int)l2;
                if (n11 == -1) {
                    ++n14;
                }
                return new String(this.prePaddedString(n11, n2), 0, n14);
            }
            BigDecimal bigDecimal = this;
            if ((n & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            n11 = bigDecimal.bi.signum();
            if (-l2 < (long)n2) {
                int n15 = 1 + n2;
                if (n11 == -1) {
                    ++n15;
                }
                return new String(bigDecimal.prePaddedString(n11, n2), 0, n15);
            }
            int n16 = 2 - (int)l2;
            if (n11 == -1) {
                ++n16;
            }
            return new String(bigDecimal.prePaddedString(n11, n2), 0, n16);
        }
        l = l2 + (long)n2 - 1L;
        int n17 = 0;
        if (this.signum() == -1) {
            ++n17;
        }
        ++n17;
        if (n2 > 1) {
            ++n17;
            n17 += n2 - 1;
        }
        ++n17;
        if (l2 != 0L) {
            ++n17;
        }
        int n18 = BigDecimal.numDigits(l);
        n17 += n18;
        if (BigDecimal.DFPHWAvailable() && (n & 3) == 0) {
            return new String(this.DFPToStringExp(n17), 0, n17);
        }
        if ((n & 1) == 1) {
            return new String(this.toStringExpLL(n17), 0, n17);
        }
        BigDecimal bigDecimal = this;
        if ((n & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToBI();
        }
        return new String(bigDecimal.toStringExpBI(n17), 0, n17);
    }

    private final char[] DFPToStringExp(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = BigDecimal.DFPBCDDigits(this.laside);
        if (l2 == 10L) {
            l2 = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        long l3 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l3);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        if (this.signum() == -1) {
            cArray[n5++] = 45;
        }
        cArray[n5++] = (char)(BigDecimal.digitAtBCD(l2, n3, 0) | 0x30);
        if (n3 > 1) {
            cArray[n5++] = 46;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                cArray[n5++] = (char)(BigDecimal.digitAtBCD(l2, n3, n2 + 1) | 0x30);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l3, n4, n2) | 0x30);
        }
        return cArray;
    }

    private final char[] toStringExpLL(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l2);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        if (this.signum() == -1) {
            cArray[n5++] = 45;
        }
        cArray[n5++] = (char)(BigDecimal.digitAt(this.laside, n3, 0) | 0x30);
        if (n3 > 1) {
            cArray[n5++] = 46;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                cArray[n5++] = (char)(BigDecimal.digitAt(this.laside, n3, n2 + 1) | 0x30);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l2, n4, n2) | 0x30);
        }
        return cArray;
    }

    private final char[] toStringExpBI(int n) {
        int n2;
        long l = -((long)this.scale());
        int n3 = this.precision();
        long l2 = l + (long)n3 - 1L;
        int n4 = BigDecimal.numDigits(l2);
        int n5 = 0;
        char[] cArray = n <= 22 ? (char[])thLocalToString.get() : new char[n];
        String string = this.bi.toString();
        int n6 = 0;
        if (this.bi.signum() == -1) {
            cArray[n5++] = 45;
        }
        if (this.bi.signum() >= 0) {
            cArray[n5++] = string.charAt(0);
            n6 = 0;
        } else {
            cArray[n5++] = string.charAt(1);
            n6 = 1;
        }
        if (n3 > 1) {
            cArray[n5++] = 46;
            if (this.bi.signum() < 0) {
                ++n3;
            }
            for (n2 = n6; n2 < n3 - 1; ++n2) {
                cArray[n5++] = string.charAt(n2 + 1);
            }
        }
        cArray[n5++] = 69;
        if (l > 0L) {
            cArray[n5++] = 43;
        } else if (l < 0L) {
            cArray[n5++] = 45;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n5++] = (char)(BigDecimal.digitAt(l2, n4, n2) | 0x30);
        }
        return cArray;
    }

    public String toEngineeringString() {
        boolean bl;
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        int n = bigDecimal.flags;
        long l = -((long)bigDecimal.cachedScale);
        if (l == Integer.MIN_VALUE) {
            l = -l;
        }
        int n2 = bigDecimal.precision();
        byte by = (byte)this.signum();
        if (-l >= 0L && l >= (long)(-5 - n2)) {
            if (-l == 0L) {
                if ((n & 1) == 1) {
                    return Long.toString(bigDecimal.laside);
                }
                if ((bigDecimal.flags & 3) == 0) {
                    bigDecimal = BigDecimal.clone(this);
                    bigDecimal.DFPToBI();
                }
                return bigDecimal.bi.toString();
            }
            if (-l < (long)n2) {
                if ((n & 1) == 1) {
                    long l2 = 1 + n2;
                    if (by == -1) {
                        ++l2;
                    }
                    return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l2);
                }
                if ((bigDecimal.flags & 3) == 0) {
                    bigDecimal = BigDecimal.clone(this);
                    bigDecimal.DFPToBI();
                }
                long l3 = 1 + n2;
                if (by == -1) {
                    ++l3;
                }
                return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l3);
            }
            long l4 = -l - (long)n2;
            if ((n & 1) == 1) {
                long l5 = 2L + l4 + (long)n2;
                if (by == -1) {
                    ++l5;
                }
                return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l5);
            }
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            long l6 = 2L + l4 + (long)n2;
            if (by == -1) {
                ++l6;
            }
            return new String(bigDecimal.prePaddedString(by, n2), 0, (int)l6);
        }
        long l7 = l + (long)bigDecimal.precision() - 1L;
        int n3 = (int)l7 % 3;
        boolean bl2 = bl = this.signum() == 0;
        if (bl) {
            int n4 = n3;
            if (n4 != 0) {
                if (n4 < 0) {
                    n3 = -n4 + 1;
                    l7 += (long)(-n4);
                } else {
                    n3 = 1 + (3 - n4);
                    l7 += (long)(3 - n4);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('0');
                if (n3 > 1) {
                    stringBuilder.append('.');
                }
                for (int i = n3 - 1; i > 0; --i) {
                    stringBuilder.append('0');
                }
                if (l7 < 0L) {
                    stringBuilder.append('E');
                    stringBuilder.append('-');
                    stringBuilder.append(-l7);
                } else if (l7 > 0L) {
                    stringBuilder.append('E');
                    stringBuilder.append('+');
                    stringBuilder.append(l7);
                }
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (l7 < 0L) {
                stringBuilder.append('0');
                stringBuilder.append('E');
                stringBuilder.append('-');
                stringBuilder.append(-l7);
                return stringBuilder.toString();
            }
            if (l7 > 0L) {
                stringBuilder.append('0');
                stringBuilder.append('E');
                stringBuilder.append('+');
                stringBuilder.append(l7);
                return stringBuilder.toString();
            }
            return "0";
        }
        if (n3 < 0) {
            n3 = 3 + n3;
        }
        l7 -= (long)n3;
        ++n3;
        int n5 = n2;
        char[] cArray = n5 <= 22 ? (char[])thLocalToString.get() : new char[n5];
        if ((n & 1) == 1) {
            int n6;
            long l8 = bigDecimal.laside;
            if (l8 < 0L) {
                l8 *= -1L;
            }
            byte by2 = 0;
            int n7 = n2;
            if (l8 <= Integer.MAX_VALUE) {
                int n8 = 0;
                int n9 = (int)l8;
                for (n6 = n7 - 1; n6 >= 0; --n6) {
                    n8 = n9;
                    n9 = BigDecimal.uDivideByTen(n9);
                    by2 = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                    cArray[n6] = (char)(by2 | 0x30);
                }
            } else {
                long l9 = 0L;
                for (n6 = n7 - 1; n6 >= 0; --n6) {
                    l9 = l8;
                    by2 = (byte)(l9 - (((l8 /= 10L) << 3) + (l8 << 1)));
                    cArray[n6] = (char)(by2 | 0x30);
                }
            }
        } else {
            if ((bigDecimal.flags & 3) == 0) {
                bigDecimal = BigDecimal.clone(this);
                bigDecimal.DFPToBI();
            }
            int n10 = 0;
            String string = bigDecimal.bi.abs().toString();
            for (n10 = 0; n10 < string.length(); ++n10) {
                cArray[n10] = (char)(string.charAt(n10) | 0x30);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.signum() == -1) {
            stringBuilder.append('-');
        }
        if (n3 >= n5) {
            stringBuilder.append(cArray, 0, n5);
            for (int i = n3 - n5; i > 0; --i) {
                stringBuilder.append('0');
            }
        } else {
            stringBuilder.append(cArray, 0, n3).append('.').append(cArray, n3, n5 - n3);
        }
        if (l7 < 0L) {
            stringBuilder.append('E');
            stringBuilder.append('-');
            stringBuilder.append(-l7);
        } else if (l7 > 0L) {
            stringBuilder.append('E');
            stringBuilder.append('+');
            stringBuilder.append(l7);
        }
        return stringBuilder.toString();
    }

    public String toPlainString() {
        String string;
        BigDecimal bigDecimal = this;
        if (BigDecimal.DFPHWAvailable() && (this.flags & 3) == 0) {
            bigDecimal = BigDecimal.clone(this);
            bigDecimal.DFPToLL();
        }
        byte by = (byte)this.signum();
        if (bigDecimal.cachedScale < 0) {
            bigDecimal = bigDecimal.setScale(0);
        }
        int n = bigDecimal.flags;
        if (bigDecimal.cachedScale == 0) {
            string = (n & 1) == 1 ? Long.toString(bigDecimal.laside) : bigDecimal.bi.toString();
        } else {
            int n2 = bigDecimal.precision();
            long l = -((long)bigDecimal.cachedScale);
            if (l == Integer.MIN_VALUE) {
                l = -l;
            }
            if (-l < (long)n2) {
                if ((n & 1) == 1) {
                    long l2 = 1 + n2;
                    if (by == -1) {
                        ++l2;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l2);
                } else {
                    if ((bigDecimal.flags & 3) == 0) {
                        bigDecimal = BigDecimal.clone(this);
                        bigDecimal.DFPToBI();
                    }
                    long l3 = 1 + n2;
                    if (by == -1) {
                        ++l3;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l3);
                }
            } else {
                long l4 = -l - (long)n2;
                if ((n & 1) == 1) {
                    long l5 = 2L + l4 + (long)n2;
                    if (by == -1) {
                        ++l5;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l5);
                } else {
                    if ((bigDecimal.flags & 3) == 0) {
                        bigDecimal = BigDecimal.clone(this);
                        bigDecimal.DFPToBI();
                    }
                    long l6 = 2L + l4 + (long)n2;
                    if (by == -1) {
                        ++l6;
                    }
                    string = new String(bigDecimal.prePaddedString(by, n2), 0, (int)l6);
                }
            }
        }
        return string;
    }

    private final char[] prePaddedStringDFP(int n, int n2) {
        char[] cArray;
        long l;
        int n3 = -this.scale();
        int n4 = 0;
        if (n == -1) {
            n4 = 1;
        }
        if ((l = BigDecimal.DFPBCDDigits(this.laside)) == 10L) {
            l = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        if (-n3 < n2) {
            int n5 = 0;
            int n6 = n4 + 1 + n2;
            cArray = n6 <= 22 ? (char[])thLocalToString.get() : new char[n6];
            int n7 = 0;
            int n8 = n6 - -n3 - 1;
            if (n4 != 0) {
                cArray[n7++] = 45;
            }
            int n9 = 0;
            for (n5 = n6 - 1; n5 > n8; --n5) {
                n9 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n5] = (char)(n9 | 0x30);
            }
            cArray[n5--] = 46;
            while (n5 >= n7) {
                n9 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n5] = (char)(n9 | 0x30);
                --n5;
            }
        } else {
            int n10 = -n3 - n2;
            int n11 = n4 + 1 + 1 + n10 + n2;
            cArray = n11 <= 22 ? (char[])thLocalToString.get() : new char[n11];
            int n12 = 0;
            int n13 = 0;
            Arrays.fill(cArray, 0, n11, '0');
            if (n4 != 0) {
                cArray[n12++] = 45;
            }
            int n14 = ++n12;
            ++n12;
            cArray[n14] = 46;
            n12 += -n3 - n2;
            int n15 = 0;
            for (n13 = n11 - 1; n13 >= n12; --n13) {
                n15 = (int)(l & 0xFL);
                l >>>= 4;
                cArray[n13] = (char)(n15 | 0x30);
            }
        }
        return cArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final char[] prePaddedString(int n, int n2) {
        char[] cArray;
        int n3 = 0;
        if (n == -1) {
            n3 = 1;
        }
        long l = -((long)this.cachedScale);
        int n4 = this.flags;
        if (-l < (long)n2) {
            if ((n4 & 3) == 1) {
                long l2 = n3 + 1 + n2;
                cArray = l2 <= 22L ? (char[])thLocalToString.get() : new char[(int)l2];
                int n5 = 0;
                int n6 = (int)(l2 - -l - 1L);
                if (n3 != 0) {
                    cArray[n5++] = 45;
                }
                long l3 = this.laside;
                l3 = Math.abs(l3);
                byte by = 0;
                int n7 = 0;
                if (l3 <= Integer.MAX_VALUE) {
                    int n8 = 0;
                    int n9 = (int)l3;
                    for (n7 = (int)(l2 - 1L); n7 > n6; --n7) {
                        n8 = n9;
                        n9 = BigDecimal.uDivideByTen(n9);
                        by = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                    }
                    cArray[n7--] = 46;
                    while (n7 >= n5) {
                        n8 = n9;
                        n9 = BigDecimal.uDivideByTen(n9);
                        by = (byte)(n8 - ((n9 << 3) + (n9 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                        --n7;
                    }
                    return cArray;
                } else {
                    long l4 = 0L;
                    for (n7 = (int)(l2 - 1L); n7 > n6; --n7) {
                        l4 = l3;
                        by = (byte)(l4 - (((l3 /= 10L) << 3) + (l3 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                    }
                    cArray[n7--] = 46;
                    while (n7 >= n5) {
                        l4 = l3;
                        by = (byte)(l4 - (((l3 /= 10L) << 3) + (l3 << 1)));
                        cArray[n7] = (char)(by | 0x30);
                        --n7;
                    }
                }
                return cArray;
            } else {
                long l5;
                String string = this.bi.toString();
                int n10 = string.length();
                if (n == -1) {
                    --n10;
                }
                cArray = (l5 = (long)(n3 + 1 + n10)) <= 22L ? (char[])thLocalToString.get() : new char[(int)l5];
                int n11 = 0;
                int n12 = (int)(l5 - -l - 1L);
                if (n3 != 0) {
                    cArray[n11++] = 45;
                }
                int n13 = 0;
                int n14 = string.length() - 1;
                for (n13 = (int)(l5 - 1L); n13 > n12; --n13) {
                    cArray[n13] = (char)(string.charAt(n14--) | 0x30);
                }
                cArray[n13--] = 46;
                while (n13 >= n11) {
                    cArray[n13] = (char)(string.charAt(n14--) | 0x30);
                    --n13;
                }
            }
            return cArray;
        } else {
            long l6 = -l - (long)n2;
            int n15 = 0;
            if ((n4 & 3) == 1) {
                char c;
                char c2;
                int n16 = n2;
                long l7 = (long)(n3 + 1 + 1) + l6 + (long)n16;
                cArray = l7 <= 22L ? (char[])thLocalToString.get() : new char[(int)l7];
                int n17 = 0;
                long l8 = 0L;
                byte by = 0;
                Arrays.fill(cArray, 0, (int)l7, '0');
                if (n3 != 0) {
                    cArray[n17++] = 45;
                }
                int n18 = ++n17;
                ++n17;
                cArray[n18] = 46;
                n17 = (int)((long)n17 + (-l - (long)n16));
                if (n == 0) return cArray;
                long l9 = this.laside;
                if (l9 < 0L) {
                    l9 *= -1L;
                }
                int n19 = (int)(l7 - 1L);
                while (l9 > Integer.MAX_VALUE) {
                    l8 = l9;
                    by = (byte)(l8 - (((l9 /= 100L) << 6) + (l9 << 5) + (l9 << 2)));
                    c2 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n19--] = c2;
                    cArray[n19--] = c;
                }
                int n20 = (int)l9;
                while (n20 != 0) {
                    int n21 = n20;
                    by = (byte)(n21 - (((n20 /= 100) << 6) + (n20 << 5) + (n20 << 2)));
                    c2 = doubleDigitsOnes[by];
                    c = doubleDigitsTens[by];
                    cArray[n19--] = c2;
                    if (n19 < n17) return cArray;
                    cArray[n19--] = c;
                }
                return cArray;
            } else {
                long l10;
                String string = this.bi.toString();
                int n22 = string.length();
                if (n == -1) {
                    --n22;
                }
                cArray = (l10 = (long)(n3 + 1 + 1) + l6 + (long)n22) <= 22L ? (char[])thLocalToString.get() : new char[(int)l10];
                int n23 = 0;
                Arrays.fill(cArray, 0, (int)l10, '0');
                if (n3 != 0) {
                    cArray[n23++] = 45;
                }
                int n24 = ++n23;
                ++n23;
                cArray[n24] = 46;
                n23 = (int)((long)n23 + (-l - (long)n22));
                if (n == 0) return cArray;
                int n25 = (int)(l10 - 1L);
                n15 = string.length() - 1;
                while (n25 >= n23) {
                    cArray[n25--] = string.charAt(n15--);
                }
            }
        }
        return cArray;
    }

    public static BigDecimal valueOf(double d) {
        return new BigDecimal(new Double(d).toString());
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public static BigDecimal valueOf(long l, int n) {
        BigDecimal bigDecimal;
        if (n == 0) {
            if (l == 0L) {
                return ZERO;
            }
            if (l == 1L) {
                return ONE;
            }
            if (l == 5L) {
                return FIVE;
            }
            if (l == 10L) {
                return TEN;
            }
        }
        if (n < 3 && l >= 0L && l < (long)CACHE1.length) {
            switch (n) {
                case 2: {
                    return CACHE2[(int)l];
                }
                case 1: {
                    return CACHE1[(int)l];
                }
            }
        }
        if (BigDecimal.DFPValueOfHelper(l, n, bigDecimal = new BigDecimal()) != null) {
            return bigDecimal;
        }
        BigDecimal.valueOf2BI(l, bigDecimal);
        bigDecimal.cachedScale = n;
        return bigDecimal;
    }

    private static void valueOf2BI(long l, BigDecimal bigDecimal) {
        if (l != Long.MIN_VALUE) {
            bigDecimal.flags |= 1;
            bigDecimal.laside = l;
        } else {
            bigDecimal.flags |= 2;
            bigDecimal.bi = BigInteger.valueOf(Long.MIN_VALUE);
        }
    }

    private static final void clone(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        bigDecimal.flags = bigDecimal2.flags;
        bigDecimal.cachedScale = bigDecimal2.cachedScale;
        bigDecimal.laside = bigDecimal2.laside;
        bigDecimal.bi = bigDecimal2.bi;
    }

    private static final BigDecimal clone(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal();
        bigDecimal2.flags = bigDecimal.flags;
        bigDecimal2.cachedScale = bigDecimal.cachedScale;
        bigDecimal2.laside = bigDecimal.laside;
        if ((bigDecimal.flags & 2) == 2) {
            bigDecimal2.bi = bigDecimal.bi;
        }
        return bigDecimal2;
    }

    public BigDecimal round(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.clone(this);
        if (mathContext.getPrecision() > 0) {
            if (BigDecimal.DFPHWAvailable() && (bigDecimal.flags & 3) == 0) {
                bigDecimal.DFPRoundHelper(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
            } else if ((bigDecimal.flags & 2) == 2) {
                bigDecimal.roundBI(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
            } else {
                if ((bigDecimal.flags & 3) == 0) {
                    bigDecimal.DFPToLL();
                }
                bigDecimal.roundLL(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal(), false);
            }
        }
        return bigDecimal;
    }

    private final void roundBI(long l, int n, boolean bl) {
        long l2 = 0L;
        long l3 = (long)this.precision() - l;
        if (l3 <= 0L) {
            return;
        }
        if (!bl && l == 0L) {
            return;
        }
        l2 = -((long)this.cachedScale) + l3;
        int n2 = this.bi.signum();
        BigInteger bigInteger = this.bi;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        int n3 = 0;
        if (l > 0L) {
            BigInteger[] bigIntegerArray = null;
            bigIntegerArray = bigInteger.divideAndRemainder(BigDecimal.powerOfTenBI(l3));
            this.bi = bigIntegerArray[0];
            bigInteger2 = bigIntegerArray[1];
            n3 = bigIntegerArray[1].divide(BigDecimal.powerOfTenBI(l3 - 1L)).byteValue();
            bigInteger3 = bigIntegerArray[1].remainder(BigDecimal.powerOfTenBI(l3 - 1L));
        } else {
            this.bi = BigInteger.ZERO;
            if (l == 0L) {
                bigInteger2 = bigInteger.remainder(BigDecimal.powerOfTenBI(l3));
                n3 = bigInteger2.divide(BigDecimal.powerOfTenBI(l3 - 1L)).byteValue();
                bigInteger3 = bigInteger2.remainder(BigDecimal.powerOfTenBI(l3 - 1L));
            } else {
                bigInteger2 = bigInteger;
                n3 = 0;
                bigInteger3 = bigInteger;
            }
        }
        if (n2 == -1) {
            n3 = (byte)(n3 * -1);
        }
        if (bigInteger3.signum() < 0) {
            bigInteger3 = bigInteger3.abs();
        }
        this.flags &= 0xFFFFFFEF;
        int n4 = 0;
        if (n == 4) {
            if (n3 >= 5) {
                n4 = n2;
            } else if (n3 == 5 && bigInteger3.signum() > 0) {
                n4 = n2;
            }
        } else if (n == 0) {
            if (bigInteger2.signum() != 0) {
                n4 = n2;
            }
        } else if (n != 1) {
            if (n == 2) {
                if (n2 == 1 && (n3 != 0 || bigInteger3.signum() != 0)) {
                    n4 = n2;
                }
            } else if (n == 3) {
                if (n2 == -1 && (n3 != 0 || bigInteger3.signum() != 0)) {
                    n4 = n2;
                }
            } else if (n == 5) {
                if (n3 > 5) {
                    n4 = n2;
                } else if (n3 == 5 && bigInteger3.signum() > 0) {
                    n4 = n2;
                }
            } else if (n == 6) {
                if (n3 > 5) {
                    n4 = n2;
                } else if (n3 == 5) {
                    if (bigInteger3.signum() != 0) {
                        n4 = n2;
                    } else if (this.bi.abs().remainder(BigInteger.TEN).byteValue() % 2 == 1) {
                        n4 = n2;
                    }
                }
            } else if (n == 7) {
                if (n3 != 0 || bigInteger3.signum() != 0) {
                    throw new ArithmeticException(Messages.getString("math.1B"));
                }
            } else {
                throw new IllegalArgumentException(Messages.getString("math.27", Integer.toString(n)));
            }
        }
        if (n4 != 0) {
            if (n2 == 0) {
                if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                    this.scaleOutOfRange(-l2);
                }
                this.bi = BigInteger.ONE;
                this.flags |= 4;
                this.flags &= 0x7F;
                this.flags |= 0x80;
                this.cachedScale = (int)(-l2);
            } else {
                BigInteger bigInteger4 = n4 == 1 ? this.bi.add(BigInteger.ONE) : this.bi.subtract(BigInteger.ONE);
                int n5 = BigDecimal.precisionBI(bigInteger4);
                if (this.precision() < n5) {
                    this.flags &= 0xFFFFFFEF;
                    ++l2;
                    bigInteger4 = bigInteger4.divide(BigInteger.TEN);
                }
                this.bi = bigInteger4;
                if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                    this.scaleOutOfRange(-l2);
                }
                this.cachedScale = (int)(-l2);
            }
        } else {
            if (-l2 < Integer.MIN_VALUE || -l2 > Integer.MAX_VALUE) {
                this.scaleOutOfRange(-l2);
            }
            this.cachedScale = (int)(-l2);
        }
        if (this.bi.bitLength() < 63) {
            this.BIToLL();
        }
    }

    private final void roundLL(long l, int n, boolean bl) {
        byte by = 0;
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = this.flags;
        if ((n4 & 0x10) != 0) {
            n3 = (n4 & 0xFFFFFF80) >> 7;
        } else {
            n3 = BigDecimal.numDigits(this.laside);
            n4 |= 0x10;
            n4 &= 0x7F;
            this.flags = n4 |= n3 << 7;
        }
        long l5 = (long)n3 - l;
        if (l5 <= 0L) {
            return;
        }
        if (!bl && l == 0L) {
            return;
        }
        l4 = -((long)this.cachedScale) + l5;
        long l6 = this.laside;
        int n5 = (int)(l6 >> 63) | (int)(-l6 >>> 63);
        if (n5 == -1) {
            l6 *= -1L;
        }
        if (l > 0L) {
            by = (byte)BigDecimal.digitAt(l6, n3, (int)l);
            l2 = l6 % BigDecimal.powerOfTenLL(l5 - 1L);
            this.laside = l6 / BigDecimal.powerOfTenLL(l5);
            this.flags &= 0x7F;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
        } else {
            this.laside = 0L;
            if (l == 0L) {
                by = (byte)BigDecimal.digitAt(l6, n3, 0);
                l2 = l6 % BigDecimal.powerOfTenLL(l5 - 1L);
            } else {
                by = 0;
                l2 = l6;
            }
            this.flags &= 0x7F;
            this.flags |= 0x80;
        }
        this.flags &= 0xFFFFFFEF;
        if (n == 4) {
            if (by >= 5) {
                n2 = n5;
            } else if (by == 5 && l2 != 0L) {
                n2 = n5;
            }
        } else if (n == 5) {
            if (by > 5) {
                n2 = n5;
            } else if (by == 5 && l2 != 0L) {
                n2 = n5;
            }
        } else if (n == 6) {
            if (by > 5) {
                n2 = n5;
            } else if (by == 5) {
                if (l2 != 0L) {
                    n2 = n5;
                } else if (BigDecimal.digitAt(this.laside, BigDecimal.numDigits(this.laside), BigDecimal.numDigits(this.laside) - 1) % 2 == 1) {
                    n2 = n5;
                }
            }
        } else if (n != 1) {
            if (n == 0) {
                if (by != 0 || l2 != 0L) {
                    n2 = n5;
                }
            } else if (n == 2) {
                if (n5 == 1 && (by != 0 || l2 != 0L)) {
                    n2 = n5;
                }
            } else if (n == 3) {
                if (n5 == -1 && (by != 0 || l2 != 0L)) {
                    n2 = n5;
                }
            } else if (n == 7) {
                if (by != 0 || l2 != 0L) {
                    throw new ArithmeticException(Messages.getString("math.1B"));
                }
            } else {
                throw new IllegalArgumentException(Messages.getString("math.27", Integer.toString(n)));
            }
        }
        if (n2 != 0) {
            if (n5 == 0) {
                this.laside = 1L;
                this.flags &= 0x7F;
                this.flags |= 0x80;
            } else {
                long l7;
                if (n5 == -1) {
                    n2 *= -1;
                }
                if (BigDecimal.overflowAdd(this.laside, n2, l7 = this.laside + (long)n2) == 0L) {
                    l3 = l7;
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.laside = l6;
                    this.LLToBI();
                    this.roundBI(l, n, bl);
                    return;
                }
                if (BigDecimal.numDigits(l3) > this.precision()) {
                    ++l4;
                    this.laside = Math.abs(l3) > Integer.MAX_VALUE ? l3 / 10L : (long)((int)l3 / 10);
                } else {
                    this.laside = l3;
                }
            }
        }
        if (-l4 < Integer.MIN_VALUE || -l4 > Integer.MAX_VALUE) {
            this.scaleOutOfRange(-l4);
        }
        this.cachedScale = (int)(-l4);
        this.flags &= 0x7F;
        this.flags |= BigDecimal.numDigits(this.laside) << 7;
        if (n5 == -1) {
            this.laside *= -1L;
        }
    }

    private static final long roundPostLLDivision(long l, int n, long l2, long l3, int n2) {
        if (n2 == 4) {
            if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                if (2L * l3 >= l2) {
                    long l4 = l + 1L;
                    if (BigDecimal.overflowAdd(l, 1L, l4) == 1L) {
                        return -1L;
                    }
                    l = l4;
                }
            } else {
                long l5 = l + 1L;
                if (BigDecimal.overflowAdd(l, 1L, l5) == 1L) {
                    return -1L;
                }
                l = l5;
            }
        } else if (n2 == 0) {
            if (l3 > 0L) {
                long l6 = l + 1L;
                if (BigDecimal.overflowAdd(l, 1L, l6) == 1L) {
                    return -1L;
                }
                l = l6;
            }
        } else if (n2 != 1) {
            if (n2 == 2) {
                if (l3 > 0L && n == 1) {
                    long l7 = l + 1L;
                    if (BigDecimal.overflowAdd(l, 1L, l7) == 1L) {
                        return -1L;
                    }
                    l = l7;
                }
            } else if (n2 == 3) {
                if (l3 > 0L && n == -1) {
                    long l8 = l + 1L;
                    if (BigDecimal.overflowAdd(l, 1L, l8) == 1L) {
                        return -1L;
                    }
                    l = l8;
                }
            } else if (n2 == 5) {
                if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * l3 > l2) {
                        long l9 = l + 1L;
                        if (BigDecimal.overflowAdd(l, 1L, l9) == 1L) {
                            return -1L;
                        }
                        l = l9;
                    }
                } else {
                    long l10 = l + 1L;
                    if (BigDecimal.overflowAdd(l, 1L, l10) == 1L) {
                        return -1L;
                    }
                    l = l10;
                }
            } else if (n2 == 6) {
                if (l3 < 0x3FFFFFFFFFFFFFFFL) {
                    if (2L * l3 > l2) {
                        long l11 = l + 1L;
                        if (BigDecimal.overflowAdd(l, 1L, l11) == 1L) {
                            return -1L;
                        }
                        l = l11;
                    } else if (2L * l3 >= l2 && l % 10L % 2L == 1L) {
                        long l12 = l + 1L;
                        if (BigDecimal.overflowAdd(l, 1L, l12) == 1L) {
                            return -1L;
                        }
                        l = l12;
                    }
                } else {
                    long l13 = l + 1L;
                    if (BigDecimal.overflowAdd(l, 1L, l13) == 1L) {
                        return -1L;
                    }
                    l = l13;
                }
            } else if (n2 == 7 && l3 != 0L) {
                throw new ArithmeticException(Messages.getString("math.30"));
            }
        }
        return l;
    }

    private static final BigInteger roundPostSlowDivision(BigInteger bigInteger, int n, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        if (n2 == 4) {
            if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) >= 0) {
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
        } else if (n2 == 0) {
            if (bigInteger3.signum() > 0) {
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
        } else if (n2 != 1) {
            if (n2 == 2) {
                if (bigInteger3.signum() > 0 && n == 1) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 3) {
                if (bigInteger3.signum() > 0 && n == -1) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 5) {
                if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) > 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 6) {
                if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) > 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                } else if (bigInteger3.shiftLeft(1).compareTo(bigInteger2) >= 0 && bigInteger.mod(BigInteger.TEN).mod(new BigInteger("2")).compareTo(BigInteger.ONE) == 0) {
                    bigInteger = bigInteger.add(BigInteger.ONE);
                }
            } else if (n2 == 7 && bigInteger3.signum() != 0) {
                throw new ArithmeticException(Messages.getString("math.30"));
            }
        }
        return bigInteger;
    }

    private static final boolean allzeroBCD(long l, int n) {
        long l2 = -1L;
        return ((l2 >>>= (64 - n) * 4) & l) == 0L;
    }

    private final void finish(int n, int n2) {
        if (n > 0 && this.precision() > n) {
            if ((this.flags & 3) == 0) {
                this.DFPRoundHelper(n, n2);
            } else if ((this.flags & 3) == 2) {
                this.roundBI(n, n2, false);
            } else {
                this.roundLL(n, n2, false);
            }
        }
    }

    private static final BigInteger powerOfTenBI(long l) {
        if (l >= 1000000L && l < Integer.MAX_VALUE) {
            throw new ArithmeticException(Messages.getString("math.1F", Long.toString(l)));
        }
        if (l > -1L && l <= 18L) {
            return powersOfTenBI[(int)l];
        }
        char[] cArray = new char[(int)l + 1];
        Arrays.fill(cArray, '0');
        cArray[0] = 49;
        return new BigInteger(new String(cArray));
    }

    private static final long powerOfTenLL(long l) {
        if (l > -1L && l <= 18L) {
            return powersOfTenLL[(int)l];
        }
        return -1L;
    }

    private static final long toLongForm(char[] cArray) {
        long l = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            l *= 10L;
            l += (long)(cArray[i] - 48);
        }
        return l;
    }

    private final void BIToLL() {
        this.flags &= 0xFFFFFFFC;
        this.flags |= 1;
        this.laside = this.bi.longValue();
        this.bi = null;
    }

    private final void LLToBI() {
        if ((this.flags & 3) == 1) {
            this.bi = BigInteger.valueOf(this.laside);
            this.flags &= 0x7F;
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(this.laside) << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private final void DFPToLL() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
            this.cachedScale = 0;
            this.laside = 0L;
            this.flags &= 0x7F;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            int n = this.DFPSignumHelper();
            this.cachedScale = this.scale();
            int n2 = this.DFPPrecisionHelper();
            this.flags &= 0x7F;
            this.flags &= 0xFFFFFFEF;
            this.flags |= 0x10;
            this.flags |= n2 << 7;
            long l = BigDecimal.DFPUnscaledValue(this.laside);
            if (l == Long.MAX_VALUE) {
                l = BigDecimal.DFPBCDDigits(this.laside);
                if (l == 10L) {
                    l = BigDecimal.extractDFPDigitsBCD(this.laside);
                }
                long l2 = 0L;
                int n3 = 0;
                while (l != 0L) {
                    l2 += (l & 0xFL) * BigDecimal.powerOfTenLL(n3++);
                    l >>>= 4;
                }
                this.laside = l2 * (long)n;
            } else {
                this.laside = l;
            }
            this.flags &= 0xFFFFFFFC;
            this.flags |= 1;
        }
        this.bi = null;
    }

    private final void DFPToBI() {
        if (this.laside == 2465720795985346560L) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
            this.cachedScale = 0;
            this.bi = BigInteger.ZERO;
            this.flags &= 0x7F;
            this.flags |= 0x10;
            this.flags |= 0x80;
        } else {
            this.cachedScale = this.scale();
            this.bi = this.DFPUnscaledValueHelper();
            int n = this.DFPPrecisionHelper();
            this.flags &= 0x7F;
            this.flags |= 0x10;
            this.flags |= n << 7;
            this.flags &= 0xFFFFFFFC;
            this.flags |= 2;
        }
    }

    private static final int numDigitsBI(int n) {
        if (n < 0) {
            return 10;
        }
        if (n < 1000000000) {
            if (n < 100000000) {
                if (n < 10000) {
                    if (n < 100) {
                        if (n < 10) {
                            return 1;
                        }
                        return 2;
                    }
                    if (n < 1000) {
                        return 3;
                    }
                    return 4;
                }
                if (n < 1000000) {
                    if (n < 100000) {
                        return 5;
                    }
                    return 6;
                }
                if (n < 10000000) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        return 10;
    }

    private static final int numDigits(long l) {
        if ((l = Math.abs(l)) < 1000000000L) {
            if (l < 100000000L) {
                if (l < 10000L) {
                    if (l < 100L) {
                        if (l < 10L) {
                            return 1;
                        }
                        return 2;
                    }
                    if (l < 1000L) {
                        return 3;
                    }
                    return 4;
                }
                if (l < 1000000L) {
                    if (l < 100000L) {
                        return 5;
                    }
                    return 6;
                }
                if (l < 10000000L) {
                    return 7;
                }
                return 8;
            }
            return 9;
        }
        if (l < 10000000000L) {
            return 10;
        }
        if (l < 100000000000000L) {
            if (l < 1000000000000L) {
                if (l < 100000000000L) {
                    return 11;
                }
                return 12;
            }
            if (l < 10000000000000L) {
                return 13;
            }
            return 14;
        }
        if (l < 10000000000000000L) {
            if (l < 1000000000000000L) {
                return 15;
            }
            return 16;
        }
        if (l < 100000000000000000L) {
            return 17;
        }
        if (l < 1000000000000000000L) {
            return 18;
        }
        return 19;
    }

    private static final int digitAt(long l, int n, int n2) {
        l = Math.abs(l);
        if (n2 > n - 1) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n - n2 - 1;
        if (l <= Integer.MAX_VALUE) {
            int n4 = (int)l;
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    n4 /= 10;
                    break;
                }
                case 2: {
                    n4 /= 100;
                    break;
                }
                case 3: {
                    n4 /= 1000;
                    break;
                }
                case 4: {
                    n4 /= 10000;
                    break;
                }
                case 5: {
                    n4 /= 100000;
                    break;
                }
                case 6: {
                    n4 /= 1000000;
                    break;
                }
                case 7: {
                    n4 /= 10000000;
                    break;
                }
                case 8: {
                    n4 /= 100000000;
                    break;
                }
                case 9: {
                    n4 /= 1000000000;
                    break;
                }
                case 10: {
                    n4 = (int)((long)n4 / 10000000000L);
                    break;
                }
                case 11: {
                    n4 = (int)((long)n4 / 100000000000L);
                    break;
                }
                case 12: {
                    n4 = (int)((long)n4 / 1000000000000L);
                    break;
                }
                case 13: {
                    n4 = (int)((long)n4 / 10000000000000L);
                    break;
                }
                case 14: {
                    n4 = (int)((long)n4 / 100000000000000L);
                    break;
                }
                case 15: {
                    n4 = (int)((long)n4 / 1000000000000000L);
                    break;
                }
                case 16: {
                    n4 = (int)((long)n4 / 10000000000000000L);
                    break;
                }
                case 17: {
                    n4 = (int)((long)n4 / 100000000000000000L);
                    break;
                }
                case 18: {
                    n4 = (int)((long)n4 / 1000000000000000000L);
                }
            }
            if (n4 <= Integer.MAX_VALUE) {
                int n5;
                int n6 = n5 = n4;
                n5 = BigDecimal.uDivideByTen(n5);
                return n6 - ((n5 << 3) + (n5 << 1));
            }
            long l2 = n4;
            return (int)(l2 - (long)(((n4 /= 10) << 3) + (n4 << 1)));
        }
        long l3 = l;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                l3 /= 10L;
                break;
            }
            case 2: {
                l3 /= 100L;
                break;
            }
            case 3: {
                l3 /= 1000L;
                break;
            }
            case 4: {
                l3 /= 10000L;
                break;
            }
            case 5: {
                l3 /= 100000L;
                break;
            }
            case 6: {
                l3 /= 1000000L;
                break;
            }
            case 7: {
                l3 /= 10000000L;
                break;
            }
            case 8: {
                l3 /= 100000000L;
                break;
            }
            case 9: {
                l3 /= 1000000000L;
                break;
            }
            case 10: {
                l3 /= 10000000000L;
                break;
            }
            case 11: {
                l3 /= 100000000000L;
                break;
            }
            case 12: {
                l3 /= 1000000000000L;
                break;
            }
            case 13: {
                l3 /= 10000000000000L;
                break;
            }
            case 14: {
                l3 /= 100000000000000L;
                break;
            }
            case 15: {
                l3 /= 1000000000000000L;
                break;
            }
            case 16: {
                l3 /= 10000000000000000L;
                break;
            }
            case 17: {
                l3 /= 100000000000000000L;
                break;
            }
            case 18: {
                l3 /= 1000000000000000000L;
            }
        }
        if (l3 <= Integer.MAX_VALUE) {
            int n7;
            int n8 = n7 = (int)l3;
            n7 = BigDecimal.uDivideByTen(n7);
            return n8 - ((n7 << 3) + (n7 << 1));
        }
        long l4 = l3;
        return (int)(l4 - (((l3 /= 10L) << 3) + (l3 << 1)));
    }

    private static final int digitAtBCD(long l, int n, int n2) {
        int n3 = n - n2 - 1;
        switch (n3) {
            case 0: {
                return (int)(l & 0xFL);
            }
            case 1: {
                return (int)((l & 0xF0L) >>> 4);
            }
            case 2: {
                return (int)((l & 0xF00L) >>> 8);
            }
            case 3: {
                return (int)((l & 0xF000L) >>> 12);
            }
            case 4: {
                return (int)((l & 0xF0000L) >>> 16);
            }
            case 5: {
                return (int)((l & 0xF00000L) >>> 20);
            }
            case 6: {
                return (int)((l & 0xF000000L) >>> 24);
            }
            case 7: {
                return (int)((l & 0xF0000000L) >>> 28);
            }
            case 8: {
                return (int)((l & 0xF00000000L) >>> 32);
            }
            case 9: {
                return (int)((l & 0xF000000000L) >>> 36);
            }
            case 10: {
                return (int)((l & 0xF0000000000L) >>> 40);
            }
            case 11: {
                return (int)((l & 0xF00000000000L) >> 44);
            }
            case 12: {
                return (int)((l & 0xF000000000000L) >>> 48);
            }
            case 13: {
                return (int)((l & 0xF0000000000000L) >>> 52);
            }
            case 14: {
                return (int)((l & 0xF00000000000000L) >>> 56);
            }
            case 15: {
                return (int)((l & 0xF000000000000000L) >>> 60);
            }
        }
        return 0;
    }

    private static final long overflowAdd(long l, long l2, long l3) {
        return ((l3 ^ l) & (l3 ^ l2)) >>> 63;
    }

    private static final boolean overflowMultiply(long l, long l2) {
        if (l < 0L) {
            l *= -1L;
        }
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if (l == 0L || l2 == 0L) {
            return false;
        }
        if (l == 1L || l2 == 1L) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        n = Long.numberOfLeadingZeros(l) - 1;
        return n + (n2 = Long.numberOfLeadingZeros(l2) - 1) < 63;
    }

    private static final int uDivideByTen(int n) {
        int n2 = (n >> 1) + (n >> 2);
        n2 += n2 >> 4;
        n2 += n2 >> 8;
        n2 += n2 >> 16;
        return n2 + ((n -= (n2 >>= 3) * 10) + 6 >> 4);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("scale", this.scale());
        putField.put("intVal", this.unscaledValue());
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        BigInteger bigInteger = (BigInteger)getField.get("intVal", null);
        int n = getField.get("scale", 0);
        if (bigInteger == null) {
            throw new IOException(Messages.getString("math.37"));
        }
        this.bigIntegerConstructor(bigInteger, n, MathContext.UNLIMITED);
    }

    private static final byte[] comboinit() {
        byte[] byArray = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 1, 5, 9, 13, 17, 21, 25, 29, 2, 6, 10, 14, 18, 22, 26, 30, 32, 36, 33, 37, 34, 38};
        return byArray;
    }

    private static final short[] dpd2bcdinit() {
        short[] sArray = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 128, 129, 2048, 2049, 2176, 2177, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 144, 145, 2064, 2065, 2192, 2193, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 130, 131, 2080, 2081, 2056, 2057, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 146, 147, 2096, 2097, 2072, 2073, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 132, 133, 2112, 2113, 136, 137, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 148, 149, 2128, 2129, 152, 153, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 134, 135, 2144, 2145, 2184, 2185, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 150, 151, 2160, 2161, 2200, 2201, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 384, 385, 2304, 2305, 2432, 2433, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 400, 401, 2320, 2321, 2448, 2449, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 386, 387, 2336, 2337, 2312, 2313, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 402, 403, 2352, 2353, 2328, 2329, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 388, 389, 2368, 2369, 392, 393, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 404, 405, 2384, 2385, 408, 409, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 390, 391, 2400, 2401, 2440, 2441, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 406, 407, 2416, 2417, 2456, 2457, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 640, 641, 2050, 2051, 2178, 2179, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 656, 657, 2066, 2067, 2194, 2195, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 642, 643, 2082, 2083, 2088, 2089, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 658, 659, 2098, 2099, 2104, 2105, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 644, 645, 2114, 2115, 648, 649, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 660, 661, 2130, 2131, 664, 665, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 646, 647, 2146, 2147, 2184, 2185, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 662, 663, 2162, 2163, 2200, 2201, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 896, 897, 2306, 2307, 2434, 2435, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 912, 913, 2322, 2323, 2450, 2451, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 898, 899, 2338, 2339, 2344, 2345, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 914, 915, 2354, 2355, 2360, 2361, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 900, 901, 2370, 2371, 904, 905, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 916, 917, 2386, 2387, 920, 921, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 902, 903, 2402, 2403, 2440, 2441, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 918, 919, 2418, 2419, 2456, 2457, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1152, 1153, 2052, 2053, 2180, 2181, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1168, 1169, 2068, 2069, 2196, 2197, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1154, 1155, 2084, 2085, 2120, 2121, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1170, 1171, 2100, 2101, 2136, 2137, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1156, 1157, 2116, 2117, 1160, 1161, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1172, 1173, 2132, 2133, 1176, 1177, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1158, 1159, 2148, 2149, 2184, 2185, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1174, 1175, 2164, 2165, 2200, 2201, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1408, 1409, 2308, 2309, 2436, 2437, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1424, 1425, 2324, 2325, 2452, 2453, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1410, 1411, 2340, 2341, 2376, 2377, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1426, 1427, 2356, 2357, 2392, 2393, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1412, 1413, 2372, 2373, 1416, 1417, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1428, 1429, 2388, 2389, 1432, 1433, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1414, 1415, 2404, 2405, 2440, 2441, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1430, 1431, 2420, 2421, 2456, 2457, 1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1664, 1665, 2054, 2055, 2182, 2183, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1680, 1681, 2070, 2071, 2198, 2199, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1666, 1667, 2086, 2087, 2152, 2153, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1682, 1683, 2102, 2103, 2168, 2169, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1668, 1669, 2118, 2119, 1672, 1673, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1684, 1685, 2134, 2135, 1688, 1689, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 1670, 1671, 2150, 2151, 2184, 2185, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1686, 1687, 2166, 2167, 2200, 2201, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1920, 1921, 2310, 2311, 2438, 2439, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1936, 1937, 2326, 2327, 2454, 2455, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1922, 1923, 2342, 2343, 2408, 2409, 1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848, 1849, 1938, 1939, 2358, 2359, 2424, 2425, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1924, 1925, 2374, 2375, 1928, 1929, 1872, 1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880, 1881, 1940, 1941, 2390, 2391, 1944, 1945, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896, 1897, 1926, 1927, 2406, 2407, 2440, 2441, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1942, 1943, 2422, 2423, 2456, 2457};
        return sArray;
    }

    private static final long extractDFPDigitsBCD(long l) {
        int n = 0;
        if (l == 2465720795985346560L) {
            return 0L;
        }
        n = (int)(l >>> 58);
        n &= 0x1F;
        long l2 = l & 0x3FFFFFFFFFFFFL;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < 5; ++i) {
            l4 = DPD2BCD[(int)((l2 & 0x3FF0000000000L) >>> 40)];
            l3 <<= 12;
            l3 |= l4;
            l2 <<= 10;
        }
        return l3 |= (long)(doubleDFPComboField[n] >>> 2) << 60;
    }

    private static final int extractDFPExponent(long l) {
        byte by = 0;
        by = (byte)(l >>> 58);
        by = (byte)(by & 0x1F);
        short s = (short)(l >>> 50);
        s = (short)(s & 0xFF);
        byte by2 = (byte)(doubleDFPComboField[by] & 3);
        short s2 = by2;
        s2 = (short)(s2 << 8);
        s2 = (short)(s2 | s);
        return s2;
    }

    private final void DFPConstructZero() {
        this.laside = 2465720795985346560L;
        this.flags |= 4;
        this.flags &= 0x7F;
        this.flags |= 0x10;
        this.flags |= 0x80;
        this.flags |= 8;
    }

    private final boolean isDFPZero() {
        if (this.laside == 2465720795985346560L) {
            return true;
        }
        return (this.laside & 0x3FFFFFFFFFFFFL) == 0L && (this.laside >>> 58 & 7L) == 0L;
    }

    private static final boolean DFPHWAvailable() {
        return DFP_HW_AVAILABLE;
    }

    private static final boolean DFPGetHWAvailable() {
        return false;
    }

    private static final boolean DFPPerformHysteresis() {
        return false;
    }

    private static final boolean DFPUseDFP() {
        return hys_type;
    }

    private final boolean DFPIntConstructor(int n, int n2, int n3, int n4) {
        return false;
    }

    private final boolean DFPLongConstructor(long l, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPLongExpConstructor(long l, int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    private final boolean DFPScaledAdd(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPAdd(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPScaledSubtract(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPSubtract(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final boolean DFPScaledMultiply(long l, long l2, int n) {
        return false;
    }

    private final boolean DFPMultiply(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    private final int DFPScaledDivide(long l, long l2, int n, int n2, int n3) {
        return -1;
    }

    private final int DFPDivide(long l, long l2, boolean bl, int n, int n2, int n3) {
        return -1;
    }

    private final boolean DFPRound(long l, int n, int n2) {
        return false;
    }

    private static final int DFPCompareTo(long l, long l2) {
        return -2;
    }

    private static final long DFPBCDDigits(long l) {
        return 10L;
    }

    private static final int DFPSignificance(long l) {
        return -1;
    }

    private static final int DFPExponent(long l) {
        return 1000;
    }

    private final int DFPSetScale(long l, int n, boolean bl, int n2, boolean bl2) {
        return -1;
    }

    private static final long DFPUnscaledValue(long l) {
        return Long.MAX_VALUE;
    }

    private final boolean DFPIntConstructorHelper(int n, MathContext mathContext) {
        if (n == 0) {
            this.DFPConstructZero();
            return true;
        }
        this.flags |= 8;
        this.flags |= 4;
        if (n < 0) {
            this.flags |= 0x60;
        } else if (n > 0) {
            this.flags |= 0x20;
        }
        int n2 = mathContext.getPrecision();
        int n3 = mathContext.getRoundingMode().ordinal();
        if (n2 == 16 && n3 == 6 && this.DFPIntConstructor(n, 64, 0, 0)) {
            this.flags |= 0x10;
            this.flags |= BigDecimal.numDigits(n) << 7;
            return true;
        }
        if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
            if (this.DFPIntConstructor(n, 0, 0, 0)) {
                if (n2 > 0 && n3 == 7) {
                    this.finish(n2, n3);
                } else {
                    this.flags |= 0x10;
                    this.flags |= BigDecimal.numDigits(n) << 7;
                }
                return true;
            }
        } else if (n2 <= 16) {
            if (n3 == 6) {
                n3 = 0;
            } else if (n3 == 0) {
                n3 = 6;
            }
            if (this.DFPIntConstructor(n, 1, n2, n3)) {
                this.flags &= 0xFFFFFFF7;
                return true;
            }
        }
        return false;
    }

    private final boolean DFPLongConstructorHelper(long l, int n, MathContext mathContext) {
        if (l == 0L) {
            this.DFPConstructZero();
            return true;
        }
        if (l <= 9999999999999999L && l >= -9999999999999999L && -n >= -398 && -n < 369) {
            this.flags |= 4;
            if (l < 0L) {
                this.flags |= 0x60;
            } else if (l > 0L) {
                this.flags |= 0x20;
            }
            int n2 = mathContext.getPrecision();
            int n3 = mathContext.getRoundingMode().ordinal();
            if (n2 == 16 && n3 == 6 && this.DFPLongExpConstructor(l, -n + 398, 64, 0, 0, false)) {
                this.flags |= 0x10;
                this.flags |= BigDecimal.numDigits(l) << 7;
                this.flags |= 8;
                this.cachedScale = n;
                return true;
            }
            if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
                if (this.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false)) {
                    if (n2 > 0 && n3 == 7) {
                        this.finish(n2, n3);
                    } else {
                        this.flags |= 8;
                        this.cachedScale = n;
                        this.flags |= 0x10;
                        this.flags |= BigDecimal.numDigits(l) << 7;
                    }
                    return true;
                }
            } else if (n2 <= 16) {
                if (n3 == 6) {
                    n3 = 0;
                } else if (n3 == 0) {
                    n3 = 6;
                }
                if (this.DFPLongExpConstructor(l, -n + 398, 1, n2, n3, false)) {
                    this.flags &= 0xFFFFFFF7;
                    return true;
                }
            }
        }
        this.flags |= 2;
        this.bi = BigInteger.valueOf(l);
        this.cachedScale = n;
        return false;
    }

    private final boolean DFPCharConstructorHelper(long l, int n, int n2, int n3, MathContext mathContext) {
        int n4 = mathContext.getPrecision();
        int n5 = mathContext.getRoundingMode().ordinal();
        if (l == 0L && n == 0) {
            this.DFPConstructZero();
            return true;
        }
        this.flags |= 4;
        if (l != 0L) {
            this.flags |= n2;
        }
        this.flags |= 8;
        this.cachedScale = -n;
        if (n4 == 16 && n5 == 6) {
            if (n2 == 96) {
                if (this.DFPLongExpConstructor(l, n + 398, 64, 0, 0, true)) {
                    if (n2 == 96) {
                        this.laside |= Long.MIN_VALUE;
                    }
                    this.flags |= 0x10;
                    this.flags |= n3 << 7;
                    this.finish(n4, n5);
                    return true;
                }
            } else if (this.DFPLongExpConstructor(l, n + 398, 64, 0, 0, true)) {
                this.flags |= 0x10;
                this.flags |= n3 << 7;
                return true;
            }
        }
        if (n4 == 0 || n4 > 0 && n5 == 7 || n4 > 16) {
            if (this.DFPLongExpConstructor(l, n + 398, 0, 0, 0, true)) {
                if (n2 == 96) {
                    this.laside |= Long.MIN_VALUE;
                }
                if (n4 > 0 && n5 == 7) {
                    if (n2 == 96) {
                        this.laside |= Long.MIN_VALUE;
                    }
                    this.finish(n4, n5);
                } else {
                    this.flags |= 0x10;
                    this.flags |= n3 << 7;
                }
                return true;
            }
        } else if (n4 <= 16) {
            if (n2 == 96) {
                if (this.DFPLongExpConstructor(l, n + 398, 0, 0, 0, true)) {
                    this.laside |= Long.MIN_VALUE;
                    this.finish(n4, n5);
                    return true;
                }
            } else {
                if (n5 == 6) {
                    n5 = 0;
                } else if (n5 == 0) {
                    n5 = 6;
                }
                if (this.DFPLongExpConstructor(l, n + 398, 1, n4, n5, true)) {
                    this.flags &= 0xFFFFFFF7;
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean DFPBigIntegerConstructorHelper(BigInteger bigInteger, int n, MathContext mathContext) {
        if (BigDecimal.precisionBI(bigInteger) < 17 && -n <= 369 && -n >= -398) {
            long l = bigInteger.longValue();
            if (l == 0L && n == 0) {
                this.DFPConstructZero();
                return true;
            }
            int n2 = mathContext.getPrecision();
            int n3 = mathContext.getRoundingMode().ordinal();
            if (n2 == 16 && n3 == 6 && this.DFPLongExpConstructor(l, -n + 398, 64, 0, 0, false)) {
                this.flags |= 0x10;
                this.flags |= BigDecimal.numDigits(l) << 7;
                this.flags |= 4;
                this.flags |= bigInteger.signum() << 5 & 0x60;
                this.flags |= 8;
                this.cachedScale = n;
                return true;
            }
            if (n2 == 0 || n2 > 0 && n3 == 7 || n2 > 16) {
                if (this.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false)) {
                    this.flags |= 4;
                    this.flags |= bigInteger.signum() << 5 & 0x60;
                    if (n2 > 0 && n3 == 7) {
                        this.finish(n2, n3);
                    } else {
                        this.flags |= 0x10;
                        this.flags |= BigDecimal.numDigits(l) << 7;
                        this.flags |= 8;
                        this.cachedScale = n;
                    }
                    return true;
                }
            } else if (n2 <= 16) {
                if (n3 == 6) {
                    n3 = 0;
                } else if (n3 == 0) {
                    n3 = 6;
                }
                if (this.DFPLongExpConstructor(l, -n + 398, 1, n2, n3, false)) {
                    this.flags |= 4;
                    this.flags |= bigInteger.signum() << 5 & 0x60;
                    return true;
                }
            }
        }
        this.flags |= 2;
        this.bi = bigInteger;
        this.cachedScale = n;
        if (mathContext != MathContext.UNLIMITED) {
            this.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
        }
        return false;
    }

    private final boolean DFPAddHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n;
        if (((this.flags | bigDecimal2.flags) & 3) == 0 && (n = -Math.max(this.scale(), bigDecimal2.scale())) >= -398 && n <= 369 && bigDecimal.DFPScaledAdd(bigDecimal2.laside, this.laside, n + 398)) {
            if (bigDecimal.isDFPZero()) {
                bigDecimal.laside &= Long.MAX_VALUE;
            }
            return true;
        }
        return false;
    }

    private final boolean DFPAddHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        int n;
        boolean bl = false;
        int n2 = mathContext.getPrecision();
        int n3 = mathContext.getRoundingMode().ordinal();
        if (n2 != 0 && mathContext.getRoundingMode().ordinal() != 7) {
            n = this.isDFPZero();
            boolean bl2 = bigDecimal2.isDFPZero();
            if (n != 0 && bl2) {
                BigDecimal.clone(bigDecimal, BigDecimal.valueOf(0L, Math.max(this.scale(), bigDecimal2.scale())));
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
            if (n != 0) {
                BigDecimal.clone(bigDecimal, bigDecimal2);
                if (this.scale() > bigDecimal2.scale() && mathContext.getPrecision() - bigDecimal2.precision() > 0) {
                    BigDecimal.clone(bigDecimal, bigDecimal.setScale(Math.abs(-this.scale()), true));
                }
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
            if (bl2) {
                BigDecimal.clone(bigDecimal, this);
                if (bigDecimal2.scale() > this.scale() && mathContext.getPrecision() - bigDecimal2.precision() > 0) {
                    BigDecimal.clone(bigDecimal, bigDecimal.setScale(Math.abs(-bigDecimal2.scale()), true));
                }
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
        }
        if (n2 == 16 && n3 == 6) {
            if (bigDecimal.DFPAdd(bigDecimal2.laside, this.laside, 64, 0, 0)) {
                bl = true;
            }
        } else if (n2 == 0) {
            n = -Math.max(this.scale(), bigDecimal2.scale());
            if (n >= -398 && n <= 369 && bigDecimal.DFPScaledAdd(bigDecimal2.laside, this.laside, n + 398)) {
                bl = true;
            }
        } else if (n2 > 0 && n3 == 7) {
            if (bigDecimal.DFPAdd(bigDecimal2.laside, this.laside, 0, 0, 0)) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    this.DFPPerformHysteresis(-3);
                }
                bigDecimal.finish(n2, n3);
                bl = true;
            }
        } else if (n2 <= 16) {
            if (n3 == 6) {
                n3 = 0;
            } else if (n3 == 0) {
                n3 = 6;
            }
            n = (n2 == 16 ? bigDecimal.DFPAdd(bigDecimal2.laside, this.laside, 1, 16, n3) : bigDecimal.DFPAdd(bigDecimal2.laside, this.laside, 1, n2, n3)) ? 1 : 0;
            if (n != 0) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    this.DFPPerformHysteresis(-3);
                }
                bl = true;
            }
        }
        if (bl) {
            if (bigDecimal.isDFPZero()) {
                bigDecimal.laside &= Long.MAX_VALUE;
            }
            return true;
        }
        return false;
    }

    private boolean DFPSubtractHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n;
        if (((this.flags | bigDecimal2.flags) & 3) == 0 && (n = -Math.max(this.scale(), bigDecimal2.scale())) >= -398 && n <= 369 && bigDecimal.DFPScaledSubtract(bigDecimal2.laside, this.laside, n + 398)) {
            if (bigDecimal.isDFPZero()) {
                bigDecimal.laside &= Long.MAX_VALUE;
            }
            return true;
        }
        return false;
    }

    private final boolean DFPSubtractHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        int n;
        int n2;
        boolean bl = false;
        int n3 = mathContext.getPrecision();
        int n4 = mathContext.getRoundingMode().ordinal();
        if (n3 != 0 && mathContext.getRoundingMode().ordinal() != 7) {
            n2 = this.isDFPZero();
            n = bigDecimal2.isDFPZero();
            if (n2 != 0 && n != 0) {
                BigDecimal.clone(bigDecimal, BigDecimal.valueOf(0L, Math.max(this.scale(), bigDecimal2.scale())));
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
            if (n2 != 0) {
                BigDecimal.clone(bigDecimal, bigDecimal2.negate());
                if (this.scale() > bigDecimal2.scale() && mathContext.getPrecision() - bigDecimal2.precision() > 0) {
                    BigDecimal.clone(bigDecimal, bigDecimal.setScale(Math.abs(-this.scale()), true));
                }
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
            if (n != 0) {
                BigDecimal.clone(bigDecimal, this);
                if (bigDecimal2.scale() > this.scale() && mathContext.getPrecision() - bigDecimal2.precision() > 0) {
                    BigDecimal.clone(bigDecimal, bigDecimal.setScale(Math.abs(-bigDecimal2.scale()), true));
                }
                if (mathContext != MathContext.UNLIMITED) {
                    bigDecimal.finish(mathContext.getPrecision(), mathContext.getRoundingMode().ordinal());
                }
                return true;
            }
        }
        if (n3 == 16 && n4 == 6) {
            if (bigDecimal.DFPSubtract(bigDecimal2.laside, this.laside, 64, 0, 0)) {
                bl = true;
            }
        } else if (n3 == 0) {
            n2 = -Math.max(this.scale(), bigDecimal2.scale());
            if (n2 >= -398 && n2 <= 369 && bigDecimal.DFPScaledSubtract(bigDecimal2.laside, this.laside, n2 + 398)) {
                bl = true;
            }
        } else if (n3 > 0 && n4 == 7) {
            if (bigDecimal.DFPSubtract(bigDecimal2.laside, this.laside, 0, 0, 0)) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    if ((hys_counter += 0xFFFFFFFD & ~((((n2 = hys_counter - 3) ^ 0xFFFFFFFD) & (n2 ^ hys_counter)) >>> 31)) < -1000) {
                        hys_type = false;
                        hys_counter = 0;
                    } else if (hys_counter > 1000) {
                        hys_type = true;
                        hys_counter = 0;
                    }
                }
                bigDecimal.finish(n3, n4);
                bl = true;
            }
        } else if (n3 <= 16) {
            if (n4 == 6) {
                n4 = 0;
            } else if (n4 == 0) {
                n4 = 6;
            }
            n2 = (n3 == 16 ? bigDecimal.DFPSubtract(bigDecimal2.laside, this.laside, 1, 16, n4) : bigDecimal.DFPSubtract(bigDecimal2.laside, this.laside, 1, n3, n4)) ? 1 : 0;
            if (n2 != 0) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    if ((hys_counter += 0xFFFFFFFD & ~((((n = hys_counter - 3) ^ 0xFFFFFFFD) & (n ^ hys_counter)) >>> 31)) < -1000) {
                        hys_type = false;
                        hys_counter = 0;
                    } else if (hys_counter > 1000) {
                        hys_type = true;
                        hys_counter = 0;
                    }
                }
                bl = true;
            }
        }
        if (bl) {
            if (bigDecimal.isDFPZero()) {
                bigDecimal.laside &= Long.MAX_VALUE;
            }
            return true;
        }
        return false;
    }

    private final boolean DFPMultiplyHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n = -(this.scale() + bigDecimal2.scale());
        if (n >= -398 && n <= 369 && bigDecimal.DFPScaledMultiply(bigDecimal2.laside, this.laside, n + 398)) {
            if (bigDecimal.isDFPZero()) {
                bigDecimal.laside &= Long.MAX_VALUE;
            }
            return true;
        }
        return false;
    }

    private final boolean DFPMultiplyHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        boolean bl = false;
        int n = mathContext.getPrecision();
        int n2 = mathContext.getRoundingMode().ordinal();
        if (n == 16 && n2 == 6) {
            if (bigDecimal.DFPMultiply(bigDecimal2.laside, this.laside, 64, 0, 0)) {
                bl = true;
            }
        } else if (n == 0) {
            int n3 = -(this.scale() + bigDecimal2.scale());
            if (n3 >= -398 && n3 <= 369 && bigDecimal.DFPScaledMultiply(bigDecimal2.laside, this.laside, n3 + 398)) {
                bl = true;
            }
        } else if (n > 0 && n2 == 7) {
            if (bigDecimal.DFPMultiply(bigDecimal2.laside, this.laside, 0, 0, 0)) {
                bigDecimal.finish(n, n2);
                bl = true;
            }
        } else if (n <= 16) {
            boolean bl2;
            if (n2 == 6) {
                n2 = 0;
            } else if (n2 == 0) {
                n2 = 6;
            }
            boolean bl3 = bl2 = n == 16 ? bigDecimal.DFPMultiply(bigDecimal2.laside, this.laside, 1, 16, n2) : bigDecimal.DFPMultiply(bigDecimal2.laside, this.laside, 1, n, n2);
            if (bl2) {
                bl = true;
            }
        }
        if (bl && bigDecimal.isDFPZero()) {
            bigDecimal.laside &= Long.MAX_VALUE;
        }
        return bl;
    }

    private final boolean DFPDivideHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        if (bigDecimal3.isDFPZero()) {
            this.badDivideByZero();
        }
        int n = (int)Math.min((double)bigDecimal2.precision() + Math.ceil(10 * bigDecimal3.precision() / 3), 2.147483647E9);
        boolean bl = false;
        int n2 = bigDecimal.DFPDivide(bigDecimal3.laside, this.laside, true, 0, 0, 0);
        if (n2 == 1) {
            if (bigDecimal.precision() > n) {
                throw new ArithmeticException(Messages.getString("math.28"));
            }
            bl = true;
        }
        if (bl && bigDecimal.isDFPZero()) {
            bigDecimal.laside &= Long.MAX_VALUE;
        }
        return bl;
    }

    private final boolean DFPDivideHelper(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, MathContext mathContext) {
        if (bigDecimal3.isDFPZero()) {
            this.badDivideByZero();
        }
        int n = mathContext.getRoundingMode().ordinal();
        int n2 = mathContext.getPrecision();
        boolean bl = false;
        if (n2 == 16 && n == 6) {
            int n3 = bigDecimal.DFPDivide(bigDecimal3.laside, bigDecimal2.laside, false, 64, 0, 0);
            if (n3 == 1) {
                bl = true;
            }
        } else if (n2 <= 16) {
            int n4;
            if (n == 6) {
                n = 0;
            } else if (n == 0) {
                n = 6;
            }
            int n5 = n4 = n2 == 16 ? bigDecimal.DFPDivide(bigDecimal3.laside, bigDecimal2.laside, true, 1, 16, n) : bigDecimal.DFPDivide(bigDecimal3.laside, bigDecimal2.laside, true, 1, n2, n);
            if (n4 == 0 && n == 7) {
                throw new ArithmeticException(Messages.getString("math.29"));
            }
            if (n4 == 1) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    this.DFPPerformHysteresis(10);
                }
                bl = true;
            }
        }
        if (bl && bigDecimal.isDFPZero()) {
            bigDecimal.laside &= Long.MAX_VALUE;
        }
        return bl;
    }

    private boolean DFPSetScaleHelper(BigDecimal bigDecimal, int n) {
        if (-n >= -398 && -n <= 369) {
            int n2 = bigDecimal.DFPSetScale(this.laside, -n + 398, false, 0, true);
            if (n2 == 1) {
                if (BigDecimal.DFPPerformHysteresis()) {
                    this.DFPPerformHysteresis(5);
                }
                if (bigDecimal.isDFPZero()) {
                    bigDecimal.laside &= Long.MAX_VALUE;
                    bigDecimal.flags |= 4;
                    bigDecimal.flags &= 0xFFFFFF9F;
                } else {
                    bigDecimal.flags |= 4;
                    bigDecimal.flags |= this.signum() << 5 & 0x60;
                }
                bigDecimal.flags |= 8;
                bigDecimal.cachedScale = n;
                bigDecimal.flags &= 0xFFFFFFEF;
                return true;
            }
            if (n2 == 0) {
                throw new ArithmeticException(Messages.getString("math.23", Long.toString(n)));
            }
            return false;
        }
        return false;
    }

    private final boolean DFPSetScaleHelper(BigDecimal bigDecimal, long l, int n, int n2) {
        boolean bl = false;
        if (-n >= -398 && -n <= 369) {
            if (n2 == 7) {
                if (bigDecimal.DFPSetScale(this.laside, -n + 398, false, 0, true) == 1) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        this.DFPPerformHysteresis(5);
                    }
                    if (bigDecimal.isDFPZero()) {
                        bigDecimal.laside &= Long.MAX_VALUE;
                        bigDecimal.flags |= 4;
                        bigDecimal.flags &= 0xFFFFFF9F;
                    } else {
                        bigDecimal.flags |= 4;
                        bigDecimal.flags |= this.signum() << 5 & 0x60;
                    }
                    bigDecimal.flags |= 8;
                    bigDecimal.cachedScale = n;
                    bl = true;
                }
            } else {
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
                if (bigDecimal.DFPSetScale(this.laside, -n + 398, true, n2, false) == 1) {
                    if (BigDecimal.DFPPerformHysteresis()) {
                        this.DFPPerformHysteresis(5);
                    }
                    if (bigDecimal.isDFPZero()) {
                        bigDecimal.laside &= Long.MAX_VALUE;
                        bigDecimal.flags |= 4;
                        bigDecimal.flags &= 0xFFFFFF9F;
                    } else {
                        bigDecimal.flags |= 4;
                        bigDecimal.flags |= this.signum() << 5 & 0x60;
                    }
                    bigDecimal.flags |= 8;
                    bigDecimal.cachedScale = n;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private final void DFPNegateHelper(BigDecimal bigDecimal) {
        int n = this.signum();
        bigDecimal.flags |= 4;
        if (n == -1) {
            bigDecimal.laside &= Long.MAX_VALUE;
            bigDecimal.flags &= 0xFFFFFF9F;
            bigDecimal.flags |= 0x20;
        } else if (n == 1) {
            bigDecimal.laside |= (bigDecimal.laside |= Long.MIN_VALUE);
            bigDecimal.flags &= 0xFFFFFF9F;
            bigDecimal.flags |= 0x60;
        }
        if (bigDecimal.bi != null) {
            bigDecimal.bi = bigDecimal.bi.negate();
        }
    }

    private final void DFPRoundHelper(int n, int n2) {
        if (this.precision() > n) {
            long l = BigDecimal.DFPBCDDigits(this.laside);
            if (l == 10L) {
                l = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            if (n2 == 7 && !BigDecimal.allzeroBCD(l, this.precision() - n)) {
                throw new ArithmeticException(Messages.getString("math.36"));
            }
            if (n2 == 6) {
                n2 = 0;
            } else if (n2 == 0) {
                n2 = 6;
            }
            if (!this.DFPRound(this.laside, n, n2)) {
                this.DFPToLL();
                if (n2 == 6) {
                    n2 = 0;
                } else if (n2 == 0) {
                    n2 = 6;
                }
                this.roundLL(n, n2, false);
            } else {
                this.flags |= 0x10;
                this.flags &= 0x7F;
                this.flags |= n << 7;
                this.flags &= 0xFFFFFFF7;
            }
            if ((this.flags & 3) == 0 && this.isDFPZero()) {
                this.laside &= Long.MAX_VALUE;
            }
        }
    }

    private final int DFPPrecisionHelper() {
        int n = this.flags;
        n |= 0x10;
        n &= 0x7F;
        int n2 = BigDecimal.DFPSignificance(this.laside);
        if (n2 < 0) {
            long l = BigDecimal.DFPBCDDigits(this.laside);
            if (l == 10L) {
                l = BigDecimal.extractDFPDigitsBCD(this.laside);
            }
            int n3 = Long.numberOfLeadingZeros(l);
            n3 >>= 2;
            if ((n3 = 16 - n3) == 0) {
                ++n3;
            }
            this.flags = n |= n3 << 7;
            return n3;
        }
        if (n2 == 0) {
            ++n2;
        }
        this.flags = n |= n2 << 7;
        return n2;
    }

    private final int DFPSignumHelper() {
        int n = this.flags;
        if ((n & 4) != 0) {
            return (n & 0x60) << 25 >> 30;
        }
        n |= 4;
        if ((this.laside & Long.MIN_VALUE) == Long.MIN_VALUE) {
            this.flags = n |= 0x60;
            return -1;
        }
        long l = BigDecimal.DFPBCDDigits(this.laside);
        if (l == 10L) {
            if (this.isDFPZero()) {
                this.flags = n &= 0xFFFFFF9F;
                return 0;
            }
            n &= 0xFFFFFF9F;
            this.flags = n |= 0x20;
            return 1;
        }
        if (l != 0L) {
            n &= 0xFFFFFF9F;
            this.flags = n |= 0x20;
            return 1;
        }
        this.flags = n &= 0xFFFFFF9F;
        return 0;
    }

    private final BigInteger DFPUnscaledValueHelper() {
        long l = BigDecimal.DFPUnscaledValue(this.laside);
        if (l != Long.MAX_VALUE) {
            this.bi = BigInteger.valueOf(l);
            return this.bi;
        }
        l = BigDecimal.DFPBCDDigits(this.laside);
        if (l == 10L) {
            l = BigDecimal.extractDFPDigitsBCD(this.laside);
        }
        if (l == 0L) {
            this.bi = BigInteger.ZERO;
            return this.bi;
        }
        long l2 = 0L;
        int n = 0;
        while (l != 0L) {
            l2 += (l & 0xFL) * BigDecimal.powerOfTenLL(n++);
            l >>>= 4;
        }
        this.bi = BigInteger.valueOf((long)this.DFPSignumHelper() * l2);
        return this.bi;
    }

    private static BigDecimal DFPValueOfHelper(long l, int n, BigDecimal bigDecimal) {
        int n2 = 0;
        if (BigDecimal.DFPHWAvailable() && BigDecimal.DFPUseDFP()) {
            if (l == 0L && n == 0) {
                bigDecimal.DFPConstructZero();
                return bigDecimal;
            }
            if (l <= 9999999999999999L && l >= -9999999999999999L && -n >= -398 && -n <= 369 && bigDecimal.DFPLongExpConstructor(l, -n + 398, 0, 0, 0, false)) {
                n2 |= 8;
                bigDecimal.cachedScale = n;
                n2 |= 4;
                if (l < 0L) {
                    n2 |= 0x60;
                } else if (l > 0L) {
                    n2 |= 0x20;
                }
                bigDecimal.flags = n2;
                return bigDecimal;
            }
        }
        return null;
    }

    private static BigDecimal slowSMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        return bigDecimal3.multiply(bigDecimal.subtract(bigDecimal2)).setScale(2, 4);
    }

    private static boolean noLLOverflowAdd(long l, long l2, long l3) {
        return ((l3 ^ l) & (l3 ^ l2)) >>> 63 == 0L;
    }

    private static boolean noLLOverflowMul(long l, long l2, long l3) {
        return l < Integer.MAX_VALUE && l > Integer.MIN_VALUE && l < Integer.MAX_VALUE && l2 > Integer.MIN_VALUE;
    }

    private static BigDecimal slowSMAAMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        BigDecimal bigDecimal6 = bigDecimal3.multiply(bigDecimal.subtract(bigDecimal2)).setScale(2, 4);
        return bigDecimal6.multiply(bigDecimal.add(bigDecimal4).add(bigDecimal5)).setScale(2, 4);
    }

    private static BigDecimal SMAAMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5, int n, int n2, int n3, int n4) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        if (bigDecimal3 != null && bigDecimal3.getClass() == BigDecimal.class && bigDecimal2.cachedScale == n && bigDecimal3.cachedScale == n2 && bigDecimal4.cachedScale == n3 && bigDecimal5.cachedScale == n4 && (bigDecimal2.flags & bigDecimal3.flags & bigDecimal4.flags & bigDecimal5.flags & 1) == 1 && BigDecimal.noLLOverflowAdd(l9 = (long)Math.pow(10.0, n), -bigDecimal2.laside, l8 = l9 - bigDecimal2.laside) && BigDecimal.noLLOverflowMul(l8, bigDecimal3.laside, l7 = l8 * bigDecimal3.laside) && BigDecimal.noLLOverflowAdd(l7, l6 = l9 / 2L, l5 = l7 + l6) && BigDecimal.noLLOverflowAdd(l9, bigDecimal4.laside, l4 = l9 + bigDecimal4.laside) && BigDecimal.noLLOverflowAdd(l4, bigDecimal5.laside, l3 = l4 + bigDecimal5.laside) && BigDecimal.noLLOverflowMul(l3, l5 /= l9, l2 = l3 * l5) && BigDecimal.noLLOverflowAdd(l2, l6, l = l2 + l6)) {
            return BigDecimal.valueOf(l / l9, 2);
        }
        return BigDecimal.slowSMAAMSS(bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4, bigDecimal5);
    }

    private static BigDecimal SMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, int n, int n2) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        if (bigDecimal3 != null && bigDecimal3.getClass() == BigDecimal.class && bigDecimal2.cachedScale == n && bigDecimal3.cachedScale == n2 && (bigDecimal2.flags & bigDecimal3.flags & 1) == 1 && BigDecimal.noLLOverflowAdd(l5 = (long)Math.pow(10.0, n), -bigDecimal2.laside, l4 = l5 - bigDecimal2.laside) && BigDecimal.noLLOverflowMul(l4, bigDecimal3.laside, l3 = l4 * bigDecimal3.laside) && BigDecimal.noLLOverflowAdd(l3, l2 = l5 / 2L, l = l3 + l2)) {
            return BigDecimal.valueOf(l / l5, 2);
        }
        return BigDecimal.slowSMSS(bigDecimal, bigDecimal2, bigDecimal3);
    }

    private static BigDecimal slowAAMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4) {
        return bigDecimal4.multiply(bigDecimal.add(bigDecimal2).add(bigDecimal3)).setScale(2, 4);
    }

    private static BigDecimal AAMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, int n, int n2, int n3) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        if (bigDecimal4 != null && bigDecimal4.getClass() == BigDecimal.class && bigDecimal2.cachedScale == n && bigDecimal3.cachedScale == n2 && bigDecimal4.cachedScale == n3 && (bigDecimal2.flags & bigDecimal3.flags & bigDecimal4.flags & 1) == 1 && BigDecimal.noLLOverflowAdd(l6 = (long)Math.pow(10.0, n), bigDecimal2.laside, l5 = l6 + bigDecimal2.laside) && BigDecimal.noLLOverflowAdd(l5, bigDecimal3.laside, l4 = l5 + bigDecimal3.laside) && BigDecimal.noLLOverflowMul(l4, bigDecimal4.laside, l3 = l4 * bigDecimal4.laside) && BigDecimal.noLLOverflowAdd(l3, l2 = l6 / 2L, l = l3 + l2)) {
            return BigDecimal.valueOf(l / l6, 2);
        }
        return BigDecimal.slowAAMSS(bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4);
    }

    private static BigDecimal slowMSS(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2).setScale(2, 4);
    }

    private static BigDecimal MSS(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        long l;
        if (bigDecimal2.cachedScale == n && (bigDecimal.flags & bigDecimal2.flags & 1) == 1 && BigDecimal.noLLOverflowMul(bigDecimal.laside, bigDecimal2.laside, l = bigDecimal.laside * bigDecimal2.laside)) {
            return BigDecimal.valueOf(l, 2);
        }
        return BigDecimal.slowMSS(bigDecimal, bigDecimal2);
    }

    private static BigDecimal SMSetScale(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        long l;
        long l2;
        long l3;
        if (bigDecimal2 != null && bigDecimal2.getClass() == BigDecimal.class && bigDecimal.cachedScale == n && bigDecimal2.cachedScale == n2 && (bigDecimal.flags & bigDecimal2.flags & 1) == 1 && BigDecimal.noLLOverflowAdd(l3 = (long)Math.pow(10.0, n), -bigDecimal.laside, l2 = l3 - bigDecimal.laside) && BigDecimal.noLLOverflowMul(l2, bigDecimal2.laside, l = l2 * bigDecimal2.laside)) {
            return BigDecimal.valueOf(l / l3, 2);
        }
        return BigDecimal.slowSMSetScale(bigDecimal, bigDecimal2);
    }

    private static BigDecimal slowSMSetScale(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal2.multiply(ONE.subtract(bigDecimal)).setScale(2, 1);
    }

    static {
        zeroDec = "0.00";
        hys_type = false;
        hys_counter = 0;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("scale", Integer.TYPE), new ObjectStreamField("intVal", BigInteger.class)};
        useSmallerScaleBD = false;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                useSmallerScaleBD = Boolean.getBoolean("ibm.java.math.BigDecimal.useSmallerScaleBD");
                return null;
            }
        });
        CACHE1 = new BigDecimal[11];
        CACHE2 = new BigDecimal[11];
        for (int i = 0; i < CACHE1.length; ++i) {
            BigDecimal.CACHE1[i] = new BigDecimal();
            BigDecimal.CACHE1[i].flags |= 1;
            BigDecimal.CACHE1[i].laside = i;
            BigDecimal.CACHE1[i].cachedScale = 1;
            BigDecimal.CACHE2[i] = new BigDecimal();
            BigDecimal.CACHE2[i].flags |= 1;
            BigDecimal.CACHE2[i].laside = i;
            BigDecimal.CACHE2[i].cachedScale = 2;
        }
    }
}

