/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

final class SMIMEUtils {
    private static String crlf = "\r\n";
    private static byte[] crlfbytes = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEUtils";

    SMIMEUtils() {
    }

    static byte[] getMessageBody(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getMessageBody", (Object)message);
        }
        if (message == null || message.length == 0) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getMessageBody_1", null);
            }
            return null;
        }
        String pszmessage = new String(message);
        StringReader sreader = new StringReader(pszmessage);
        BufferedReader breader = new BufferedReader(sreader);
        String inline = null;
        boolean bbody = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((inline = breader.readLine()) != null) {
            if (!inline.equals("")) continue;
            bbody = true;
            break;
        }
        if (bbody) {
            while ((inline = breader.readLine()) != null) {
                try {
                    bos.write(inline.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException e) {
                    if (debug != null) {
                        debug.exception(49152L, className, "getMessageBody", e);
                    }
                    bos.write(inline.getBytes());
                }
                bos.write(crlfbytes);
            }
        }
        byte[] retval = bos.toByteArray();
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getMessageBody_2", retval);
        }
        return retval;
    }

    static byte[] getMessageBodyRemoveTrailer(byte[] message) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getMessageBodyRemoveTrailer", (Object)message);
        }
        if (message == null || message.length == 0) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getMessageBodyRemoveTrailer_1", null);
            }
            return null;
        }
        String pszmessage = new String(message);
        StringReader sreader = new StringReader(pszmessage);
        BufferedReader breader = new BufferedReader(sreader);
        String inline = null;
        boolean bbody = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (!((inline = breader.readLine()) == null || bbody && inline.equals("."))) {
            try {
                bos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(49152L, className, "getMessageBodyRemoveTrailer", e);
                }
                bos.write(inline.getBytes());
            }
            bos.write(crlfbytes);
            bbody = true;
        }
        byte[] retval = bos.toByteArray();
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getMessageBodyRemoveTrailer_2", retval);
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getContentType(Object obj) {
        String contentType;
        block11: {
            block9: {
                block12: {
                    Content content;
                    block10: {
                        contentType = null;
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getContentType", obj);
                        }
                        if (!(obj instanceof ContentInfo)) break block9;
                        content = ((ContentInfo)obj).getContent();
                        if (!(content instanceof EnvelopedData)) break block10;
                        contentType = "application/x-pkcs7-mime; name=\"smime.p7m\"";
                        break block11;
                    }
                    if (!(content instanceof SignedData)) break block12;
                    contentType = "application/x-pkcs7-mime; smime-type=signed-data; name=\"smime.p7m\"";
                    SignedData sd = (SignedData)content;
                    if (sd.hasCertificatesOnly()) {
                        contentType = "application/x-pkcs7-mime; smime-type=certs-only; name=\"smime.p7c\"";
                        break block11;
                    } else if (!sd.hasContent()) {
                        contentType = "application/x-pkcs7-signature; name=\"smime.p7s\"";
                    }
                    break block11;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (obj instanceof CertificationRequest) {
                contentType = "application/x-pkcs10; name=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getContentType", contentType);
        }
        return contentType;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getContentType(Object obj, boolean oldType) {
        String contentType;
        block12: {
            block10: {
                block13: {
                    Content content;
                    block11: {
                        contentType = null;
                        if (!oldType) {
                            return SMIMEUtils.getContentType(obj);
                        }
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getContentType2", obj);
                        }
                        if (!(obj instanceof ContentInfo)) break block10;
                        content = ((ContentInfo)obj).getContent();
                        if (!(content instanceof EnvelopedData)) break block11;
                        contentType = "application/pkcs7-mime; name=\"smime.p7m\"";
                        break block12;
                    }
                    if (!(content instanceof SignedData)) break block13;
                    contentType = "application/pkcs7-mime; smime-type=signed-data; name=\"smime.p7m\"";
                    SignedData sd = (SignedData)content;
                    if (sd.hasCertificatesOnly()) {
                        contentType = "application/pkcs7-mime; smime-type=certs-only; name=\"smime.p7c\"";
                        break block12;
                    } else if (!sd.hasContent()) {
                        contentType = "application/pkcs7-signature; name=\"smime.p7s\"";
                    }
                    break block12;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (obj instanceof CertificationRequest) {
                contentType = "application/pkcs10; name=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getContentType", contentType);
        }
        return contentType;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getDisposition(Object obj) {
        String disposition;
        block11: {
            block9: {
                block12: {
                    Content content;
                    block10: {
                        disposition = null;
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getDisposition", obj);
                        }
                        if (!(obj instanceof ContentInfo)) break block9;
                        content = ((ContentInfo)obj).getContent();
                        if (!(content instanceof EnvelopedData)) break block10;
                        disposition = "attachment; filename=\"smime.p7m\"";
                        break block11;
                    }
                    if (!(content instanceof SignedData)) break block12;
                    disposition = "attachment; filename=\"smime.p7m\"";
                    SignedData sd = (SignedData)content;
                    if (sd.hasCertificatesOnly()) {
                        disposition = "attachment; filename=\"smime.p7c\"";
                        break block11;
                    } else if (!sd.hasContent()) {
                        disposition = "attachment; filename=\"smime.p7s\"";
                    }
                    break block11;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getDisposition", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (obj instanceof CertificationRequest) {
                disposition = "attachment; filename=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getDisposition", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getDisposition", disposition);
        }
        return disposition;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getDescription(Object obj) {
        String description;
        block11: {
            block9: {
                Content content;
                block10: {
                    description = null;
                    if (debug != null) {
                        debug.entry(49152L, (Object)className, "getDescription", obj);
                    }
                    if (!(obj instanceof ContentInfo)) break block9;
                    content = ((ContentInfo)obj).getContent();
                    if (!(content instanceof EnvelopedData)) break block10;
                    description = "S/MIME Encrypted Message";
                    break block11;
                }
                if (content instanceof SignedData) {
                    description = null;
                    SignedData sd = (SignedData)content;
                    if (!sd.hasCertificatesOnly() && !sd.hasContent()) {
                        description = "S/MIME Cryptographic Signature";
                    }
                    break block11;
                } else {
                    if (debug != null) {
                        debug.text(49152L, className, "getDescription", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                    }
                    throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
            }
            if (obj instanceof CertificationRequest) {
                description = null;
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getDescription", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getDescription", description);
        }
        return description;
    }

    static {
        try {
            crlfbytes = crlf.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            crlfbytes = crlf.getBytes();
        }
    }
}

