/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class Countersignature
extends PKCS9DerObject
implements Cloneable {
    private SignerInfo[] signers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.CounterSignature";
    private volatile int cachedHashVal = 0;

    public Countersignature(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", (Object)der);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", der, provider);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo signerinfo) {
        SignerInfo[] signers = new SignerInfo[]{signerinfo};
        this.signers = signers;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", signerinfo);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo signerinfo, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", signerinfo, provider);
            debug.exit(16384L, className, "CounterSignature");
        }
        SignerInfo[] signers = new SignerInfo[]{signerinfo};
        this.signers = signers;
    }

    public Countersignature(SignerInfo[] signerinfos) {
        this.signers = signerinfos;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CounterSignature", signerinfos);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(SignerInfo[] signerinfos, String provider) {
        super(provider);
        this.signers = signerinfos;
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", signerinfos, provider);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "CounterSignature", filename, new Boolean(base64));
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Countersignature(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "CounterSignature", parms);
            debug.exit(16384L, className, "CounterSignature");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            Countersignature result = new Countersignature(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof Countersignature) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((Countersignature)obj));
            }
            return this.equals((Countersignature)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.COUNTERSIGNATURE_OID);
        }
        return PKCSOID.COUNTERSIGNATURE_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.signers == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "SignerInfo objects not specified.");
            }
            throw new IOException("SignerInfo objects not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        DerEncoder[] temps = new DerOutputStream[this.signers.length];
        for (int i = 0; i < this.signers.length; ++i) {
            temps[i] = new DerOutputStream();
            this.signers[i].encode((OutputStream)((Object)temps[i]));
        }
        tmpout.putOrderedSetOf((byte)49, temps);
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SignerInfo[] getSignerInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerInfos");
            debug.exit(16384L, (Object)className, "getSignerInfos", this.signers.clone());
        }
        return (SignerInfo[])this.signers.clone();
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getSignerInfos());
        }
        return this.getSignerInfos();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 48) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "Countersignature");
        }
        return "Countersignature";
    }

    @Override
    public String toString() {
        String out = "PKCS9 Countersignature:\r\n";
        if (this.signers == null || this.signers.length == 0) {
            out = out + "\tNo SignerInfo values set.\r\n";
        } else {
            for (int i = 0; i < this.signers.length; ++i) {
                out = out + "SignerInfo[" + i + "]:\r\n";
                out = out + this.signers[i].toString();
            }
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.signers = new SignerInfo[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            this.signers[i] = new SignerInfo(elems[i].toByteArray(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(Countersignature other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

